/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Notification;
import android.content.ComponentCallbacks;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks {
    public static final int START_CONTINUATION_MASK = 15;
    public static final int START_FLAG_REDELIVERY = 1;
    public static final int START_FLAG_RETRY = 2;
    public static final int START_NOT_STICKY = 2;
    public static final int START_REDELIVER_INTENT = 3;
    public static final int START_STICKY = 1;
    public static final int START_STICKY_COMPATIBILITY = 0;
    private static final String TAG = "Service";
    private IActivityManager mActivityManager = null;
    private Application mApplication = null;
    private String mClassName = null;
    private boolean mStartCompatibility = false;
    private ActivityThread mThread = null;
    private IBinder mToken = null;

    public Service() {
        super(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void attach(Context context, ActivityThread activityThread, String string2, IBinder iBinder, Application application, Object object) {
        IActivityManager iActivityManager;
        this.attachBaseContext(context);
        this.mThread = activityThread;
        this.mClassName = string2;
        this.mToken = iBinder;
        this.mApplication = application;
        this.mActivityManager = iActivityManager = (IActivityManager)object;
        boolean bl = this.getApplicationInfo().targetSdkVersion < 5;
        this.mStartCompatibility = bl;
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println("nothing to dump");
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public final Application getApplication() {
        return this.mApplication;
    }

    final String getClassName() {
        return this.mClassName;
    }

    public abstract IBinder onBind(Intent var1);

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onCreate() {
    }

    public void onDestroy() {
    }

    @Override
    public void onLowMemory() {
    }

    public void onRebind(Intent intent) {
    }

    @Deprecated
    public void onStart(Intent intent, int n) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int onStartCommand(Intent intent, int n, int n2) {
        this.onStart(intent, n2);
        if (!this.mStartCompatibility) return 1;
        return 0;
    }

    public boolean onUnbind(Intent intent) {
        return false;
    }

    @Deprecated
    public final void setForeground(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder().append("setForeground: ignoring old API call on ");
        String string2 = this.getClass().getName();
        String string3 = stringBuilder.append(string2).toString();
        int n = Log.w(TAG, string3);
    }

    public final void startForeground(int n, Notification notification) {
        try {
            IActivityManager iActivityManager = this.mActivityManager;
            String string2 = this.mClassName;
            ComponentName componentName = new ComponentName((Context)this, string2);
            IBinder iBinder = this.mToken;
            int n2 = n;
            Notification notification2 = notification;
            iActivityManager.setServiceForeground(componentName, iBinder, n2, notification2, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void stopForeground(boolean bl) {
        try {
            IActivityManager iActivityManager = this.mActivityManager;
            String string2 = this.mClassName;
            ComponentName componentName = new ComponentName((Context)this, string2);
            IBinder iBinder = this.mToken;
            boolean bl2 = bl;
            iActivityManager.setServiceForeground(componentName, iBinder, 0, null, bl2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void stopSelf() {
        this.stopSelf(-1);
    }

    public final void stopSelf(int n) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            IActivityManager iActivityManager = this.mActivityManager;
            String string2 = this.mClassName;
            ComponentName componentName = new ComponentName((Context)this, string2);
            IBinder iBinder = this.mToken;
            boolean bl = iActivityManager.stopServiceToken(componentName, iBinder, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean stopSelfResult(int n) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            IActivityManager iActivityManager = this.mActivityManager;
            String string2 = this.mClassName;
            ComponentName componentName = new ComponentName((Context)this, string2);
            IBinder iBinder = this.mToken;
            boolean bl = iActivityManager.stopServiceToken(componentName, iBinder, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }
}

