/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.statusbar.IStatusBarService;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 1;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE_NOTIFICATION_ALERTS = 4;
    public static final int DISABLE_NOTIFICATION_ICONS = 2;
    public static final int DISABLE_NOTIFICATION_TICKER = 8;
    private Context mContext;
    private IStatusBarService mService;
    private IBinder mToken;

    StatusBarManager(Context context) {
        IStatusBarService iStatusBarService;
        Binder binder = new Binder();
        this.mToken = binder;
        this.mContext = context;
        this.mService = iStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
    }

    public void collapse() {
        try {
            this.mService.collapse();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void disable(int n) {
        try {
            IStatusBarService iStatusBarService = this.mService;
            IBinder iBinder = this.mToken;
            String string2 = this.mContext.getPackageName();
            iStatusBarService.disable(n, iBinder, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void expand() {
        try {
            this.mService.expand();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void removeIcon(String string2) {
        try {
            this.mService.removeIcon(string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setIcon(String string2, int n, int n2) {
        try {
            IStatusBarService iStatusBarService = this.mService;
            String string3 = this.mContext.getPackageName();
            iStatusBarService.setIcon(string2, string3, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setIconVisibility(String string2, boolean bl) {
        try {
            this.mService.setIconVisibility(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }
}

