/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SearchDialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;

class SuggestionsAdapter
extends ResourceCursorAdapter {
    private static final boolean DBG = false;
    private static final long DELETE_KEY_POST_DELAY = 500L;
    private static final String LOG_TAG = "SuggestionsAdapter";
    static final int NONE = 255;
    private static final int QUERY_LIMIT = 50;
    private int mBackgroundColorCol;
    private SparseArray<Drawable.ConstantState> mBackgroundsCache;
    private boolean mClosed = false;
    private int mIconName1Col;
    private int mIconName2Col;
    private WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private Context mProviderContext;
    private SearchDialog mSearchDialog;
    private SearchManager mSearchManager;
    private SearchableInfo mSearchable;
    private final Runnable mStartSpinnerRunnable;
    private final Runnable mStopSpinnerRunnable;
    private int mText1Col;
    private int mText2Col;
    private int mText2UrlCol;
    private ColorStateList mUrlColor;

    public SuggestionsAdapter(Context context, SearchDialog searchDialog, SearchableInfo searchableInfo, WeakHashMap<String, Drawable.ConstantState> weakHashMap) {
        super(context, 17367132, null, true);
        Runnable runnable;
        Runnable runnable2;
        Context context2;
        SearchManager searchManager;
        this.mSearchManager = searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchDialog = searchDialog;
        SearchableInfo searchableInfo2 = this.mSearchable = searchableInfo;
        Context context3 = this.mContext;
        Context context4 = searchableInfo2.getActivityContext(context3);
        SearchableInfo searchableInfo3 = this.mSearchable;
        Context context5 = this.mContext;
        this.mProviderContext = context2 = searchableInfo3.getProviderContext(context5, context4);
        this.mOutsideDrawablesCache = weakHashMap;
        SparseArray sparseArray = new SparseArray();
        this.mBackgroundsCache = sparseArray;
        this.mStartSpinnerRunnable = runnable2 = new Runnable(){

            @Override
            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(true);
            }
        };
        this.mStopSpinnerRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(false);
            }
        };
        Filter filter = this.getFilter();
        Filter.Delayer delayer = new Filter.Delayer(){
            private int mPreviousLength = 0;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long getPostingDelay(CharSequence charSequence) {
                int n;
                int n2;
                if (charSequence == null) {
                    return 0L;
                }
                int n3 = charSequence.length();
                long l = n3 < (n2 = this.mPreviousLength) ? 500L : 0L;
                this.mPreviousLength = n = charSequence.length();
                return l;
            }
        };
        filter.setDelayer(delayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable checkIconCache(String string2) {
        Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
        if (constantState != null) return constantState.newDrawable();
        return null;
    }

    private CharSequence formatUrl(CharSequence charSequence) {
        if (this.mUrlColor == null) {
            ColorStateList colorStateList;
            TypedValue typedValue = new TypedValue();
            boolean bl = this.mContext.getTheme().resolveAttribute(16843367, typedValue, true);
            Resources resources = this.mContext.getResources();
            int n = typedValue.resourceId;
            this.mUrlColor = colorStateList = resources.getColorStateList(n);
        }
        SpannableString spannableString = new SpannableString(charSequence);
        ColorStateList colorStateList = this.mUrlColor;
        int n = 0;
        ColorStateList colorStateList2 = null;
        TextAppearanceSpan textAppearanceSpan = new TextAppearanceSpan(null, 0, n, colorStateList, colorStateList2);
        int n2 = charSequence.length();
        spannableString.setSpan(textAppearanceSpan, 0, n2, 33);
        return spannableString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getActivityIcon(ComponentName componentName) {
        ApplicationInfo applicationInfo;
        ActivityInfo activityInfo;
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            ActivityInfo activityInfo2;
            activityInfo = activityInfo2 = packageManager.getActivityInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = nameNotFoundException.toString();
            int n = Log.w(LOG_TAG, string2);
            return null;
        }
        int n = activityInfo.getIconResource();
        if (n == 0) {
            return null;
        }
        String string3 = componentName.getPackageName();
        Drawable drawable2 = packageManager.getDrawable(string3, n, applicationInfo = activityInfo.applicationInfo);
        if (drawable2 != null) return drawable2;
        StringBuilder stringBuilder = new StringBuilder().append("Invalid icon resource ").append(n).append(" for ");
        String string4 = componentName.flattenToShortString();
        String string5 = stringBuilder.append(string4).toString();
        int n2 = Log.w(LOG_TAG, string5);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getActivityIconWithCache(ComponentName componentName) {
        String string2 = componentName.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(string2)) {
            Drawable.ConstantState constantState = this.mOutsideDrawablesCache.get(string2);
            if (constantState == null) {
                return null;
            }
            Resources resources = this.mProviderContext.getResources();
            return constantState.newDrawable(resources);
        }
        Drawable drawable2 = this.getActivityIcon(componentName);
        Drawable.ConstantState constantState = drawable2 == null ? null : drawable2.getConstantState();
        Drawable.ConstantState constantState2 = this.mOutsideDrawablesCache.put(string2, constantState);
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String string2) {
        int n = cursor.getColumnIndex(string2);
        return SuggestionsAdapter.getStringOrNull(cursor, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDefaultIcon1(Cursor cursor) {
        ComponentName componentName;
        Drawable drawable2;
        String string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_component");
        if (string2 != null) {
            ComponentName componentName2 = ComponentName.unflattenFromString(string2);
            if (componentName2 != null) {
                drawable2 = this.getActivityIconWithCache(componentName2);
                if (drawable2 != null) {
                    return drawable2;
                }
            } else {
                String string3 = "Bad component name: " + string2;
                int n = Log.w(LOG_TAG, string3);
            }
        }
        if ((drawable2 = this.getActivityIconWithCache(componentName = this.mSearchable.getSearchActivity())) == null) return this.mContext.getPackageManager().getDefaultActivityIcon();
        return drawable2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getDrawable(Uri uri) {
        String string2;
        InputStream inputStream;
        try {
            String string3 = uri.getScheme();
            if ("android.resource".equals(string3)) {
                Object object = this.mProviderContext.getContentResolver().getResourceId(uri);
                ContentResolver.OpenResourceIdResult openResourceIdResult = object;
                try {
                    Resources resources = openResourceIdResult.r;
                    int n = openResourceIdResult.id;
                    object = resources.getDrawable(n);
                    return object;
                }
                catch (Resources.NotFoundException notFoundException) {
                    String string4 = "Resource does not exist: " + uri;
                    throw new FileNotFoundException(string4);
                }
            }
            inputStream = this.mProviderContext.getContentResolver().openInputStream(uri);
            if (inputStream == null) {
                String string5 = "Failed to open " + uri;
                throw new FileNotFoundException(string5);
            }
            string2 = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder().append("Icon not found: ").append(uri).append(", ");
            String string6 = fileNotFoundException.getMessage();
            String string7 = stringBuilder.append(string6).toString();
            int n = Log.w(LOG_TAG, string7);
            return null;
        }
        Drawable drawable2 = Drawable.createFromStream(inputStream, string2);
        Drawable drawable3 = drawable2;
        {
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string8 = "Error closing icon stream for " + uri;
                    int n = Log.e(LOG_TAG, string8, iOException);
                    throw throwable;
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return drawable3;
        }
        catch (IOException iOException) {
            String string9 = "Error closing icon stream for " + uri;
            int n = Log.e(LOG_TAG, string9, iOException);
            return drawable3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getDrawableFromResourceValue(String string2) {
        if (string2 == null) return null;
        if (string2.length() == 0) return null;
        if ("0".equals(string2)) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2);
            StringBuilder stringBuilder = new StringBuilder().append("android.resource://");
            String string3 = this.mProviderContext.getPackageName();
            String string4 = stringBuilder.append(string3).append("/").append(n).toString();
            Drawable drawable2 = this.checkIconCache(string4);
            if (drawable2 != null) {
                return drawable2;
            }
            drawable2 = this.mProviderContext.getResources().getDrawable(n);
            this.storeInIconCache(string4, drawable2);
            return drawable2;
        }
        catch (NumberFormatException numberFormatException) {
            Drawable drawable3 = this.checkIconCache(string2);
            if (drawable3 != null) {
                return drawable3;
            }
            Uri uri = Uri.parse(string2);
            Drawable drawable4 = this.getDrawable(uri);
            this.storeInIconCache(string2, drawable4);
            return drawable4;
        }
        catch (Resources.NotFoundException notFoundException) {
            String string5 = "Icon resource not found: " + string2;
            int n = Log.w(LOG_TAG, string5);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col < 0) {
            return null;
        }
        int n = this.mIconName1Col;
        String string2 = cursor.getString(n);
        Drawable drawable2 = this.getDrawableFromResourceValue(string2);
        if (drawable2 == null) return this.getDefaultIcon1(cursor);
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col < 0) {
            return null;
        }
        int n = this.mIconName2Col;
        String string2 = cursor.getString(n);
        return this.getDrawableFromResourceValue(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getItemBackground(int n) {
        if (n == 0) {
            return null;
        }
        Drawable.ConstantState constantState = this.mBackgroundsCache.get(n);
        if (constantState != null) {
            Resources resources = this.mProviderContext.getResources();
            return constantState.newDrawable(resources);
        }
        ColorDrawable colorDrawable = new ColorDrawable(0);
        ColorDrawable colorDrawable2 = new ColorDrawable(n);
        StateListDrawable stateListDrawable = new StateListDrawable();
        int[] nArray = new int[]{0x10100A1};
        stateListDrawable.addState(nArray, colorDrawable);
        int[] nArray2 = new int[]{16842919};
        stateListDrawable.addState(nArray2, colorDrawable);
        int[] nArray3 = new int[]{};
        stateListDrawable.addState(nArray3, colorDrawable2);
        SparseArray<Drawable.ConstantState> sparseArray = this.mBackgroundsCache;
        Drawable.ConstantState constantState2 = stateListDrawable.getConstantState();
        sparseArray.put(n, constantState2);
        return stateListDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getStringOrNull(Cursor cursor, int n) {
        if (n == -1) {
            return null;
        }
        try {
            String string2 = cursor.getString(n);
            return string2;
        }
        catch (Exception exception) {
            int n2 = Log.e(LOG_TAG, "unexpected error retrieving valid column from cursor, did the remote process die?", exception);
            return null;
        }
    }

    private void setViewDrawable(ImageView imageView, Drawable drawable2) {
        imageView.setImageDrawable(drawable2);
        if (drawable2 == null) {
            imageView.setVisibility(8);
            return;
        }
        imageView.setVisibility(0);
        boolean bl = drawable2.setVisible(false, false);
        boolean bl2 = drawable2.setVisible(true, false);
    }

    private void setViewText(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        if (TextUtils.isEmpty(charSequence)) {
            textView.setVisibility(8);
            return;
        }
        textView.setVisibility(0);
    }

    private void storeInIconCache(String string2, Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        WeakHashMap<String, Drawable.ConstantState> weakHashMap = this.mOutsideDrawablesCache;
        Drawable.ConstantState constantState = drawable2.getConstantState();
        Drawable.ConstantState constantState2 = weakHashMap.put(string2, constantState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSpinnerState(Cursor cursor) {
        Bundle bundle = cursor != null ? cursor.getExtras() : null;
        if (bundle != null && bundle.getBoolean("in_progress")) {
            View view = this.mSearchDialog.getWindow().getDecorView();
            Runnable runnable = this.mStartSpinnerRunnable;
            boolean bl = view.post(runnable);
            return;
        }
        View view = this.mSearchDialog.getWindow().getDecorView();
        Runnable runnable = this.mStopSpinnerRunnable;
        boolean bl = view.post(runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache childViewCache = (ChildViewCache)view.getTag();
        int n = 0;
        if (this.mBackgroundColorCol != -1) {
            int n2 = this.mBackgroundColorCol;
            n = cursor.getInt(n2);
        }
        Drawable drawable2 = this.getItemBackground(n);
        view.setBackgroundDrawable(drawable2);
        if (childViewCache.mText1 != null) {
            int n3 = this.mText1Col;
            String string2 = SuggestionsAdapter.getStringOrNull(cursor, n3);
            TextView textView = childViewCache.mText1;
            this.setViewText(textView, string2);
        }
        if (childViewCache.mText2 != null) {
            CharSequence charSequence;
            int n4 = this.mText2UrlCol;
            String string3 = SuggestionsAdapter.getStringOrNull(cursor, n4);
            if (string3 != null) {
                charSequence = this.formatUrl(string3);
            } else {
                int n5 = this.mText2Col;
                charSequence = SuggestionsAdapter.getStringOrNull(cursor, n5);
            }
            if (TextUtils.isEmpty(charSequence)) {
                if (childViewCache.mText1 != null) {
                    childViewCache.mText1.setSingleLine(false);
                    childViewCache.mText1.setMaxLines(2);
                }
            } else if (childViewCache.mText1 != null) {
                childViewCache.mText1.setSingleLine(true);
                childViewCache.mText1.setMaxLines(1);
            }
            TextView textView = childViewCache.mText2;
            this.setViewText(textView, charSequence);
        }
        if (childViewCache.mIcon1 != null) {
            ImageView imageView = childViewCache.mIcon1;
            Drawable drawable3 = this.getIcon1(cursor);
            this.setViewDrawable(imageView, drawable3);
        }
        if (childViewCache.mIcon2 == null) {
            return;
        }
        ImageView imageView = childViewCache.mIcon2;
        Drawable drawable4 = this.getIcon2(cursor);
        this.setViewDrawable(imageView, drawable4);
    }

    @Override
    public void changeCursor(Cursor cursor) {
        if (this.mClosed) {
            int n = Log.w(LOG_TAG, "Tried to change cursor after adapter was closed.");
            if (cursor == null) {
                return;
            }
            cursor.close();
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            super.changeCursor(cursor);
            if (cursor == null) {
                return;
            }
            this.mText1Col = n6 = cursor.getColumnIndex("suggest_text_1");
            this.mText2Col = n5 = cursor.getColumnIndex("suggest_text_2");
            this.mText2UrlCol = n4 = cursor.getColumnIndex("suggest_text_2_url");
            this.mIconName1Col = n3 = cursor.getColumnIndex("suggest_icon_1");
            this.mIconName2Col = n2 = cursor.getColumnIndex("suggest_icon_2");
            this.mBackgroundColorCol = n = cursor.getColumnIndex("suggest_background_color");
            return;
        }
        catch (Exception exception) {
            int n = Log.e(LOG_TAG, "error changing cursor and caching columns", exception);
            return;
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence convertToString(Cursor cursor) {
        String string2;
        if (cursor == null) {
            return null;
        }
        String string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (string3 != null) {
            return string3;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (string2 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return string2;
        }
        if (!this.mSearchable.shouldRewriteQueryFromText()) return null;
        String string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1");
        if (string4 == null) return null;
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        try {
            View view2 = super.getView(n, view, viewGroup);
            return view2;
        }
        catch (RuntimeException runtimeException) {
            int n2 = Log.w(LOG_TAG, "Search suggestions cursor threw exception.", runtimeException);
            Context context = this.mContext;
            Cursor cursor = this.mCursor;
            View view3 = this.newView(context, cursor, viewGroup);
            if (view3 == null) return view3;
            TextView textView = ((ChildViewCache)view3.getTag()).mText1;
            String string2 = runtimeException.toString();
            textView.setText(string2);
            return view3;
        }
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        View view = super.newView(context, cursor, viewGroup);
        ChildViewCache childViewCache = new ChildViewCache(view);
        view.setTag(childViewCache);
        return view;
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mSearchDialog.onDataSetChanged();
        Cursor cursor = this.getCursor();
        this.updateSpinnerState(cursor);
    }

    @Override
    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        Cursor cursor = this.getCursor();
        this.updateSpinnerState(cursor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        String string2 = charSequence == null ? "" : ((Object)charSequence).toString();
        View view = this.mSearchDialog.getWindow().getDecorView();
        Runnable runnable = this.mStartSpinnerRunnable;
        boolean bl = view.post(runnable);
        try {
            SearchManager searchManager = this.mSearchManager;
            SearchableInfo searchableInfo = this.mSearchable;
            Cursor cursor = searchManager.getSuggestions(searchableInfo, string2, 50);
            if (cursor != null) {
                int n = cursor.getCount();
                return cursor;
            }
        }
        catch (RuntimeException runtimeException) {
            int n = Log.w(LOG_TAG, "Search suggestions query threw an exception.", runtimeException);
        }
        View view2 = this.mSearchDialog.getWindow().getDecorView();
        Runnable runnable2 = this.mStopSpinnerRunnable;
        boolean bl2 = view2.post(runnable2);
        return null;
    }

    private static final class ChildViewCache {
        public final ImageView mIcon1;
        public final ImageView mIcon2;
        public final TextView mText1;
        public final TextView mText2;

        public ChildViewCache(View view) {
            ImageView imageView;
            ImageView imageView2;
            TextView textView;
            TextView textView2;
            this.mText1 = textView2 = (TextView)view.findViewById(16908308);
            this.mText2 = textView = (TextView)view.findViewById(16908309);
            this.mIcon1 = imageView2 = (ImageView)view.findViewById(16908295);
            this.mIcon2 = imageView = (ImageView)view.findViewById(16908296);
        }
    }
}

