/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityGroup;
import android.app.LocalActivityManager;
import android.os.Bundle;
import android.view.View;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TextView;

public class TabActivity
extends ActivityGroup {
    private String mDefaultTab = null;
    private int mDefaultTabIndex = -1;
    private TabHost mTabHost;

    private void ensureTabHost() {
        if (this.mTabHost != null) {
            return;
        }
        this.setContentView(17367138);
    }

    public TabHost getTabHost() {
        this.ensureTabHost();
        return this.mTabHost;
    }

    public TabWidget getTabWidget() {
        return this.mTabHost.getTabWidget();
    }

    @Override
    protected void onChildTitleChanged(Activity activity, CharSequence charSequence) {
        if (this.getLocalActivityManager().getCurrentActivity() != activity) {
            return;
        }
        View view = this.mTabHost.getCurrentTabView();
        if (view == null) {
            return;
        }
        if (!(view instanceof TextView)) {
            return;
        }
        ((TextView)view).setText(charSequence);
    }

    @Override
    public void onContentChanged() {
        TabHost tabHost;
        super.onContentChanged();
        this.mTabHost = tabHost = (TabHost)this.findViewById(0x1020012);
        if (this.mTabHost == null) {
            throw new RuntimeException("Your content must have a TabHost whose id attribute is 'android.R.id.tabhost'");
        }
        TabHost tabHost2 = this.mTabHost;
        LocalActivityManager localActivityManager = this.getLocalActivityManager();
        tabHost2.setup(localActivityManager);
    }

    @Override
    protected void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        this.ensureTabHost();
        if (this.mTabHost.getCurrentTab() != -1) {
            return;
        }
        this.mTabHost.setCurrentTab(0);
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.ensureTabHost();
        String string2 = bundle.getString("currentTab");
        if (string2 != null) {
            this.mTabHost.setCurrentTabByTag(string2);
        }
        if (this.mTabHost.getCurrentTab() >= 0) {
            return;
        }
        if (this.mDefaultTab != null) {
            TabHost tabHost = this.mTabHost;
            String string3 = this.mDefaultTab;
            tabHost.setCurrentTabByTag(string3);
            return;
        }
        if (this.mDefaultTabIndex < 0) {
            return;
        }
        TabHost tabHost = this.mTabHost;
        int n = this.mDefaultTabIndex;
        tabHost.setCurrentTab(n);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        String string2 = this.mTabHost.getCurrentTabTag();
        if (string2 == null) {
            return;
        }
        bundle.putString("currentTab", string2);
    }

    public void setDefaultTab(int n) {
        this.mDefaultTab = null;
        this.mDefaultTabIndex = n;
    }

    public void setDefaultTab(String string2) {
        this.mDefaultTab = string2;
        this.mDefaultTabIndex = -1;
    }
}

