/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperInfo;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindowSession;
import android.view.ViewRoot;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WallpaperManager {
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String COMMAND_DROP = "android.home.drop";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    private static boolean DEBUG;
    private static String TAG;
    private static Object mSync;
    private static Globals sGlobals;
    private final Context mContext;
    private float mWallpaperXStep = -1.0f;
    private float mWallpaperYStep = -1.0f;

    static {
        TAG = "WallpaperManager";
        DEBUG = false;
        mSync = new Object();
    }

    WallpaperManager(Context context, Handler handler) {
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    /*
     * Enabled aggressive block sorting
     */
    static Bitmap generateBitmap(Context context, Bitmap bitmap, int n, int n2) {
        int n3;
        int n4;
        if (bitmap == null) {
            return bitmap;
        }
        int n5 = DisplayMetrics.DENSITY_DEVICE;
        bitmap.setDensity(n5);
        Bitmap.Config config = Bitmap.Config.RGB_565;
        Bitmap bitmap2 = Bitmap.createBitmap(n, n2, config);
        int n6 = DisplayMetrics.DENSITY_DEVICE;
        bitmap2.setDensity(n6);
        Canvas canvas = new Canvas(bitmap2);
        int n7 = DisplayMetrics.DENSITY_DEVICE;
        canvas.setDensity(n7);
        Rect rect = new Rect();
        rect.top = 0;
        rect.left = 0;
        rect.right = n4 = bitmap.getWidth();
        rect.bottom = n3 = bitmap.getHeight();
        int n8 = rect.right;
        int n9 = n - n8;
        int n10 = rect.bottom;
        int n11 = n2 - n10;
        if (n9 > 0 || n11 > 0) {
            int n12;
            int n13;
            float f;
            if (n9 > n11) {
                float f2 = n;
                float f3 = rect.right;
                f = f2 / f3;
            } else {
                float f4 = n2;
                float f5 = rect.bottom;
                f = f4 / f5;
            }
            rect.right = n13 = (int)((float)rect.right * f);
            rect.bottom = n12 = (int)((float)rect.bottom * f);
            int n14 = rect.right;
            n9 = n - n14;
            int n15 = rect.bottom;
            n11 = n2 - n15;
        }
        int n16 = n9 / 2;
        int n17 = n11 / 2;
        rect.offset(n16, n17);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawBitmap(bitmap, null, rect, paint);
        bitmap.recycle();
        return bitmap2;
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    static void initGlobals(Looper looper) {
        Object object = mSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
            return;
        }
    }

    private void setWallpaper(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n;
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        return;
    }

    public void clear() throws IOException {
        this.setResource(17301844);
    }

    public void clearWallpaperOffsets(IBinder iBinder) {
        try {
            IWindowSession iWindowSession = ViewRoot.getWindowSession(this.mContext.getMainLooper());
            IBinder iBinder2 = iBinder;
            iWindowSession.setWallpaperPosition(iBinder2, -1.0f, -1.0f, -1.0f, -1.0f);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDesiredMinimumHeight() {
        try {
            int n = sGlobals.mService.getHeightHint();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDesiredMinimumWidth() {
        try {
            int n = sGlobals.mService.getWidthHint();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getDrawable() {
        Globals globals = sGlobals;
        Context context = this.mContext;
        Bitmap bitmap = globals.peekWallpaperBitmap(context, true);
        if (bitmap == null) return null;
        Resources resources = this.mContext.getResources();
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        ((Drawable)bitmapDrawable).setDither(false);
        return bitmapDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getFastDrawable() {
        Globals globals = sGlobals;
        Context context = this.mContext;
        Bitmap bitmap = globals.peekWallpaperBitmap(context, true);
        if (bitmap == null) return null;
        return new FastBitmapDrawable(bitmap);
    }

    public IWallpaperManager getIWallpaperManager() {
        return sGlobals.mService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WallpaperInfo getWallpaperInfo() {
        try {
            WallpaperInfo wallpaperInfo = sGlobals.mService.getWallpaperInfo();
            return wallpaperInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable peekDrawable() {
        Globals globals = sGlobals;
        Context context = this.mContext;
        Bitmap bitmap = globals.peekWallpaperBitmap(context, false);
        if (bitmap == null) return null;
        Resources resources = this.mContext.getResources();
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        ((Drawable)bitmapDrawable).setDither(false);
        return bitmapDrawable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable peekFastDrawable() {
        Globals globals = sGlobals;
        Context context = this.mContext;
        Bitmap bitmap = globals.peekWallpaperBitmap(context, false);
        if (bitmap == null) return null;
        return new FastBitmapDrawable(bitmap);
    }

    public void sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle) {
        try {
            IWindowSession iWindowSession = ViewRoot.getWindowSession(this.mContext.getMainLooper());
            IBinder iBinder2 = iBinder;
            String string3 = string2;
            int n4 = n;
            int n5 = n2;
            int n6 = n3;
            Bundle bundle2 = bundle;
            Bundle bundle3 = iWindowSession.sendWallpaperCommand(iBinder2, string3, n4, n5, n6, bundle2, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setBitmap(Bitmap var1_1) throws IOException {
        block10: {
            var3_3 = var2_2 = Globals.access$300(WallpaperManager.sGlobals).setWallpaper(null);
            if (var3_3 == null) {
                return;
            }
            var4_4 = null;
            try {
                var5_5 = new ParcelFileDescriptor.AutoCloseOutputStream(var3_3);
            }
            catch (Throwable var9_9) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw var9_10;
                }
            }
            try {
                var6_6 = Bitmap.CompressFormat.PNG;
                var7_7 = var1_1.compress(var6_6, 90, var5_5);
                if (var5_5 != null) break block10;
                return;
            }
            catch (Throwable var9_11) {
                var4_4 = var5_5;
                ** continue;
            }
        }
        try {
            var5_5.close();
            return;
        }
        catch (RemoteException var8_8) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setResource(int var1_1) throws IOException {
        block10: {
            var2_2 = this.mContext.getResources();
            var3_3 = Globals.access$300(WallpaperManager.sGlobals);
            var4_4 = new StringBuilder().append("res:");
            var5_5 = var2_2.getResourceName(var1_1);
            var6_6 = var4_4.append(var5_5).toString();
            var8_8 = var7_7 = var3_3.setWallpaper(var6_6);
            if (var8_8 == null) {
                return;
            }
            var9_9 = null;
            var10_10 = new ParcelFileDescriptor.AutoCloseOutputStream(var8_8);
            {
                catch (Throwable var12_12) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var9_9 != null) {
                            var9_9.close();
                        }
                        throw var12_13;
                    }
                }
            }
            try {
                var11_11 = var2_2.openRawResource(var1_1);
                this.setWallpaper(var11_11, var10_10);
                if (var10_10 != null) break block10;
                return;
            }
            catch (Throwable var12_14) {
                var9_9 = var10_10;
                ** continue;
            }
        }
        try {
            var10_10.close();
            return;
        }
        catch (RemoteException var13_15) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setStream(InputStream var1_1) throws IOException {
        block10: {
            var3_3 = var2_2 = Globals.access$300(WallpaperManager.sGlobals).setWallpaper(null);
            if (var3_3 == null) {
                return;
            }
            var4_4 = null;
            try {
                var5_5 = new ParcelFileDescriptor.AutoCloseOutputStream(var3_3);
            }
            catch (Throwable var7_7) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    throw var7_8;
                }
            }
            try {
                this.setWallpaper(var1_1, var5_5);
                if (var5_5 != null) break block10;
                return;
            }
            catch (Throwable var7_9) {
                var4_4 = var5_5;
                ** continue;
            }
        }
        try {
            var5_5.close();
            return;
        }
        catch (RemoteException var6_6) {
            return;
        }
    }

    public void setWallpaperOffsetSteps(float f, float f2) {
        this.mWallpaperXStep = f;
        this.mWallpaperYStep = f2;
    }

    public void setWallpaperOffsets(IBinder iBinder, float f, float f2) {
        try {
            IWindowSession iWindowSession = ViewRoot.getWindowSession(this.mContext.getMainLooper());
            float f3 = this.mWallpaperXStep;
            float f4 = this.mWallpaperYStep;
            IBinder iBinder2 = iBinder;
            float f5 = f;
            float f6 = f2;
            iWindowSession.setWallpaperPosition(iBinder2, f5, f6, f3, f4);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void suggestDesiredDimensions(int n, int n2) {
        try {
            sGlobals.mService.setDimensionHints(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    static class Globals
    extends IWallpaperManagerCallback.Stub {
        private static final int MSG_CLEAR_WALLPAPER = 1;
        private Bitmap mDefaultWallpaper;
        private final Handler mHandler;
        private IWallpaperManager mService;
        private Bitmap mWallpaper;

        Globals(Looper looper) {
            Handler handler;
            IWallpaperManager iWallpaperManager;
            this.mService = iWallpaperManager = IWallpaperManager.Stub.asInterface(ServiceManager.getService("wallpaper"));
            this.mHandler = handler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 1: 
                    }
                    synchronized (this) {
                        Bitmap bitmap = Globals.access$002(Globals.this, null);
                        Bitmap bitmap2 = Globals.access$102(Globals.this, null);
                        return;
                    }
                }
            };
        }

        static /* synthetic */ Bitmap access$002(Globals globals, Bitmap bitmap) {
            globals.mWallpaper = bitmap;
            return bitmap;
        }

        static /* synthetic */ Bitmap access$102(Globals globals, Bitmap bitmap) {
            globals.mDefaultWallpaper = bitmap;
            return bitmap;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bitmap getCurrentWallpaperLocked(Context context) {
            Bitmap bitmap;
            Bitmap bitmap2;
            Bitmap bitmap3;
            int n;
            int n2;
            block7: {
                try {
                    Bitmap.Config config;
                    Bundle bundle = new Bundle();
                    ParcelFileDescriptor parcelFileDescriptor = this.mService.getWallpaper(this, bundle);
                    if (parcelFileDescriptor == null) return null;
                    n2 = bundle.getInt("width", 0);
                    n = bundle.getInt("height", 0);
                    if (n2 <= 0 || n <= 0) {
                        Bitmap bitmap4;
                        bitmap3 = bitmap4 = BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, null);
                        parcelFileDescriptor.close();
                        break block7;
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inDither = false;
                    options.inPreferredConfig = config = Bitmap.Config.ARGB_8888;
                    bitmap = bitmap2 = BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, options);
                    parcelFileDescriptor.close();
                    bitmap2 = WallpaperManager.generateBitmap(context, bitmap, n2, n);
                    return bitmap2;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return null;
                catch (IOException iOException) {}
            }
            if (bitmap3 == null) return bitmap3;
            int n3 = DisplayMetrics.DENSITY_DEVICE;
            bitmap3.setDensity(n3);
            return bitmap3;
            catch (IOException iOException) {}
            bitmap2 = WallpaperManager.generateBitmap(context, bitmap, n2, n);
            return bitmap2;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bitmap getDefaultWallpaperLocked(Context context) {
            Bitmap bitmap;
            Bitmap bitmap2;
            int n;
            int n2;
            block10: {
                Bitmap bitmap3;
                block9: {
                    try {
                        Bitmap.Config config;
                        InputStream inputStream = context.getResources().openRawResource(17301844);
                        if (inputStream == null) return null;
                        n2 = this.mService.getWidthHint();
                        n = this.mService.getHeightHint();
                        if (n2 <= 0 || n <= 0) {
                            Bitmap bitmap4;
                            bitmap3 = bitmap4 = BitmapFactory.decodeStream(inputStream, null, null);
                            inputStream.close();
                            break block9;
                        }
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inDither = false;
                        options.inPreferredConfig = config = Bitmap.Config.ARGB_8888;
                        bitmap = bitmap2 = BitmapFactory.decodeStream(inputStream, null, options);
                        inputStream.close();
                        break block10;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    return null;
                    catch (IOException iOException) {}
                }
                if (bitmap3 == null) return bitmap3;
                int n3 = DisplayMetrics.DENSITY_DEVICE;
                bitmap3.setDensity(n3);
                return bitmap3;
                catch (IOException iOException) {}
            }
            try {
                bitmap2 = WallpaperManager.generateBitmap(context, bitmap, n2, n);
                return bitmap2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                int n4 = Log.w(TAG, "Can't generate default bitmap", outOfMemoryError);
                return bitmap;
            }
        }

        @Override
        public void onWallpaperChanged() {
            boolean bl = this.mHandler.sendEmptyMessage(1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean bl) {
            synchronized (this) {
                Bitmap bitmap;
                if (this.mWallpaper != null) {
                    return this.mWallpaper;
                }
                if (this.mDefaultWallpaper != null) {
                    return this.mDefaultWallpaper;
                }
                this.mWallpaper = bitmap = null;
                try {
                    Bitmap bitmap2;
                    this.mWallpaper = bitmap2 = this.getCurrentWallpaperLocked(context);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    int n = Log.w(TAG, "No memory load current wallpaper", outOfMemoryError);
                }
                if (this.mWallpaper != null) return this.mWallpaper;
                if (!bl) return this.mWallpaper;
                Bitmap bitmap3 = this.getDefaultWallpaperLocked(context);
                this.mDefaultWallpaper = bitmap3;
                return this.mDefaultWallpaper;
            }
        }
    }

    static class FastBitmapDrawable
    extends Drawable {
        private final Bitmap mBitmap;
        private int mDrawLeft;
        private int mDrawTop;
        private final int mHeight;
        private final int mWidth;

        private FastBitmapDrawable(Bitmap bitmap) {
            int n;
            int n2;
            this.mBitmap = bitmap;
            this.mWidth = n2 = bitmap.getWidth();
            this.mHeight = n = bitmap.getHeight();
            int n3 = this.mWidth;
            int n4 = this.mHeight;
            this.setBounds(0, 0, n3, n4);
        }

        @Override
        public void draw(Canvas canvas) {
            Bitmap bitmap = this.mBitmap;
            float f = this.mDrawLeft;
            float f2 = this.mDrawTop;
            canvas.drawBitmap(bitmap, f, f2, null);
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        @Override
        public int getMinimumHeight() {
            return this.mHeight;
        }

        @Override
        public int getMinimumWidth() {
            return this.mWidth;
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setAlpha(int n) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7 = n3 - n;
            int n8 = this.mWidth;
            this.mDrawLeft = n6 = (n7 - n8) / 2 + n;
            int n9 = n4 - n2;
            int n10 = this.mHeight;
            this.mDrawTop = n5 = (n9 - n10) / 2 + n2;
        }

        @Override
        public void setBounds(Rect rect) {
            super.setBounds(rect);
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setDither(boolean bl) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setFilterBitmap(boolean bl) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }
    }
}

