/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;

public class DeviceAdminReceiver
extends BroadcastReceiver {
    public static final String ACTION_DEVICE_ADMIN_DISABLED = "android.app.action.DEVICE_ADMIN_DISABLED";
    public static final String ACTION_DEVICE_ADMIN_DISABLE_REQUESTED = "android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED";
    public static final String ACTION_DEVICE_ADMIN_ENABLED = "android.app.action.DEVICE_ADMIN_ENABLED";
    public static final String ACTION_PASSWORD_CHANGED = "android.app.action.ACTION_PASSWORD_CHANGED";
    public static final String ACTION_PASSWORD_FAILED = "android.app.action.ACTION_PASSWORD_FAILED";
    public static final String ACTION_PASSWORD_SUCCEEDED = "android.app.action.ACTION_PASSWORD_SUCCEEDED";
    private static boolean DEBUG = false;
    public static final String DEVICE_ADMIN_META_DATA = "android.app.device_admin";
    public static final String EXTRA_DISABLE_WARNING = "android.app.extra.DISABLE_WARNING";
    private static String TAG = "DevicePolicy";
    private static boolean localLOGV;
    private DevicePolicyManager mManager;
    private ComponentName mWho;

    /*
     * Enabled aggressive block sorting
     */
    static {
        DEBUG = false;
        boolean bl = DEBUG;
        localLOGV = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DevicePolicyManager getManager(Context context) {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy");
        this.mManager = devicePolicyManager;
        if (this.mManager == null) return this.mManager;
        return this.mManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ComponentName getWho(Context context) {
        if (this.mWho != null) {
            return this.mWho;
        }
        Class<? extends Object> clazz = this.getClass();
        ComponentName componentName = new ComponentName(context, clazz);
        this.mWho = componentName;
        return this.mWho;
    }

    public CharSequence onDisableRequested(Context context, Intent intent) {
        return null;
    }

    public void onDisabled(Context context, Intent intent) {
    }

    public void onEnabled(Context context, Intent intent) {
    }

    public void onPasswordChanged(Context context, Intent intent) {
    }

    public void onPasswordFailed(Context context, Intent intent) {
    }

    public void onPasswordSucceeded(Context context, Intent intent) {
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getAction();
        if (ACTION_PASSWORD_CHANGED.equals(string2)) {
            this.onPasswordChanged(context, intent);
            return;
        }
        if (ACTION_PASSWORD_FAILED.equals(string2)) {
            this.onPasswordFailed(context, intent);
            return;
        }
        if (ACTION_PASSWORD_SUCCEEDED.equals(string2)) {
            this.onPasswordSucceeded(context, intent);
            return;
        }
        if (ACTION_DEVICE_ADMIN_ENABLED.equals(string2)) {
            this.onEnabled(context, intent);
            return;
        }
        if (ACTION_DEVICE_ADMIN_DISABLE_REQUESTED.equals(string2)) {
            CharSequence charSequence = this.onDisableRequested(context, intent);
            if (charSequence == null) {
                return;
            }
            this.getResultExtras(true).putCharSequence(EXTRA_DISABLE_WARNING, charSequence);
            return;
        }
        if (!ACTION_DEVICE_ADMIN_DISABLED.equals(string2)) {
            return;
        }
        this.onDisabled(context, intent);
    }
}

