/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.DeviceAdminInfo;
import android.app.admin.IDevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.IOException;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class DevicePolicyManager {
    public static final String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";
    public static final String ACTION_DEVICE_POLICY_MANAGER_STATE_CHANGED = "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED";
    public static final String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";
    private static boolean DEBUG = false;
    public static final String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";
    public static final String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";
    public static final int PASSWORD_QUALITY_ALPHABETIC = 262144;
    public static final int PASSWORD_QUALITY_ALPHANUMERIC = 327680;
    public static final int PASSWORD_QUALITY_NUMERIC = 131072;
    public static final int PASSWORD_QUALITY_SOMETHING = 65536;
    public static final int PASSWORD_QUALITY_UNSPECIFIED = 0;
    public static final int RESET_PASSWORD_REQUIRE_ENTRY = 1;
    private static String TAG = "DevicePolicyManager";
    public static final int WIPE_EXTERNAL_STORAGE = 1;
    private static boolean localLOGV;
    private final Context mContext;
    private final Handler mHandler;
    private final IDevicePolicyManager mService;

    /*
     * Enabled aggressive block sorting
     */
    static {
        DEBUG = false;
        boolean bl = DEBUG;
        localLOGV = bl;
    }

    private DevicePolicyManager(Context context, Handler handler) {
        IDevicePolicyManager iDevicePolicyManager;
        this.mContext = context;
        this.mHandler = handler;
        this.mService = iDevicePolicyManager = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DevicePolicyManager create(Context context, Handler handler) {
        DevicePolicyManager devicePolicyManager = new DevicePolicyManager(context, handler);
        if (devicePolicyManager.mService == null) return null;
        return devicePolicyManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ComponentName> getActiveAdmins() {
        if (this.mService == null) return null;
        try {
            List<ComponentName> list = this.mService.getActiveAdmins();
            return list;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeviceAdminInfo getAdminInfo(ComponentName componentName) {
        ResolveInfo resolveInfo;
        try {
            ActivityInfo activityInfo;
            ActivityInfo activityInfo2 = activityInfo = this.mContext.getPackageManager().getReceiverInfo(componentName, 128);
            resolveInfo = new ResolveInfo();
            resolveInfo.activityInfo = activityInfo2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = TAG;
            String string3 = "Unable to retrieve device policy " + componentName;
            int n = Log.w(string2, string3, nameNotFoundException);
            return null;
        }
        try {
            Context context = this.mContext;
            return new DeviceAdminInfo(context, resolveInfo);
        }
        catch (XmlPullParserException xmlPullParserException) {
            String string4 = TAG;
            String string5 = "Unable to parse device policy " + componentName;
            int n = Log.w(string4, string5, xmlPullParserException);
            return null;
        }
        catch (IOException iOException) {
            String string6 = TAG;
            String string7 = "Unable to parse device policy " + componentName;
            int n = Log.w(string6, string7, iOException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCurrentFailedPasswordAttempts() {
        if (this.mService == null) return -1;
        try {
            int n = this.mService.getCurrentFailedPasswordAttempts();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMaximumFailedPasswordsForWipe(ComponentName componentName) {
        if (this.mService == null) return 0;
        try {
            int n = this.mService.getMaximumFailedPasswordsForWipe(componentName);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getMaximumTimeToLock(ComponentName componentName) {
        if (this.mService == null) return 0L;
        try {
            long l = this.mService.getMaximumTimeToLock(componentName);
            return l;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return 0L;
    }

    public int getPasswordMaximumLength(int n) {
        return 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPasswordMinimumLength(ComponentName componentName) {
        if (this.mService == null) return 0;
        try {
            int n = this.mService.getPasswordMinimumLength(componentName);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPasswordQuality(ComponentName componentName) {
        if (this.mService == null) return 0;
        try {
            int n = this.mService.getPasswordQuality(componentName);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return 0;
    }

    public void getRemoveWarning(ComponentName componentName, RemoteCallback remoteCallback) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.getRemoveWarning(componentName, remoteCallback);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActivePasswordSufficient() {
        if (this.mService == null) return false;
        try {
            boolean bl = this.mService.isActivePasswordSufficient();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAdminActive(ComponentName componentName) {
        if (this.mService == null) return false;
        try {
            boolean bl = this.mService.isAdminActive(componentName);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return false;
    }

    public void lockNow() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.lockNow();
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean packageHasActiveAdmins(String string2) {
        if (this.mService == null) return false;
        try {
            boolean bl = this.mService.packageHasActiveAdmins(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return false;
    }

    public void removeActiveAdmin(ComponentName componentName) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.removeActiveAdmin(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void reportFailedPasswordAttempt() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.reportFailedPasswordAttempt();
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void reportSuccessfulPasswordAttempt() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.reportSuccessfulPasswordAttempt();
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resetPassword(String string2, int n) {
        if (this.mService == null) return false;
        try {
            boolean bl = this.mService.resetPassword(string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Failed talking with device policy service", remoteException);
        }
        return false;
    }

    public void setActiveAdmin(ComponentName componentName) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setActiveAdmin(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setActivePasswordState(int n, int n2) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setActivePasswordState(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setMaximumFailedPasswordsForWipe(componentName, n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setMaximumTimeToLock(ComponentName componentName, long l) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setMaximumTimeToLock(componentName, l);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setPasswordMinimumLength(ComponentName componentName, int n) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setPasswordMinimumLength(componentName, n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setPasswordQuality(ComponentName componentName, int n) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setPasswordQuality(componentName, n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void wipeData(int n) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.wipeData(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }
}

