/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;

public abstract class BackupAgent
extends ContextWrapper {
    private static final boolean DEBUG = false;
    private static final String TAG = "BackupAgent";
    private final IBinder mBinder;

    public BackupAgent() {
        super(null);
        IBinder iBinder;
        this.mBinder = iBinder = new BackupServiceBinder().asBinder();
    }

    public void attach(Context context) {
        this.attachBaseContext(context);
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public final IBinder onBind() {
        return this.mBinder;
    }

    public void onCreate() {
    }

    public void onDestroy() {
    }

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    private class BackupServiceBinder
    extends IBackupAgent.Stub {
        private static final String TAG = "BackupServiceBinder";

        private BackupServiceBinder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doBackup(ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, ParcelFileDescriptor parcelFileDescriptor3, int n, IBackupManager iBackupManager) throws RemoteException {
            long l = Binder.clearCallingIdentity();
            FileDescriptor fileDescriptor = parcelFileDescriptor2.getFileDescriptor();
            BackupDataOutput backupDataOutput = new BackupDataOutput(fileDescriptor);
            try {
                BackupAgent.this.onBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor3);
                return;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("onBackup (");
                String string2 = BackupAgent.this.getClass().getName();
                String string3 = stringBuilder.append(string2).append(") threw").toString();
                int n2 = Log.d(TAG, string3, iOException);
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("onBackup (");
                String string4 = BackupAgent.this.getClass().getName();
                String string5 = stringBuilder.append(string4).append(") threw").toString();
                int n3 = Log.d(TAG, string5, runtimeException);
                throw runtimeException;
            }
            finally {
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void doRestore(ParcelFileDescriptor parcelFileDescriptor, int n, ParcelFileDescriptor parcelFileDescriptor2, int n2, IBackupManager iBackupManager) throws RemoteException {
            long l = Binder.clearCallingIdentity();
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            BackupDataInput backupDataInput = new BackupDataInput(fileDescriptor);
            try {
                BackupAgent.this.onRestore(backupDataInput, n, parcelFileDescriptor2);
                return;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("onRestore (");
                String string2 = BackupAgent.this.getClass().getName();
                String string3 = stringBuilder.append(string2).append(") threw").toString();
                int n3 = Log.d(TAG, string3, iOException);
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder = new StringBuilder().append("onRestore (");
                String string4 = BackupAgent.this.getClass().getName();
                String string5 = stringBuilder.append(string4).append(") threw").toString();
                int n4 = Log.d(TAG, string5, runtimeException);
                throw runtimeException;
            }
            finally {
                Binder.restoreCallingIdentity(l);
                iBackupManager.opComplete(n2);
            }
        }
    }
}

