/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataInput {
    int mBackupReader;
    private EntityHeader mHeader;
    private boolean mHeaderReady;

    public BackupDataInput(FileDescriptor fileDescriptor) {
        int n;
        EntityHeader entityHeader;
        this.mHeader = entityHeader = new EntityHeader();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        this.mBackupReader = n = BackupDataInput.ctor(fileDescriptor);
        if (this.mBackupReader != 0) {
            return;
        }
        String string2 = "Native initialization failed with fd=" + fileDescriptor;
        throw new RuntimeException(string2);
    }

    private static native int ctor(FileDescriptor var0);

    private static native void dtor(int var0);

    private native int readEntityData_native(int var1, byte[] var2, int var3, int var4);

    private native int readNextHeader_native(int var1, EntityHeader var2);

    private native int skipEntityData_native(int var1);

    protected void finalize() throws Throwable {
        try {
            BackupDataInput.dtor(this.mBackupReader);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDataSize() {
        if (this.mHeaderReady) {
            return this.mHeader.dataSize;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public String getKey() {
        if (this.mHeaderReady) {
            return this.mHeader.key;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int readEntityData(byte[] byArray, int n, int n2) throws IOException {
        if (this.mHeaderReady) {
            int n3 = this.mBackupReader;
            int n4 = this.readEntityData_native(n3, byArray, n, n2);
            if (n4 >= 0) {
                return n4;
            }
            StringBuilder stringBuilder = new StringBuilder().append("result=0x");
            String string2 = Integer.toHexString(n4);
            String string3 = stringBuilder.append(string2).toString();
            throw new IOException(string3);
        }
        throw new IllegalStateException("Entity header not read");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readNextHeader() throws IOException {
        int n = this.mBackupReader;
        EntityHeader entityHeader = this.mHeader;
        int n2 = this.readNextHeader_native(n, entityHeader);
        if (n2 == 0) {
            this.mHeaderReady = true;
            return true;
        }
        if (n2 > 0) {
            this.mHeaderReady = false;
            return false;
        }
        this.mHeaderReady = false;
        StringBuilder stringBuilder = new StringBuilder().append("failed: 0x");
        String string2 = Integer.toHexString(n2);
        String string3 = stringBuilder.append(string2).toString();
        throw new IOException(string3);
    }

    public void skipEntityData() throws IOException {
        if (this.mHeaderReady) {
            int n = this.mBackupReader;
            int n2 = this.skipEntityData_native(n);
            return;
        }
        throw new IllegalStateException("Entity header not read");
    }

    private static class EntityHeader {
        int dataSize;
        String key;

        private EntityHeader() {
        }
    }
}

