/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BackupHelperDispatcher {
    private static final String TAG = "BackupHelperDispatcher";
    TreeMap<String, BackupHelper> mHelpers;

    public BackupHelperDispatcher() {
        TreeMap treeMap = new TreeMap();
        this.mHelpers = treeMap;
    }

    private static native int allocateHeader_native(Header var0, FileDescriptor var1);

    private void doOneBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, Header header, BackupHelper backupHelper) throws IOException {
        FileDescriptor fileDescriptor = parcelFileDescriptor2.getFileDescriptor();
        int n = BackupHelperDispatcher.allocateHeader_native(header, fileDescriptor);
        if (n < 0) {
            String string2 = "allocateHeader_native failed (error " + n + ")";
            throw new IOException(string2);
        }
        String string3 = header.keyPrefix;
        backupDataOutput.setKeyPrefix(string3);
        backupHelper.performBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
        int n2 = BackupHelperDispatcher.writeHeader_native(header, fileDescriptor, n);
        if (n2 == 0) {
            return;
        }
        String string4 = "writeHeader_native failed (error " + n2 + ")";
        throw new IOException(string4);
    }

    private static native int readHeader_native(Header var0, FileDescriptor var1);

    private static native int skipChunk_native(FileDescriptor var0, int var1);

    private static native int writeHeader_native(Header var0, FileDescriptor var1, int var2);

    public void addHelper(String string2, BackupHelper backupHelper) {
        BackupHelper backupHelper2 = this.mHelpers.put(string2, backupHelper);
    }

    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) throws IOException {
        Header header = new Header();
        TreeMap treeMap = (TreeMap)this.mHelpers.clone();
        FileDescriptor fileDescriptor = parcelFileDescriptor2.getFileDescriptor();
        if (parcelFileDescriptor != null) {
            int n;
            FileDescriptor fileDescriptor2 = parcelFileDescriptor.getFileDescriptor();
            while ((n = BackupHelperDispatcher.readHeader_native(header, fileDescriptor2)) >= 0) {
                if (n != 0) continue;
                String string2 = header.keyPrefix;
                BackupHelper backupHelper = (BackupHelper)treeMap.get(string2);
                StringBuilder stringBuilder = new StringBuilder().append("handling existing helper '");
                String string3 = header.keyPrefix;
                String string4 = stringBuilder.append(string3).append("' ").append(backupHelper).toString();
                int n2 = Log.d(TAG, string4);
                if (backupHelper != null) {
                    BackupHelperDispatcher backupHelperDispatcher = this;
                    ParcelFileDescriptor parcelFileDescriptor3 = parcelFileDescriptor;
                    BackupDataOutput backupDataOutput2 = backupDataOutput;
                    ParcelFileDescriptor parcelFileDescriptor4 = parcelFileDescriptor2;
                    backupHelperDispatcher.doOneBackup(parcelFileDescriptor3, backupDataOutput2, parcelFileDescriptor4, header, backupHelper);
                    String string5 = header.keyPrefix;
                    Object v = treeMap.remove(string5);
                    continue;
                }
                int n3 = header.chunkSize;
                int n4 = BackupHelperDispatcher.skipChunk_native(fileDescriptor2, n3);
            }
        }
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string6;
            Map.Entry entry = iterator.next();
            header.keyPrefix = string6 = (String)entry.getKey();
            StringBuilder stringBuilder = new StringBuilder().append("handling new helper '");
            String string7 = header.keyPrefix;
            String string8 = stringBuilder.append(string7).append("'").toString();
            int n = Log.d(TAG, string8);
            BackupHelper backupHelper = (BackupHelper)entry.getValue();
            BackupHelperDispatcher backupHelperDispatcher = this;
            ParcelFileDescriptor parcelFileDescriptor5 = parcelFileDescriptor;
            BackupDataOutput backupDataOutput3 = backupDataOutput;
            ParcelFileDescriptor parcelFileDescriptor6 = parcelFileDescriptor2;
            backupHelperDispatcher.doOneBackup(parcelFileDescriptor5, backupDataOutput3, parcelFileDescriptor6, header, backupHelper);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void performRestore(BackupDataInput backupDataInput, int n, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        boolean bl = false;
        BackupDataInputStream backupDataInputStream = new BackupDataInputStream(backupDataInput);
        while (backupDataInput.readNextHeader()) {
            block8: {
                String string2;
                block7: {
                    string2 = backupDataInput.getKey();
                    int n2 = string2.indexOf(58);
                    if (n2 <= 0) break block7;
                    String string3 = string2.substring(0, n2);
                    BackupHelper backupHelper = this.mHelpers.get(string3);
                    if (backupHelper != null) {
                        String string4;
                        int n3;
                        backupDataInputStream.dataSize = n3 = backupDataInput.getDataSize();
                        int n4 = n2 + 1;
                        backupDataInputStream.key = string4 = string2.substring(n4);
                        backupHelper.restoreEntity(backupDataInputStream);
                        break block8;
                    } else if (!bl) {
                        String string5 = "Couldn't find helper for: '" + string2 + "'";
                        int n5 = Log.w(TAG, string5);
                        bl = true;
                    }
                    break block8;
                }
                if (!bl) {
                    String string6 = "Entity with no prefix: '" + string2 + "'";
                    int n6 = Log.w(TAG, string6);
                    bl = true;
                }
            }
            backupDataInput.skipEntityData();
        }
        Iterator iterator = this.mHelpers.values().iterator();
        while (iterator.hasNext()) {
            ((BackupHelper)iterator.next()).writeNewStateDescription(parcelFileDescriptor);
        }
        return;
    }

    private static class Header {
        int chunkSize;
        String keyPrefix;

        private Header() {
        }
    }
}

