/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class BackupManager {
    private static final String TAG = "BackupManager";
    private static IBackupManager sService;
    private Context mContext;

    public BackupManager(Context context) {
        this.mContext = context;
    }

    private static void checkServiceBinder() {
        if (sService != null) {
            return;
        }
        sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
    }

    public static void dataChanged(String string2) {
        BackupManager.checkServiceBinder();
        if (sService == null) {
            return;
        }
        try {
            sService.dataChanged(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.d(TAG, "dataChanged(pkg) couldn't connect");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestoreSession beginRestoreSession() {
        RestoreSession restoreSession = null;
        BackupManager.checkServiceBinder();
        if (sService == null) return restoreSession;
        try {
            IRestoreSession iRestoreSession = sService.beginRestoreSession(null, null);
            Context context = this.mContext;
            RestoreSession restoreSession2 = new RestoreSession(context, iRestoreSession);
            return restoreSession2;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "beginRestoreSession() couldn't connect");
            return restoreSession;
        }
    }

    public void dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService == null) {
            return;
        }
        try {
            IBackupManager iBackupManager = sService;
            String string2 = this.mContext.getPackageName();
            iBackupManager.dataChanged(string2);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.d(TAG, "dataChanged() couldn't connect");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int requestRestore(RestoreObserver var1_1) {
        block12: {
            var2_2 = -1;
            BackupManager.checkServiceBinder();
            if (BackupManager.sService != null) {
                var3_3 = null;
                var4_4 = BackupManager.sService;
                var5_5 = this.mContext.getPackageName();
                var6_6 = var4_4.beginRestoreSession(var5_5, null);
                var7_7 = this.mContext;
                var8_8 = new RestoreSession(var7_7, var6_6);
                var9_9 = this.mContext.getPackageName();
                var2_2 = var10_10 = var8_8.restorePackage(var9_9, var1_1);
                if (var8_8 == null) break block12;
                var8_8.endRestoreSession();
            }
        }
lbl17:
        // 3 sources

        return var2_2;
        catch (RemoteException var11_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                try {
                    var12_12 = Log.w("BackupManager", "restoreSelf() unable to contact service");
                    if (var3_3 == null) ** GOTO lbl17
                    var3_3.endRestoreSession();
                    ** continue;
                }
                catch (Throwable var13_13) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var3_3 != null) {
                            var3_3.endRestoreSession();
                        }
                        throw var13_14;
                    }
                }
                break;
            }
        }
        catch (Throwable var13_15) {
            var3_3 = var8_8;
            ** continue;
        }
        catch (RemoteException var14_16) {
            var3_3 = var8_8;
            ** continue;
        }
    }
}

