/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;

class FileBackupHelperBase {
    private static final String TAG = "FileBackupHelperBase";
    Context mContext;
    boolean mExceptionLogged;
    int mPtr;

    FileBackupHelperBase(Context context) {
        int n;
        this.mPtr = n = FileBackupHelperBase.ctor();
        this.mContext = context;
    }

    private static native int ctor();

    private static native void dtor(int var0);

    /*
     * Enabled aggressive block sorting
     */
    static void performBackup_checked(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, String[] stringArray, String[] stringArray2) {
        if (stringArray.length == 0) {
            return;
        }
        for (String string2 : stringArray) {
            if (string2.charAt(0) == '/') continue;
            String string3 = "files must have all absolute paths: " + string2;
            throw new RuntimeException(string3);
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        if (n != n2) {
            StringBuilder stringBuilder = new StringBuilder().append("files.length=");
            int n3 = stringArray.length;
            StringBuilder stringBuilder2 = stringBuilder.append(n3).append(" keys.length=");
            int n4 = stringArray2.length;
            String string4 = stringBuilder2.append(n4).toString();
            throw new RuntimeException(string4);
        }
        FileDescriptor fileDescriptor = parcelFileDescriptor != null ? parcelFileDescriptor.getFileDescriptor() : null;
        FileDescriptor fileDescriptor2 = parcelFileDescriptor2.getFileDescriptor();
        if (fileDescriptor2 == null) {
            throw new NullPointerException();
        }
        int n5 = backupDataOutput.mBackupWriter;
        int n6 = FileBackupHelperBase.performBackup_native(fileDescriptor, n5, fileDescriptor2, stringArray, stringArray2);
        if (n6 == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Backup failed 0x");
        String string5 = Integer.toHexString(n6);
        String string6 = stringBuilder.append(string5).toString();
        throw new RuntimeException(string6);
    }

    private static native int performBackup_native(FileDescriptor var0, int var1, FileDescriptor var2, String[] var3, String[] var4);

    private static native int writeFile_native(int var0, String var1, int var2);

    private static native int writeSnapshot_native(int var0, FileDescriptor var1);

    protected void finalize() throws Throwable {
        try {
            FileBackupHelperBase.dtor(this.mPtr);
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isKeyInList(String string2, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray2[n2].equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void writeFile(File file, BackupDataInputStream backupDataInputStream) {
        int n;
        boolean bl = file.getParentFile().mkdirs();
        int n2 = this.mPtr;
        String string2 = file.getAbsolutePath();
        int n3 = FileBackupHelperBase.writeFile_native(n2, string2, n = backupDataInputStream.mData.mBackupReader);
        if (n3 == 0) {
            return;
        }
        if (this.mExceptionLogged) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Failed restoring file '").append(file).append("' for app '");
        String string3 = this.mContext.getPackageName();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("' result=0x");
        String string4 = Integer.toHexString(n3);
        String string5 = stringBuilder2.append(string4).toString();
        int n4 = Log.e(TAG, string5);
        this.mExceptionLogged = true;
    }

    public void writeNewStateDescription(ParcelFileDescriptor parcelFileDescriptor) {
        int n = this.mPtr;
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        int n2 = FileBackupHelperBase.writeSnapshot_native(n, fileDescriptor);
    }
}

