/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;

public class RestoreSession {
    static final String TAG = "RestoreSession";
    IRestoreSession mBinder;
    final Context mContext;
    RestoreObserverWrapper mObserver = null;

    RestoreSession(Context context, IRestoreSession iRestoreSession) {
        this.mContext = context;
        this.mBinder = iRestoreSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endRestoreSession() {
        try {
            this.mBinder.endRestoreSession();
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.d(TAG, "Can't contact server to get available sets");
            return;
        }
        finally {
            this.mBinder = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAvailableRestoreSets(RestoreObserver restoreObserver) {
        int n = -1;
        Context context = this.mContext;
        RestoreObserverWrapper restoreObserverWrapper = new RestoreObserverWrapper(context, restoreObserver);
        try {
            int n2 = this.mBinder.getAvailableRestoreSets(restoreObserverWrapper);
            return n2;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.d(TAG, "Can't contact server to get available sets");
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int restoreAll(long l, RestoreObserver restoreObserver) {
        RestoreObserverWrapper restoreObserverWrapper;
        int n = -1;
        if (this.mObserver != null) {
            int n2 = Log.d(TAG, "restoreAll() called during active restore");
            return -1;
        }
        Context context = this.mContext;
        this.mObserver = restoreObserverWrapper = new RestoreObserverWrapper(context, restoreObserver);
        try {
            int n3;
            IRestoreSession iRestoreSession = this.mBinder;
            RestoreObserverWrapper restoreObserverWrapper2 = this.mObserver;
            n = n3 = iRestoreSession.restoreAll(l, restoreObserverWrapper2);
            return n;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.d(TAG, "Can't contact server to restore");
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int restorePackage(String string2, RestoreObserver restoreObserver) {
        RestoreObserverWrapper restoreObserverWrapper;
        int n = -1;
        if (this.mObserver != null) {
            int n2 = Log.d(TAG, "restorePackage() called during active restore");
            return -1;
        }
        Context context = this.mContext;
        this.mObserver = restoreObserverWrapper = new RestoreObserverWrapper(context, restoreObserver);
        try {
            int n3;
            IRestoreSession iRestoreSession = this.mBinder;
            RestoreObserverWrapper restoreObserverWrapper2 = this.mObserver;
            n = n3 = iRestoreSession.restorePackage(string2, restoreObserverWrapper2);
            return n;
        }
        catch (RemoteException remoteException) {
            int n4 = Log.d(TAG, "Can't contact server to restore package");
            return n;
        }
    }

    private class RestoreObserverWrapper
    extends IRestoreObserver.Stub {
        static final int MSG_RESTORE_FINISHED = 3;
        static final int MSG_RESTORE_SETS_AVAILABLE = 4;
        static final int MSG_RESTORE_STARTING = 1;
        static final int MSG_UPDATE = 2;
        final RestoreObserver mAppObserver;
        final Handler mHandler;

        RestoreObserverWrapper(Context context, RestoreObserver restoreObserver) {
            Handler handler;
            Looper looper = context.getMainLooper();
            this.mHandler = handler = new Handler(looper){

                @Override
                public void handleMessage(Message message) {
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 1: {
                            RestoreObserver restoreObserver = RestoreObserverWrapper.this.mAppObserver;
                            int n = message.arg1;
                            restoreObserver.restoreStarting(n);
                            return;
                        }
                        case 2: {
                            RestoreObserver restoreObserver = RestoreObserverWrapper.this.mAppObserver;
                            int n = message.arg1;
                            String string2 = (String)message.obj;
                            restoreObserver.onUpdate(n, string2);
                            return;
                        }
                        case 3: {
                            RestoreObserver restoreObserver = RestoreObserverWrapper.this.mAppObserver;
                            int n = message.arg1;
                            restoreObserver.restoreFinished(n);
                            return;
                        }
                        case 4: 
                    }
                    RestoreObserver restoreObserver = RestoreObserverWrapper.this.mAppObserver;
                    RestoreSet[] restoreSetArray = (RestoreSet[])message.obj;
                    restoreObserver.restoreSetsAvailable(restoreSetArray);
                }
            };
            this.mAppObserver = restoreObserver;
        }

        @Override
        public void onUpdate(int n, String string2) {
            Handler handler = this.mHandler;
            Message message = this.mHandler.obtainMessage(2, n, 0, string2);
            boolean bl = handler.sendMessage(message);
        }

        @Override
        public void restoreFinished(int n) {
            Handler handler = this.mHandler;
            Message message = this.mHandler.obtainMessage(3, n, 0);
            boolean bl = handler.sendMessage(message);
        }

        @Override
        public void restoreSetsAvailable(RestoreSet[] restoreSetArray) {
            Handler handler = this.mHandler;
            Message message = this.mHandler.obtainMessage(4, restoreSetArray);
            boolean bl = handler.sendMessage(message);
        }

        @Override
        public void restoreStarting(int n) {
            Handler handler = this.mHandler;
            Message message = this.mHandler.obtainMessage(1, n, 0);
            boolean bl = handler.sendMessage(message);
        }
    }
}

