/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.QueuedWork;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import java.io.File;

public class SharedPreferencesBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "SharedPreferencesBackupHelper";
    private Context mContext;
    private String[] mPrefGroups;

    public SharedPreferencesBackupHelper(Context context, String ... stringArray) {
        super(context);
        this.mContext = context;
        this.mPrefGroups = stringArray;
    }

    @Override
    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) {
        Context context = this.mContext;
        QueuedWork.waitToFinish();
        String[] stringArray = this.mPrefGroups;
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = stringArray[i];
            stringArray2[i] = string2 = context.getSharedPrefsFile(string3).getAbsolutePath();
        }
        SharedPreferencesBackupHelper.performBackup_checked(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2, stringArray2, stringArray);
    }

    @Override
    public void restoreEntity(BackupDataInputStream backupDataInputStream) {
        String[] stringArray;
        Context context = this.mContext;
        String string2 = backupDataInputStream.getKey();
        if (!this.isKeyInList(string2, stringArray = this.mPrefGroups)) {
            return;
        }
        File file = context.getSharedPrefsFile(string2).getAbsoluteFile();
        this.writeFile(file, backupDataInputStream);
    }
}

