/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.ArrayList;
import java.util.HashMap;

public class AppWidgetHost {
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final int HANDLE_UPDATE = 1;
    static IAppWidgetService sService;
    static final Object sServiceLock;
    Callbacks mCallbacks;
    Context mContext;
    Handler mHandler;
    int mHostId;
    String mPackageName;
    final HashMap<Integer, AppWidgetHostView> mViews;

    static {
        sServiceLock = new Object();
    }

    public AppWidgetHost(Context context, int n) {
        Callbacks callbacks;
        this.mCallbacks = callbacks = new Callbacks();
        HashMap hashMap = new HashMap();
        this.mViews = hashMap;
        this.mContext = context;
        this.mHostId = n;
        Looper looper = context.getMainLooper();
        UpdateHandler updateHandler = new UpdateHandler(looper);
        this.mHandler = updateHandler;
        Object object = sServiceLock;
        synchronized (object) {
            if (sService == null) {
                sService = IAppWidgetService.Stub.asInterface(ServiceManager.getService("appwidget"));
            }
            return;
        }
    }

    public static void deleteAllHosts() {
        try {
            sService.deleteAllHosts();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public int allocateAppWidgetId() {
        try {
            if (this.mPackageName == null) {
                String string2;
                this.mPackageName = string2 = this.mContext.getPackageName();
            }
            IAppWidgetService iAppWidgetService = sService;
            String string3 = this.mPackageName;
            int n = this.mHostId;
            int n2 = iAppWidgetService.allocateAppWidgetId(string3, n);
            return n2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AppWidgetHostView createView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        AppWidgetHostView appWidgetHostView = this.onCreateView(context, n, appWidgetProviderInfo);
        appWidgetHostView.setAppWidget(n, appWidgetProviderInfo);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            HashMap<Integer, AppWidgetHostView> hashMap2 = this.mViews;
            Integer n2 = n;
            AppWidgetHostView appWidgetHostView2 = hashMap2.put(n2, appWidgetHostView);
        }
        try {
            RemoteViews remoteViews;
            RemoteViews remoteViews2 = remoteViews = sService.getAppWidgetViews(n);
            appWidgetHostView.updateAppWidget(remoteViews2);
            return appWidgetHostView;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void deleteAppWidgetId(int n) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            HashMap<Integer, AppWidgetHostView> hashMap2 = this.mViews;
            Integer n2 = n;
            AppWidgetHostView appWidgetHostView = hashMap2.remove(n2);
            try {
                sService.deleteAppWidgetId(n);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("system server dead?", remoteException);
            }
        }
    }

    public void deleteHost() {
        try {
            IAppWidgetService iAppWidgetService = sService;
            int n = this.mHostId;
            iAppWidgetService.deleteHost(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    protected AppWidgetHostView onCreateView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        return new AppWidgetHostView(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void onProviderChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        // MONITORENTER : hashMap
        HashMap<Integer, AppWidgetHostView> hashMap2 = this.mViews;
        Integer n2 = n;
        AppWidgetHostView appWidgetHostView = hashMap2.get(n2);
        // MONITOREXIT : hashMap
        if (appWidgetHostView == null) {
            return;
        }
        appWidgetHostView.resetAppWidget(appWidgetProviderInfo);
    }

    public void startListening() {
        int[] nArray;
        ArrayList<RemoteViews> arrayList = new ArrayList<RemoteViews>();
        try {
            int[] nArray2;
            if (this.mPackageName == null) {
                String string2;
                this.mPackageName = string2 = this.mContext.getPackageName();
            }
            IAppWidgetService iAppWidgetService = sService;
            Callbacks callbacks = this.mCallbacks;
            String string3 = this.mPackageName;
            int n = this.mHostId;
            nArray = nArray2 = iAppWidgetService.startListening(callbacks, string3, n, arrayList);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                return;
            }
            int n3 = nArray[n2];
            RemoteViews remoteViews = arrayList.get(n2);
            this.updateAppWidgetView(n3, remoteViews);
            ++n2;
        }
    }

    public void stopListening() {
        try {
            IAppWidgetService iAppWidgetService = sService;
            int n = this.mHostId;
            iAppWidgetService.stopListening(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateAppWidgetView(int n, RemoteViews remoteViews) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        // MONITORENTER : hashMap
        HashMap<Integer, AppWidgetHostView> hashMap2 = this.mViews;
        Integer n2 = n;
        AppWidgetHostView appWidgetHostView = hashMap2.get(n2);
        // MONITOREXIT : hashMap
        if (appWidgetHostView == null) {
            return;
        }
        appWidgetHostView.updateAppWidget(remoteViews);
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    AppWidgetHost appWidgetHost = AppWidgetHost.this;
                    int n = message.arg1;
                    RemoteViews remoteViews = (RemoteViews)message.obj;
                    appWidgetHost.updateAppWidgetView(n, remoteViews);
                    return;
                }
                case 2: 
            }
            AppWidgetHost appWidgetHost = AppWidgetHost.this;
            int n = message.arg1;
            AppWidgetProviderInfo appWidgetProviderInfo = (AppWidgetProviderInfo)message.obj;
            appWidgetHost.onProviderChanged(n, appWidgetProviderInfo);
        }
    }

    class Callbacks
    extends IAppWidgetHost.Stub {
        Callbacks() {
        }

        @Override
        public void providerChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
            Message message = AppWidgetHost.this.mHandler.obtainMessage(2);
            message.arg1 = n;
            message.obj = appWidgetProviderInfo;
            message.sendToTarget();
        }

        @Override
        public void updateAppWidget(int n, RemoteViews remoteViews) {
            Message message = AppWidgetHost.this.mHandler.obtainMessage(1);
            message.arg1 = n;
            message.obj = remoteViews;
            message.sendToTarget();
        }
    }
}

