/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;

public class AppWidgetHostView
extends FrameLayout {
    static final boolean CROSSFADE = false;
    static final int FADE_DURATION = 1000;
    static final boolean LOGD = false;
    static final String TAG = "AppWidgetHostView";
    static final int VIEW_MODE_CONTENT = 1;
    static final int VIEW_MODE_DEFAULT = 3;
    static final int VIEW_MODE_ERROR = 2;
    static final int VIEW_MODE_NOINIT;
    static final LayoutInflater.Filter sInflaterFilter;
    int mAppWidgetId;
    Context mContext;
    long mFadeStartTime = 65535L;
    AppWidgetProviderInfo mInfo;
    int mLayoutId = -1;
    Bitmap mOld;
    Paint mOldPaint;
    Context mRemoteContext;
    View mView;
    int mViewMode = 0;

    static {
        sInflaterFilter = new LayoutInflater.Filter(){

            @Override
            public boolean onLoadClass(Class clazz) {
                return clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
            }
        };
    }

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
    }

    public AppWidgetHostView(Context context, int n, int n2) {
        super(context);
        Paint paint;
        this.mOldPaint = paint = new Paint();
        this.mContext = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int generateId() {
        int n = this.getId();
        if (n != -1) return n;
        return this.mAppWidgetId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Context getRemoteContext(RemoteViews remoteViews) {
        String string2 = remoteViews.getPackage();
        if (string2 == null) {
            return this.mContext;
        }
        try {
            Context context = this.mContext.createPackageContext(string2, 4);
            return context;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = "Package name " + string2 + " not found";
            int n = Log.e(TAG, string3);
            return this.mContext;
        }
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        int n = this.generateId();
        Parcelable parcelable = sparseArray.get(n);
        ParcelableSparseArray parcelableSparseArray = null;
        if (parcelable != null && parcelable instanceof ParcelableSparseArray) {
            parcelableSparseArray = (ParcelableSparseArray)parcelable;
        }
        if (parcelableSparseArray == null) {
            parcelableSparseArray = new ParcelableSparseArray();
        }
        super.dispatchRestoreInstanceState(parcelableSparseArray);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
        super.dispatchSaveInstanceState(parcelableSparseArray);
        int n = this.generateId();
        sparseArray.put(n, parcelableSparseArray);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        return super.drawChild(canvas, view, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context;
        if (this.mRemoteContext != null) {
            context = this.mRemoteContext;
            return new FrameLayout.LayoutParams(context, attributeSet);
        }
        context = this.mContext;
        return new FrameLayout.LayoutParams(context, attributeSet);
    }

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return this.mInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected View getDefaultView() {
        Throwable throwable;
        View view;
        block6: {
            view = null;
            throwable = null;
            try {
                if (this.mInfo != null) {
                    View view2;
                    Context context;
                    Context context2 = this.mContext;
                    String string2 = this.mInfo.provider.getPackageName();
                    this.mRemoteContext = context = context2.createPackageContext(string2, 4);
                    LayoutInflater layoutInflater = ((LayoutInflater)context.getSystemService("layout_inflater")).cloneInContext(context);
                    LayoutInflater.Filter filter = sInflaterFilter;
                    layoutInflater.setFilter(filter);
                    int n = this.mInfo.initialLayout;
                    view = view2 = layoutInflater.inflate(n, (ViewGroup)this, false);
                    break block6;
                }
                int n = Log.w(TAG, "can't inflate defaultView because mInfo is missing");
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        if (throwable != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Error inflating AppWidget ");
            AppWidgetProviderInfo appWidgetProviderInfo = this.mInfo;
            StringBuilder stringBuilder2 = stringBuilder.append(appWidgetProviderInfo).append(": ");
            String string3 = throwable.toString();
            String string4 = stringBuilder2.append(string3).toString();
            int n = Log.w(TAG, string4);
        }
        if (view != null) return view;
        return this.getErrorView();
    }

    protected View getErrorView() {
        Context context = this.mContext;
        TextView textView = new TextView(context);
        textView.setText(17040207);
        int n = Color.argb(127, 0, 0, 0);
        textView.setBackgroundColor(n);
        return textView;
    }

    protected void prepareView(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
        }
        layoutParams.gravity = 17;
        view.setLayoutParams(layoutParams);
    }

    void resetAppWidget(AppWidgetProviderInfo appWidgetProviderInfo) {
        this.mInfo = appWidgetProviderInfo;
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    public void setAppWidget(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        this.mAppWidgetId = n;
        this.mInfo = appWidgetProviderInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAppWidget(RemoteViews remoteViews) {
        boolean bl = false;
        View view = null;
        Throwable throwable = null;
        if (remoteViews == null) {
            if (this.mViewMode == 3) {
                return;
            }
            view = this.getDefaultView();
            this.mLayoutId = -1;
            this.mViewMode = 3;
        } else {
            Context context;
            this.mRemoteContext = context = this.getRemoteContext(remoteViews);
            int n = remoteViews.getLayoutId();
            int n2 = this.mLayoutId;
            if (n != n2) {
                try {
                    Context context2 = this.mContext;
                    View view2 = this.mView;
                    remoteViews.reapply(context2, view2);
                    view = this.mView;
                    bl = true;
                }
                catch (RuntimeException runtimeException) {}
            }
            if (view == null) {
                try {
                    View view3;
                    Context context3 = this.mContext;
                    view = view3 = remoteViews.apply(context3, this);
                }
                catch (RuntimeException runtimeException) {}
            }
            this.mLayoutId = n;
            this.mViewMode = 1;
        }
        if (view == null) {
            if (this.mViewMode == 2) {
                return;
            }
            int n = Log.w(TAG, "updateAppWidget couldn't find any view, using error view", throwable);
            view = this.getErrorView();
            this.mViewMode = 2;
        }
        if (!bl) {
            this.prepareView(view);
            this.addView(view);
        }
        if (this.mView == view) {
            return;
        }
        View view4 = this.mView;
        this.removeView(view4);
        this.mView = view;
    }

    private static class ParcelableSparseArray
    extends SparseArray<Parcelable>
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableSparseArray> CREATOR = new Parcelable.Creator<ParcelableSparseArray>(){

            @Override
            public ParcelableSparseArray createFromParcel(Parcel parcel) {
                ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
                ClassLoader classLoader = parcelableSparseArray.getClass().getClassLoader();
                int n = parcel.readInt();
                for (int i = 0; i < n; ++i) {
                    int n2 = parcel.readInt();
                    Object t = parcel.readParcelable(classLoader);
                    parcelableSparseArray.put(n2, t);
                }
                return parcelableSparseArray;
            }

            public ParcelableSparseArray[] newArray(int n) {
                return new ParcelableSparseArray[n];
            }
        };

        private ParcelableSparseArray() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.size();
            parcel.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.keyAt(n3);
                parcel.writeInt(n4);
                Parcelable parcelable = (Parcelable)this.valueAt(n3);
                parcel.writeParcelable(parcelable, 0);
                ++n3;
            }
            return;
        }
    }
}

