/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetService;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.WeakHashMap;

public class AppWidgetManager {
    public static final String ACTION_APPWIDGET_CONFIGURE = "android.appwidget.action.APPWIDGET_CONFIGURE";
    public static final String ACTION_APPWIDGET_DELETED = "android.appwidget.action.APPWIDGET_DELETED";
    public static final String ACTION_APPWIDGET_DISABLED = "android.appwidget.action.APPWIDGET_DISABLED";
    public static final String ACTION_APPWIDGET_ENABLED = "android.appwidget.action.APPWIDGET_ENABLED";
    public static final String ACTION_APPWIDGET_PICK = "android.appwidget.action.APPWIDGET_PICK";
    public static final String ACTION_APPWIDGET_UPDATE = "android.appwidget.action.APPWIDGET_UPDATE";
    public static final String EXTRA_APPWIDGET_ID = "appWidgetId";
    public static final String EXTRA_APPWIDGET_IDS = "appWidgetIds";
    public static final String EXTRA_CUSTOM_EXTRAS = "customExtras";
    public static final String EXTRA_CUSTOM_INFO = "customInfo";
    public static final int INVALID_APPWIDGET_ID = 0;
    public static final String META_DATA_APPWIDGET_OLD_NAME = "android.appwidget.oldName";
    public static final String META_DATA_APPWIDGET_PROVIDER = "android.appwidget.provider";
    static final String TAG = "AppWidgetManager";
    static WeakHashMap<Context, WeakReference<AppWidgetManager>> sManagerCache = new WeakHashMap();
    static IAppWidgetService sService;
    Context mContext;
    private DisplayMetrics mDisplayMetrics;

    private AppWidgetManager(Context context) {
        DisplayMetrics displayMetrics;
        this.mContext = context;
        this.mDisplayMetrics = displayMetrics = context.getResources().getDisplayMetrics();
    }

    public static AppWidgetManager getInstance(Context context) {
        WeakHashMap<Context, WeakReference<AppWidgetManager>> weakHashMap = sManagerCache;
        synchronized (weakHashMap) {
            if (sService == null) {
                sService = IAppWidgetService.Stub.asInterface(ServiceManager.getService("appwidget"));
            }
            WeakReference<AppWidgetManager> weakReference = sManagerCache.get(context);
            AppWidgetManager appWidgetManager = null;
            if (weakReference != null) {
                appWidgetManager = (AppWidgetManager)weakReference.get();
            }
            if (appWidgetManager == null) {
                appWidgetManager = new AppWidgetManager(context);
                WeakHashMap<Context, WeakReference<AppWidgetManager>> weakHashMap2 = sManagerCache;
                WeakReference<AppWidgetManager> weakReference2 = new WeakReference<AppWidgetManager>(appWidgetManager);
                WeakReference<AppWidgetManager> weakReference3 = weakHashMap2.put(context, weakReference2);
            }
            return appWidgetManager;
        }
    }

    public void bindAppWidgetId(int n, ComponentName componentName) {
        try {
            sService.bindAppWidgetId(n, componentName);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public int[] getAppWidgetIds(ComponentName componentName) {
        try {
            int[] nArray = sService.getAppWidgetIds(componentName);
            return nArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public AppWidgetProviderInfo getAppWidgetInfo(int n) {
        try {
            AppWidgetProviderInfo appWidgetProviderInfo = sService.getAppWidgetInfo(n);
            if (appWidgetProviderInfo != null) {
                int n2;
                int n3;
                int n4 = appWidgetProviderInfo.minWidth;
                DisplayMetrics displayMetrics = this.mDisplayMetrics;
                appWidgetProviderInfo.minWidth = n3 = TypedValue.complexToDimensionPixelSize(n4, displayMetrics);
                int n5 = appWidgetProviderInfo.minHeight;
                DisplayMetrics displayMetrics2 = this.mDisplayMetrics;
                appWidgetProviderInfo.minHeight = n2 = TypedValue.complexToDimensionPixelSize(n5, displayMetrics2);
            }
            return appWidgetProviderInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public List<AppWidgetProviderInfo> getInstalledProviders() {
        try {
            List<AppWidgetProviderInfo> list = sService.getInstalledProviders();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void updateAppWidget(int n, RemoteViews remoteViews) {
        int[] nArray = new int[]{n};
        this.updateAppWidget(nArray, remoteViews);
    }

    public void updateAppWidget(ComponentName componentName, RemoteViews remoteViews) {
        try {
            sService.updateAppWidgetProvider(componentName, remoteViews);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void updateAppWidget(int[] nArray, RemoteViews remoteViews) {
        try {
            sService.updateAppWidgetIds(nArray, remoteViews);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }
}

