/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothA2dp;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class BluetoothA2dp {
    public static final String ACTION_SINK_STATE_CHANGED = "android.bluetooth.a2dp.action.SINK_STATE_CHANGED";
    private static final boolean DBG = false;
    public static final String EXTRA_PREVIOUS_SINK_STATE = "android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE";
    public static final String EXTRA_SINK_STATE = "android.bluetooth.a2dp.extra.SINK_STATE";
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    public static final int PRIORITY_OFF = 0;
    public static final int PRIORITY_ON = 100;
    public static final int PRIORITY_UNDEFINED = 255;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_PLAYING = 4;
    private static final String TAG = "BluetoothA2dp";
    private final Context mContext;
    private final IBluetoothA2dp mService;

    public BluetoothA2dp(Context context) {
        this.mContext = context;
        IBinder iBinder = ServiceManager.getService("bluetooth_a2dp");
        if (iBinder != null) {
            IBluetoothA2dp iBluetoothA2dp;
            this.mService = iBluetoothA2dp = IBluetoothA2dp.Stub.asInterface(iBinder);
            return;
        }
        int n = Log.w(TAG, "Bluetooth A2DP service not available!");
        this.mService = null;
    }

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stateToString(int n) {
        switch (n) {
            default: {
                return "<unknown state " + n + ">";
            }
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 4: 
        }
        return "playing";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectSink(BluetoothDevice bluetoothDevice) {
        try {
            boolean bl = this.mService.connectSink(bluetoothDevice);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectSink(BluetoothDevice bluetoothDevice) {
        try {
            boolean bl = this.mService.disconnectSink(bluetoothDevice);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<BluetoothDevice> getConnectedSinks() {
        try {
            List<BluetoothDevice> list = Arrays.asList(this.mService.getConnectedSinks());
            Set<BluetoothDevice> set = Collections.unmodifiableSet(new HashSet<BluetoothDevice>(list));
            return set;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<BluetoothDevice> getNonDisconnectedSinks() {
        try {
            List<BluetoothDevice> list = Arrays.asList(this.mService.getNonDisconnectedSinks());
            Set<BluetoothDevice> set = Collections.unmodifiableSet(new HashSet<BluetoothDevice>(list));
            return set;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSinkPriority(BluetoothDevice bluetoothDevice) {
        try {
            int n = this.mService.getSinkPriority(bluetoothDevice);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSinkState(BluetoothDevice bluetoothDevice) {
        try {
            int n = this.mService.getSinkState(bluetoothDevice);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSinkConnected(BluetoothDevice bluetoothDevice) {
        int n = this.getSinkState(bluetoothDevice);
        if (n == 2) return true;
        if (n != 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resumeSink(BluetoothDevice bluetoothDevice) {
        try {
            boolean bl = this.mService.resumeSink(bluetoothDevice);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSinkPriority(BluetoothDevice bluetoothDevice, int n) {
        try {
            boolean bl = this.mService.setSinkPriority(bluetoothDevice, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean suspendSink(BluetoothDevice bluetoothDevice) {
        try {
            boolean bl = this.mService.suspendSink(bluetoothDevice);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }
}

