/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.IBluetooth;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public final class BluetoothAdapter {
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    private static final int ADDRESS_LENGTH = 17;
    public static final String BLUETOOTH_SERVICE = "bluetooth";
    private static final boolean DBG = false;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    public static final int SCAN_MODE_NONE = 20;
    public static final int STATE_OFF = 10;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_TURNING_ON = 11;
    private static final String TAG = "BluetoothAdapter";
    private static BluetoothAdapter sAdapter;
    private Handler mHandler;
    private final IBluetooth mService;

    public BluetoothAdapter(IBluetooth iBluetooth) {
        Handler handler;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                int n = message.what;
                try {
                    BluetoothAdapter.this.mService.removeServiceRecord(n);
                    return;
                }
                catch (RemoteException remoteException) {
                    int n2 = Log.e(BluetoothAdapter.TAG, "", remoteException);
                    return;
                }
            }
        };
        if (iBluetooth == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.mService = iBluetooth;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean checkBluetoothAddress(String string2) {
        if (string2 == null) return false;
        if (string2.length() != 17) {
            return false;
        }
        int n = 0;
        while (n < 17) {
            char c = string2.charAt(n);
            switch (n % 3) {
                case 0: 
                case 1: {
                    if (c < '0' || c > '9') {
                        if (c < 'A') return false;
                        if (c > 'F') {
                            return false;
                        }
                    }
                }
                default: {
                    break;
                }
                case 2: {
                    if (c == ':') break;
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BluetoothServerSocket createNewRfcommSocketAndRecord(String string2, UUID uUID, boolean bl, boolean bl2) throws IOException {
        block15: {
            RfcommChannelPicker rfcommChannelPicker = new RfcommChannelPicker(uUID);
            while (true) {
                int n;
                BluetoothServerSocket bluetoothServerSocket;
                block14: {
                    int n2;
                    int n3;
                    if ((n3 = rfcommChannelPicker.nextChannel()) == -1) {
                        throw new IOException("No available channels");
                    }
                    bluetoothServerSocket = new BluetoothServerSocket(1, bl, bl2, n3);
                    n = bluetoothServerSocket.mSocket.bindListen();
                    if (n == 0) {
                        int n4;
                        n2 = -1;
                        IBluetooth iBluetooth = this.mService;
                        ParcelUuid parcelUuid = new ParcelUuid(uUID);
                        Binder binder = new Binder();
                        n2 = n4 = iBluetooth.addRfcommServiceRecord(string2, parcelUuid, n3, binder);
                    }
                    if (n == 98) {
                        try {
                            bluetoothServerSocket.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    try {
                        bluetoothServerSocket.close();
                        break block14;
                    }
                    catch (IOException iOException) {}
                    catch (RemoteException remoteException) {
                        int n5 = Log.e(TAG, "", remoteException);
                    }
                    if (n2 == -1) {
                        bluetoothServerSocket.close();
                        break block15;
                    } else {
                        Handler handler = this.mHandler;
                        bluetoothServerSocket.setCloseHandler(handler, n2);
                        return bluetoothServerSocket;
                    }
                }
                bluetoothServerSocket.mSocket.throwErrnoNative(n);
            }
            catch (IOException iOException) {}
        }
        String string3 = "Not able to register SDP record for " + string2;
        throw new IOException(string3);
    }

    public static BluetoothAdapter getDefaultAdapter() {
        synchronized (BluetoothAdapter.class) {
            IBinder iBinder;
            if (sAdapter == null && (iBinder = ServiceManager.getService(BLUETOOTH_SERVICE)) != null) {
                IBluetooth iBluetooth = IBluetooth.Stub.asInterface(iBinder);
                sAdapter = new BluetoothAdapter(iBluetooth);
            }
            BluetoothAdapter bluetoothAdapter = sAdapter;
            return bluetoothAdapter;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BluetoothServerSocket listenUsingScoOn() throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(2, false, false, -1);
        int n = bluetoothServerSocket.mSocket.bindListen();
        if (n != 0) {
            try {
                bluetoothServerSocket.close();
            }
            catch (IOException iOException) {}
            bluetoothServerSocket.mSocket.throwErrnoNative(n);
        }
        return bluetoothServerSocket;
    }

    private Set<BluetoothDevice> toDeviceSet(String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        HashSet<BluetoothDevice> hashSet = new HashSet<BluetoothDevice>(n2);
        for (int i = 0; i < (n = stringArray.length); ++i) {
            String string2 = stringArray[i];
            BluetoothDevice bluetoothDevice = this.getRemoteDevice(string2);
            boolean bl = hashSet.add(bluetoothDevice);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.cancelDiscovery();
            return false;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disable() {
        try {
            boolean bl = this.mService.disable(true);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enable() {
        try {
            boolean bl = this.mService.enable();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAddress() {
        try {
            String string2 = this.mService.getAddress();
            return string2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            String[] stringArray = new String[]{};
            return this.toDeviceSet(stringArray);
        }
        try {
            String[] stringArray = this.mService.listBonds();
            Set<BluetoothDevice> set = this.toDeviceSet(stringArray);
            return set;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return -1;
        }
        try {
            int n = this.mService.getDiscoverableTimeout();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName() {
        try {
            String string2 = this.mService.getName();
            return string2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public BluetoothDevice getRemoteDevice(String string2) {
        return new BluetoothDevice(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        try {
            int n = this.mService.getScanMode();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return 20;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        try {
            int n = this.mService.getBluetoothState();
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return 10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.isDiscovering();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled() {
        try {
            boolean bl = this.mService.isEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothServerSocket listenUsingInsecureRfcommOn(int n) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, false, false, n);
        int n2 = bluetoothServerSocket.mSocket.bindListen();
        if (n2 != 0) {
            try {
                bluetoothServerSocket.close();
            }
            catch (IOException iOException) {}
            bluetoothServerSocket.mSocket.throwErrnoNative(n2);
        }
        return bluetoothServerSocket;
    }

    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return this.createNewRfcommSocketAndRecord(string2, uUID, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothServerSocket listenUsingRfcommOn(int n) throws IOException {
        BluetoothServerSocket bluetoothServerSocket = new BluetoothServerSocket(1, true, true, n);
        int n2 = bluetoothServerSocket.mSocket.bindListen();
        if (n2 != 0) {
            try {
                bluetoothServerSocket.close();
            }
            catch (IOException iOException) {}
            bluetoothServerSocket.mSocket.throwErrnoNative(n2);
        }
        return bluetoothServerSocket;
    }

    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String string2, UUID uUID) throws IOException {
        return this.createNewRfcommSocketAndRecord(string2, uUID, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<byte[], byte[]> readOutOfBandData() {
        if (this.getState() != 12) {
            return null;
        }
        try {
            byte[] byArray = this.mService.readOutOfBandData();
            if (byArray == null) return null;
            if (byArray.length != 32) {
                return null;
            }
            byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, 16, 32);
            return new Pair<byte[], byte[]>(byArray2, byArray3);
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public void setDiscoverableTimeout(int n) {
        if (this.getState() != 12) {
            return;
        }
        try {
            boolean bl = this.mService.setDiscoverableTimeout(n);
            return;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setName(String string2) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.setName(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanMode(int n) {
        if (this.getState() == 12) return this.setScanMode(n, 120);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanMode(int n, int n2) {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.setScanMode(n, n2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n3 = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        try {
            boolean bl = this.mService.startDiscovery();
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    private static class RfcommChannelPicker {
        private static final int[] RESERVED_RFCOMM_CHANNELS = new int[]{10, 11, 12, 19};
        private static LinkedList<Integer> sChannels;
        private static Random sRandom;
        private final LinkedList<Integer> mChannels;
        private final UUID mUuid;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RfcommChannelPicker(UUID uUID) {
            synchronized (RfcommChannelPicker.class) {
                LinkedList linkedList;
                if (sChannels == null) {
                    sChannels = new LinkedList();
                    for (int i = 1; i <= 30; ++i) {
                        LinkedList<Integer> linkedList2 = sChannels;
                        Integer n = new Integer(i);
                        linkedList2.addLast(n);
                    }
                    for (int n : RESERVED_RFCOMM_CHANNELS) {
                        LinkedList<Integer> linkedList3 = sChannels;
                        Integer n2 = new Integer(n);
                        boolean bl = linkedList3.remove(n2);
                    }
                    sRandom = new Random();
                }
                this.mChannels = linkedList = (LinkedList)sChannels.clone();
            }
            this.mUuid = uUID;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int nextChannel() {
            if (this.mChannels.size() == 0) {
                return -1;
            }
            LinkedList<Integer> linkedList = this.mChannels;
            Random random = sRandom;
            int n = this.mChannels.size();
            int n2 = random.nextInt(n);
            return linkedList.remove(n2);
        }
    }
}

