/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public final class BluetoothAudioGateway {
    private static final boolean DBG = false;
    public static final int DEFAULT_HF_AG_CHANNEL = 10;
    public static final int DEFAULT_HS_AG_CHANNEL = 11;
    public static final int MSG_INCOMING_HANDSFREE_CONNECTION = 101;
    public static final int MSG_INCOMING_HEADSET_CONNECTION = 100;
    private static final int SELECT_WAIT_TIMEOUT = 1000;
    private static final String TAG = "BT Audio Gateway";
    private final BluetoothAdapter mAdapter;
    private Handler mCallback;
    private Thread mConnectThead;
    private String mConnectingHandsfreeAddress;
    private int mConnectingHandsfreeRfcommChannel;
    private int mConnectingHandsfreeSocketFd;
    private String mConnectingHeadsetAddress;
    private int mConnectingHeadsetRfcommChannel;
    private int mConnectingHeadsetSocketFd;
    private int mHandsfreeAgRfcommChannel = -1;
    private int mHeadsetAgRfcommChannel = -1;
    private volatile boolean mInterrupted;
    private int mNativeData;
    private int mTimeoutRemainingMs;

    static {
        BluetoothAudioGateway.classInitNative();
    }

    public BluetoothAudioGateway(BluetoothAdapter bluetoothAdapter) {
        this(bluetoothAdapter, 10, 11);
    }

    public BluetoothAudioGateway(BluetoothAdapter bluetoothAdapter, int n, int n2) {
        this.mAdapter = bluetoothAdapter;
        this.mHandsfreeAgRfcommChannel = n;
        this.mHeadsetAgRfcommChannel = n2;
        this.initializeNativeDataNative();
    }

    static /* synthetic */ boolean access$002(BluetoothAudioGateway bluetoothAudioGateway, boolean bl) {
        bluetoothAudioGateway.mInterrupted = bl;
        return bl;
    }

    static /* synthetic */ int access$102(BluetoothAudioGateway bluetoothAudioGateway, int n) {
        bluetoothAudioGateway.mConnectingHeadsetRfcommChannel = n;
        return n;
    }

    static /* synthetic */ int access$202(BluetoothAudioGateway bluetoothAudioGateway, int n) {
        bluetoothAudioGateway.mConnectingHandsfreeRfcommChannel = n;
        return n;
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native void initializeNativeDataNative();

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    private native boolean setUpListeningSocketsNative();

    private native void tearDownListeningSocketsNative();

    private native boolean waitForHandsfreeConnectNative(int var1);

    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean start(Handler handler) {
        synchronized (this) {
            block4: {
                Thread thread;
                if (this.mConnectThead != null) return true;
                this.mCallback = handler;
                this.mConnectThead = thread = new Thread(TAG){

                    @Override
                    public void run() {
                        while (!BluetoothAudioGateway.this.mInterrupted) {
                            int n = BluetoothAudioGateway.access$102(BluetoothAudioGateway.this, -1);
                            int n2 = BluetoothAudioGateway.access$202(BluetoothAudioGateway.this, -1);
                            if (!BluetoothAudioGateway.this.waitForHandsfreeConnectNative(1000)) {
                                if (BluetoothAudioGateway.this.mTimeoutRemainingMs <= 0) continue;
                                try {
                                    StringBuilder stringBuilder = new StringBuilder().append("select thread timed out, but ");
                                    int n3 = BluetoothAudioGateway.this.mTimeoutRemainingMs;
                                    String string2 = stringBuilder.append(n3).append("ms of waiting remain.").toString();
                                    int n4 = Log.i(BluetoothAudioGateway.TAG, string2);
                                    Thread.sleep(BluetoothAudioGateway.this.mTimeoutRemainingMs);
                                }
                                catch (InterruptedException interruptedException) {
                                    int n5 = Log.i(BluetoothAudioGateway.TAG, "select thread was interrupted (2), exiting");
                                    boolean bl = BluetoothAudioGateway.access$002(BluetoothAudioGateway.this, true);
                                }
                                continue;
                            }
                            int n6 = Log.i(BluetoothAudioGateway.TAG, "connect notification!");
                            if (BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel >= 0) {
                                StringBuilder stringBuilder = new StringBuilder().append("Incoming connection from headset ");
                                String string3 = BluetoothAudioGateway.this.mConnectingHeadsetAddress;
                                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" on channel ");
                                int n7 = BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel;
                                String string4 = stringBuilder2.append(n7).toString();
                                int n8 = Log.i(BluetoothAudioGateway.TAG, string4);
                                Message message = Message.obtain(BluetoothAudioGateway.this.mCallback);
                                message.what = 100;
                                BluetoothAudioGateway bluetoothAudioGateway = BluetoothAudioGateway.this;
                                BluetoothAdapter bluetoothAdapter = BluetoothAudioGateway.this.mAdapter;
                                BluetoothAdapter bluetoothAdapter2 = BluetoothAudioGateway.this.mAdapter;
                                String string5 = BluetoothAudioGateway.this.mConnectingHeadsetAddress;
                                BluetoothDevice bluetoothDevice = bluetoothAdapter2.getRemoteDevice(string5);
                                int n9 = BluetoothAudioGateway.this.mConnectingHeadsetSocketFd;
                                int n10 = BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel;
                                IncomingConnectionInfo incomingConnectionInfo = bluetoothAudioGateway.new IncomingConnectionInfo(bluetoothAdapter, bluetoothDevice, n9, n10);
                                message.obj = incomingConnectionInfo;
                                message.sendToTarget();
                            }
                            if (BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel < 0) continue;
                            StringBuilder stringBuilder = new StringBuilder().append("Incoming connection from handsfree ");
                            String string6 = BluetoothAudioGateway.this.mConnectingHandsfreeAddress;
                            StringBuilder stringBuilder3 = stringBuilder.append(string6).append(" on channel ");
                            int n11 = BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel;
                            String string7 = stringBuilder3.append(n11).toString();
                            int n12 = Log.i(BluetoothAudioGateway.TAG, string7);
                            Message message = Message.obtain();
                            Handler handler = BluetoothAudioGateway.this.mCallback;
                            message.setTarget(handler);
                            message.what = 101;
                            BluetoothAudioGateway bluetoothAudioGateway = BluetoothAudioGateway.this;
                            BluetoothAdapter bluetoothAdapter = BluetoothAudioGateway.this.mAdapter;
                            BluetoothAdapter bluetoothAdapter3 = BluetoothAudioGateway.this.mAdapter;
                            String string8 = BluetoothAudioGateway.this.mConnectingHandsfreeAddress;
                            BluetoothDevice bluetoothDevice = bluetoothAdapter3.getRemoteDevice(string8);
                            int n13 = BluetoothAudioGateway.this.mConnectingHandsfreeSocketFd;
                            int n14 = BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel;
                            IncomingConnectionInfo incomingConnectionInfo = bluetoothAudioGateway.new IncomingConnectionInfo(bluetoothAdapter, bluetoothDevice, n13, n14);
                            message.obj = incomingConnectionInfo;
                            message.sendToTarget();
                        }
                        return;
                    }
                };
                if (this.setUpListeningSocketsNative()) break block4;
                int n = Log.e(TAG, "Could not set up listening socket, exiting");
                return false;
            }
            boolean bl = false;
            this.mInterrupted = bl;
            this.mConnectThead.start();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        synchronized (this) {
            if (this.mConnectThead != null) {
                this.mInterrupted = true;
                try {
                    this.mConnectThead.interrupt();
                    this.mConnectThead.join();
                    this.mConnectThead = null;
                    this.mCallback = null;
                    this.tearDownListeningSocketsNative();
                }
                catch (InterruptedException interruptedException) {
                    int n = Log.w(TAG, "Interrupted waiting for Connect Thread to join");
                }
            }
            return;
        }
    }

    public class IncomingConnectionInfo {
        public BluetoothAdapter mAdapter;
        public BluetoothDevice mRemoteDevice;
        public int mRfcommChan;
        public int mSocketFd;

        IncomingConnectionInfo(BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice, int n, int n2) {
            this.mAdapter = bluetoothAdapter;
            this.mRemoteDevice = bluetoothDevice;
            this.mSocketFd = n;
            this.mRfcommChan = n2;
        }
    }
}

