/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public final class BluetoothDevice
implements Parcelable {
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    public static final String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    public static final String ACTION_DISAPPEARED = "android.bluetooth.device.action.DISAPPEARED";
    public static final String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    public static final String ACTION_UUID = "android.bleutooth.device.action.UUID";
    public static final int BOND_BONDED = 12;
    public static final int BOND_BONDING = 11;
    public static final int BOND_NONE = 10;
    public static final int BOND_SUCCESS = 0;
    public static final Parcelable.Creator<BluetoothDevice> CREATOR = new Parcelable.Creator<BluetoothDevice>(){

        @Override
        public BluetoothDevice createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            return new BluetoothDevice(string2);
        }

        public BluetoothDevice[] newArray(int n) {
            return new BluetoothDevice[n];
        }
    };
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PASSKEY = "android.bluetooth.device.extra.PASSKEY";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static final int PAIRING_VARIANT_CONSENT = 3;
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static final int PAIRING_VARIANT_OOB_CONSENT = 5;
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    public static final int PAIRING_VARIANT_PIN = 0;
    private static final String TAG = "BluetoothDevice";
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    private static IBluetooth sService;
    private final String mAddress;

    BluetoothDevice(String string2) {
        IBluetooth iBluetooth = BluetoothDevice.getService();
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            String string3 = string2 + " is not a valid Bluetooth address";
            throw new IllegalArgumentException(string3);
        }
        this.mAddress = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] convertPinToBytes(String string2) {
        byte[] byArray;
        if (string2 == null) {
            return null;
        }
        try {
            byte[] byArray2;
            byArray = byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = Log.e(TAG, "UTF-8 not supported?!?");
            return null;
        }
        if (byArray.length <= 0) return null;
        if (byArray.length <= 16) return byArray;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBluetooth getService() {
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                IBinder iBinder = ServiceManager.getService("bluetooth");
                if (iBinder == null) {
                    throw new RuntimeException("Bluetooth service not available");
                }
                sService = IBluetooth.Stub.asInterface(iBinder);
            }
            return sService;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelBondProcess() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.cancelBondProcess(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelPairingUserInput() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.cancelPairingUserInput(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createBond() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.createBond(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createBondOutOfBand(byte[] byArray, byte[] byArray2) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.createBondOutOfBand(string2, byArray, byArray2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public BluetoothSocket createInsecureRfcommSocket(int n) throws IOException {
        boolean bl = false;
        BluetoothDevice bluetoothDevice = this;
        int n2 = n;
        return new BluetoothSocket(1, -1, false, bl, bluetoothDevice, n2, null);
    }

    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        ParcelUuid parcelUuid = new ParcelUuid(uUID);
        boolean bl = false;
        BluetoothDevice bluetoothDevice = this;
        int n = -1;
        return new BluetoothSocket(1, -1, false, bl, bluetoothDevice, n, parcelUuid);
    }

    public BluetoothSocket createRfcommSocket(int n) throws IOException {
        boolean bl = true;
        boolean bl2 = true;
        BluetoothDevice bluetoothDevice = this;
        int n2 = n;
        return new BluetoothSocket(1, -1, bl, bl2, bluetoothDevice, n2, null);
    }

    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        ParcelUuid parcelUuid = new ParcelUuid(uUID);
        boolean bl = true;
        boolean bl2 = true;
        BluetoothDevice bluetoothDevice = this;
        int n = -1;
        return new BluetoothSocket(1, -1, bl, bl2, bluetoothDevice, n, parcelUuid);
    }

    public BluetoothSocket createScoSocket() throws IOException {
        boolean bl = true;
        BluetoothDevice bluetoothDevice = this;
        int n = -1;
        return new BluetoothSocket(2, -1, true, bl, bluetoothDevice, n, null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof BluetoothDevice)) return false;
        String string2 = this.mAddress;
        String string3 = ((BluetoothDevice)object).getAddress();
        return string2.equals(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fetchUuidsWithSdp() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.fetchRemoteUuids(string2, null, null);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public String getAddress() {
        return this.mAddress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothClass getBluetoothClass() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            int n = iBluetooth.getRemoteClass(string2);
            if (n != -16777216) return new BluetoothClass(n);
            return null;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBondState() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            int n = iBluetooth.getBondState(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return 10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            String string3 = iBluetooth.getRemoteName(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getServiceChannel(ParcelUuid parcelUuid) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            int n = iBluetooth.getRemoteServiceChannel(string2, parcelUuid);
            return n;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return Integer.MIN_VALUE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getTrustState() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.getTrustState(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParcelUuid[] getUuids() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            ParcelUuid[] parcelUuidArray = iBluetooth.getRemoteUuids(string2);
            return parcelUuidArray;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBluetoothDock() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.isBluetoothDock(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeBond() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.removeBond(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setDeviceOutOfBandData(byte[] byArray, byte[] byArray2) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.setDeviceOutOfBandData(string2, byArray, byArray2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPairingConfirmation(boolean bl) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl2 = iBluetooth.setPairingConfirmation(string2, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPasskey(int n) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.setPasskey(string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n2 = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPin(byte[] byArray) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.setPin(string2, byArray);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRemoteOutOfBandData() {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl = iBluetooth.setRemoteOutOfBandData(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setTrust(boolean bl) {
        try {
            IBluetooth iBluetooth = sService;
            String string2 = this.mAddress;
            boolean bl2 = iBluetooth.setTrust(string2, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public String toString() {
        return this.mAddress;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.mAddress;
        parcel.writeString(string2);
    }
}

