/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothPbap;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.server.BluetoothA2dpService;
import android.server.BluetoothService;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public final class BluetoothDeviceProfileState
extends HierarchicalStateMachine {
    private static final int AUTO_CONNECT_DELAY = 6000;
    public static final int AUTO_CONNECT_PROFILES = 101;
    public static final int CONNECT_A2DP_INCOMING = 4;
    public static final int CONNECT_A2DP_OUTGOING = 3;
    public static final int CONNECT_HFP_INCOMING = 2;
    public static final int CONNECT_HFP_OUTGOING = 1;
    public static final int CONNECT_OTHER_PROFILES = 103;
    private static final int CONNECT_OTHER_PROFILES_DELAY = 4000;
    private static final boolean DBG = false;
    public static final int DISCONNECT_A2DP_INCOMING = 8;
    public static final int DISCONNECT_A2DP_OUTGOING = 7;
    private static final int DISCONNECT_HFP_INCOMING = 6;
    public static final int DISCONNECT_HFP_OUTGOING = 5;
    public static final int DISCONNECT_PBAP_OUTGOING = 9;
    private static final String TAG = "BluetoothDeviceProfileState";
    public static final int TRANSITION_TO_STABLE = 102;
    public static final int UNPAIR = 100;
    private BluetoothA2dpService mA2dpService;
    private int mA2dpState;
    private BondedDevice mBondedDevice;
    private BroadcastReceiver mBroadcastReceiver;
    private Context mContext;
    private BluetoothDevice mDevice;
    private BluetoothHeadset mHeadsetService;
    private boolean mHeadsetServiceConnected;
    private int mHeadsetState;
    private IncomingA2dp mIncomingA2dp;
    private IncomingHandsfree mIncomingHandsfree;
    private OutgoingA2dp mOutgoingA2dp;
    private OutgoingHandsfree mOutgoingHandsfree;
    private BluetoothPbap mPbapService;
    private boolean mPbapServiceConnected;
    private BluetoothService mService;

    public BluetoothDeviceProfileState(Context context, String string2, BluetoothService bluetoothService, BluetoothA2dpService bluetoothA2dpService) {
        super(string2);
        BluetoothDevice bluetoothDevice;
        BroadcastReceiver broadcastReceiver;
        OutgoingA2dp outgoingA2dp;
        IncomingA2dp incomingA2dp;
        IncomingHandsfree incomingHandsfree;
        OutgoingHandsfree outgoingHandsfree;
        BondedDevice bondedDevice;
        this.mBondedDevice = bondedDevice = new BondedDevice();
        this.mOutgoingHandsfree = outgoingHandsfree = new OutgoingHandsfree();
        this.mIncomingHandsfree = incomingHandsfree = new IncomingHandsfree();
        this.mIncomingA2dp = incomingA2dp = new IncomingA2dp();
        this.mOutgoingA2dp = outgoingA2dp = new OutgoingA2dp();
        this.mBroadcastReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                BluetoothDevice bluetoothDevice;
                String string2 = intent.getAction();
                BluetoothDevice bluetoothDevice2 = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (!bluetoothDevice2.equals(bluetoothDevice = BluetoothDeviceProfileState.this.mDevice)) {
                    return;
                }
                if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                    int n2 = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", 0);
                    int n3 = intent.getIntExtra("android.bluetooth.headset.extra.DISCONNECT_INITIATOR", 1);
                    int n4 = BluetoothDeviceProfileState.access$602(BluetoothDeviceProfileState.this, n);
                    if (n == 0 && n3 == 0) {
                        BluetoothDeviceProfileState.this.sendMessage(6);
                    }
                    if (n != 2 && n != 0) {
                        return;
                    }
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    return;
                }
                if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                    int n5 = intent.getIntExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", 0);
                    int n6 = BluetoothDeviceProfileState.access$702(BluetoothDeviceProfileState.this, n);
                    if ((n5 == 2 || n5 == 4) && n == 0) {
                        BluetoothDeviceProfileState.this.sendMessage(8);
                    }
                    if (n != 2 && n != 0) {
                        return;
                    }
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    return;
                }
                if (!string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                    return;
                }
                BluetoothDeviceProfileState.this.sendMessage(102);
            }
        };
        this.mContext = context;
        this.mDevice = bluetoothDevice = new BluetoothDevice(string2);
        this.mService = bluetoothService;
        this.mA2dpService = bluetoothA2dpService;
        BondedDevice bondedDevice2 = this.mBondedDevice;
        this.addState(bondedDevice2);
        OutgoingHandsfree outgoingHandsfree2 = this.mOutgoingHandsfree;
        this.addState(outgoingHandsfree2);
        IncomingHandsfree incomingHandsfree2 = this.mIncomingHandsfree;
        this.addState(incomingHandsfree2);
        IncomingA2dp incomingA2dp2 = this.mIncomingA2dp;
        this.addState(incomingA2dp2);
        OutgoingA2dp outgoingA2dp2 = this.mOutgoingA2dp;
        this.addState(outgoingA2dp2);
        BondedDevice bondedDevice3 = this.mBondedDevice;
        this.setInitialState(bondedDevice3);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        Context context2 = this.mContext;
        BroadcastReceiver broadcastReceiver2 = this.mBroadcastReceiver;
        Intent intent = context2.registerReceiver(broadcastReceiver2, intentFilter);
        HeadsetServiceListener headsetServiceListener = new HeadsetServiceListener();
        PbapServiceListener pbapServiceListener = new PbapServiceListener();
    }

    static /* synthetic */ boolean access$1002(BluetoothDeviceProfileState bluetoothDeviceProfileState, boolean bl) {
        bluetoothDeviceProfileState.mHeadsetServiceConnected = bl;
        return bl;
    }

    static /* synthetic */ BluetoothPbap access$1102(BluetoothDeviceProfileState bluetoothDeviceProfileState, BluetoothPbap bluetoothPbap) {
        bluetoothDeviceProfileState.mPbapService = bluetoothPbap;
        return bluetoothPbap;
    }

    static /* synthetic */ boolean access$1202(BluetoothDeviceProfileState bluetoothDeviceProfileState, boolean bl) {
        bluetoothDeviceProfileState.mPbapServiceConnected = bl;
        return bl;
    }

    static /* synthetic */ int access$602(BluetoothDeviceProfileState bluetoothDeviceProfileState, int n) {
        bluetoothDeviceProfileState.mHeadsetState = n;
        return n;
    }

    static /* synthetic */ int access$702(BluetoothDeviceProfileState bluetoothDeviceProfileState, int n) {
        bluetoothDeviceProfileState.mA2dpState = n;
        return n;
    }

    static /* synthetic */ BluetoothHeadset access$802(BluetoothDeviceProfileState bluetoothDeviceProfileState, BluetoothHeadset bluetoothHeadset) {
        bluetoothDeviceProfileState.mHeadsetService = bluetoothHeadset;
        return bluetoothHeadset;
    }

    private void handleConnectionOfOtherProfiles(int n) {
        BluetoothDevice bluetoothDevice;
        BluetoothHeadset bluetoothHeadset;
        switch (n) {
            default: {
                return;
            }
            case 2: {
                BluetoothDevice bluetoothDevice2;
                BluetoothA2dpService bluetoothA2dpService;
                BluetoothA2dpService bluetoothA2dpService2 = this.mA2dpService;
                BluetoothDevice bluetoothDevice3 = this.mDevice;
                if (bluetoothA2dpService2.getSinkPriority(bluetoothDevice3) != 100 && (bluetoothA2dpService = this.mA2dpService).getSinkPriority(bluetoothDevice2 = this.mDevice) != 1000) {
                    return;
                }
                Message message = new Message();
                message.what = 103;
                message.arg1 = 3;
                this.sendMessageDelayed(message, 4000L);
                return;
            }
            case 4: 
        }
        BluetoothHeadset bluetoothHeadset2 = this.mHeadsetService;
        BluetoothDevice bluetoothDevice4 = this.mDevice;
        if (bluetoothHeadset2.getPriority(bluetoothDevice4) != 100 && (bluetoothHeadset = this.mHeadsetService).getPriority(bluetoothDevice = this.mDevice) != 1000) {
            return;
        }
        Message message = new Message();
        message.what = 103;
        message.arg1 = 1;
        this.sendMessageDelayed(message, 4000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPhoneDocked(BluetoothDevice bluetoothDevice) {
        Context context = this.mContext;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent == null) return false;
        if (intent.getIntExtra("android.intent.extra.DOCK_STATE", 0) == 0) return false;
        BluetoothDevice bluetoothDevice2 = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (bluetoothDevice2 == null) return false;
        if (!bluetoothDevice.equals(bluetoothDevice2)) return false;
        return true;
    }

    private void log(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cancelCommand(int n) {
        synchronized (this) {
            if (n == 1 && this.mHeadsetServiceConnected) {
                boolean bl = this.mHeadsetService.cancelConnectThread();
            }
            return;
        }
    }

    void deferProfileServiceMessage(int n) {
        synchronized (this) {
            Message message = new Message();
            message.what = n;
            this.deferMessage(message);
            return;
        }
    }

    BluetoothDevice getDevice() {
        return this.mDevice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean processCommand(int n) {
        synchronized (this) {
            String string2 = "Processing command:" + n;
            int n2 = Log.i(TAG, string2);
            switch (n) {
                default: {
                    int n3 = Log.e(TAG, "Error: Unknown Command");
                    return false;
                }
                case 1: {
                    if (this.mHeadsetService == null) return false;
                    BluetoothHeadset bluetoothHeadset = this.mHeadsetService;
                    BluetoothDevice bluetoothDevice = this.mDevice;
                    return bluetoothHeadset.connectHeadsetInternal(bluetoothDevice);
                }
                case 2: {
                    if (!this.mHeadsetServiceConnected) {
                        this.deferProfileServiceMessage(n);
                        return false;
                    } else {
                        if (this.mHeadsetState == 1) {
                            BluetoothHeadset bluetoothHeadset = this.mHeadsetService;
                            BluetoothDevice bluetoothDevice = this.mDevice;
                            return bluetoothHeadset.acceptIncomingConnect(bluetoothDevice);
                        }
                        if (this.mHeadsetState != 0) return false;
                        this.handleConnectionOfOtherProfiles(n);
                        BluetoothHeadset bluetoothHeadset = this.mHeadsetService;
                        BluetoothDevice bluetoothDevice = this.mDevice;
                        return bluetoothHeadset.createIncomingConnect(bluetoothDevice);
                    }
                }
                case 3: {
                    if (this.mA2dpService == null) return false;
                    BluetoothA2dpService bluetoothA2dpService = this.mA2dpService;
                    BluetoothDevice bluetoothDevice = this.mDevice;
                    return bluetoothA2dpService.connectSinkInternal(bluetoothDevice);
                }
                case 4: {
                    this.handleConnectionOfOtherProfiles(n);
                    return true;
                }
                case 5: {
                    if (!this.mHeadsetServiceConnected) {
                        this.deferProfileServiceMessage(n);
                        return false;
                    } else {
                        Message message = new Message();
                        message.what = 9;
                        this.deferMessage(message);
                        BluetoothHeadset bluetoothHeadset = this.mHeadsetService;
                        BluetoothDevice bluetoothDevice = this.mDevice;
                        if (bluetoothHeadset.getPriority(bluetoothDevice) == 1000) {
                            BluetoothHeadset bluetoothHeadset2 = this.mHeadsetService;
                            BluetoothDevice bluetoothDevice2 = this.mDevice;
                            boolean bl = bluetoothHeadset2.setPriority(bluetoothDevice2, 100);
                        }
                        BluetoothHeadset bluetoothHeadset3 = this.mHeadsetService;
                        BluetoothDevice bluetoothDevice3 = this.mDevice;
                        return bluetoothHeadset3.disconnectHeadsetInternal(bluetoothDevice3);
                    }
                }
                case 6: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 7: {
                    if (this.mA2dpService == null) return false;
                    BluetoothA2dpService bluetoothA2dpService = this.mA2dpService;
                    BluetoothDevice bluetoothDevice = this.mDevice;
                    if (bluetoothA2dpService.getSinkPriority(bluetoothDevice) == 1000) {
                        BluetoothA2dpService bluetoothA2dpService2 = this.mA2dpService;
                        BluetoothDevice bluetoothDevice4 = this.mDevice;
                        boolean bl = bluetoothA2dpService2.setSinkPriority(bluetoothDevice4, 100);
                    }
                    BluetoothA2dpService bluetoothA2dpService3 = this.mA2dpService;
                    BluetoothDevice bluetoothDevice5 = this.mDevice;
                    return bluetoothA2dpService3.disconnectSinkInternal(bluetoothDevice5);
                }
                case 9: {
                    if (this.mPbapServiceConnected) return this.mPbapService.disconnect();
                    this.deferProfileServiceMessage(n);
                    return false;
                }
                case 100: 
            }
            BluetoothService bluetoothService = this.mService;
            String string3 = this.mDevice.getAddress();
            boolean bl = bluetoothService.removeBondInternal(string3);
            return bl;
        }
    }

    private class IncomingA2dp
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private IncomingA2dp() {
        }

        @Override
        protected void enter() {
            boolean bl;
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("Entering IncomingA2dp state with: ");
            int n2 = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            String string2 = stringBuilder.append(n2).toString();
            int n3 = Log.i(BluetoothDeviceProfileState.TAG, string2);
            this.mCommand = n = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 4 && this.mCommand != 8) {
                StringBuilder stringBuilder2 = new StringBuilder().append("Error: IncomingA2DP state with command:");
                int n4 = this.mCommand;
                String string3 = stringBuilder2.append(n4).toString();
                int n5 = Log.e(BluetoothDeviceProfileState.TAG, string3);
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            int n6 = this.mCommand;
            this.mStatus = bl = bluetoothDeviceProfileState.processCommand(n6);
            if (this.mStatus) {
                return;
            }
            BluetoothDeviceProfileState.this.sendMessage(102);
            BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            StringBuilder stringBuilder = new StringBuilder().append("IncomingA2dp State->Processing Message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            bluetoothDeviceProfileState.log(string2);
            Message message2 = new Message();
            switch (message.what) {
                default: {
                    return false;
                }
                case 1: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 2: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 5: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 7: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 9: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                }
                case 4: 
                case 6: 
                case 8: {
                    return true;
                }
                case 102: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState2 = BluetoothDeviceProfileState.this;
                    BondedDevice bondedDevice = BluetoothDeviceProfileState.this.mBondedDevice;
                    bluetoothDeviceProfileState2.transitionTo(bondedDevice);
                }
            }
            return true;
        }
    }

    private class OutgoingA2dp
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private OutgoingA2dp() {
        }

        @Override
        protected void enter() {
            boolean bl;
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("Entering OutgoingA2dp state with: ");
            int n2 = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            String string2 = stringBuilder.append(n2).toString();
            int n3 = Log.i(BluetoothDeviceProfileState.TAG, string2);
            this.mCommand = n = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 3 && this.mCommand != 7) {
                StringBuilder stringBuilder2 = new StringBuilder().append("Error: OutgoingA2DP state with command:");
                int n4 = this.mCommand;
                String string3 = stringBuilder2.append(n4).toString();
                int n5 = Log.e(BluetoothDeviceProfileState.TAG, string3);
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            int n6 = this.mCommand;
            this.mStatus = bl = bluetoothDeviceProfileState.processCommand(n6);
            if (this.mStatus) {
                return;
            }
            BluetoothDeviceProfileState.this.sendMessage(102);
            BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            StringBuilder stringBuilder = new StringBuilder().append("OutgoingA2dp State->Processing Message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            bluetoothDeviceProfileState.log(string2);
            Message message2 = new Message();
            int n2 = 0;
            block11: do {
                switch (n2 == 0 ? message.what : n2) {
                    default: {
                        return false;
                    }
                    case 1: {
                        int n3;
                        boolean bl = BluetoothDeviceProfileState.this.processCommand(1);
                        n2 = 3;
                        if (!this.mStatus) continue block11;
                        message2.what = n3 = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        return true;
                    }
                    case 2: {
                        int n4;
                        boolean bl = BluetoothDeviceProfileState.this.processCommand(2);
                        n2 = 3;
                        if (!this.mStatus) continue block11;
                        message2.what = n4 = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        return true;
                    }
                    case 4: {
                        BluetoothDeviceProfileState bluetoothDeviceProfileState2 = BluetoothDeviceProfileState.this;
                        IncomingA2dp incomingA2dp = BluetoothDeviceProfileState.this.mIncomingA2dp;
                        bluetoothDeviceProfileState2.transitionTo(incomingA2dp);
                        return true;
                    }
                    case 5: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    case 6: {
                        int n5;
                        n2 = 3;
                        if (!this.mStatus) continue block11;
                        message2.what = n5 = this.mCommand;
                        BluetoothDeviceProfileState.this.deferMessage(message2);
                        return true;
                    }
                    case 7: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    case 9: 
                    case 100: 
                    case 101: 
                    case 103: {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                    }
                    case 3: 
                    case 8: {
                        return true;
                    }
                    case 102: {
                        BluetoothDeviceProfileState bluetoothDeviceProfileState3 = BluetoothDeviceProfileState.this;
                        BondedDevice bondedDevice = BluetoothDeviceProfileState.this.mBondedDevice;
                        bluetoothDeviceProfileState3.transitionTo(bondedDevice);
                    }
                }
                return true;
            } while (true);
            return true;
        }
    }

    private class IncomingHandsfree
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private IncomingHandsfree() {
        }

        @Override
        protected void enter() {
            boolean bl;
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("Entering IncomingHandsfree state with: ");
            int n2 = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            String string2 = stringBuilder.append(n2).toString();
            int n3 = Log.i(BluetoothDeviceProfileState.TAG, string2);
            this.mCommand = n = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 2 && this.mCommand != 6) {
                StringBuilder stringBuilder2 = new StringBuilder().append("Error: IncomingHandsfree state with command:");
                int n4 = this.mCommand;
                String string3 = stringBuilder2.append(n4).toString();
                int n5 = Log.e(BluetoothDeviceProfileState.TAG, string3);
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            int n6 = this.mCommand;
            this.mStatus = bl = bluetoothDeviceProfileState.processCommand(n6);
            if (this.mStatus) {
                return;
            }
            BluetoothDeviceProfileState.this.sendMessage(102);
            BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            StringBuilder stringBuilder = new StringBuilder().append("IncomingHandsfree State -> Processing Message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            bluetoothDeviceProfileState.log(string2);
            switch (message.what) {
                default: {
                    return false;
                }
                case 1: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 2: {
                    int n2 = Log.e(BluetoothDeviceProfileState.TAG, "Error: Incoming connection with a pending incoming connection");
                    return true;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 5: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 7: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 9: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                }
                case 6: 
                case 8: {
                    return true;
                }
                case 102: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState2 = BluetoothDeviceProfileState.this;
                    BondedDevice bondedDevice = BluetoothDeviceProfileState.this.mBondedDevice;
                    bluetoothDeviceProfileState2.transitionTo(bondedDevice);
                }
            }
            return true;
        }
    }

    private class OutgoingHandsfree
    extends HierarchicalState {
        private int mCommand;
        private boolean mStatus = false;

        private OutgoingHandsfree() {
        }

        @Override
        protected void enter() {
            boolean bl;
            int n;
            StringBuilder stringBuilder = new StringBuilder().append("Entering OutgoingHandsfree state with: ");
            int n2 = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            String string2 = stringBuilder.append(n2).toString();
            int n3 = Log.i(BluetoothDeviceProfileState.TAG, string2);
            this.mCommand = n = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 1 && this.mCommand != 5) {
                StringBuilder stringBuilder2 = new StringBuilder().append("Error: OutgoingHandsfree state with command:");
                int n4 = this.mCommand;
                String string3 = stringBuilder2.append(n4).toString();
                int n5 = Log.e(BluetoothDeviceProfileState.TAG, string3);
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            int n6 = this.mCommand;
            this.mStatus = bl = bluetoothDeviceProfileState.processCommand(n6);
            if (this.mStatus) {
                return;
            }
            BluetoothDeviceProfileState.this.sendMessage(102);
            BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            StringBuilder stringBuilder = new StringBuilder().append("OutgoingHandsfree State -> Processing Message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            bluetoothDeviceProfileState.log(string2);
            Message message2 = new Message();
            int n2 = message.what;
            switch (n2) {
                default: {
                    return false;
                }
                case 1: {
                    int n3 = this.mCommand;
                    if (n2 == n3) return true;
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 2: {
                    if (this.mCommand == 1) {
                        BluetoothDeviceProfileState.this.cancelCommand(1);
                        BluetoothDeviceProfileState bluetoothDeviceProfileState2 = BluetoothDeviceProfileState.this;
                        IncomingHandsfree incomingHandsfree = BluetoothDeviceProfileState.this.mIncomingHandsfree;
                        bluetoothDeviceProfileState2.transitionTo(incomingHandsfree);
                        return true;
                    }
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 4: {
                    int n4;
                    BluetoothDeviceProfileState bluetoothDeviceProfileState3 = BluetoothDeviceProfileState.this;
                    IncomingA2dp incomingA2dp = BluetoothDeviceProfileState.this.mIncomingA2dp;
                    bluetoothDeviceProfileState3.transitionTo(incomingA2dp);
                    if (!this.mStatus) return true;
                    message2.what = n4 = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(message2);
                    return true;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 5: {
                    if (this.mCommand != 1) return true;
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    boolean bl = BluetoothDeviceProfileState.this.processCommand(5);
                    return true;
                }
                case 6: {
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    return true;
                }
                case 7: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 8: {
                    int n5;
                    if (!this.mStatus) return true;
                    message2.what = n5 = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(message2);
                    return true;
                }
                case 9: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    return true;
                }
                case 102: 
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState4 = BluetoothDeviceProfileState.this;
            BondedDevice bondedDevice = BluetoothDeviceProfileState.this.mBondedDevice;
            bluetoothDeviceProfileState4.transitionTo(bondedDevice);
            return true;
        }
    }

    private class BondedDevice
    extends HierarchicalState {
        private BondedDevice() {
        }

        @Override
        protected void enter() {
            StringBuilder stringBuilder = new StringBuilder().append("Entering ACL Connected state with: ");
            int n = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            String string2 = stringBuilder.append(n).toString();
            int n2 = Log.i(BluetoothDeviceProfileState.TAG, string2);
            Message message = new Message();
            Message message2 = BluetoothDeviceProfileState.this.getCurrentMessage();
            message.copyFrom(message2);
            BluetoothDeviceProfileState.this.sendMessageAtFrontOfQueue(message);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean processMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            StringBuilder stringBuilder = new StringBuilder().append("ACL Connected State -> Processing Message: ");
            int n = message.what;
            String string2 = stringBuilder.append(n).toString();
            bluetoothDeviceProfileState.log(string2);
            switch (message.what) {
                default: {
                    return false;
                }
                case 1: 
                case 5: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState2 = BluetoothDeviceProfileState.this;
                    OutgoingHandsfree outgoingHandsfree = BluetoothDeviceProfileState.this.mOutgoingHandsfree;
                    bluetoothDeviceProfileState2.transitionTo(outgoingHandsfree);
                    return true;
                }
                case 2: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState3 = BluetoothDeviceProfileState.this;
                    IncomingHandsfree incomingHandsfree = BluetoothDeviceProfileState.this.mIncomingHandsfree;
                    bluetoothDeviceProfileState3.transitionTo(incomingHandsfree);
                    return true;
                }
                case 6: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState4 = BluetoothDeviceProfileState.this;
                    IncomingHandsfree incomingHandsfree = BluetoothDeviceProfileState.this.mIncomingHandsfree;
                    bluetoothDeviceProfileState4.transitionTo(incomingHandsfree);
                    return true;
                }
                case 3: 
                case 7: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState5 = BluetoothDeviceProfileState.this;
                    OutgoingA2dp outgoingA2dp = BluetoothDeviceProfileState.this.mOutgoingA2dp;
                    bluetoothDeviceProfileState5.transitionTo(outgoingA2dp);
                    return true;
                }
                case 4: 
                case 8: {
                    BluetoothDeviceProfileState bluetoothDeviceProfileState6 = BluetoothDeviceProfileState.this;
                    IncomingA2dp incomingA2dp = BluetoothDeviceProfileState.this.mIncomingA2dp;
                    bluetoothDeviceProfileState6.transitionTo(incomingA2dp);
                    return true;
                }
                case 9: {
                    boolean bl = BluetoothDeviceProfileState.this.processCommand(9);
                    return true;
                }
                case 100: {
                    if (BluetoothDeviceProfileState.this.mHeadsetState != 0) {
                        BluetoothDeviceProfileState.this.sendMessage(5);
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    if (BluetoothDeviceProfileState.this.mA2dpState != 0) {
                        BluetoothDeviceProfileState.this.sendMessage(7);
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    boolean bl = BluetoothDeviceProfileState.this.processCommand(100);
                    return true;
                }
                case 101: {
                    BluetoothDevice bluetoothDevice;
                    BluetoothDevice bluetoothDevice2;
                    BluetoothHeadset bluetoothHeadset;
                    BluetoothDevice bluetoothDevice3;
                    BluetoothDeviceProfileState bluetoothDeviceProfileState7 = BluetoothDeviceProfileState.this;
                    BluetoothDevice bluetoothDevice4 = BluetoothDeviceProfileState.this.mDevice;
                    if (bluetoothDeviceProfileState7.isPhoneDocked(bluetoothDevice4)) return true;
                    if (!BluetoothDeviceProfileState.this.mHeadsetServiceConnected) {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    BluetoothHeadset bluetoothHeadset2 = BluetoothDeviceProfileState.this.mHeadsetService;
                    if (bluetoothHeadset2.getPriority(bluetoothDevice3 = BluetoothDeviceProfileState.this.mDevice) == 1000 && !(bluetoothHeadset = BluetoothDeviceProfileState.this.mHeadsetService).isConnected(bluetoothDevice2 = BluetoothDeviceProfileState.this.mDevice)) {
                        int n2 = Log.i(BluetoothDeviceProfileState.TAG, "Headset:Auto Connect Profiles");
                        BluetoothHeadset bluetoothHeadset3 = BluetoothDeviceProfileState.this.mHeadsetService;
                        BluetoothDevice bluetoothDevice5 = BluetoothDeviceProfileState.this.mDevice;
                        boolean bl = bluetoothHeadset3.connectHeadset(bluetoothDevice5);
                    }
                    if (BluetoothDeviceProfileState.this.mA2dpService == null) return true;
                    BluetoothA2dpService bluetoothA2dpService = BluetoothDeviceProfileState.this.mA2dpService;
                    if (bluetoothA2dpService.getSinkPriority(bluetoothDevice = BluetoothDeviceProfileState.this.mDevice) != 1000) return true;
                    if (BluetoothDeviceProfileState.this.mA2dpService.getConnectedSinks().length != 0) return true;
                    int n3 = Log.i(BluetoothDeviceProfileState.TAG, "A2dp:Auto Connect Profiles");
                    BluetoothA2dpService bluetoothA2dpService2 = BluetoothDeviceProfileState.this.mA2dpService;
                    BluetoothDevice bluetoothDevice6 = BluetoothDeviceProfileState.this.mDevice;
                    boolean bl = bluetoothA2dpService2.connectSink(bluetoothDevice6);
                }
                case 102: {
                    return true;
                }
                case 103: {
                    BluetoothDevice bluetoothDevice;
                    BluetoothDeviceProfileState bluetoothDeviceProfileState8 = BluetoothDeviceProfileState.this;
                    BluetoothDevice bluetoothDevice7 = BluetoothDeviceProfileState.this.mDevice;
                    if (bluetoothDeviceProfileState8.isPhoneDocked(bluetoothDevice7)) return true;
                    if (message.arg1 == 3) {
                        if (BluetoothDeviceProfileState.this.mA2dpService == null) return true;
                        if (BluetoothDeviceProfileState.this.mA2dpService.getConnectedSinks().length != 0) return true;
                        int n4 = Log.i(BluetoothDeviceProfileState.TAG, "A2dp:Connect Other Profiles");
                        BluetoothA2dpService bluetoothA2dpService = BluetoothDeviceProfileState.this.mA2dpService;
                        BluetoothDevice bluetoothDevice8 = BluetoothDeviceProfileState.this.mDevice;
                        boolean bl = bluetoothA2dpService.connectSink(bluetoothDevice8);
                        return true;
                    }
                    if (message.arg1 != 1) return true;
                    if (!BluetoothDeviceProfileState.this.mHeadsetServiceConnected) {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        return true;
                    }
                    BluetoothHeadset bluetoothHeadset = BluetoothDeviceProfileState.this.mHeadsetService;
                    if (bluetoothHeadset.isConnected(bluetoothDevice = BluetoothDeviceProfileState.this.mDevice)) return true;
                    int n5 = Log.i(BluetoothDeviceProfileState.TAG, "Headset:Connect Other Profiles");
                    BluetoothHeadset bluetoothHeadset4 = BluetoothDeviceProfileState.this.mHeadsetService;
                    BluetoothDevice bluetoothDevice9 = BluetoothDeviceProfileState.this.mDevice;
                    boolean bl = bluetoothHeadset4.connectHeadset(bluetoothDevice9);
                }
            }
            return true;
        }
    }

    private class PbapServiceListener
    implements BluetoothPbap.ServiceListener {
        public PbapServiceListener() {
            Context context = BluetoothDeviceProfileState.this.mContext;
            BluetoothPbap bluetoothPbap = new BluetoothPbap(context, this);
            BluetoothPbap bluetoothPbap2 = BluetoothDeviceProfileState.access$1102(BluetoothDeviceProfileState.this, bluetoothPbap);
        }

        @Override
        public void onServiceConnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                boolean bl = BluetoothDeviceProfileState.access$1202(BluetoothDeviceProfileState.this, true);
                return;
            }
        }

        @Override
        public void onServiceDisconnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                boolean bl = BluetoothDeviceProfileState.access$1202(BluetoothDeviceProfileState.this, false);
                return;
            }
        }
    }

    private class HeadsetServiceListener
    implements BluetoothHeadset.ServiceListener {
        public HeadsetServiceListener() {
            Context context = BluetoothDeviceProfileState.this.mContext;
            BluetoothHeadset bluetoothHeadset = new BluetoothHeadset(context, this);
            BluetoothHeadset bluetoothHeadset2 = BluetoothDeviceProfileState.access$802(BluetoothDeviceProfileState.this, bluetoothHeadset);
        }

        @Override
        public void onServiceConnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                boolean bl = BluetoothDeviceProfileState.access$1002(BluetoothDeviceProfileState.this, true);
                return;
            }
        }

        @Override
        public void onServiceDisconnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                boolean bl = BluetoothDeviceProfileState.access$1002(BluetoothDeviceProfileState.this, false);
                return;
            }
        }
    }
}

