/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothHeadset;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public final class BluetoothHeadset {
    public static final String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.action.AUDIO_STATE_CHANGED";
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.headset.action.STATE_CHANGED";
    public static final int AUDIO_STATE_CONNECTED = 1;
    public static final int AUDIO_STATE_DISCONNECTED = 0;
    private static final boolean DBG = false;
    public static final String EXTRA_AUDIO_STATE = "android.bluetooth.headset.extra.AUDIO_STATE";
    public static final String EXTRA_DISCONNECT_INITIATOR = "android.bluetooth.headset.extra.DISCONNECT_INITIATOR";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.headset.extra.PREVIOUS_STATE";
    public static final String EXTRA_STATE = "android.bluetooth.headset.extra.STATE";
    public static final int LOCAL_DISCONNECT = 1;
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    public static final int PRIORITY_OFF = 0;
    public static final int PRIORITY_ON = 100;
    public static final int PRIORITY_UNDEFINED = 255;
    public static final int REMOTE_DISCONNECT = 0;
    public static final int RESULT_CANCELED = 2;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_ERROR = 255;
    private static final String TAG = "BluetoothHeadset";
    private ServiceConnection mConnection;
    private final Context mContext;
    private IBluetoothHeadset mService;
    private final ServiceListener mServiceListener;

    public BluetoothHeadset(Context context, ServiceListener serviceListener) {
        ServiceConnection serviceConnection;
        this.mConnection = serviceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                BluetoothHeadset bluetoothHeadset = BluetoothHeadset.this;
                IBluetoothHeadset iBluetoothHeadset = IBluetoothHeadset.Stub.asInterface(iBinder);
                IBluetoothHeadset iBluetoothHeadset2 = BluetoothHeadset.access$002(bluetoothHeadset, iBluetoothHeadset);
                if (BluetoothHeadset.this.mServiceListener == null) {
                    return;
                }
                BluetoothHeadset.this.mServiceListener.onServiceConnected();
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                IBluetoothHeadset iBluetoothHeadset = BluetoothHeadset.access$002(BluetoothHeadset.this, null);
                if (BluetoothHeadset.this.mServiceListener == null) {
                    return;
                }
                BluetoothHeadset.this.mServiceListener.onServiceDisconnected();
            }
        };
        this.mContext = context;
        this.mServiceListener = serviceListener;
        String string2 = IBluetoothHeadset.class.getName();
        Intent intent = new Intent(string2);
        ServiceConnection serviceConnection2 = this.mConnection;
        if (context.bindService(intent, serviceConnection2, 0)) {
            return;
        }
        int n = Log.e(TAG, "Could not bind to Bluetooth Headset Service");
    }

    static /* synthetic */ IBluetoothHeadset access$002(BluetoothHeadset bluetoothHeadset, IBluetoothHeadset iBluetoothHeadset) {
        bluetoothHeadset.mService = iBluetoothHeadset;
        return iBluetoothHeadset;
    }

    public static boolean isBluetoothVoiceDialingEnabled(Context context) {
        return context.getResources().getBoolean(0x10D0011);
    }

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.acceptIncomingConnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cancelConnectThread() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.cancelConnectThread();
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    public void close() {
        synchronized (this) {
            if (this.mConnection != null) {
                Context context = this.mContext;
                ServiceConnection serviceConnection = this.mConnection;
                context.unbindService(serviceConnection);
                this.mConnection = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectHeadset(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.connectHeadset(bluetoothDevice);
                if (!bl) return false;
                return true;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
            }
            return false;
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectHeadsetInternal(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.connectHeadsetInternal(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createIncomingConnect(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.createIncomingConnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectHeadset(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                this.mService.disconnectHeadset(bluetoothDevice);
                return true;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectHeadsetInternal(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.disconnectHeadsetInternal(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getBatteryUsageHint() {
        if (this.mService != null) {
            try {
                int n = this.mService.getBatteryUsageHint();
                return n;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return -1;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothDevice getCurrentHeadset() {
        if (this.mService != null) {
            try {
                BluetoothDevice bluetoothDevice = this.mService.getCurrentHeadset();
                return bluetoothDevice;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return null;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                int n = this.mService.getPriority(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return -1;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                int n = this.mService.getState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return -1;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isConnected(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.setPriority(bluetoothDevice, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n2 = Log.e(TAG, string2);
                return false;
            }
        }
        int n3 = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startVoiceRecognition() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.startVoiceRecognition();
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopVoiceRecognition() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.stopVoiceRecognition();
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    public static interface ServiceListener {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }
}

