/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;

final class BluetoothInputStream
extends InputStream {
    private BluetoothSocket mSocket;

    BluetoothInputStream(BluetoothSocket bluetoothSocket) {
        this.mSocket = bluetoothSocket;
    }

    @Override
    public int available() throws IOException {
        return this.mSocket.available();
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.mSocket.read(byArray, 0, 1) != 1) return -1;
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException("byte array is null");
        }
        if ((n | n2) < 0 || n2 > (n3 = byArray.length - n)) {
            throw new ArrayIndexOutOfBoundsException("invalid offset or length");
        }
        return this.mSocket.read(byArray, n, n2);
    }
}

