/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothPbap;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class BluetoothPbap {
    private static final boolean DBG = false;
    public static final String PBAP_PREVIOUS_STATE = "android.bluetooth.pbap.intent.PBAP_PREVIOUS_STATE";
    public static final String PBAP_STATE = "android.bluetooth.pbap.intent.PBAP_STATE";
    public static final String PBAP_STATE_CHANGED_ACTION = "android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED";
    public static final int RESULT_CANCELED = 2;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_ERROR = 255;
    private static final String TAG = "BluetoothPbap";
    private ServiceConnection mConnection;
    private final Context mContext;
    private IBluetoothPbap mService;
    private final ServiceListener mServiceListener;

    public BluetoothPbap(Context context, ServiceListener serviceListener) {
        ServiceConnection serviceConnection;
        this.mConnection = serviceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                BluetoothPbap bluetoothPbap = BluetoothPbap.this;
                IBluetoothPbap iBluetoothPbap = IBluetoothPbap.Stub.asInterface(iBinder);
                IBluetoothPbap iBluetoothPbap2 = BluetoothPbap.access$002(bluetoothPbap, iBluetoothPbap);
                if (BluetoothPbap.this.mServiceListener == null) {
                    return;
                }
                BluetoothPbap.this.mServiceListener.onServiceConnected();
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                IBluetoothPbap iBluetoothPbap = BluetoothPbap.access$002(BluetoothPbap.this, null);
                if (BluetoothPbap.this.mServiceListener == null) {
                    return;
                }
                BluetoothPbap.this.mServiceListener.onServiceDisconnected();
            }
        };
        this.mContext = context;
        this.mServiceListener = serviceListener;
        String string2 = IBluetoothPbap.class.getName();
        Intent intent = new Intent(string2);
        ServiceConnection serviceConnection2 = this.mConnection;
        if (context.bindService(intent, serviceConnection2, 0)) {
            return;
        }
        int n = Log.e(TAG, "Could not bind to Bluetooth Pbap Service");
    }

    static /* synthetic */ IBluetoothPbap access$002(BluetoothPbap bluetoothPbap, IBluetoothPbap iBluetoothPbap) {
        bluetoothPbap.mService = iBluetoothPbap;
        return iBluetoothPbap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doesClassMatchSink(BluetoothClass bluetoothClass) {
        switch (bluetoothClass.getDeviceClass()) {
            default: {
                return false;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
        }
        return true;
    }

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    public void close() {
        synchronized (this) {
            if (this.mConnection != null) {
                Context context = this.mContext;
                ServiceConnection serviceConnection = this.mConnection;
                context.unbindService(serviceConnection);
                this.mConnection = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        if (this.mService != null) {
            try {
                this.mService.disconnect();
                return true;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothDevice getClient() {
        if (this.mService != null) {
            try {
                BluetoothDevice bluetoothDevice = this.mService.getClient();
                return bluetoothDevice;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return null;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        if (this.mService != null) {
            try {
                int n = this.mService.getState();
                return n;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return -1;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isConnected(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                String string2 = remoteException.toString();
                int n = Log.e(TAG, string2);
                return false;
            }
        }
        int n = Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    public static interface ServiceListener {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }
}

