/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public class BluetoothProfileState
extends HierarchicalStateMachine {
    public static final int A2DP = 1;
    private static final boolean DBG = true;
    public static final int HFP = 0;
    private static final String TAG = "BluetoothProfileState";
    static final int TRANSITION_TO_STABLE = 100;
    private BroadcastReceiver mBroadcastReceiver;
    private PendingCommandState mPendingCommandState;
    private BluetoothDevice mPendingDevice;
    private int mProfile;
    private StableState mStableState;

    public BluetoothProfileState(Context context, int n) {
        BroadcastReceiver broadcastReceiver;
        StableState stableState;
        PendingCommandState pendingCommandState;
        String string2 = "BluetoothProfileState:" + n;
        super(string2);
        this.mPendingCommandState = pendingCommandState = new PendingCommandState();
        this.mStableState = stableState = new StableState();
        this.mBroadcastReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                    if (BluetoothProfileState.this.mProfile != 0) {
                        return;
                    }
                    if (n != 2 && n != 0) {
                        return;
                    }
                    BluetoothProfileState.this.sendMessage(100);
                    return;
                }
                if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                    if (BluetoothProfileState.this.mProfile != 1) {
                        return;
                    }
                    if (n != 2 && n != 0) {
                        return;
                    }
                    BluetoothProfileState.this.sendMessage(100);
                    return;
                }
                if (!string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                    return;
                }
                BluetoothDevice bluetoothDevice2 = BluetoothProfileState.this.mPendingDevice;
                if (!bluetoothDevice.equals(bluetoothDevice2)) {
                    return;
                }
                BluetoothProfileState.this.sendMessage(100);
            }
        };
        this.mProfile = n;
        StableState stableState2 = this.mStableState;
        this.addState(stableState2);
        PendingCommandState pendingCommandState2 = this.mPendingCommandState;
        this.addState(pendingCommandState2);
        StableState stableState3 = this.mStableState;
        this.setInitialState(stableState3);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        BroadcastReceiver broadcastReceiver2 = this.mBroadcastReceiver;
        Intent intent = context.registerReceiver(broadcastReceiver2, intentFilter);
    }

    static /* synthetic */ BluetoothDevice access$302(BluetoothProfileState bluetoothProfileState, BluetoothDevice bluetoothDevice) {
        bluetoothProfileState.mPendingDevice = bluetoothDevice;
        return bluetoothDevice;
    }

    private void log(String string2) {
        String string3 = "Message:" + string2;
        int n = Log.i(TAG, string3);
    }

    private class PendingCommandState
    extends HierarchicalState {
        private PendingCommandState() {
        }

        private void dispatchMessage(Message message) {
            BluetoothDevice bluetoothDevice;
            BluetoothDevice bluetoothDevice2;
            BluetoothDeviceProfileState bluetoothDeviceProfileState = (BluetoothDeviceProfileState)message.obj;
            int n = message.arg1;
            if (BluetoothProfileState.this.mPendingDevice == null || (bluetoothDevice2 = BluetoothProfileState.this.mPendingDevice).equals(bluetoothDevice = bluetoothDeviceProfileState.getDevice())) {
                BluetoothProfileState bluetoothProfileState = BluetoothProfileState.this;
                BluetoothDevice bluetoothDevice3 = bluetoothDeviceProfileState.getDevice();
                BluetoothDevice bluetoothDevice4 = BluetoothProfileState.access$302(bluetoothProfileState, bluetoothDevice3);
                bluetoothDeviceProfileState.sendMessage(n);
                return;
            }
            Message message2 = new Message();
            message2.arg1 = n;
            message2.obj = bluetoothDeviceProfileState;
            BluetoothProfileState.this.deferMessage(message2);
        }

        @Override
        protected void enter() {
            BluetoothProfileState.this.log("Entering PendingCommandState State");
            Message message = BluetoothProfileState.this.getCurrentMessage();
            this.dispatchMessage(message);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 100) {
                BluetoothProfileState bluetoothProfileState = BluetoothProfileState.this;
                StableState stableState = BluetoothProfileState.this.mStableState;
                bluetoothProfileState.transitionTo(stableState);
                return true;
            }
            this.dispatchMessage(message);
            return true;
        }
    }

    private class StableState
    extends HierarchicalState {
        private StableState() {
        }

        @Override
        protected void enter() {
            BluetoothProfileState.this.log("Entering Stable State");
            BluetoothDevice bluetoothDevice = BluetoothProfileState.access$302(BluetoothProfileState.this, null);
        }

        @Override
        protected boolean processMessage(Message message) {
            if (message.what != 100) {
                BluetoothProfileState bluetoothProfileState = BluetoothProfileState.this;
                PendingCommandState pendingCommandState = BluetoothProfileState.this.mPendingCommandState;
                bluetoothProfileState.transitionTo(pendingCommandState);
            }
            return true;
        }
    }
}

