/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BluetoothSocket
implements Closeable {
    static final int EADDRINUSE = 98;
    static final int EBADFD = 77;
    public static final int MAX_RFCOMM_CHANNEL = 30;
    private static final String TAG = "BluetoothSocket";
    static final int TYPE_L2CAP = 3;
    static final int TYPE_RFCOMM = 1;
    static final int TYPE_SCO = 2;
    private final String mAddress;
    private final boolean mAuth;
    private boolean mClosed;
    private final BluetoothDevice mDevice;
    private final boolean mEncrypt;
    private final BluetoothInputStream mInputStream;
    private final ReentrantReadWriteLock mLock;
    private final BluetoothOutputStream mOutputStream;
    private int mPort;
    private final SdpHelper mSdp;
    private int mSocketData;
    private final int mType;

    /*
     * Enabled aggressive block sorting
     */
    BluetoothSocket(int n, int n2, boolean bl, boolean bl2, BluetoothDevice bluetoothDevice, int n3, ParcelUuid parcelUuid) throws IOException {
        ReentrantReadWriteLock reentrantReadWriteLock;
        BluetoothOutputStream bluetoothOutputStream;
        BluetoothInputStream bluetoothInputStream;
        String string2;
        if (n == 1 && parcelUuid == null && n2 == -1 && (n3 < 1 || n3 > 30)) {
            String string3 = "Invalid RFCOMM channel: " + n3;
            throw new IOException(string3);
        }
        if (parcelUuid == null) {
            this.mPort = n3;
            this.mSdp = null;
        } else {
            SdpHelper sdpHelper;
            this.mSdp = sdpHelper = new SdpHelper(bluetoothDevice, parcelUuid);
            this.mPort = -1;
        }
        this.mType = n;
        this.mAuth = bl;
        this.mEncrypt = bl2;
        this.mDevice = bluetoothDevice;
        this.mAddress = bluetoothDevice == null ? null : (string2 = bluetoothDevice.getAddress());
        if (n2 == -1) {
            this.initSocketNative();
        } else {
            this.initSocketFromFdNative(n2);
        }
        this.mInputStream = bluetoothInputStream = new BluetoothInputStream(this);
        this.mOutputStream = bluetoothOutputStream = new BluetoothOutputStream(this);
        this.mClosed = false;
        this.mLock = reentrantReadWriteLock = new ReentrantReadWriteLock();
    }

    private BluetoothSocket(int n, int n2, boolean bl, boolean bl2, String string2, int n3) throws IOException {
        BluetoothDevice bluetoothDevice = new BluetoothDevice(string2);
        BluetoothSocket bluetoothSocket = this;
        int n4 = n;
        int n5 = n2;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        int n6 = n3;
        bluetoothSocket(n4, n5, bl3, bl4, bluetoothDevice, n6, null);
    }

    private native void abortNative() throws IOException;

    private native BluetoothSocket acceptNative(int var1) throws IOException;

    private native int availableNative() throws IOException;

    private native int bindListenNative();

    private native void connectNative() throws IOException;

    private native void destroyNative() throws IOException;

    private native void initSocketFromFdNative(int var1) throws IOException;

    private native void initSocketNative() throws IOException;

    private native int readNative(byte[] var1, int var2, int var3) throws IOException;

    private native int writeNative(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothSocket accept(int n) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mClosed) {
                throw new IOException("socket closed");
            }
        }
        catch (Throwable throwable) {
            this.mLock.readLock().unlock();
            throw throwable;
        }
        {
            BluetoothSocket bluetoothSocket;
            BluetoothSocket bluetoothSocket2 = bluetoothSocket = this.acceptNative(n);
            this.mLock.readLock().unlock();
            return bluetoothSocket2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int available() throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mClosed) {
                throw new IOException("socket closed");
            }
        }
        catch (Throwable throwable) {
            this.mLock.readLock().unlock();
            throw throwable;
        }
        {
            int n;
            int n2 = n = this.availableNative();
            this.mLock.readLock().unlock();
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int bindListen() {
        this.mLock.readLock().lock();
        try {
            ReentrantReadWriteLock.ReadLock readLock;
            int n;
            boolean bl = this.mClosed;
            if (bl) {
                n = 77;
                readLock = this.mLock.readLock();
            } else {
                int n2;
                n = n2 = this.bindListenNative();
                readLock = this.mLock.readLock();
            }
            readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            this.mLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        block8: {
            this.mLock.readLock().lock();
            boolean bl = this.mClosed;
            if (!bl) break block8;
            this.mLock.readLock().unlock();
            return;
        }
        if (this.mSdp != null) {
            this.mSdp.cancel();
        }
        this.abortNative();
        this.mLock.writeLock().lock();
        boolean bl = true;
        try {
            this.mClosed = bl;
            this.destroyNative();
            return;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mClosed) {
                throw new IOException("socket closed");
            }
            if (this.mSdp != null) {
                int n;
                this.mPort = n = this.mSdp.doSdp();
            }
            this.connectNative();
            return;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.mInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    public BluetoothDevice getRemoteDevice() {
        return this.mDevice;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int read(byte[] byArray, int n, int n2) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mClosed) {
                throw new IOException("socket closed");
            }
        }
        catch (Throwable throwable) {
            this.mLock.readLock().unlock();
            throw throwable;
        }
        {
            int n3;
            int n4 = n3 = this.readNative(byArray, n, n2);
            this.mLock.readLock().unlock();
            return n4;
        }
    }

    native void throwErrnoNative(int var1) throws IOException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int write(byte[] byArray, int n, int n2) throws IOException {
        this.mLock.readLock().lock();
        try {
            if (this.mClosed) {
                throw new IOException("socket closed");
            }
        }
        catch (Throwable throwable) {
            this.mLock.readLock().unlock();
            throw throwable;
        }
        {
            int n3;
            int n4 = n3 = this.writeNative(byArray, n, n2);
            this.mLock.readLock().unlock();
            return n4;
        }
    }

    private static class SdpHelper
    extends IBluetoothCallback.Stub {
        private boolean canceled;
        private int channel;
        private final BluetoothDevice device;
        private final IBluetooth service;
        private final ParcelUuid uuid;

        public SdpHelper(BluetoothDevice bluetoothDevice, ParcelUuid parcelUuid) {
            IBluetooth iBluetooth;
            this.service = iBluetooth = BluetoothDevice.getService();
            this.device = bluetoothDevice;
            this.uuid = parcelUuid;
            this.canceled = false;
        }

        public void cancel() {
            synchronized (this) {
                if (!this.canceled) {
                    this.canceled = true;
                    this.channel = -1;
                    this.notifyAll();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int doSdp() throws IOException {
            synchronized (this) {
                int n;
                if (this.canceled) {
                    throw new IOException("Service discovery canceled");
                }
                this.channel = n = -1;
                boolean bl = false;
                try {
                    boolean bl2;
                    IBluetooth iBluetooth = this.service;
                    String string2 = this.device.getAddress();
                    ParcelUuid parcelUuid = this.uuid;
                    bl = bl2 = iBluetooth.fetchRemoteUuids(string2, parcelUuid, this);
                }
                catch (RemoteException remoteException) {
                    int n2 = Log.e(BluetoothSocket.TAG, "", remoteException);
                }
                if (!bl) {
                    throw new IOException("Unable to start Service Discovery");
                }
                n = (int)12000L;
                try {
                    this.wait(n);
                }
                catch (InterruptedException interruptedException) {}
                if (this.canceled) {
                    throw new IOException("Service discovery canceled");
                }
                if (this.channel >= 1) return this.channel;
                throw new IOException("Service discovery failed");
            }
        }

        @Override
        public void onRfcommChannelFound(int n) {
            synchronized (this) {
                if (!this.canceled) {
                    this.channel = n;
                    this.notifyAll();
                }
                return;
            }
        }
    }
}

