/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.ParcelUuid;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class BluetoothUuid {
    public static final ParcelUuid AdvAudioDist;
    public static final ParcelUuid AudioSink;
    public static final ParcelUuid AudioSource;
    public static final ParcelUuid AvrcpController;
    public static final ParcelUuid AvrcpTarget;
    public static final ParcelUuid HSP;
    public static final ParcelUuid Handsfree;
    public static final ParcelUuid ObexObjectPush;
    public static final ParcelUuid[] RESERVED_UUIDS;

    static {
        AudioSink = ParcelUuid.fromString("0000110B-0000-1000-8000-00805F9B34FB");
        AudioSource = ParcelUuid.fromString("0000110A-0000-1000-8000-00805F9B34FB");
        AdvAudioDist = ParcelUuid.fromString("0000110D-0000-1000-8000-00805F9B34FB");
        HSP = ParcelUuid.fromString("00001108-0000-1000-8000-00805F9B34FB");
        Handsfree = ParcelUuid.fromString("0000111E-0000-1000-8000-00805F9B34FB");
        AvrcpController = ParcelUuid.fromString("0000110E-0000-1000-8000-00805F9B34FB");
        AvrcpTarget = ParcelUuid.fromString("0000110C-0000-1000-8000-00805F9B34FB");
        ObexObjectPush = ParcelUuid.fromString("00001105-0000-1000-8000-00805f9b34fb");
        ParcelUuid parcelUuid = AudioSink;
        ParcelUuid parcelUuid2 = AudioSource;
        ParcelUuid parcelUuid3 = AdvAudioDist;
        ParcelUuid parcelUuid4 = HSP;
        ParcelUuid parcelUuid5 = Handsfree;
        ParcelUuid parcelUuid6 = AvrcpController;
        ParcelUuid parcelUuid7 = AvrcpTarget;
        ParcelUuid parcelUuid8 = ObexObjectPush;
        ParcelUuid[] parcelUuidArray = new ParcelUuid[]{parcelUuid, parcelUuid2, parcelUuid3, parcelUuid4, parcelUuid5, parcelUuid6, parcelUuid7, parcelUuid8};
        RESERVED_UUIDS = parcelUuidArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsAllUuids(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            if (parcelUuidArray2.length != 0) return false;
            return true;
        }
        if (parcelUuidArray2 == null) {
            return true;
        }
        List<ParcelUuid> list = Arrays.asList(parcelUuidArray);
        HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(list);
        ParcelUuid[] parcelUuidArray3 = parcelUuidArray2;
        int n = parcelUuidArray3.length;
        int n2 = 0;
        while (n2 < n) {
            ParcelUuid parcelUuid = parcelUuidArray3[n2];
            if (!hashSet.contains(parcelUuid)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsAnyUuid(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            if (parcelUuidArray2.length != 0) return false;
            return true;
        }
        if (parcelUuidArray2 == null) {
            if (parcelUuidArray.length != 0) return false;
            return true;
        }
        List<ParcelUuid> list = Arrays.asList(parcelUuidArray);
        HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(list);
        ParcelUuid[] parcelUuidArray3 = parcelUuidArray2;
        int n = parcelUuidArray3.length;
        int n2 = 0;
        while (n2 < n) {
            ParcelUuid parcelUuid = parcelUuidArray3[n2];
            if (hashSet.contains(parcelUuid)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAdvAudioDist(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = AdvAudioDist;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isAudioSink(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = AudioSink;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isAudioSource(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = AudioSource;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isAvrcpController(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = AvrcpController;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isAvrcpTarget(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = AvrcpTarget;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isHandsfree(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = Handsfree;
        return parcelUuid.equals(parcelUuid2);
    }

    public static boolean isHeadset(ParcelUuid parcelUuid) {
        ParcelUuid parcelUuid2 = HSP;
        return parcelUuid.equals(parcelUuid2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUuidPresent(ParcelUuid[] parcelUuidArray, ParcelUuid parcelUuid) {
        if ((parcelUuidArray == null || parcelUuidArray.length == 0) && parcelUuid == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return false;
        }
        ParcelUuid[] parcelUuidArray2 = parcelUuidArray;
        int n = parcelUuidArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (parcelUuidArray2[n2].equals(parcelUuid)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

