/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.AtCommandResult;
import android.bluetooth.AtParser;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;

public final class HeadsetBase {
    private static final boolean DBG = false;
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    public static final int RFCOMM_DISCONNECTED = 1;
    private static final String TAG = "Bluetooth HeadsetBase";
    private static int sAtInputCount = 0;
    private final BluetoothAdapter mAdapter;
    private final String mAddress;
    protected AtParser mAtParser;
    private final long mConnectTimestamp;
    private final int mDirection;
    private Thread mEventThread;
    private Handler mEventThreadHandler;
    private volatile boolean mEventThreadInterrupted;
    private int mNativeData;
    private final BluetoothDevice mRemoteDevice;
    private final int mRfcommChannel;
    private int mTimeoutRemainingMs;
    private PowerManager.WakeLock mWakeLock;

    static {
        HeadsetBase.classInitNative();
    }

    public HeadsetBase(PowerManager powerManager, BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice, int n) {
        PowerManager.WakeLock wakeLock;
        String string2;
        long l;
        this.mDirection = 2;
        this.mConnectTimestamp = l = System.currentTimeMillis();
        this.mAdapter = bluetoothAdapter;
        this.mRemoteDevice = bluetoothDevice;
        this.mAddress = string2 = bluetoothDevice.getAddress();
        this.mRfcommChannel = n;
        this.mWakeLock = wakeLock = powerManager.newWakeLock(1, "HeadsetBase");
        this.mWakeLock.setReferenceCounted(false);
        this.initializeAtParser();
        this.initializeNativeDataNative(-1);
    }

    public HeadsetBase(PowerManager powerManager, BluetoothAdapter bluetoothAdapter, BluetoothDevice bluetoothDevice, int n, int n2, Handler handler) {
        PowerManager.WakeLock wakeLock;
        String string2;
        long l;
        this.mDirection = 1;
        this.mConnectTimestamp = l = System.currentTimeMillis();
        this.mAdapter = bluetoothAdapter;
        this.mRemoteDevice = bluetoothDevice;
        this.mAddress = string2 = bluetoothDevice.getAddress();
        this.mRfcommChannel = n2;
        this.mEventThreadHandler = handler;
        this.mWakeLock = wakeLock = powerManager.newWakeLock(1, "HeadsetBase");
        this.mWakeLock.setReferenceCounted(false);
        this.initializeAtParser();
        this.initializeNativeDataNative(n);
    }

    private void acquireWakeLock() {
        synchronized (this) {
            if (!this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            }
            return;
        }
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native int connectAsyncNative();

    private native boolean connectNative();

    private native void disconnectNative();

    public static int getAtInputCount() {
        return sAtInputCount;
    }

    private native int getLastReadStatusNative();

    private native void initializeNativeDataNative(int var1);

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    private native String readNative(int var1);

    private void releaseWakeLock() {
        synchronized (this) {
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            return;
        }
    }

    private native boolean sendURCNative(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopEventThread() {
        this.mEventThreadInterrupted = true;
        this.mEventThread.interrupt();
        try {
            this.mEventThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.mEventThread = null;
    }

    private native int waitForAsyncConnectNative(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(Handler handler) {
        if (this.mEventThread != null) return true;
        if (!this.connectNative()) {
            return false;
        }
        this.mEventThreadHandler = handler;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectAsync() {
        if (this.connectAsyncNative() != 0) return false;
        return true;
    }

    public void disconnect() {
        if (this.mEventThread != null) {
            this.stopEventThread();
        }
        this.disconnectNative();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            this.releaseWakeLock();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public AtParser getAtParser() {
        return this.mAtParser;
    }

    public long getConnectTimestamp() {
        return this.mConnectTimestamp;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getRemainingAsyncConnectWaitingTimeMs() {
        return this.mTimeoutRemainingMs;
    }

    public BluetoothDevice getRemoteDevice() {
        return this.mRemoteDevice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleInput(String string2) {
        this.acquireWakeLock();
        synchronized (HeadsetBase.class) {
            sAtInputCount = sAtInputCount == Integer.MAX_VALUE ? 0 : ++sAtInputCount;
        }
        AtCommandResult atCommandResult = this.mAtParser.process(string2);
        if (atCommandResult.getResultCode() == 1) {
            String string3 = "Error processing <" + string2 + ">";
            int n = Log.i(TAG, string3);
        }
        String string4 = atCommandResult.toString();
        boolean bl = this.sendURC(string4);
        this.releaseWakeLock();
    }

    protected void initializeAtParser() {
        AtParser atParser;
        this.mAtParser = atParser = new AtParser();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        if (this.mEventThread == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendURC(String string2) {
        synchronized (this) {
            if (string2.length() <= 0) return true;
            boolean bl = this.sendURCNative(string2);
            return bl;
        }
    }

    public void startEventThread() {
        Thread thread;
        this.mEventThread = thread = new Thread("HeadsetBase Event Thread"){

            @Override
            public void run() {
                int n;
                while (true) {
                    if (HeadsetBase.this.mEventThreadInterrupted) {
                        return;
                    }
                    String string2 = HeadsetBase.this.readNative(500);
                    if (string2 != null) {
                        HeadsetBase.this.handleInput(string2);
                        continue;
                    }
                    n = HeadsetBase.this.getLastReadStatusNative();
                    if (n != 0) break;
                }
                String string3 = "headset read error " + n;
                int n2 = Log.i(HeadsetBase.TAG, string3);
                if (HeadsetBase.this.mEventThreadHandler != null) {
                    HeadsetBase.this.mEventThreadHandler.obtainMessage(1).sendToTarget();
                }
                HeadsetBase.this.disconnectNative();
            }
        };
        this.mEventThreadInterrupted = false;
        this.mEventThread.start();
    }

    public int waitForAsyncConnect(int n, Handler handler) {
        int n2 = this.waitForAsyncConnectNative(n);
        if (n2 > 0) {
            this.mEventThreadHandler = handler;
        }
        return n2;
    }
}

