/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.IBluetoothCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IBluetooth
extends IInterface {
    public int addRfcommServiceRecord(String var1, ParcelUuid var2, int var3, IBinder var4) throws RemoteException;

    public boolean cancelBondProcess(String var1) throws RemoteException;

    public boolean cancelDiscovery() throws RemoteException;

    public boolean cancelPairingUserInput(String var1) throws RemoteException;

    public boolean connectHeadset(String var1) throws RemoteException;

    public boolean createBond(String var1) throws RemoteException;

    public boolean createBondOutOfBand(String var1, byte[] var2, byte[] var3) throws RemoteException;

    public boolean disable(boolean var1) throws RemoteException;

    public boolean disconnectHeadset(String var1) throws RemoteException;

    public boolean enable() throws RemoteException;

    public boolean fetchRemoteUuids(String var1, ParcelUuid var2, IBluetoothCallback var3) throws RemoteException;

    public String getAddress() throws RemoteException;

    public int getBluetoothState() throws RemoteException;

    public int getBondState(String var1) throws RemoteException;

    public int getDiscoverableTimeout() throws RemoteException;

    public String getName() throws RemoteException;

    public int getRemoteClass(String var1) throws RemoteException;

    public String getRemoteName(String var1) throws RemoteException;

    public int getRemoteServiceChannel(String var1, ParcelUuid var2) throws RemoteException;

    public ParcelUuid[] getRemoteUuids(String var1) throws RemoteException;

    public int getScanMode() throws RemoteException;

    public boolean getTrustState(String var1) throws RemoteException;

    public boolean isBluetoothDock(String var1) throws RemoteException;

    public boolean isDiscovering() throws RemoteException;

    public boolean isEnabled() throws RemoteException;

    public String[] listBonds() throws RemoteException;

    public boolean notifyIncomingConnection(String var1) throws RemoteException;

    public byte[] readOutOfBandData() throws RemoteException;

    public boolean removeBond(String var1) throws RemoteException;

    public void removeServiceRecord(int var1) throws RemoteException;

    public boolean setDeviceOutOfBandData(String var1, byte[] var2, byte[] var3) throws RemoteException;

    public boolean setDiscoverableTimeout(int var1) throws RemoteException;

    public boolean setName(String var1) throws RemoteException;

    public boolean setPairingConfirmation(String var1, boolean var2) throws RemoteException;

    public boolean setPasskey(String var1, int var2) throws RemoteException;

    public boolean setPin(String var1, byte[] var2) throws RemoteException;

    public boolean setRemoteOutOfBandData(String var1) throws RemoteException;

    public boolean setScanMode(int var1, int var2) throws RemoteException;

    public boolean setTrust(String var1, boolean var2) throws RemoteException;

    public boolean startDiscovery() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetooth {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetooth";
        static final int TRANSACTION_addRfcommServiceRecord = 36;
        static final int TRANSACTION_cancelBondProcess = 18;
        static final int TRANSACTION_cancelDiscovery = 13;
        static final int TRANSACTION_cancelPairingUserInput = 32;
        static final int TRANSACTION_connectHeadset = 38;
        static final int TRANSACTION_createBond = 16;
        static final int TRANSACTION_createBondOutOfBand = 17;
        static final int TRANSACTION_disable = 4;
        static final int TRANSACTION_disconnectHeadset = 39;
        static final int TRANSACTION_enable = 3;
        static final int TRANSACTION_fetchRemoteUuids = 26;
        static final int TRANSACTION_getAddress = 5;
        static final int TRANSACTION_getBluetoothState = 2;
        static final int TRANSACTION_getBondState = 21;
        static final int TRANSACTION_getDiscoverableTimeout = 10;
        static final int TRANSACTION_getName = 6;
        static final int TRANSACTION_getRemoteClass = 24;
        static final int TRANSACTION_getRemoteName = 23;
        static final int TRANSACTION_getRemoteServiceChannel = 27;
        static final int TRANSACTION_getRemoteUuids = 25;
        static final int TRANSACTION_getScanMode = 8;
        static final int TRANSACTION_getTrustState = 34;
        static final int TRANSACTION_isBluetoothDock = 35;
        static final int TRANSACTION_isDiscovering = 14;
        static final int TRANSACTION_isEnabled = 1;
        static final int TRANSACTION_listBonds = 20;
        static final int TRANSACTION_notifyIncomingConnection = 40;
        static final int TRANSACTION_readOutOfBandData = 15;
        static final int TRANSACTION_removeBond = 19;
        static final int TRANSACTION_removeServiceRecord = 37;
        static final int TRANSACTION_setDeviceOutOfBandData = 22;
        static final int TRANSACTION_setDiscoverableTimeout = 11;
        static final int TRANSACTION_setName = 7;
        static final int TRANSACTION_setPairingConfirmation = 30;
        static final int TRANSACTION_setPasskey = 29;
        static final int TRANSACTION_setPin = 28;
        static final int TRANSACTION_setRemoteOutOfBandData = 31;
        static final int TRANSACTION_setScanMode = 9;
        static final int TRANSACTION_setTrust = 33;
        static final int TRANSACTION_startDiscovery = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IBluetooth asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBluetooth) {
                IBluetooth iBluetooth = (IBluetooth)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isEnabled();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = this.getBluetoothState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.enable();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    void var11_12;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var11_11 = null;
                    } else {
                        Object var11_13 = null;
                    }
                    boolean bl = this.disable((boolean)var11_12);
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getAddress();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.getName();
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    boolean bl = this.setName(string4);
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.getScanMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = parcel.readInt();
                    int n10 = parcel.readInt();
                    boolean bl = this.setScanMode(n9, n10);
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getDiscoverableTimeout();
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = parcel.readInt();
                    boolean bl = this.setDiscoverableTimeout(n13);
                    parcel2.writeNoException();
                    int n14 = bl ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.startDiscovery();
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    parcel2.writeInt(n15);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.cancelDiscovery();
                    parcel2.writeNoException();
                    int n16 = bl ? 1 : 0;
                    parcel2.writeInt(n16);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isDiscovering();
                    parcel2.writeNoException();
                    int n17 = bl ? 1 : 0;
                    parcel2.writeInt(n17);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = this.readOutOfBandData();
                    parcel2.writeNoException();
                    parcel2.writeByteArray(byArray);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    boolean bl = this.createBond(string5);
                    parcel2.writeNoException();
                    int n18 = bl ? 1 : 0;
                    parcel2.writeInt(n18);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    byte[] byArray = parcel.createByteArray();
                    byte[] byArray2 = parcel.createByteArray();
                    boolean bl = this.createBondOutOfBand(string6, byArray, byArray2);
                    parcel2.writeNoException();
                    int n19 = bl ? 1 : 0;
                    parcel2.writeInt(n19);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = parcel.readString();
                    boolean bl = this.cancelBondProcess(string7);
                    parcel2.writeNoException();
                    int n20 = bl ? 1 : 0;
                    parcel2.writeInt(n20);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    boolean bl = this.removeBond(string8);
                    parcel2.writeNoException();
                    int n21 = bl ? 1 : 0;
                    parcel2.writeInt(n21);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.listBonds();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = parcel.readString();
                    int n22 = this.getBondState(string9);
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = parcel.readString();
                    byte[] byArray = parcel.createByteArray();
                    byte[] byArray3 = parcel.createByteArray();
                    boolean bl = this.setDeviceOutOfBandData(string10, byArray, byArray3);
                    parcel2.writeNoException();
                    int n23 = bl ? 1 : 0;
                    parcel2.writeInt(n23);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string11 = parcel.readString();
                    String string12 = this.getRemoteName(string11);
                    parcel2.writeNoException();
                    parcel2.writeString(string12);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string13 = parcel.readString();
                    int n24 = this.getRemoteClass(string13);
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string14 = parcel.readString();
                    Parcelable[] parcelableArray = this.getRemoteUuids(string14);
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 26: {
                    void var63_71;
                    parcel.enforceInterface(DESCRIPTOR);
                    String string15 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        ParcelUuid parcelUuid = ParcelUuid.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var63_72 = null;
                    }
                    IBluetoothCallback iBluetoothCallback = IBluetoothCallback.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.fetchRemoteUuids(string15, (ParcelUuid)var63_71, iBluetoothCallback);
                    parcel2.writeNoException();
                    int n25 = bl ? 1 : 0;
                    parcel2.writeInt(n25);
                    return true;
                }
                case 27: {
                    void var63_74;
                    parcel.enforceInterface(DESCRIPTOR);
                    String string16 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        ParcelUuid parcelUuid = ParcelUuid.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var63_75 = null;
                    }
                    int n26 = this.getRemoteServiceChannel(string16, (ParcelUuid)var63_74);
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string17 = parcel.readString();
                    byte[] byArray = parcel.createByteArray();
                    boolean bl = this.setPin(string17, byArray);
                    parcel2.writeNoException();
                    int n27 = bl ? 1 : 0;
                    parcel2.writeInt(n27);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string18 = parcel.readString();
                    int n28 = parcel.readInt();
                    boolean bl = this.setPasskey(string18, n28);
                    parcel2.writeNoException();
                    int n29 = bl ? 1 : 0;
                    parcel2.writeInt(n29);
                    return true;
                }
                case 30: {
                    void var63_77;
                    parcel.enforceInterface(DESCRIPTOR);
                    String string19 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Object var63_76 = null;
                    } else {
                        Object var63_78 = null;
                    }
                    boolean bl = this.setPairingConfirmation(string19, (boolean)var63_77);
                    parcel2.writeNoException();
                    int n30 = bl ? 1 : 0;
                    parcel2.writeInt(n30);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string20 = parcel.readString();
                    boolean bl = this.setRemoteOutOfBandData(string20);
                    parcel2.writeNoException();
                    int n31 = bl ? 1 : 0;
                    parcel2.writeInt(n31);
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string21 = parcel.readString();
                    boolean bl = this.cancelPairingUserInput(string21);
                    parcel2.writeNoException();
                    int n32 = bl ? 1 : 0;
                    parcel2.writeInt(n32);
                    return true;
                }
                case 33: {
                    void var63_80;
                    parcel.enforceInterface(DESCRIPTOR);
                    String string22 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Object var63_79 = null;
                    } else {
                        Object var63_81 = null;
                    }
                    boolean bl = this.setTrust(string22, (boolean)var63_80);
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    parcel2.writeInt(n33);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string23 = parcel.readString();
                    boolean bl = this.getTrustState(string23);
                    parcel2.writeNoException();
                    int n34 = bl ? 1 : 0;
                    parcel2.writeInt(n34);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string24 = parcel.readString();
                    boolean bl = this.isBluetoothDock(string24);
                    parcel2.writeNoException();
                    int n35 = bl ? 1 : 0;
                    parcel2.writeInt(n35);
                    return true;
                }
                case 36: {
                    void var63_83;
                    parcel.enforceInterface(DESCRIPTOR);
                    String string25 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        ParcelUuid parcelUuid = ParcelUuid.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var63_84 = null;
                    }
                    int n36 = parcel.readInt();
                    IBinder iBinder = parcel.readStrongBinder();
                    int n37 = this.addRfcommServiceRecord(string25, (ParcelUuid)var63_83, n36, iBinder);
                    parcel2.writeNoException();
                    parcel2.writeInt(n37);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n38 = parcel.readInt();
                    this.removeServiceRecord(n38);
                    parcel2.writeNoException();
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string26 = parcel.readString();
                    boolean bl = this.connectHeadset(string26);
                    parcel2.writeNoException();
                    int n39 = bl ? 1 : 0;
                    parcel2.writeInt(n39);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string27 = parcel.readString();
                    boolean bl = this.disconnectHeadset(string27);
                    parcel2.writeNoException();
                    int n40 = bl ? 1 : 0;
                    parcel2.writeInt(n40);
                    return true;
                }
                case 40: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            String string28 = parcel.readString();
            boolean bl = this.notifyIncomingConnection(string28);
            parcel2.writeNoException();
            int n41 = bl ? 1 : 0;
            parcel2.writeInt(n41);
            return true;
        }

        private static class Proxy
        implements IBluetooth {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addRfcommServiceRecord(String string2, ParcelUuid parcelUuid, int n, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        int n3 = 0;
                        parcel.writeInt(n3);
                    }
                    parcel.writeInt(n);
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = n2 = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean cancelBondProcess(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean cancelDiscovery() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean cancelPairingUserInput(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean connectHeadset(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean createBond(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean createBondOutOfBand(String string2, byte[] byArray, byte[] byArray2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeByteArray(byArray);
                    parcel.writeByteArray(byArray2);
                    boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean disable(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl3 = n2 != 0;
                    return bl3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean disconnectHeadset(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean enable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean fetchRemoteUuids(String string2, ParcelUuid parcelUuid, IBluetoothCallback iBluetoothCallback) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iBluetoothCallback != null ? iBluetoothCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl2 = this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            @Override
            public String getAddress() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = string2 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getBluetoothState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getBondState(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getDiscoverableTimeout() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getName() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string2;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = string2 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getRemoteClass(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String getRemoteName(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String string3;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    String string4 = string3 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getRemoteServiceChannel(String string2, ParcelUuid parcelUuid) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    boolean bl = this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public ParcelUuid[] getRemoteUuids(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<ParcelUuid> creator = ParcelUuid.CREATOR;
                    ParcelUuid[] parcelUuidArray = parcel2.createTypedArray(creator);
                    return parcelUuidArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getScanMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean getTrustState(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isBluetoothDock(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isDiscovering() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] listBonds() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    String[] stringArray;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = stringArray = parcel2.createStringArray();
                    parcel2.recycle();
                    parcel.recycle();
                    return stringArray2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean notifyIncomingConnection(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public byte[] readOutOfBandData() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    byte[] byArray;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    byte[] byArray2 = byArray = parcel2.createByteArray();
                    parcel2.recycle();
                    parcel.recycle();
                    return byArray2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean removeBond(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeServiceRecord(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setDeviceOutOfBandData(String string2, byte[] byArray, byte[] byArray2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeByteArray(byArray);
                    parcel.writeByteArray(byArray2);
                    boolean bl = this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setDiscoverableTimeout(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl2 = n2 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setName(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPairingConfirmation(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl3 = n2 != 0;
                    return bl3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPasskey(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl2 = n2 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPin(String string2, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeByteArray(byArray);
                    boolean bl = this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setRemoteOutOfBandData(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setScanMode(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl2 = n3 != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setTrust(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl3 = n2 != 0;
                    return bl3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean startDiscovery() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

