/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;

public class ScoSocket {
    private static final boolean DBG = true;
    public static final int STATE_ACCEPT = 2;
    public static final int STATE_CLOSED = 5;
    public static final int STATE_CONNECTED = 4;
    public static final int STATE_CONNECTING = 3;
    public static final int STATE_READY = 1;
    private static final String TAG = "ScoSocket";
    private static final boolean VDBG;
    private int mAcceptedCode;
    private int mClosedCode;
    private int mConnectedCode;
    private Handler mHandler;
    private int mNativeData;
    private int mState;
    private PowerManager.WakeLock mWakeLock;

    static {
        ScoSocket.classInitNative();
    }

    public ScoSocket(PowerManager powerManager, Handler handler, int n, int n2, int n3) {
        PowerManager.WakeLock wakeLock;
        this.initNative();
        this.mState = 1;
        this.mHandler = handler;
        this.mAcceptedCode = n;
        this.mConnectedCode = n2;
        this.mClosedCode = n3;
        this.mWakeLock = wakeLock = powerManager.newWakeLock(1, TAG);
        this.mWakeLock.setReferenceCounted(false);
    }

    private native boolean acceptNative();

    private void acquireWakeLock() {
        if (this.mWakeLock.isHeld()) {
            return;
        }
        this.mWakeLock.acquire();
    }

    private static native void classInitNative();

    private native void closeNative();

    private native boolean connectNative(String var1, String var2);

    private native void destroyNative();

    private native void initNative();

    private void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onAccepted(int n) {
        synchronized (this) {
            if (this.mState != 2) {
                String string2 = "Strange state " + this;
                this.log(string2);
            } else {
                int n2;
                int n3;
                this.mState = n >= 0 ? (n3 = 4) : (n2 = 5);
                Handler handler = this.mHandler;
                int n4 = this.mAcceptedCode;
                int n5 = this.mState;
                handler.obtainMessage(n4, n5, -1, this).sendToTarget();
            }
            return;
        }
    }

    private void onClosed() {
        synchronized (this) {
            String string2 = "onClosed() " + this;
            this.log(string2);
            if (this.mState != 5) {
                this.mState = 5;
                Handler handler = this.mHandler;
                int n = this.mClosedCode;
                int n2 = this.mState;
                handler.obtainMessage(n, n2, -1, this).sendToTarget();
                this.releaseWakeLock();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onConnected(int n) {
        synchronized (this) {
            if (this.mState != 3) {
                StringBuilder stringBuilder = new StringBuilder().append("Strange state, closing ");
                int n2 = this.mState;
                String string2 = stringBuilder.append(n2).append(" ").append(this).toString();
                this.log(string2);
            } else {
                int n3;
                int n4;
                this.mState = n >= 0 ? (n4 = 4) : (n3 = 5);
                Handler handler = this.mHandler;
                int n5 = this.mConnectedCode;
                int n6 = this.mState;
                handler.obtainMessage(n5, n6, -1, this).sendToTarget();
                this.releaseWakeLockNow();
            }
            return;
        }
    }

    private void releaseWakeLock() {
        if (!this.mWakeLock.isHeld()) {
            return;
        }
        this.mWakeLock.acquire(2000L);
    }

    private void releaseWakeLockNow() {
        if (!this.mWakeLock.isHeld()) {
            return;
        }
        this.mWakeLock.release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept() {
        synchronized (this) {
            block5: {
                if (this.mState == 1) break block5;
                this.log("Bad state");
                return false;
            }
            if (this.acceptNative()) {
                this.mState = 2;
                return true;
            }
            this.mState = 5;
            return false;
        }
    }

    public void close() {
        synchronized (this) {
            StringBuilder stringBuilder = new StringBuilder().append(this).append(" SCO OBJECT close() mState = ");
            int n = this.mState;
            String string2 = stringBuilder.append(n).toString();
            this.log(string2);
            this.acquireWakeLock();
            this.mState = 5;
            this.closeNative();
            this.releaseWakeLock();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(String string2, String string3) {
        synchronized (this) {
            block5: {
                String string4 = "connect() " + this;
                this.log(string4);
                if (this.mState == 1) break block5;
                this.log("connect(): Bad state");
                return false;
            }
            this.acquireWakeLock();
            if (this.connectNative(string2, string3)) {
                this.mState = 3;
                return true;
            }
            this.mState = 5;
            this.releaseWakeLockNow();
            return false;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroyNative();
            this.releaseWakeLockNow();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getState() {
        synchronized (this) {
            int n = this.mState;
            return n;
        }
    }
}

