/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public abstract class AsyncQueryHandler
extends Handler {
    private static final int EVENT_ARG_DELETE = 4;
    private static final int EVENT_ARG_INSERT = 2;
    private static final int EVENT_ARG_QUERY = 1;
    private static final int EVENT_ARG_UPDATE = 3;
    private static final String TAG = "AsyncQuery";
    private static final boolean localLOGV;
    private static Looper sLooper;
    final WeakReference<ContentResolver> mResolver;
    private Handler mWorkerThreadHandler;

    static {
        sLooper = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncQueryHandler(ContentResolver contentResolver) {
        Handler handler;
        WeakReference<ContentResolver> weakReference = new WeakReference<ContentResolver>(contentResolver);
        this.mResolver = weakReference;
        synchronized (AsyncQueryHandler.class) {
            if (sLooper == null) {
                HandlerThread handlerThread = new HandlerThread("AsyncQueryWorker");
                handlerThread.start();
                sLooper = handlerThread.getLooper();
            }
        }
        Looper looper = sLooper;
        this.mWorkerThreadHandler = handler = this.createHandler(looper);
    }

    public final void cancelOperation(int n) {
        this.mWorkerThreadHandler.removeMessages(n);
    }

    protected Handler createHandler(Looper looper) {
        return new WorkerHandler(looper);
    }

    @Override
    public void handleMessage(Message message) {
        WorkerArgs workerArgs = (WorkerArgs)message.obj;
        int n = message.what;
        switch (message.arg1) {
            default: {
                return;
            }
            case 1: {
                Object object = workerArgs.cookie;
                Cursor cursor = (Cursor)workerArgs.result;
                this.onQueryComplete(n, object, cursor);
                return;
            }
            case 2: {
                Object object = workerArgs.cookie;
                Uri uri = (Uri)workerArgs.result;
                this.onInsertComplete(n, object, uri);
                return;
            }
            case 3: {
                Object object = workerArgs.cookie;
                int n2 = (Integer)workerArgs.result;
                this.onUpdateComplete(n, object, n2);
                return;
            }
            case 4: 
        }
        Object object = workerArgs.cookie;
        int n3 = (Integer)workerArgs.result;
        this.onDeleteComplete(n, object, n3);
    }

    protected void onDeleteComplete(int n, Object object, int n2) {
    }

    protected void onInsertComplete(int n, Object object, Uri uri) {
    }

    protected void onQueryComplete(int n, Object object, Cursor cursor) {
    }

    protected void onUpdateComplete(int n, Object object, int n2) {
    }

    public final void startDelete(int n, Object object, Uri uri, String string2, String[] stringArray) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 4;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray;
        message.obj = workerArgs;
        boolean bl = this.mWorkerThreadHandler.sendMessage(message);
    }

    public final void startInsert(int n, Object object, Uri uri, ContentValues contentValues) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 2;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.values = contentValues;
        message.obj = workerArgs;
        boolean bl = this.mWorkerThreadHandler.sendMessage(message);
    }

    public void startQuery(int n, Object object, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 1;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.projection = stringArray;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray2;
        workerArgs.orderBy = string3;
        workerArgs.cookie = object;
        message.obj = workerArgs;
        boolean bl = this.mWorkerThreadHandler.sendMessage(message);
    }

    public final void startUpdate(int n, Object object, Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        Message message = this.mWorkerThreadHandler.obtainMessage(n);
        message.arg1 = 3;
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.handler = this;
        workerArgs.uri = uri;
        workerArgs.cookie = object;
        workerArgs.values = contentValues;
        workerArgs.selection = string2;
        workerArgs.selectionArgs = stringArray;
        message.obj = workerArgs;
        boolean bl = this.mWorkerThreadHandler.sendMessage(message);
    }

    protected class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message var1_1) {
            var2_2 = (ContentResolver)AsyncQueryHandler.this.mResolver.get();
            if (var2_2 == null) {
                return;
            }
            var3_3 = (WorkerArgs)var1_1.obj;
            var4_4 = var1_1.what;
            switch (var1_1.arg1) lbl-1000:
            // 4 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var5_5 = var3_3.handler.obtainMessage(var4_4);
                        var5_5.obj = var3_3;
                        var5_5.arg1 = var6_6 = var1_1.arg1;
                        var5_5.sendToTarget();
                        return;
                    }
                }
                case 1: {
                    try {
                        var7_7 = var3_3.uri;
                        var8_8 = var3_3.projection;
                        var9_9 = var3_3.selection;
                        var10_10 = var3_3.selectionArgs;
                        var11_11 = var3_3.orderBy;
                        var12_12 = var2_2.query(var7_7, var8_8, var9_9, var10_10, var11_11);
                        if (var12_12 != null) {
                            var13_13 = var12_12.getCount();
                        }
lbl24:
                        // 4 sources

                        while (true) {
                            var3_3.result = var12_12;
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    catch (Exception v0) {
                        var14_14 = v0.toString();
                        var15_15 = Log.w("AsyncQuery", var14_14);
                        var12_12 = null;
                        ** continue;
                    }
                }
                case 2: {
                    var16_16 = var3_3.uri;
                    var17_17 = var3_3.values;
                    var18_18 = var2_2.insert(var16_16, var17_17);
                    var3_3.result = var18_18;
                    ** GOTO lbl-1000
                }
                case 3: {
                    var19_19 = var3_3.uri;
                    var20_20 = var3_3.values;
                    var21_21 = var3_3.selection;
                    var22_22 = var3_3.selectionArgs;
                    var23_23 = var2_2.update(var19_19, var20_20, var21_21, var22_22);
                    var3_3.result = var23_23;
                    ** GOTO lbl-1000
                }
                case 4: 
            }
            var24_24 = var3_3.uri;
            var25_25 = var3_3.selection;
            var26_26 = var3_3.selectionArgs;
            var27_27 = var2_2.delete(var24_24, var25_25, var26_26);
            var3_3.result = var27_27;
            ** while (true)
        }
    }

    protected static final class WorkerArgs {
        public Object cookie;
        public Handler handler;
        public String orderBy;
        public String[] projection;
        public Object result;
        public String selection;
        public String[] selectionArgs;
        public Uri uri;
        public ContentValues values;

        protected WorkerArgs() {
        }
    }
}

