/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public abstract class BroadcastReceiver {
    private boolean mAbortBroadcast;
    private boolean mDebugUnregister;
    private boolean mInitialStickyHint;
    private boolean mOrderedHint;
    private int mResultCode;
    private String mResultData;
    private Bundle mResultExtras;

    public final void abortBroadcast() {
        this.checkSynchronousHint();
        this.mAbortBroadcast = true;
    }

    void checkSynchronousHint() {
        if (this.mOrderedHint) {
            return;
        }
        if (this.mInitialStickyHint) {
            return;
        }
        RuntimeException runtimeException = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        Throwable throwable = runtimeException.fillInStackTrace();
        String string2 = runtimeException.getMessage();
        int n = Log.e("BroadcastReceiver", string2, runtimeException);
    }

    public final void clearAbortBroadcast() {
        this.mAbortBroadcast = false;
    }

    public final boolean getAbortBroadcast() {
        return this.mAbortBroadcast;
    }

    public final boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    public final int getResultCode() {
        return this.mResultCode;
    }

    public final String getResultData() {
        return this.mResultData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Bundle getResultExtras(boolean bl) {
        Bundle bundle = this.mResultExtras;
        if (!bl) {
            return bundle;
        }
        if (bundle != null) return bundle;
        this.mResultExtras = bundle = new Bundle();
        return bundle;
    }

    public final boolean isInitialStickyBroadcast() {
        return this.mInitialStickyHint;
    }

    public final boolean isOrderedBroadcast() {
        return this.mOrderedHint;
    }

    public abstract void onReceive(Context var1, Intent var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBinder peekService(Context context, Intent intent) {
        IActivityManager iActivityManager = ActivityManagerNative.getDefault();
        IBinder iBinder = null;
        try {
            ContentResolver contentResolver = context.getContentResolver();
            String string2 = intent.resolveTypeIfNeeded(contentResolver);
            IBinder iBinder2 = iActivityManager.peekService(intent, string2);
            return iBinder2;
        }
        catch (RemoteException remoteException) {
            return iBinder;
        }
    }

    public final void setDebugUnregister(boolean bl) {
        this.mDebugUnregister = bl;
    }

    public final void setInitialStickyHint(boolean bl) {
        this.mInitialStickyHint = bl;
    }

    public final void setOrderedHint(boolean bl) {
        this.mOrderedHint = bl;
    }

    public final void setResult(int n, String string2, Bundle bundle) {
        this.checkSynchronousHint();
        this.mResultCode = n;
        this.mResultData = string2;
        this.mResultExtras = bundle;
    }

    public final void setResultCode(int n) {
        this.checkSynchronousHint();
        this.mResultCode = n;
    }

    public final void setResultData(String string2) {
        this.checkSynchronousHint();
        this.mResultData = string2;
    }

    public final void setResultExtras(Bundle bundle) {
        this.checkSynchronousHint();
        this.mResultExtras = bundle;
    }
}

