/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ComponentCallbacks;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.CursorToBulkCursorAdaptor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public abstract class ContentProvider
implements ComponentCallbacks {
    private Context mContext = null;
    private boolean mExported;
    private int mMyUid;
    private PathPermission[] mPathPermissions;
    private String mReadPermission;
    private Transport mTransport;
    private String mWritePermission;

    public ContentProvider() {
        Transport transport;
        this.mTransport = transport = new Transport();
    }

    public ContentProvider(Context context, String string2, String string3, PathPermission[] pathPermissionArray) {
        Transport transport;
        this.mTransport = transport = new Transport();
        this.mContext = context;
        this.mReadPermission = string2;
        this.mWritePermission = string3;
        this.mPathPermissions = pathPermissionArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentProvider coerceToLocalContentProvider(IContentProvider iContentProvider) {
        if (!(iContentProvider instanceof Transport)) return null;
        return ((Transport)iContentProvider).getContentProvider();
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
        int n = arrayList.size();
        ContentProviderResult[] contentProviderResultArray = new ContentProviderResult[n];
        for (int i = 0; i < n; ++i) {
            ContentProviderResult contentProviderResult;
            contentProviderResultArray[i] = contentProviderResult = arrayList.get(i).apply(this, contentProviderResultArray, i);
        }
        return contentProviderResultArray;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        int n;
        if (this.mContext != null) {
            return;
        }
        this.mContext = context;
        this.mMyUid = n = Process.myUid();
        if (providerInfo != null) {
            boolean bl;
            String string2 = providerInfo.readPermission;
            this.setReadPermission(string2);
            String string3 = providerInfo.writePermission;
            this.setWritePermission(string3);
            PathPermission[] pathPermissionArray = providerInfo.pathPermissions;
            this.setPathPermissions(pathPermissionArray);
            this.mExported = bl = providerInfo.exported;
        }
        boolean bl = this.onCreate();
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        int n = contentValuesArray.length;
        for (int i = 0; i < n; ++i) {
            ContentValues contentValues = contentValuesArray[i];
            Uri uri2 = this.insert(uri, contentValues);
        }
        return n;
    }

    public Bundle call(String string2, String string3, Bundle bundle) {
        return null;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public final Context getContext() {
        return this.mContext;
    }

    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    public final PathPermission[] getPathPermissions() {
        return this.mPathPermissions;
    }

    public final String getReadPermission() {
        return this.mReadPermission;
    }

    public abstract String getType(Uri var1);

    public final String getWritePermission() {
        return this.mWritePermission;
    }

    public abstract Uri insert(Uri var1, ContentValues var2);

    protected boolean isTemporary() {
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    public abstract boolean onCreate();

    @Override
    public void onLowMemory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        ParcelFileDescriptor parcelFileDescriptor = this.openFile(uri, string2);
        if (parcelFileDescriptor == null) return null;
        return new AssetFileDescriptor(parcelFileDescriptor, 0L, 65535L);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        String string3 = "No files supported by provider at " + uri;
        throw new FileNotFoundException(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final ParcelFileDescriptor openFileHelper(Uri uri, String string2) throws FileNotFoundException {
        ContentProvider contentProvider = this;
        Uri uri2 = uri;
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = contentProvider.query(uri2, stringArray, null, null, null);
        int n = cursor != null ? cursor.getCount() : 0;
        if (n != 1) {
            if (cursor != null) {
                cursor.close();
            }
            if (n == 0) {
                String string3 = "No entry for " + uri;
                throw new FileNotFoundException(string3);
            }
            String string4 = "Multiple items at " + uri;
            throw new FileNotFoundException(string4);
        }
        boolean bl = cursor.moveToFirst();
        int n2 = cursor.getColumnIndex("_data");
        String string5 = n2 >= 0 ? cursor.getString(n2) : null;
        cursor.close();
        if (string5 == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int n3 = ContentResolver.modeToMode(uri, string2);
        return ParcelFileDescriptor.open(new File(string5), n3);
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    protected final void setPathPermissions(PathPermission[] pathPermissionArray) {
        this.mPathPermissions = pathPermissionArray;
    }

    protected final void setReadPermission(String string2) {
        this.mReadPermission = string2;
    }

    protected final void setWritePermission(String string2) {
        this.mWritePermission = string2;
    }

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    class Transport
    extends ContentProviderNative {
        Transport() {
        }

        private void enforceReadPermission(Uri uri) {
            PathPermission[] pathPermissionArray;
            int n;
            int n2 = Binder.getCallingUid();
            if (n2 != (n = ContentProvider.this.mMyUid)) {
                return;
            }
            Context context = ContentProvider.this.getContext();
            String string2 = ContentProvider.this.getReadPermission();
            int n3 = Binder.getCallingPid();
            if (ContentProvider.this.mExported) {
                if (string2 == null) {
                    return;
                }
                if (context.checkPermission(string2, n3, n2) == 0) {
                    return;
                }
            }
            if ((pathPermissionArray = ContentProvider.this.getPathPermissions()) != null) {
                String string3 = uri.getPath();
                int n4 = pathPermissionArray.length;
                while (n4 > 0) {
                    PathPermission pathPermission = pathPermissionArray[n4 += -1];
                    String string4 = pathPermission.getReadPermission();
                    if (string4 == null || !pathPermission.match(string3) || context.checkPermission(string4, n3, n2) != 0) continue;
                    return;
                }
            }
            if (context.checkUriPermission(uri, n3, n2, 1) == 0) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: reading ");
            String string5 = ContentProvider.this.getClass().getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string5).append(" uri ").append(uri).append(" from pid=");
            int n5 = Binder.getCallingPid();
            StringBuilder stringBuilder3 = stringBuilder2.append(n5).append(", uid=");
            int n6 = Binder.getCallingUid();
            String string6 = stringBuilder3.append(n6).append(" requires ").append(string2).toString();
            throw new SecurityException(string6);
        }

        private void enforceWritePermission(Uri uri) {
            if (this.hasWritePermission(uri)) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: writing ");
            String string2 = ContentProvider.this.getClass().getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" uri ").append(uri).append(" from pid=");
            int n = Binder.getCallingPid();
            StringBuilder stringBuilder3 = stringBuilder2.append(n).append(", uid=");
            int n2 = Binder.getCallingUid();
            StringBuilder stringBuilder4 = stringBuilder3.append(n2).append(" requires ");
            String string3 = ContentProvider.this.getWritePermission();
            String string4 = stringBuilder4.append(string3).toString();
            throw new SecurityException(string4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasWritePermission(Uri uri) {
            PathPermission[] pathPermissionArray;
            int n;
            int n2 = Binder.getCallingUid();
            if (n2 != (n = ContentProvider.this.mMyUid)) {
                return true;
            }
            Context context = ContentProvider.this.getContext();
            String string2 = ContentProvider.this.getWritePermission();
            int n3 = Binder.getCallingPid();
            if (ContentProvider.this.mExported) {
                if (string2 == null) return true;
                if (context.checkPermission(string2, n3, n2) == 0) {
                    return true;
                }
            }
            if ((pathPermissionArray = ContentProvider.this.getPathPermissions()) != null) {
                String string3 = uri.getPath();
                int n4 = pathPermissionArray.length;
                while (n4 > 0) {
                    PathPermission pathPermission = pathPermissionArray[n4 += -1];
                    String string4 = pathPermission.getWritePermission();
                    if (string4 == null || !pathPermission.match(string3) || context.checkPermission(string4, n3, n2) != 0) continue;
                    return true;
                }
            }
            if (context.checkUriPermission(uri, n3, n2, 2) != 0) return false;
            return true;
        }

        @Override
        public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
            for (ContentProviderOperation contentProviderOperation : arrayList) {
                if (contentProviderOperation.isReadOperation()) {
                    Uri uri = contentProviderOperation.getUri();
                    this.enforceReadPermission(uri);
                }
                if (!contentProviderOperation.isWriteOperation()) continue;
                Uri uri = contentProviderOperation.getUri();
                this.enforceWritePermission(uri);
            }
            return ContentProvider.this.applyBatch(arrayList);
        }

        @Override
        public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.bulkInsert(uri, contentValuesArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IBulkCursor bulkQuery(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, IContentObserver iContentObserver, CursorWindow cursorWindow) {
            this.enforceReadPermission(uri);
            ContentProvider contentProvider = ContentProvider.this;
            Uri uri2 = uri;
            String[] stringArray3 = stringArray;
            String string4 = string2;
            String[] stringArray4 = stringArray2;
            String string5 = string3;
            Cursor cursor = contentProvider.query(uri2, stringArray3, string4, stringArray4, string5);
            if (cursor == null) {
                return null;
            }
            String string6 = ContentProvider.this.getClass().getName();
            boolean bl = this.hasWritePermission(uri);
            IContentObserver iContentObserver2 = iContentObserver;
            CursorWindow cursorWindow2 = cursorWindow;
            return new CursorToBulkCursorAdaptor(cursor, iContentObserver2, string6, bl, cursorWindow2);
        }

        @Override
        public Bundle call(String string2, String string3, Bundle bundle) {
            return ContentProvider.this.call(string2, string3, bundle);
        }

        @Override
        public int delete(Uri uri, String string2, String[] stringArray) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.delete(uri, string2, stringArray);
        }

        ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        @Override
        public String getType(Uri uri) {
            return ContentProvider.this.getType(uri);
        }

        @Override
        public Uri insert(Uri uri, ContentValues contentValues) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.insert(uri, contentValues);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
            if (string2 != null && string2.startsWith("rw")) {
                this.enforceWritePermission(uri);
                return ContentProvider.this.openAssetFile(uri, string2);
            }
            this.enforceReadPermission(uri);
            return ContentProvider.this.openAssetFile(uri, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
            if (string2 != null && string2.startsWith("rw")) {
                this.enforceWritePermission(uri);
                return ContentProvider.this.openFile(uri, string2);
            }
            this.enforceReadPermission(uri);
            return ContentProvider.this.openFile(uri, string2);
        }

        @Override
        public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
            this.enforceReadPermission(uri);
            ContentProvider contentProvider = ContentProvider.this;
            Uri uri2 = uri;
            String[] stringArray3 = stringArray;
            String string4 = string2;
            String[] stringArray4 = stringArray2;
            String string5 = string3;
            return contentProvider.query(uri2, stringArray3, string4, stringArray4, string5);
        }

        @Override
        public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.update(uri, contentValues, string2, stringArray);
        }
    }
}

