/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProviderOperation;
import android.content.ContentProviderProxy;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.res.AssetFileDescriptor;
import android.database.BulkCursorToCursorAdaptor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;

public abstract class ContentProviderNative
extends Binder
implements IContentProvider {
    private static final String TAG = "ContentProvider";

    public ContentProviderNative() {
        this.attachInterface(this, "android.content.IContentProvider");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IContentProvider asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IContentProvider iContentProvider = (IContentProvider)iBinder.queryLocalInterface("android.content.IContentProvider");
        if (iContentProvider == null) return new ContentProviderProxy(iBinder);
        return iContentProvider;
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        switch (n) {
            default: {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            case 1: {
                int n3;
                Parcel parcel3 = parcel;
                String string2 = "android.content.IContentProvider";
                parcel3.enforceInterface(string2);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel4 = parcel;
                Uri uri = creator.createFromParcel(parcel4);
                int n4 = parcel.readInt();
                String[] stringArray = null;
                if (n4 > 0) {
                    int n5;
                    int n6;
                    stringArray = new String[n4];
                    n3 = 0;
                    while ((n6 = ++n3) < (n5 = n4)) {
                        String string3;
                        stringArray[n3] = string3 = parcel.readString();
                    }
                }
                String string4 = parcel.readString();
                n4 = parcel.readInt();
                String[] stringArray2 = null;
                if (n4 > 0) {
                    int n7;
                    int n8;
                    stringArray2 = new String[n4];
                    n3 = 0;
                    while ((n8 = ++n3) < (n7 = n4)) {
                        String string5;
                        stringArray2[n3] = string5 = parcel.readString();
                    }
                }
                String string6 = parcel.readString();
                IContentObserver iContentObserver = IContentObserver.Stub.asInterface(parcel.readStrongBinder());
                Parcelable.Creator<CursorWindow> creator2 = CursorWindow.CREATOR;
                Parcel parcel5 = parcel;
                CursorWindow cursorWindow = creator2.createFromParcel(parcel5);
                boolean bl = parcel.readInt() != 0;
                IBulkCursor iBulkCursor = this.bulkQuery(uri, stringArray, string4, stringArray2, string6, iContentObserver, cursorWindow);
                parcel2.writeNoException();
                if (iBulkCursor != null) {
                    IBinder iBinder = iBulkCursor.asBinder();
                    Parcel parcel6 = parcel2;
                    IBinder iBinder2 = iBinder;
                    parcel6.writeStrongBinder(iBinder2);
                    if (!bl) return true;
                    int n9 = iBulkCursor.count();
                    Parcel parcel7 = parcel2;
                    int n10 = n9;
                    parcel7.writeInt(n10);
                    int n11 = BulkCursorToCursorAdaptor.findRowIdColumnIndex(iBulkCursor.getColumnNames());
                    Parcel parcel8 = parcel2;
                    int n12 = n11;
                    parcel8.writeInt(n12);
                    return true;
                } else {
                    Parcel parcel9 = parcel2;
                    IBinder iBinder = null;
                    parcel9.writeStrongBinder(iBinder);
                }
                return true;
            }
            case 2: {
                try {
                    Parcel parcel10 = parcel;
                    String string7 = "android.content.IContentProvider";
                    parcel10.enforceInterface(string7);
                    Parcelable.Creator<Uri> creator = Uri.CREATOR;
                    Parcel parcel11 = parcel;
                    Uri uri = creator.createFromParcel(parcel11);
                    ContentProviderNative contentProviderNative = this;
                    Uri uri2 = uri;
                    String string8 = contentProviderNative.getType(uri2);
                    parcel2.writeNoException();
                    Parcel parcel12 = parcel2;
                    String string9 = string8;
                    parcel12.writeString(string9);
                    return true;
                }
                catch (Exception exception) {
                    Parcel parcel13 = parcel2;
                    Exception exception2 = exception;
                    DatabaseUtils.writeExceptionToParcel(parcel13, exception2);
                    return true;
                }
            }
            case 3: {
                Parcel parcel14 = parcel;
                String string10 = "android.content.IContentProvider";
                parcel14.enforceInterface(string10);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel15 = parcel;
                Uri uri = creator.createFromParcel(parcel15);
                Parcelable.Creator<ContentValues> creator3 = ContentValues.CREATOR;
                Parcel parcel16 = parcel;
                ContentValues contentValues = creator3.createFromParcel(parcel16);
                ContentProviderNative contentProviderNative = this;
                Uri uri3 = uri;
                ContentValues contentValues2 = contentValues;
                Uri uri4 = contentProviderNative.insert(uri3, contentValues2);
                parcel2.writeNoException();
                Parcel parcel17 = parcel2;
                Uri uri5 = uri4;
                Uri.writeToParcel(parcel17, uri5);
                return true;
            }
            case 13: {
                Parcel parcel18 = parcel;
                String string11 = "android.content.IContentProvider";
                parcel18.enforceInterface(string11);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel19 = parcel;
                Uri uri = creator.createFromParcel(parcel19);
                Parcelable.Creator<ContentValues> creator4 = ContentValues.CREATOR;
                Parcel parcel20 = parcel;
                Parcelable.Creator<ContentValues> creator5 = creator4;
                ContentValues[] contentValuesArray = parcel20.createTypedArray(creator5);
                ContentProviderNative contentProviderNative = this;
                Uri uri6 = uri;
                ContentValues[] contentValuesArray2 = contentValuesArray;
                int n13 = contentProviderNative.bulkInsert(uri6, contentValuesArray2);
                parcel2.writeNoException();
                Parcel parcel21 = parcel2;
                int n14 = n13;
                parcel21.writeInt(n14);
                return true;
            }
            case 20: {
                ArrayList<ContentProviderOperation> arrayList;
                Parcel parcel22 = parcel;
                String string12 = "android.content.IContentProvider";
                parcel22.enforceInterface(string12);
                int n15 = parcel.readInt();
                ArrayList<ContentProviderOperation> arrayList2 = arrayList;
                int n16 = n15;
                arrayList2(n16);
                int n17 = 0;
                while (true) {
                    int n18;
                    int n19;
                    if ((n19 = n17) >= (n18 = n15)) {
                        ContentProviderNative contentProviderNative = this;
                        ArrayList<ContentProviderOperation> arrayList3 = arrayList;
                        Parcelable[] parcelableArray = contentProviderNative.applyBatch(arrayList3);
                        parcel2.writeNoException();
                        Parcel parcel23 = parcel2;
                        Parcelable[] parcelableArray2 = parcelableArray;
                        int n20 = 0;
                        parcel23.writeTypedArray(parcelableArray2, n20);
                        return true;
                    }
                    Parcelable.Creator<ContentProviderOperation> creator = ContentProviderOperation.CREATOR;
                    Parcel parcel24 = parcel;
                    ContentProviderOperation contentProviderOperation = creator.createFromParcel(parcel24);
                    ArrayList<ContentProviderOperation> arrayList4 = arrayList;
                    int n21 = n17++;
                    ContentProviderOperation contentProviderOperation2 = contentProviderOperation;
                    arrayList4.add(n21, contentProviderOperation2);
                }
            }
            case 4: {
                Parcel parcel25 = parcel;
                String string13 = "android.content.IContentProvider";
                parcel25.enforceInterface(string13);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel26 = parcel;
                Uri uri = creator.createFromParcel(parcel26);
                String string14 = parcel.readString();
                String[] stringArray = parcel.readStringArray();
                ContentProviderNative contentProviderNative = this;
                Uri uri7 = uri;
                String string15 = string14;
                String[] stringArray3 = stringArray;
                int n22 = contentProviderNative.delete(uri7, string15, stringArray3);
                parcel2.writeNoException();
                Parcel parcel27 = parcel2;
                int n23 = n22;
                parcel27.writeInt(n23);
                return true;
            }
            case 10: {
                Parcel parcel28 = parcel;
                String string16 = "android.content.IContentProvider";
                parcel28.enforceInterface(string16);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel29 = parcel;
                Uri uri = creator.createFromParcel(parcel29);
                Parcelable.Creator<ContentValues> creator6 = ContentValues.CREATOR;
                Parcel parcel30 = parcel;
                ContentValues contentValues = creator6.createFromParcel(parcel30);
                String string17 = parcel.readString();
                String[] stringArray = parcel.readStringArray();
                ContentProviderNative contentProviderNative = this;
                Uri uri8 = uri;
                ContentValues contentValues3 = contentValues;
                String string18 = string17;
                String[] stringArray4 = stringArray;
                int n24 = contentProviderNative.update(uri8, contentValues3, string18, stringArray4);
                parcel2.writeNoException();
                Parcel parcel31 = parcel2;
                int n25 = n24;
                parcel31.writeInt(n25);
                return true;
            }
            case 14: {
                Parcel parcel32 = parcel;
                String string19 = "android.content.IContentProvider";
                parcel32.enforceInterface(string19);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel33 = parcel;
                Uri uri = creator.createFromParcel(parcel33);
                String string20 = parcel.readString();
                ContentProviderNative contentProviderNative = this;
                Uri uri9 = uri;
                String string21 = string20;
                ParcelFileDescriptor parcelFileDescriptor = contentProviderNative.openFile(uri9, string21);
                parcel2.writeNoException();
                if (parcelFileDescriptor != null) {
                    Parcel parcel34 = parcel2;
                    int n26 = 1;
                    parcel34.writeInt(n26);
                    ParcelFileDescriptor parcelFileDescriptor2 = parcelFileDescriptor;
                    Parcel parcel35 = parcel2;
                    int n27 = 1;
                    parcelFileDescriptor2.writeToParcel(parcel35, n27);
                    return true;
                } else {
                    Parcel parcel36 = parcel2;
                    int n28 = 0;
                    parcel36.writeInt(n28);
                }
                return true;
            }
            case 15: {
                Parcel parcel37 = parcel;
                String string22 = "android.content.IContentProvider";
                parcel37.enforceInterface(string22);
                Parcelable.Creator<Uri> creator = Uri.CREATOR;
                Parcel parcel38 = parcel;
                Uri uri = creator.createFromParcel(parcel38);
                String string23 = parcel.readString();
                ContentProviderNative contentProviderNative = this;
                Uri uri10 = uri;
                String string24 = string23;
                AssetFileDescriptor assetFileDescriptor = contentProviderNative.openAssetFile(uri10, string24);
                parcel2.writeNoException();
                if (assetFileDescriptor != null) {
                    Parcel parcel39 = parcel2;
                    int n29 = 1;
                    parcel39.writeInt(n29);
                    AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor;
                    Parcel parcel40 = parcel2;
                    int n30 = 1;
                    assetFileDescriptor2.writeToParcel(parcel40, n30);
                    return true;
                } else {
                    Parcel parcel41 = parcel2;
                    int n31 = 0;
                    parcel41.writeInt(n31);
                }
                return true;
            }
            case 21: 
        }
        Parcel parcel42 = parcel;
        String string25 = "android.content.IContentProvider";
        parcel42.enforceInterface(string25);
        String string26 = parcel.readString();
        String string27 = parcel.readString();
        Bundle bundle = parcel.readBundle();
        ContentProviderNative contentProviderNative = this;
        String string28 = string26;
        String string29 = string27;
        Bundle bundle2 = bundle;
        Bundle bundle3 = contentProviderNative.call(string28, string29, bundle2);
        parcel2.writeNoException();
        Parcel parcel43 = parcel2;
        Bundle bundle4 = bundle3;
        parcel43.writeBundle(bundle4);
        return true;
    }
}

