/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContentProviderOperation
implements Parcelable {
    public static final Parcelable.Creator<ContentProviderOperation> CREATOR = new Parcelable.Creator<ContentProviderOperation>(){

        @Override
        public ContentProviderOperation createFromParcel(Parcel parcel) {
            return new ContentProviderOperation(parcel);
        }

        public ContentProviderOperation[] newArray(int n) {
            return new ContentProviderOperation[n];
        }
    };
    private static final String TAG = "ContentProviderOperation";
    public static final int TYPE_ASSERT = 4;
    public static final int TYPE_DELETE = 3;
    public static final int TYPE_INSERT = 1;
    public static final int TYPE_UPDATE = 2;
    private final Integer mExpectedCount;
    private final String mSelection;
    private final String[] mSelectionArgs;
    private final Map<Integer, Integer> mSelectionArgsBackReferences;
    private final int mType;
    private final Uri mUri;
    private final ContentValues mValues;
    private final ContentValues mValuesBackReferences;
    private final boolean mYieldAllowed;

    private ContentProviderOperation(Builder builder) {
        boolean bl;
        ContentValues contentValues;
        Map map;
        Integer n;
        String string2;
        ContentValues contentValues2;
        Uri uri;
        int n2;
        this.mType = n2 = builder.mType;
        this.mUri = uri = builder.mUri;
        this.mValues = contentValues2 = builder.mValues;
        this.mSelection = string2 = builder.mSelection;
        String[] stringArray = builder.mSelectionArgs;
        this.mSelectionArgs = stringArray;
        this.mExpectedCount = n = builder.mExpectedCount;
        this.mSelectionArgsBackReferences = map = builder.mSelectionArgsBackReferences;
        this.mValuesBackReferences = contentValues = builder.mValuesBackReferences;
        this.mYieldAllowed = bl = builder.mYieldAllowed;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ContentProviderOperation(Parcel parcel) {
        Uri uri;
        int n;
        this.mType = n = parcel.readInt();
        this.mUri = uri = Uri.CREATOR.createFromParcel(parcel);
        ContentValues contentValues = parcel.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(parcel) : null;
        this.mValues = contentValues;
        String string2 = parcel.readInt() != 0 ? parcel.readString() : null;
        this.mSelection = string2;
        String[] stringArray = parcel.readInt() != 0 ? parcel.readStringArray() : null;
        this.mSelectionArgs = stringArray;
        Integer n2 = parcel.readInt() != 0 ? Integer.valueOf(parcel.readInt()) : null;
        this.mExpectedCount = n2;
        ContentValues contentValues2 = parcel.readInt() != 0 ? ContentValues.CREATOR.createFromParcel(parcel) : null;
        this.mValuesBackReferences = contentValues2;
        HashMap<Integer, Integer> hashMap = parcel.readInt() != 0 ? new HashMap<Integer, Integer>() : null;
        this.mSelectionArgsBackReferences = hashMap;
        if (this.mSelectionArgsBackReferences != null) {
            int n3 = parcel.readInt();
            for (int i = 0; i < n3; ++i) {
                Map<Integer, Integer> map = this.mSelectionArgsBackReferences;
                Integer n4 = parcel.readInt();
                Integer n5 = parcel.readInt();
                Integer n6 = map.put(n4, n5);
            }
        }
        boolean bl = parcel.readInt() != 0;
        this.mYieldAllowed = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long backRefToValue(ContentProviderResult[] contentProviderResultArray, int n, Integer n2) {
        if (n2 >= n) {
            String string2 = this.toString();
            int n3 = Log.e(TAG, string2);
            String string3 = "asked for back ref " + n2 + " but there are only " + n + " back refs";
            throw new ArrayIndexOutOfBoundsException(string3);
        }
        int n4 = n2;
        ContentProviderResult contentProviderResult = contentProviderResultArray[n4];
        if (contentProviderResult.uri == null) return contentProviderResult.count.intValue();
        return ContentUris.parseId(contentProviderResult.uri);
    }

    public static Builder newAssertQuery(Uri uri) {
        return new Builder(4, uri);
    }

    public static Builder newDelete(Uri uri) {
        return new Builder(3, uri);
    }

    public static Builder newInsert(Uri uri) {
        return new Builder(1, uri);
    }

    public static Builder newUpdate(Uri uri) {
        return new Builder(2, uri);
    }

    /*
     * Unable to fully structure code
     */
    public ContentProviderResult apply(ContentProvider var1_1, ContentProviderResult[] var2_2, int var3_3) throws OperationApplicationException {
        block14: {
            block16: {
                block11: {
                    block12: {
                        block15: {
                            block13: {
                                var4_4 = this;
                                var5_5 = var2_2;
                                var6_6 = var3_3;
                                var7_7 = var4_4.resolveValueBackReferences(var5_5, var6_6);
                                var8_8 = this;
                                var9_9 = var2_2;
                                var10_10 = var3_3;
                                var11_11 = var8_8.resolveSelectionArgsBackReferences(var9_9, var10_10);
                                if (this.mType == 1) {
                                    var13_13 = var1_1;
                                    var12_12 = this.mUri;
                                    var14_14 = var12_12;
                                    var15_15 = var7_7;
                                    var16_16 = var13_13.insert(var14_14, var15_15);
                                    if (var16_16 == null) {
                                        throw new OperationApplicationException("insert failed");
                                    }
                                    var18_18 = var17_17;
                                    var19_19 = var16_16;
                                    var18_18(var19_19);
lbl20:
                                    // 2 sources

                                    return var17_17;
                                }
                                if (this.mType != 3) break block13;
                                var20_20 = this.mUri;
                                var21_21 = this.mSelection;
                                var22_22 = var1_1;
                                var23_23 = var20_20;
                                var24_24 = var21_21;
                                var25_25 = var11_11;
                                var26_26 = var22_22.delete(var23_23, var24_24, var25_25);
lbl30:
                                // 3 sources

                                while (this.mExpectedCount != null && (var27_27 = this.mExpectedCount.intValue()) != (var28_28 = var26_26)) {
                                    var29_29 = this.toString();
                                    var30_30 = Log.e("ContentProviderOperation", var29_29);
                                    var31_31 = new StringBuilder().append("wrong number of rows: ");
                                    var32_32 = var26_26;
                                    var33_33 = var31_31.append(var32_32).toString();
                                    throw new OperationApplicationException(var33_33);
                                }
                                break block14;
                            }
                            if (this.mType != 2) break block15;
                            var34_34 = this.mUri;
                            var35_35 = this.mSelection;
                            var36_36 = var1_1;
                            var37_37 = var34_34;
                            var38_38 = var7_7;
                            var39_39 = var35_35;
                            var40_40 = var11_11;
                            var26_26 = var36_36.update(var37_37, var38_38, var39_39, var40_40);
                            ** GOTO lbl30
                        }
                        if (this.mType != 4) break block16;
                        var41_41 = null;
                        if (var7_7 != null) {
                            var42_42 = new ArrayList<String>();
                            var43_43 = var7_7.valueSet().iterator();
                            while (var43_43.hasNext()) {
                                var44_44 = var43_43.next().getKey();
                                var45_45 = var42_42;
                                var46_46 = var44_44;
                                var47_47 = var45_45.add(var46_46);
                            }
                            var48_48 = new String[var42_42.size()];
                            var49_49 = var42_42;
                            var50_50 = var48_48;
                            var41_41 = var49_49.toArray(var50_50);
                        }
                        var51_51 = this.mUri;
                        var52_52 = this.mSelection;
                        var53_53 = var1_1.query(var51_51, var41_41, var52_52, var11_11, null);
                        try {
                            var26_26 = var53_53.getCount();
                            if (var41_41 == null) break block11;
                            while (var53_53.moveToNext()) {
                                var54_54 = 0;
lbl73:
                                // 2 sources

                                while (var54_54 < (var55_55 = var41_41.length)) {
                                    var56_56 = var53_53.getString(var54_54);
                                    if (!TextUtils.equals(var56_56, var60_60 = (var58_58 = var7_7).getAsString(var59_59 = (var57_57 = var41_41[var54_54])))) {
                                        var61_61 = this.toString();
                                        var62_62 = Log.e("ContentProviderOperation", var61_61);
                                        var63_63 = new StringBuilder().append("Found value ").append(var56_56).append(" when expected ").append(var60_60).append(" for column ");
                                        var64_64 = var41_41[var54_54];
                                        var65_65 = var63_63.append(var64_64).toString();
                                        throw new OperationApplicationException(var65_65);
                                    }
                                    break block12;
                                }
                            }
                            break block11;
                        }
                        catch (Throwable var66_66) {
                            var53_53.close();
                            throw var66_66;
                        }
                    }
                    ++var54_54;
                    ** GOTO lbl73
                }
                var53_53.close();
                ** GOTO lbl30
            }
            var67_67 = this.toString();
            var68_68 = Log.e("ContentProviderOperation", var67_67);
            var69_69 = new StringBuilder().append("bad type, ");
            var70_70 = this.mType;
            var71_71 = var69_69.append(var70_70).toString();
            throw new IllegalStateException(var71_71);
        }
        var72_72 = var17_17;
        var73_73 = var26_26;
        var72_72(var73_73);
        ** while (true)
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.mType;
    }

    public Uri getUri() {
        return this.mUri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReadOperation() {
        if (this.mType != 4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWriteOperation() {
        if (this.mType == 3) return true;
        if (this.mType == 1) return true;
        if (this.mType != 2) return false;
        return true;
    }

    public boolean isYieldAllowed() {
        return this.mYieldAllowed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] resolveSelectionArgsBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        if (this.mSelectionArgsBackReferences == null) {
            return this.mSelectionArgs;
        }
        String[] stringArray = new String[this.mSelectionArgs.length];
        String[] stringArray2 = this.mSelectionArgs;
        int n2 = this.mSelectionArgs.length;
        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.mSelectionArgsBackReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Map.Entry<Integer, Integer> entry = iterator.next();
            Integer n3 = entry.getKey();
            int n4 = entry.getValue();
            int n5 = n3;
            Integer n6 = n4;
            stringArray[n5] = string2 = String.valueOf(this.backRefToValue(contentProviderResultArray, n, n6));
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContentValues resolveValueBackReferences(ContentProviderResult[] contentProviderResultArray, int n) {
        ContentValues contentValues;
        if (this.mValuesBackReferences == null) {
            return this.mValues;
        }
        if (this.mValues == null) {
            contentValues = new ContentValues();
        } else {
            ContentValues contentValues2 = this.mValues;
            contentValues = new ContentValues(contentValues2);
        }
        Iterator<Map.Entry<String, Object>> iterator = this.mValuesBackReferences.valueSet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getKey();
            Integer n2 = this.mValuesBackReferences.getAsInteger(string2);
            if (n2 == null) {
                String string3 = this.toString();
                int n3 = Log.e(TAG, string3);
                String string4 = "values backref " + string2 + " is not an integer";
                throw new IllegalArgumentException(string4);
            }
            Long l = this.backRefToValue(contentProviderResultArray, n, n2);
            contentValues.put(string2, l);
        }
        return contentValues;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("mType: ");
        int n = this.mType;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(", mUri: ");
        Uri uri = this.mUri;
        StringBuilder stringBuilder3 = stringBuilder2.append(uri).append(", mSelection: ");
        String string2 = this.mSelection;
        StringBuilder stringBuilder4 = stringBuilder3.append(string2).append(", mExpectedCount: ");
        Integer n2 = this.mExpectedCount;
        StringBuilder stringBuilder5 = stringBuilder4.append(n2).append(", mYieldAllowed: ");
        boolean bl = this.mYieldAllowed;
        StringBuilder stringBuilder6 = stringBuilder5.append(bl).append(", mValues: ");
        ContentValues contentValues = this.mValues;
        StringBuilder stringBuilder7 = stringBuilder6.append(contentValues).append(", mValuesBackReferences: ");
        ContentValues contentValues2 = this.mValuesBackReferences;
        StringBuilder stringBuilder8 = stringBuilder7.append(contentValues2).append(", mSelectionArgsBackReferences: ");
        Map<Integer, Integer> map = this.mSelectionArgsBackReferences;
        return stringBuilder8.append(map).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mType;
        parcel.writeInt(n2);
        Uri uri = this.mUri;
        Uri.writeToParcel(parcel, uri);
        if (this.mValues != null) {
            parcel.writeInt(1);
            this.mValues.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelection != null) {
            parcel.writeInt(1);
            String string2 = this.mSelection;
            parcel.writeString(string2);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelectionArgs != null) {
            parcel.writeInt(1);
            String[] stringArray = this.mSelectionArgs;
            parcel.writeStringArray(stringArray);
        } else {
            parcel.writeInt(0);
        }
        if (this.mExpectedCount != null) {
            parcel.writeInt(1);
            int n3 = this.mExpectedCount;
            parcel.writeInt(n3);
        } else {
            parcel.writeInt(0);
        }
        if (this.mValuesBackReferences != null) {
            parcel.writeInt(1);
            this.mValuesBackReferences.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mSelectionArgsBackReferences != null) {
            parcel.writeInt(1);
            int n4 = this.mSelectionArgsBackReferences.size();
            parcel.writeInt(n4);
            for (Map.Entry<Integer, Integer> entry : this.mSelectionArgsBackReferences.entrySet()) {
                int n5 = entry.getKey();
                parcel.writeInt(n5);
                int n6 = entry.getValue();
                parcel.writeInt(n6);
            }
        } else {
            parcel.writeInt(0);
        }
        int n7 = this.mYieldAllowed ? 1 : 0;
        parcel.writeInt(n7);
    }

    public static class Builder {
        private Integer mExpectedCount;
        private String mSelection;
        private String[] mSelectionArgs;
        private Map<Integer, Integer> mSelectionArgsBackReferences;
        private final int mType;
        private final Uri mUri;
        private ContentValues mValues;
        private ContentValues mValuesBackReferences;
        private boolean mYieldAllowed;

        private Builder(int n, Uri uri) {
            if (uri == null) {
                throw new IllegalArgumentException("uri must not be null");
            }
            this.mType = n;
            this.mUri = uri;
        }

        public ContentProviderOperation build() {
            if (!(this.mType != 2 || this.mValues != null && this.mValues.size() != 0 || this.mValuesBackReferences != null && this.mValuesBackReferences.size() != 0)) {
                throw new IllegalArgumentException("Empty values");
            }
            if (!(this.mType != 4 || this.mValues != null && this.mValues.size() != 0 || this.mValuesBackReferences != null && this.mValuesBackReferences.size() != 0 || this.mExpectedCount != null)) {
                throw new IllegalArgumentException("Empty values");
            }
            return new ContentProviderOperation(this);
        }

        public Builder withExpectedCount(int n) {
            Integer n2;
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have expected counts");
            }
            this.mExpectedCount = n2 = Integer.valueOf(n);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder withSelection(String string2, String[] stringArray) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selections");
            }
            this.mSelection = string2;
            if (stringArray == null) {
                this.mSelectionArgs = null;
                return this;
            }
            String[] stringArray2 = new String[stringArray.length];
            String[] stringArray3 = this.mSelectionArgs = stringArray2;
            int n = stringArray.length;
            System.arraycopy(stringArray, 0, stringArray3, 0, n);
            return this;
        }

        public Builder withSelectionBackReference(int n, int n2) {
            if (this.mType != 2 && this.mType != 3 && this.mType != 4) {
                throw new IllegalArgumentException("only updates, deletes, and asserts can have selection back-references");
            }
            if (this.mSelectionArgsBackReferences == null) {
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                this.mSelectionArgsBackReferences = hashMap;
            }
            Map<Integer, Integer> map = this.mSelectionArgsBackReferences;
            Integer n3 = n;
            Integer n4 = n2;
            Integer n5 = map.put(n3, n4);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder withValue(String string2, Object object) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts and updates can have values");
            }
            if (this.mValues == null) {
                ContentValues contentValues;
                this.mValues = contentValues = new ContentValues();
            }
            if (object == null) {
                this.mValues.putNull(string2);
                return this;
            }
            if (object instanceof String) {
                ContentValues contentValues = this.mValues;
                String string3 = (String)object;
                contentValues.put(string2, string3);
                return this;
            }
            if (object instanceof Byte) {
                ContentValues contentValues = this.mValues;
                Byte by = (Byte)object;
                contentValues.put(string2, by);
                return this;
            }
            if (object instanceof Short) {
                ContentValues contentValues = this.mValues;
                Short s = (Short)object;
                contentValues.put(string2, s);
                return this;
            }
            if (object instanceof Integer) {
                ContentValues contentValues = this.mValues;
                Integer n = (Integer)object;
                contentValues.put(string2, n);
                return this;
            }
            if (object instanceof Long) {
                ContentValues contentValues = this.mValues;
                Long l = (Long)object;
                contentValues.put(string2, l);
                return this;
            }
            if (object instanceof Float) {
                ContentValues contentValues = this.mValues;
                Float f = (Float)object;
                contentValues.put(string2, f);
                return this;
            }
            if (object instanceof Double) {
                ContentValues contentValues = this.mValues;
                Double d = (Double)object;
                contentValues.put(string2, d);
                return this;
            }
            if (object instanceof Boolean) {
                ContentValues contentValues = this.mValues;
                Boolean bl = (Boolean)object;
                contentValues.put(string2, bl);
                return this;
            }
            if (object instanceof byte[]) {
                ContentValues contentValues = this.mValues;
                byte[] byArray = (byte[])object;
                contentValues.put(string2, byArray);
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder().append("bad value type: ");
            String string4 = object.getClass().getName();
            String string5 = stringBuilder.append(string4).toString();
            throw new IllegalArgumentException(string5);
        }

        public Builder withValueBackReference(String string2, int n) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            if (this.mValuesBackReferences == null) {
                ContentValues contentValues;
                this.mValuesBackReferences = contentValues = new ContentValues();
            }
            ContentValues contentValues = this.mValuesBackReferences;
            Integer n2 = n;
            contentValues.put(string2, n2);
            return this;
        }

        public Builder withValueBackReferences(ContentValues contentValues) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have value back-references");
            }
            this.mValuesBackReferences = contentValues;
            return this;
        }

        public Builder withValues(ContentValues contentValues) {
            if (this.mType != 1 && this.mType != 2 && this.mType != 4) {
                throw new IllegalArgumentException("only inserts, updates, and asserts can have values");
            }
            if (this.mValues == null) {
                ContentValues contentValues2;
                this.mValues = contentValues2 = new ContentValues();
            }
            this.mValues.putAll(contentValues);
            return this;
        }

        public Builder withYieldAllowed(boolean bl) {
            this.mYieldAllowed = bl;
            return this;
        }
    }
}

