/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentValues;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class ContentQueryMap
extends Observable {
    private String[] mColumnNames;
    private ContentObserver mContentObserver;
    private Cursor mCursor;
    private boolean mDirty = false;
    private Handler mHandlerForUpdateNotifications = null;
    private boolean mKeepUpdated = false;
    private int mKeyColumn;
    private Map<String, ContentValues> mValues = null;

    public ContentQueryMap(Cursor cursor, String string2, boolean bl, Handler handler) {
        int n;
        this.mCursor = cursor;
        String[] stringArray = this.mCursor.getColumnNames();
        this.mColumnNames = stringArray;
        this.mKeyColumn = n = this.mCursor.getColumnIndexOrThrow(string2);
        this.mHandlerForUpdateNotifications = handler;
        this.setKeepUpdated(bl);
        if (bl) {
            return;
        }
        this.readCursorIntoCache();
    }

    static /* synthetic */ boolean access$002(ContentQueryMap contentQueryMap, boolean bl) {
        contentQueryMap.mDirty = bl;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCursorIntoCache() {
        synchronized (this) {
            int n = this.mValues != null ? this.mValues.size() : 0;
            HashMap<String, ContentValues> hashMap = new HashMap<String, ContentValues>(n);
            this.mValues = hashMap;
            while (this.mCursor.moveToNext()) {
                int n2;
                ContentValues contentValues = new ContentValues();
                for (int i = 0; i < (n2 = this.mColumnNames.length); ++i) {
                    int n3 = this.mKeyColumn;
                    if (i == n3) continue;
                    String string2 = this.mColumnNames[i];
                    String string3 = this.mCursor.getString(i);
                    contentValues.put(string2, string3);
                }
                Map<String, ContentValues> map = this.mValues;
                Cursor cursor = this.mCursor;
                int n4 = this.mKeyColumn;
                String string4 = cursor.getString(n4);
                ContentValues contentValues2 = map.put(string4, contentValues);
            }
            return;
        }
    }

    public void close() {
        synchronized (this) {
            if (this.mContentObserver != null) {
                Cursor cursor = this.mCursor;
                ContentObserver contentObserver = this.mContentObserver;
                cursor.unregisterContentObserver(contentObserver);
                this.mContentObserver = null;
            }
            this.mCursor.close();
            this.mCursor = null;
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCursor != null) {
            this.close();
        }
        super.finalize();
    }

    public Map<String, ContentValues> getRows() {
        synchronized (this) {
            if (this.mDirty) {
                this.requery();
            }
            Map<String, ContentValues> map = this.mValues;
            return map;
        }
    }

    public ContentValues getValues(String string2) {
        synchronized (this) {
            if (this.mDirty) {
                this.requery();
            }
            ContentValues contentValues = this.mValues.get(string2);
            return contentValues;
        }
    }

    public void requery() {
        this.mDirty = false;
        boolean bl = this.mCursor.requery();
        this.readCursorIntoCache();
        this.setChanged();
        this.notifyObservers();
    }

    public void setKeepUpdated(boolean bl) {
        boolean bl2 = this.mKeepUpdated;
        if (bl != bl2) {
            return;
        }
        this.mKeepUpdated = bl;
        if (!this.mKeepUpdated) {
            Cursor cursor = this.mCursor;
            ContentObserver contentObserver = this.mContentObserver;
            cursor.unregisterContentObserver(contentObserver);
            this.mContentObserver = null;
            return;
        }
        if (this.mHandlerForUpdateNotifications == null) {
            Handler handler;
            this.mHandlerForUpdateNotifications = handler = new Handler();
        }
        if (this.mContentObserver == null) {
            ContentObserver contentObserver;
            Handler handler = this.mHandlerForUpdateNotifications;
            this.mContentObserver = contentObserver = new ContentObserver(handler){

                @Override
                public void onChange(boolean bl) {
                    if (ContentQueryMap.this.countObservers() != 0) {
                        ContentQueryMap.this.requery();
                        return;
                    }
                    boolean bl2 = ContentQueryMap.access$002(ContentQueryMap.this, true);
                }
            };
        }
        Cursor cursor = this.mCursor;
        ContentObserver contentObserver = this.mContentObserver;
        cursor.registerContentObserver(contentObserver);
        this.mDirty = true;
    }
}

