/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncStatusInfo;
import android.content.SyncStatusObserver;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.EventLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public abstract class ContentResolver {
    public static final String CONTENT_SERVICE_NAME = "content";
    public static final String CURSOR_DIR_BASE_TYPE = "vnd.android.cursor.dir";
    public static final String CURSOR_ITEM_BASE_TYPE = "vnd.android.cursor.item";
    public static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static final String SCHEME_CONTENT = "content";
    public static final String SCHEME_FILE = "file";
    private static final int SLOW_THRESHOLD_MILLIS = 500;
    public static final int SYNC_ERROR_AUTHENTICATION = 2;
    public static final int SYNC_ERROR_CONFLICT = 5;
    public static final int SYNC_ERROR_INTERNAL = 8;
    public static final int SYNC_ERROR_IO = 3;
    public static final int SYNC_ERROR_PARSE = 4;
    public static final int SYNC_ERROR_SYNC_ALREADY_IN_PROGRESS = 1;
    public static final int SYNC_ERROR_TOO_MANY_DELETIONS = 6;
    public static final int SYNC_ERROR_TOO_MANY_RETRIES = 7;
    @Deprecated
    public static final String SYNC_EXTRAS_ACCOUNT = "account";
    public static final String SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS = "discard_deletions";
    public static final String SYNC_EXTRAS_DO_NOT_RETRY = "do_not_retry";
    public static final String SYNC_EXTRAS_EXPEDITED = "expedited";
    @Deprecated
    public static final String SYNC_EXTRAS_FORCE = "force";
    public static final String SYNC_EXTRAS_IGNORE_BACKOFF = "ignore_backoff";
    public static final String SYNC_EXTRAS_IGNORE_SETTINGS = "ignore_settings";
    public static final String SYNC_EXTRAS_INITIALIZE = "initialize";
    public static final String SYNC_EXTRAS_MANUAL = "force";
    public static final String SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS = "deletions_override";
    public static final String SYNC_EXTRAS_UPLOAD = "upload";
    public static final int SYNC_OBSERVER_TYPE_ACTIVE = 4;
    public static final int SYNC_OBSERVER_TYPE_ALL = Integer.MAX_VALUE;
    public static final int SYNC_OBSERVER_TYPE_PENDING = 2;
    public static final int SYNC_OBSERVER_TYPE_SETTINGS = 1;
    public static final int SYNC_OBSERVER_TYPE_STATUS = 8;
    private static final String TAG = "ContentResolver";
    private static IContentService sContentService;
    private final Context mContext;
    private final Random mRandom;

    public ContentResolver(Context context) {
        Random random;
        this.mRandom = random = new Random();
        this.mContext = context;
    }

    public static void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        if (bundle.getBoolean("force", false) || bundle.getBoolean(SYNC_EXTRAS_DO_NOT_RETRY, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_BACKOFF, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_SETTINGS, false) || bundle.getBoolean(SYNC_EXTRAS_INITIALIZE, false) || bundle.getBoolean("force", false) || bundle.getBoolean(SYNC_EXTRAS_EXPEDITED, false)) {
            throw new IllegalArgumentException("illegal extras were set");
        }
        try {
            IContentService iContentService = ContentResolver.getContentService();
            Account account2 = account;
            String string3 = string2;
            Bundle bundle2 = bundle;
            long l2 = l;
            iContentService.addPeriodicSync(account2, string3, bundle2, l2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static Object addStatusChangeListener(int n, final SyncStatusObserver syncStatusObserver) {
        if (syncStatusObserver == null) {
            throw new IllegalArgumentException("you passed in a null callback");
        }
        try {
            ISyncStatusObserver.Stub stub = new ISyncStatusObserver.Stub(){

                @Override
                public void onStatusChanged(int n) throws RemoteException {
                    syncStatusObserver.onStatusChanged(n);
                }
            };
            ContentResolver.getContentService().addStatusChangeListener(n, stub);
            return stub;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static void cancelSync(Account account, String string2) {
        try {
            ContentResolver.getContentService().cancelSync(account, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IContentService getContentService() {
        if (sContentService == null) return sContentService = IContentService.Stub.asInterface(ServiceManager.getService("content"));
        return sContentService;
    }

    public static SyncInfo getCurrentSync() {
        try {
            SyncInfo syncInfo = ContentResolver.getContentService().getCurrentSync();
            return syncInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static int getIsSyncable(Account account, String string2) {
        try {
            int n = ContentResolver.getContentService().getIsSyncable(account, string2);
            return n;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getMasterSyncAutomatically() {
        try {
            boolean bl = ContentResolver.getContentService().getMasterSyncAutomatically();
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        try {
            List<PeriodicSync> list = ContentResolver.getContentService().getPeriodicSyncs(account, string2);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypes() {
        try {
            SyncAdapterType[] syncAdapterTypeArray = ContentResolver.getContentService().getSyncAdapterTypes();
            return syncAdapterTypeArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getSyncAutomatically(Account account, String string2) {
        try {
            boolean bl = ContentResolver.getContentService().getSyncAutomatically(account, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncStatusInfo getSyncStatus(Account account, String string2) {
        try {
            SyncStatusInfo syncStatusInfo = ContentResolver.getContentService().getSyncStatus(account, string2);
            return syncStatusInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean isSyncActive(Account account, String string2) {
        try {
            boolean bl = ContentResolver.getContentService().isSyncActive(account, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean isSyncPending(Account account, String string2) {
        try {
            boolean bl = ContentResolver.getContentService().isSyncPending(account, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeLogQueryToEventLog(long l, Uri uri, String[] stringArray, String string2, String string3) {
        int n = this.samplePercentForDuration(l);
        if (n < 100) {
            Random random = this.mRandom;
            synchronized (random) {
                if (this.mRandom.nextInt(100) >= n) {
                    return;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        if (stringArray != null) {
            int n2;
            for (int i = 0; i < (n2 = stringArray.length); ++i) {
                if (i != 0) {
                    StringBuilder stringBuilder2 = stringBuilder.append('/');
                }
                String string4 = stringArray[i];
                StringBuilder stringBuilder3 = stringBuilder.append(string4);
            }
        }
        String string5 = AppGlobals.getInitialPackage();
        int n3 = 52002;
        Object[] objectArray = new Object[7];
        String string6 = uri.toString();
        objectArray[0] = string6;
        String string7 = stringBuilder.toString();
        objectArray[1] = string7;
        int n4 = 2;
        String string8 = string2 != null ? string2 : "";
        objectArray[n4] = string8;
        int n5 = 3;
        String string9 = string3 != null ? string3 : "";
        objectArray[n5] = string9;
        Long l2 = l;
        objectArray[4] = l2;
        int n6 = 5;
        String string10 = string5 != null ? string5 : "";
        objectArray[n6] = string10;
        Integer n7 = n;
        objectArray[6] = n7;
        int n8 = EventLog.writeEvent(n3, objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeLogUpdateToEventLog(long l, Uri uri, String string2, String string3) {
        int n = this.samplePercentForDuration(l);
        if (n < 100) {
            Random random = this.mRandom;
            synchronized (random) {
                if (this.mRandom.nextInt(100) >= n) {
                    return;
                }
            }
        }
        String string4 = AppGlobals.getInitialPackage();
        int n2 = 52003;
        Object[] objectArray = new Object[6];
        String string5 = uri.toString();
        objectArray[0] = string5;
        objectArray[1] = string2;
        int n3 = 2;
        String string6 = string3 != null ? string3 : "";
        objectArray[n3] = string6;
        Long l2 = l;
        objectArray[3] = l2;
        int n4 = 4;
        String string7 = string4 != null ? string4 : "";
        objectArray[n4] = string7;
        Integer n5 = n;
        objectArray[5] = n5;
        int n6 = EventLog.writeEvent(n2, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int modeToMode(Uri uri, String string2) throws FileNotFoundException {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2)) return 0x2C000000;
        if ("wt".equals(string2)) {
            return 0x2C000000;
        }
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if ("rwt".equals(string2)) {
            return 0x3C000000;
        }
        String string3 = "Bad mode for " + uri + ": " + string2;
        throw new FileNotFoundException(string3);
    }

    public static void removePeriodicSync(Account account, String string2, Bundle bundle) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        try {
            ContentResolver.getContentService().removePeriodicSync(account, string2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static void removeStatusChangeListener(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("you passed in a null handle");
        }
        try {
            IContentService iContentService = ContentResolver.getContentService();
            ISyncStatusObserver.Stub stub = (ISyncStatusObserver.Stub)object;
            iContentService.removeStatusChangeListener(stub);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void requestSync(Account account, String string2, Bundle bundle) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        try {
            ContentResolver.getContentService().requestSync(account, string2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int samplePercentForDuration(long l) {
        if (l < 500L) return (int)(100L * l / 500L) + 1;
        return 100;
    }

    public static void setIsSyncable(Account account, String string2, int n) {
        try {
            ContentResolver.getContentService().setIsSyncable(account, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void setMasterSyncAutomatically(boolean bl) {
        try {
            ContentResolver.getContentService().setMasterSyncAutomatically(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void setSyncAutomatically(Account account, String string2, boolean bl) {
        try {
            ContentResolver.getContentService().setSyncAutomatically(account, string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void validateSyncExtrasBundle(Bundle bundle) {
        try {
            String string2;
            Object object;
            Iterator<String> iterator = bundle.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return;
            } while ((object = bundle.get(string2 = iterator.next())) == null || object instanceof Long || object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof Account);
            StringBuilder stringBuilder = new StringBuilder().append("unexpected value type: ");
            String string3 = object.getClass().getName();
            String string4 = stringBuilder.append(string3).toString();
            throw new IllegalArgumentException(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("error unparceling Bundle", runtimeException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ContentProviderClient acquireContentProviderClient(Uri uri) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) return null;
        return new ContentProviderClient(this, iContentProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ContentProviderClient acquireContentProviderClient(String string2) {
        IContentProvider iContentProvider = this.acquireProvider(string2);
        if (iContentProvider == null) return null;
        return new ContentProviderClient(this, iContentProvider);
    }

    protected IContentProvider acquireExistingProvider(Context context, String string2) {
        return this.acquireProvider(context, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IContentProvider acquireExistingProvider(Uri uri) {
        String string2 = uri.getScheme();
        if (!"content".equals(string2)) {
            return null;
        }
        if (uri.getAuthority() == null) return null;
        Context context = this.mContext;
        String string3 = uri.getAuthority();
        return this.acquireExistingProvider(context, string3);
    }

    protected abstract IContentProvider acquireProvider(Context var1, String var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IContentProvider acquireProvider(Uri uri) {
        String string2 = uri.getScheme();
        if (!"content".equals(string2)) {
            return null;
        }
        if (uri.getAuthority() == null) return null;
        Context context = this.mContext;
        String string3 = uri.getAuthority();
        return this.acquireProvider(context, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IContentProvider acquireProvider(String string2) {
        if (string2 == null) {
            return null;
        }
        Context context = this.mContext;
        return this.acquireProvider(context, string2);
    }

    public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        ContentProviderClient contentProviderClient = this.acquireContentProviderClient(string2);
        if (contentProviderClient == null) {
            String string3 = "Unknown authority " + string2;
            throw new IllegalArgumentException(string3);
        }
        try {
            ContentProviderResult[] contentProviderResultArray;
            ContentProviderResult[] contentProviderResultArray2 = contentProviderResultArray = contentProviderClient.applyBatch(arrayList);
            boolean bl = contentProviderClient.release();
            return contentProviderResultArray2;
        }
        catch (Throwable throwable) {
            boolean bl = contentProviderClient.release();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        int n;
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            String string2 = "Unknown URL " + uri;
            throw new IllegalArgumentException(string2);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n2 = iContentProvider.bulkInsert(uri, contentValuesArray);
            long l2 = SystemClock.uptimeMillis() - l;
            ContentResolver contentResolver = this;
            Uri uri2 = uri;
            contentResolver.maybeLogUpdateToEventLog(l2, uri2, "bulkinsert", null);
            n = n2;
            return n;
        }
        catch (RemoteException remoteException) {
            n = 0;
            return n;
        }
        finally {
            boolean bl = this.releaseProvider(iContentProvider);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void cancelSync(Uri uri) {
        String string2 = uri != null ? uri.getAuthority() : null;
        ContentResolver.cancelSync(null, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int delete(Uri uri, String string2, String[] stringArray) {
        int n;
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            String string3 = "Unknown URL " + uri;
            throw new IllegalArgumentException(string3);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n2 = iContentProvider.delete(uri, string2, stringArray);
            long l2 = SystemClock.uptimeMillis() - l;
            ContentResolver contentResolver = this;
            Uri uri2 = uri;
            String string4 = string2;
            contentResolver.maybeLogUpdateToEventLog(l2, uri2, "delete", string4);
            n = n2;
            return n;
        }
        catch (RemoteException remoteException) {
            n = -1;
            return n;
        }
        finally {
            boolean bl = this.releaseProvider(iContentProvider);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenResourceIdResult getResourceId(Uri uri) throws FileNotFoundException {
        int n;
        List<String> list;
        Resources resources;
        String string2 = uri.getAuthority();
        if (TextUtils.isEmpty(string2)) {
            String string3 = "No authority: " + uri;
            throw new FileNotFoundException(string3);
        }
        try {
            Resources resources2;
            resources = resources2 = this.mContext.getPackageManager().getResourcesForApplication(string2);
            list = uri.getPathSegments();
            if (list == null) {
                String string4 = "No path: " + uri;
                throw new FileNotFoundException(string4);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string5 = "No package found for authority: " + uri;
            throw new FileNotFoundException(string5);
        }
        int n2 = list.size();
        if (n2 == 1) {
            int n3 = 0;
            try {
                int n4;
                n = n4 = Integer.parseInt(list.get(n3));
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = "Single path segment is not a resource ID: " + uri;
                throw new FileNotFoundException(string6);
            }
        } else {
            if (n2 != 2) {
                String string7 = "More than two path segments: " + uri;
                throw new FileNotFoundException(string7);
            }
            String string8 = list.get(1);
            String string9 = list.get(0);
            n = resources.getIdentifier(string8, string9, string2);
        }
        if (n == 0) {
            String string10 = "No resource found for: " + uri;
            throw new FileNotFoundException(string10);
        }
        OpenResourceIdResult openResourceIdResult = new OpenResourceIdResult();
        openResourceIdResult.r = resources;
        openResourceIdResult.id = n;
        return openResourceIdResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getType(Uri uri) {
        IContentProvider iContentProvider = this.acquireExistingProvider(uri);
        if (iContentProvider != null) {
            String string2;
            try {
                String string3;
                string2 = string3 = iContentProvider.getType(uri);
                boolean bl = this.releaseProvider(iContentProvider);
            }
            catch (RemoteException remoteException) {
                boolean bl = this.releaseProvider(iContentProvider);
                return null;
            }
            catch (Exception exception) {
                boolean bl = this.releaseProvider(iContentProvider);
                return null;
            }
            catch (Throwable throwable) {
                boolean bl = this.releaseProvider(iContentProvider);
                throw throwable;
            }
            return string2;
        }
        String string4 = uri.getScheme();
        if (!"content".equals(string4)) {
            return null;
        }
        try {
            String string5 = ActivityManagerNative.getDefault().getProviderMimeType(uri);
            return string5;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Uri insert(Uri uri, ContentValues contentValues) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            String string2 = "Unknown URL " + uri;
            throw new IllegalArgumentException(string2);
        }
        try {
            long l = SystemClock.uptimeMillis();
            Uri uri2 = iContentProvider.insert(uri, contentValues);
            long l2 = SystemClock.uptimeMillis() - l;
            ContentResolver contentResolver = this;
            Uri uri3 = uri;
            contentResolver.maybeLogUpdateToEventLog(l2, uri3, "insert", null);
            boolean bl = this.releaseProvider(iContentProvider);
            return uri2;
        }
        catch (RemoteException remoteException) {
            boolean bl = this.releaseProvider(iContentProvider);
            return null;
        }
        catch (Throwable throwable) {
            boolean bl = this.releaseProvider(iContentProvider);
            throw throwable;
        }
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver) {
        this.notifyChange(uri, contentObserver, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyChange(Uri uri, ContentObserver contentObserver, boolean bl) {
        try {
            IContentObserver iContentObserver;
            IContentService iContentService = ContentResolver.getContentService();
            IContentObserver iContentObserver2 = contentObserver == null ? null : (iContentObserver = contentObserver.getContentObserver());
            boolean bl2 = contentObserver != null && contentObserver.deliverSelfNotifications();
            iContentService.notifyChange(uri, iContentObserver2, bl2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final AssetFileDescriptor openAssetFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        String string3 = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(string3)) {
            if (!"r".equals(string2)) {
                String string4 = "Can't write resources: " + uri;
                throw new FileNotFoundException(string4);
            }
            OpenResourceIdResult openResourceIdResult = this.getResourceId(uri);
            try {
                Resources resources = openResourceIdResult.r;
                int n = openResourceIdResult.id;
                AssetFileDescriptor assetFileDescriptor = resources.openRawResourceFd(n);
                return assetFileDescriptor;
            }
            catch (Resources.NotFoundException notFoundException) {
                String string5 = "Resource does not exist: " + uri;
                throw new FileNotFoundException(string5);
            }
        }
        if (SCHEME_FILE.equals(string3)) {
            String string6 = uri.getPath();
            File file = new File(string6);
            int n = ContentResolver.modeToMode(uri, string2);
            ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open(file, n);
            return new AssetFileDescriptor(parcelFileDescriptor, 0L, 65535L);
        }
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            String string7 = "No content provider: " + uri;
            throw new FileNotFoundException(string7);
        }
        try {
            AssetFileDescriptor assetFileDescriptor = iContentProvider.openAssetFile(uri, string2);
            if (assetFileDescriptor == null) {
                boolean bl = this.releaseProvider(iContentProvider);
                return null;
            }
            ParcelFileDescriptor parcelFileDescriptor = assetFileDescriptor.getParcelFileDescriptor();
            ParcelFileDescriptorInner parcelFileDescriptorInner = new ParcelFileDescriptorInner(parcelFileDescriptor, iContentProvider);
            long l = assetFileDescriptor.getStartOffset();
            long l2 = assetFileDescriptor.getDeclaredLength();
            return new AssetFileDescriptor(parcelFileDescriptorInner, l, l2);
        }
        catch (RemoteException remoteException) {
            boolean bl = this.releaseProvider(iContentProvider);
            String string8 = "Dead content provider: " + uri;
            throw new FileNotFoundException(string8);
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = this.releaseProvider(iContentProvider);
            throw fileNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            boolean bl = this.releaseProvider(iContentProvider);
            throw runtimeException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ParcelFileDescriptor openFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, string2);
        if (assetFileDescriptor == null) {
            return null;
        }
        if (assetFileDescriptor.getDeclaredLength() < 0L) {
            return assetFileDescriptor.getParcelFileDescriptor();
        }
        try {
            assetFileDescriptor.close();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Not a whole file");
        }
        throw new FileNotFoundException("Not a whole file");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final InputStream openInputStream(Uri uri) throws FileNotFoundException {
        void var7_9;
        String string2 = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(string2)) {
            OpenResourceIdResult openResourceIdResult = this.getResourceId(uri);
            try {
                InputStream inputStream;
                Resources resources = openResourceIdResult.r;
                int n = openResourceIdResult.id;
                InputStream inputStream2 = inputStream = resources.openRawResource(n);
            }
            catch (Resources.NotFoundException notFoundException) {
                String string3 = "Resource does not exist: " + uri;
                throw new FileNotFoundException(string3);
            }
            return var7_9;
        }
        if (SCHEME_FILE.equals(string2)) {
            String string4 = uri.getPath();
            FileInputStream fileInputStream = new FileInputStream(string4);
            return var7_9;
        }
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, "r");
        if (assetFileDescriptor == null) return var7_9;
        try {
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2 = fileInputStream = assetFileDescriptor.createInputStream();
            return var7_9;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public final OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return this.openOutputStream(uri, "w");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final OutputStream openOutputStream(Uri uri, String string2) throws FileNotFoundException {
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, string2);
        if (assetFileDescriptor == null) return null;
        try {
            FileOutputStream fileOutputStream = assetFileDescriptor.createOutputStream();
            return fileOutputStream;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            return null;
        }
        try {
            long l = SystemClock.uptimeMillis();
            Uri uri2 = uri;
            String[] stringArray3 = stringArray;
            String string4 = string2;
            String[] stringArray4 = stringArray2;
            String string5 = string3;
            Cursor cursor = iContentProvider.query(uri2, stringArray3, string4, stringArray4, string5);
            if (cursor == null) {
                boolean bl = this.releaseProvider(iContentProvider);
                return null;
            }
            int n = cursor.getCount();
            long l2 = SystemClock.uptimeMillis() - l;
            ContentResolver contentResolver = this;
            Uri uri3 = uri;
            String[] stringArray5 = stringArray;
            String string6 = string2;
            String string7 = string3;
            contentResolver.maybeLogQueryToEventLog(l2, uri3, stringArray5, string6, string7);
            return new CursorWrapperInner(cursor, iContentProvider);
        }
        catch (RemoteException remoteException) {
            boolean bl = this.releaseProvider(iContentProvider);
            return null;
        }
        catch (RuntimeException runtimeException) {
            boolean bl = this.releaseProvider(iContentProvider);
            throw runtimeException;
        }
    }

    public final void registerContentObserver(Uri uri, boolean bl, ContentObserver contentObserver) {
        try {
            IContentService iContentService = ContentResolver.getContentService();
            IContentObserver iContentObserver = contentObserver.getContentObserver();
            iContentService.registerContentObserver(uri, bl, iContentObserver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public abstract boolean releaseProvider(IContentProvider var1);

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void startSync(Uri uri, Bundle bundle) {
        Account account = null;
        if (bundle != null) {
            String string2 = bundle.getString(SYNC_EXTRAS_ACCOUNT);
            if (!TextUtils.isEmpty(string2)) {
                account = new Account(string2, "com.google");
            }
            bundle.remove(SYNC_EXTRAS_ACCOUNT);
        }
        String string3 = uri != null ? uri.getAuthority() : null;
        ContentResolver.requestSync(account, string3, bundle);
    }

    public final void unregisterContentObserver(ContentObserver contentObserver) {
        try {
            IContentObserver iContentObserver = contentObserver.releaseContentObserver();
            if (iContentObserver == null) {
                return;
            }
            ContentResolver.getContentService().unregisterContentObserver(iContentObserver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n;
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            String string3 = "Unknown URI " + uri;
            throw new IllegalArgumentException(string3);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n2 = iContentProvider.update(uri, contentValues, string2, stringArray);
            long l2 = SystemClock.uptimeMillis() - l;
            ContentResolver contentResolver = this;
            Uri uri2 = uri;
            String string4 = string2;
            contentResolver.maybeLogUpdateToEventLog(l2, uri2, "update", string4);
            n = n2;
            return n;
        }
        catch (RemoteException remoteException) {
            n = -1;
            return n;
        }
        finally {
            boolean bl = this.releaseProvider(iContentProvider);
            return n;
        }
    }

    private final class ParcelFileDescriptorInner
    extends ParcelFileDescriptor {
        public static final String TAG = "ParcelFileDescriptorInner";
        private IContentProvider mContentProvider;
        private boolean mReleaseProviderFlag;

        ParcelFileDescriptorInner(ParcelFileDescriptor parcelFileDescriptor, IContentProvider iContentProvider) {
            super(parcelFileDescriptor);
            this.mReleaseProviderFlag = false;
            this.mContentProvider = iContentProvider;
        }

        @Override
        public void close() throws IOException {
            if (this.mReleaseProviderFlag) {
                return;
            }
            super.close();
            ContentResolver contentResolver = ContentResolver.this;
            IContentProvider iContentProvider = this.mContentProvider;
            boolean bl = contentResolver.releaseProvider(iContentProvider);
            this.mReleaseProviderFlag = true;
        }

        @Override
        protected void finalize() throws Throwable {
            if (this.mReleaseProviderFlag) {
                return;
            }
            this.close();
        }
    }

    private final class CursorWrapperInner
    extends CursorWrapper {
        public static final String TAG = "CursorWrapperInner";
        private boolean mCloseFlag;
        private IContentProvider mContentProvider;

        CursorWrapperInner(Cursor cursor, IContentProvider iContentProvider) {
            super(cursor);
            this.mCloseFlag = false;
            this.mContentProvider = iContentProvider;
        }

        @Override
        public void close() {
            super.close();
            ContentResolver contentResolver = ContentResolver.this;
            IContentProvider iContentProvider = this.mContentProvider;
            boolean bl = contentResolver.releaseProvider(iContentProvider);
            this.mCloseFlag = true;
        }

        protected void finalize() throws Throwable {
            try {
                if (!this.mCloseFlag) {
                    ContentResolver contentResolver = ContentResolver.this;
                    IContentProvider iContentProvider = this.mContentProvider;
                    boolean bl = contentResolver.releaseProvider(iContentProvider);
                }
                return;
            }
            finally {
                super.finalize();
            }
        }
    }

    public class OpenResourceIdResult {
        public int id;
        public Resources r;
    }
}

