/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncManager;
import android.content.SyncStatusInfo;
import android.content.SyncStorageEngine;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public final class ContentService
extends IContentService.Stub {
    private static final String TAG = "ContentService";
    private Context mContext;
    private boolean mFactoryTest;
    private final ObserverNode mRootNode;
    private SyncManager mSyncManager;
    private final Object mSyncManagerLock;

    ContentService(Context context, boolean bl) {
        Object object;
        ObserverNode observerNode;
        this.mRootNode = observerNode = new ObserverNode("");
        this.mSyncManager = null;
        this.mSyncManagerLock = object = new Object();
        this.mContext = context;
        this.mFactoryTest = bl;
        SyncManager syncManager = this.getSyncManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SyncManager getSyncManager() {
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                SyncManager syncManager;
                if (this.mSyncManager != null) return this.mSyncManager;
                Context context = this.mContext;
                boolean bl = this.mFactoryTest;
                this.mSyncManager = syncManager = new SyncManager(context, bl);
                return this.mSyncManager;
            }
            catch (SQLiteException sQLiteException) {
                int n = Log.e(TAG, "Can't create SyncManager", sQLiteException);
                return this.mSyncManager;
            }
        }
    }

    public static IContentService main(Context context, boolean bl) {
        ContentService contentService = new ContentService(context, bl);
        ServiceManager.addService("content", contentService);
        return contentService;
    }

    @Override
    public void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l2 = ContentService.clearCallingIdentity();
        try {
            SyncStorageEngine syncStorageEngine = this.getSyncManager().getSyncStorageEngine();
            Account account2 = account;
            String string3 = string2;
            Bundle bundle2 = bundle;
            long l3 = l;
            syncStorageEngine.addPeriodicSync(account2, string3, bundle2, l3);
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l2);
        }
    }

    @Override
    public void addStatusChangeListener(int n, ISyncStatusObserver iSyncStatusObserver) {
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && iSyncStatusObserver != null) {
                syncManager.getSyncStorageEngine().addStatusChangeListener(n, iSyncStatusObserver);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void cancelSync(Account account, String string2) {
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.clearScheduledSyncOperations(account, string2);
                syncManager.cancelActiveSync(account, string2);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        synchronized (this) {
            long l;
            this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
            long l2 = l = ContentService.clearCallingIdentity();
            try {
                if (this.mSyncManager == null) {
                    printWriter.println("No SyncManager created!  (Disk full?)");
                } else {
                    this.mSyncManager.dump(fileDescriptor, printWriter);
                }
                return;
            }
            finally {
                ContentService.restoreCallingIdentity(l2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SyncInfo getCurrentSync() {
        long l;
        block2: {
            SyncInfo syncInfo;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            try {
                SyncInfo syncInfo2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                syncInfo = syncInfo2 = syncManager.getSyncStorageEngine().getCurrentSync();
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return syncInfo;
        }
        ContentService.restoreCallingIdentity(l);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getIsSyncable(Account account, String string2) {
        long l;
        block2: {
            int n;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            try {
                int n2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                n = n2 = syncManager.getSyncStorageEngine().getIsSyncable(account, string2);
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return n;
        }
        ContentService.restoreCallingIdentity(l);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getMasterSyncAutomatically() {
        long l;
        block2: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            try {
                boolean bl2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                bl = bl2 = syncManager.getSyncStorageEngine().getMasterSyncAutomatically();
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
    }

    @Override
    public List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        List<PeriodicSync> list;
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            List<PeriodicSync> list2;
            list = list2 = this.getSyncManager().getSyncStorageEngine().getPeriodicSyncs(account, string2);
        }
        catch (Throwable throwable) {
            ContentService.restoreCallingIdentity(l);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(l);
        return list;
    }

    @Override
    public SyncAdapterType[] getSyncAdapterTypes() {
        SyncAdapterType[] syncAdapterTypeArray;
        long l = ContentService.clearCallingIdentity();
        try {
            SyncAdapterType[] syncAdapterTypeArray2;
            syncAdapterTypeArray = syncAdapterTypeArray2 = this.getSyncManager().getSyncAdapterTypes();
        }
        catch (Throwable throwable) {
            ContentService.restoreCallingIdentity(l);
            throw throwable;
        }
        ContentService.restoreCallingIdentity(l);
        return syncAdapterTypeArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getSyncAutomatically(Account account, String string2) {
        long l;
        block2: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            try {
                boolean bl2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                bl = bl2 = syncManager.getSyncStorageEngine().getSyncAutomatically(account, string2);
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SyncStatusInfo getSyncStatus(Account account, String string2) {
        long l;
        block2: {
            SyncStatusInfo syncStatusInfo;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            try {
                SyncStatusInfo syncStatusInfo2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                syncStatusInfo = syncStatusInfo2 = syncManager.getSyncStorageEngine().getStatusByAccountAndAuthority(account, string2);
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return syncStatusInfo;
        }
        ContentService.restoreCallingIdentity(l);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSyncActive(Account account, String string2) {
        long l;
        block2: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            try {
                boolean bl2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                bl = bl2 = syncManager.getSyncStorageEngine().isSyncActive(account, string2);
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSyncPending(Account account, String string2) {
        long l;
        block2: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            try {
                boolean bl2;
                SyncManager syncManager = this.getSyncManager();
                if (syncManager == null) break block2;
                bl = bl2 = syncManager.getSyncStorageEngine().isSyncPending(account, string2);
            }
            catch (Throwable throwable) {
                ContentService.restoreCallingIdentity(l);
                throw throwable;
            }
            ContentService.restoreCallingIdentity(l);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyChange(Uri var1_1, IContentObserver var2_2, boolean var3_3, boolean var4_4) {
        if (Log.isLoggable("ContentService", 2)) {
            var5_5 = new StringBuilder().append("Notifying update of ");
            var6_6 = var1_1;
            var7_7 = var5_5.append(var6_6).append(" from observer ");
            var8_8 = var2_2;
            var9_9 = var7_7.append(var8_8).append(", syncToNetwork ");
            var10_10 = var4_4;
            var11_11 = var9_9.append(var10_10).toString();
            var12_12 = Log.v("ContentService", var11_11);
        }
        var13_13 = ContentService.clearCallingIdentity();
        var15_14 = new ArrayList<ObserverCall>();
        var16_15 = this.mRootNode;
        synchronized (var16_15) {
            var17_16 = this.mRootNode;
            var18_17 = var1_1;
            var19_18 = var2_2;
            var20_19 = var3_3;
            var17_16.collectObserversLocked(var18_17, 0, var19_18, var20_19, var15_14);
        }
        {
            catch (Throwable var35_42) {
                ContentService.restoreCallingIdentity(var13_13);
                throw var35_42;
            }
            {
                // MONITOREXIT @DISABLED, blocks:[9, 12] lbl24 : MonitorExitStatement: MONITOREXIT : var16_15
                var21_20 = var15_14.size();
                var22_21 = 0;
                while ((var23_22 = ++var22_21) < (var24_23 = var21_20)) {
                    var25_24 = var15_14.get(var22_21);
                    try {
                        var26_25 = var25_24.mObserver;
                        var27_26 = var25_24.mSelfNotify;
                        var26_25.onChange(var27_26);
                        if (!Log.isLoggable("ContentService", 2)) continue;
                        var28_27 = new StringBuilder().append("Notified ");
                        var29_28 = var25_24.mObserver;
                        var30_29 = var28_27.append(var29_28).append(" of ").append("update at ");
                        var31_30 = var1_1;
                        var32_31 = var30_29.append(var31_30).toString();
                        var33_32 = Log.v("ContentService", var32_31);
                    }
                    catch (RemoteException var36_34) {}
                    {
                        var34_33 = this.mRootNode;
                        ** synchronized (var34_33)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var37_35 = Log.w("ContentService", "Found dead observer, removing");
                        var16_15 = var25_24.mObserver.asBinder();
                        var38_36 = ObserverNode.access$000(var25_24.mNode);
                        var39_37 = var38_36.size();
                        var40_38 = 0;
                        while ((var41_39 = ++var40_38) < (var42_40 = var39_37)) {
                            if (((ObserverNode.ObserverEntry)var38_36.get((int)var40_38)).observer.asBinder() != var16_15) continue;
                            var43_41 = var38_36.remove(var40_38);
                            var40_38 += -1;
                            var39_37 += -1;
                        }
                    }
                }
            }
        }
        if (var4_4 && (var45_43 = this.getSyncManager()) != null) {
            var46_44 = var1_1.getAuthority();
            var47_45 = var45_43;
            var48_46 = null;
            var49_47 = var46_44;
            var47_45.scheduleLocalSync(var48_46, var49_47);
        }
        ContentService.restoreCallingIdentity(var13_13);
    }

    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        try {
            boolean bl = super.onTransact(n, parcel, parcel2, n2);
            return bl;
        }
        catch (RuntimeException runtimeException) {
            if (!(runtimeException instanceof SecurityException)) {
                int n3 = Log.e(TAG, "Content Service Crash", runtimeException);
            }
            throw runtimeException;
        }
    }

    @Override
    public void registerContentObserver(Uri uri, boolean bl, IContentObserver iContentObserver) {
        if (iContentObserver == null || uri == null) {
            throw new IllegalArgumentException("You must pass a valid uri and observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            ObserverNode observerNode2 = this.mRootNode;
            ObserverNode observerNode3 = this.mRootNode;
            observerNode2.addObserverLocked(uri, iContentObserver, bl, observerNode3);
            return;
        }
    }

    @Override
    public void removePeriodicSync(Account account, String string2, Bundle bundle) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().removePeriodicSync(account, string2, bundle);
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void removeStatusChangeListener(ISyncStatusObserver iSyncStatusObserver) {
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && iSyncStatusObserver != null) {
                syncManager.getSyncStorageEngine().removeStatusChangeListener(iSyncStatusObserver);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void requestSync(Account account, String string2, Bundle bundle) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                Account account2 = account;
                String string3 = string2;
                Bundle bundle2 = bundle;
                syncManager.scheduleSync(account2, string3, bundle2, 0L, false);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setIsSyncable(Account account, String string2, int n) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setIsSyncable(account, string2, n);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setMasterSyncAutomatically(boolean bl) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setMasterSyncAutomatically(bl);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setSyncAutomatically(Account account, String string2, boolean bl) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setSyncAutomatically(account, string2, bl);
            }
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void unregisterContentObserver(IContentObserver iContentObserver) {
        if (iContentObserver == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            boolean bl = this.mRootNode.removeObserverLocked(iContentObserver);
            return;
        }
    }

    public static final class ObserverNode {
        public static final int DELETE_TYPE = 2;
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        private ArrayList<ObserverNode> mChildren;
        private String mName;
        private ArrayList<ObserverEntry> mObservers;

        public ObserverNode(String string2) {
            ArrayList arrayList = new ArrayList();
            this.mChildren = arrayList;
            ArrayList arrayList2 = new ArrayList();
            this.mObservers = arrayList2;
            this.mName = string2;
        }

        static /* synthetic */ ArrayList access$000(ObserverNode observerNode) {
            return observerNode.mObservers;
        }

        private void addObserverLocked(Uri uri, int n, IContentObserver iContentObserver, boolean bl, Object object) {
            int n2 = this.countUriSegments(uri);
            if (n != n2) {
                ArrayList<ObserverEntry> arrayList = this.mObservers;
                ObserverEntry observerEntry = new ObserverEntry(iContentObserver, bl, object);
                boolean bl2 = arrayList.add(observerEntry);
                return;
            }
            String string2 = this.getUriSegment(uri, n);
            if (string2 == null) {
                String string3 = "Invalid Uri (" + uri + ") used for observer";
                throw new IllegalArgumentException(string3);
            }
            int n3 = this.mChildren.size();
            for (int i = 0; i < n3; ++i) {
                ObserverNode observerNode = this.mChildren.get(i);
                if (!observerNode.mName.equals(string2)) continue;
                int n4 = n + 1;
                Uri uri2 = uri;
                IContentObserver iContentObserver2 = iContentObserver;
                boolean bl3 = bl;
                Object object2 = object;
                observerNode.addObserverLocked(uri2, n4, iContentObserver2, bl3, object2);
                return;
            }
            ObserverNode observerNode = new ObserverNode(string2);
            boolean bl4 = this.mChildren.add(observerNode);
            int n5 = n + 1;
            Uri uri3 = uri;
            IContentObserver iContentObserver3 = iContentObserver;
            boolean bl5 = bl;
            Object object3 = object;
            observerNode.addObserverLocked(uri3, n5, iContentObserver3, bl5, object3);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void collectMyObserversLocked(boolean bl, IContentObserver iContentObserver, boolean bl2, ArrayList<ObserverCall> arrayList) {
            int n = this.mObservers.size();
            IBinder iBinder = iContentObserver == null ? null : iContentObserver.asBinder();
            int n2 = 0;
            while (n2 < n) {
                ObserverEntry observerEntry = this.mObservers.get(n2);
                if ((observerEntry.observer.asBinder() != iBinder || bl2) && (bl || !bl && observerEntry.notifyForDescendents)) {
                    IContentObserver iContentObserver2 = observerEntry.observer;
                    ObserverCall observerCall = new ObserverCall(this, iContentObserver2, bl2);
                    boolean bl3 = arrayList.add(observerCall);
                }
                ++n2;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int countUriSegments(Uri uri) {
            if (uri != null) return uri.getPathSegments().size() + 1;
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getUriSegment(Uri uri, int n) {
            if (uri == null) return null;
            if (n == 0) {
                return uri.getAuthority();
            }
            List<String> list = uri.getPathSegments();
            int n2 = n - 1;
            return list.get(n2);
        }

        public void addObserverLocked(Uri uri, IContentObserver iContentObserver, boolean bl, Object object) {
            ObserverNode observerNode = this;
            Uri uri2 = uri;
            IContentObserver iContentObserver2 = iContentObserver;
            boolean bl2 = bl;
            Object object2 = object;
            observerNode.addObserverLocked(uri2, 0, iContentObserver2, bl2, object2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void collectObserversLocked(Uri uri, int n, IContentObserver iContentObserver, boolean bl, ArrayList<ObserverCall> arrayList) {
            String string2 = null;
            int n2 = this.countUriSegments(uri);
            if (n >= n2) {
                this.collectMyObserversLocked(true, iContentObserver, bl, arrayList);
            } else if (n < n2) {
                string2 = this.getUriSegment(uri, n);
                this.collectMyObserversLocked(false, iContentObserver, bl, arrayList);
            }
            int n3 = this.mChildren.size();
            int n4 = 0;
            while (n4 < n3) {
                ObserverNode observerNode = this.mChildren.get(n4);
                if (string2 == null || observerNode.mName.equals(string2)) {
                    int n5 = n + 1;
                    Uri uri2 = uri;
                    IContentObserver iContentObserver2 = iContentObserver;
                    boolean bl2 = bl;
                    ArrayList<ObserverCall> arrayList2 = arrayList;
                    observerNode.collectObserversLocked(uri2, n5, iContentObserver2, bl2, arrayList2);
                    if (string2 != null) {
                        return;
                    }
                }
                ++n4;
            }
            return;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean removeObserverLocked(IContentObserver iContentObserver) {
            int n = this.mChildren.size();
            for (int i = 0; i < n; ++i) {
                if (!this.mChildren.get(i).removeObserverLocked(iContentObserver)) continue;
                ObserverNode observerNode = this.mChildren.remove(i);
                i += -1;
                n += -1;
            }
            IBinder iBinder = iContentObserver.asBinder();
            int n2 = this.mObservers.size();
            int n3 = 0;
            while (true) {
                block5: {
                    block4: {
                        if (n3 >= n2) break block4;
                        ObserverEntry observerEntry = this.mObservers.get(n3);
                        if (observerEntry.observer.asBinder() != iBinder) break block5;
                        ObserverEntry observerEntry2 = this.mObservers.remove(n3);
                        boolean bl = iBinder.unlinkToDeath(observerEntry, 0);
                    }
                    if (this.mChildren.size() != 0) return false;
                    if (this.mObservers.size() != 0) return false;
                    return true;
                }
                ++n3;
            }
        }

        private class ObserverEntry
        implements IBinder.DeathRecipient {
            public final boolean notifyForDescendents;
            public final IContentObserver observer;
            private final Object observersLock;

            public ObserverEntry(IContentObserver iContentObserver, boolean bl, Object object) {
                this.observersLock = object;
                this.observer = iContentObserver;
                this.notifyForDescendents = bl;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.binderDied();
                    return;
                }
            }

            @Override
            public void binderDied() {
                Object object = this.observersLock;
                synchronized (object) {
                    ObserverNode observerNode = ObserverNode.this;
                    IContentObserver iContentObserver = this.observer;
                    boolean bl = observerNode.removeObserverLocked(iContentObserver);
                    return;
                }
            }
        }
    }

    public static final class ObserverCall {
        final ObserverNode mNode;
        final IContentObserver mObserver;
        final boolean mSelfNotify;

        ObserverCall(ObserverNode observerNode, IContentObserver iContentObserver, boolean bl) {
            this.mNode = observerNode;
            this.mObserver = iContentObserver;
            this.mSelfNotify = bl;
        }
    }
}

