/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ContentValues
implements Parcelable {
    public static final Parcelable.Creator<ContentValues> CREATOR = new Parcelable.Creator<ContentValues>(){

        @Override
        public ContentValues createFromParcel(Parcel parcel) {
            HashMap hashMap = parcel.readHashMap(null);
            return new ContentValues(hashMap);
        }

        public ContentValues[] newArray(int n) {
            return new ContentValues[n];
        }
    };
    public static final String TAG = "ContentValues";
    private HashMap<String, Object> mValues;

    public ContentValues() {
        HashMap hashMap = new HashMap(8);
        this.mValues = hashMap;
    }

    public ContentValues(int n) {
        HashMap hashMap = new HashMap(n, 1.0f);
        this.mValues = hashMap;
    }

    public ContentValues(ContentValues contentValues) {
        HashMap<String, Object> hashMap = contentValues.mValues;
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(hashMap);
        this.mValues = hashMap2;
    }

    private ContentValues(HashMap<String, Object> hashMap) {
        this.mValues = hashMap;
    }

    public void clear() {
        this.mValues.clear();
    }

    public boolean containsKey(String string2) {
        return this.mValues.containsKey(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof ContentValues)) {
            return false;
        }
        HashMap<String, Object> hashMap = this.mValues;
        HashMap<String, Object> hashMap2 = ((ContentValues)object).mValues;
        return hashMap.equals(hashMap2);
    }

    public Object get(String string2) {
        return this.mValues.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean getAsBoolean(String string2) {
        Object object = this.mValues.get(string2);
        try {
            return object = (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                return Boolean.valueOf(object.toString());
            }
            String string3 = "Cannot cast value for " + string2 + " to a Boolean: " + object;
            int n = Log.e(TAG, string3, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Byte getAsByte(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Byte by = ((Number)object).byteValue();
            return by;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Byte by = Byte.valueOf(object.toString());
                    return by;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Byte value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Byte: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getAsByteArray(String string2) {
        Object object = this.mValues.get(string2);
        if (!(object instanceof byte[])) return null;
        return (byte[])object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Double getAsDouble(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Double d = ((Number)object).doubleValue();
            return d;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Double d = Double.valueOf(object.toString());
                    return d;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Double value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Double: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Float getAsFloat(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Float f = Float.valueOf(((Number)object).floatValue());
            return f;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Float f = Float.valueOf(object.toString());
                    return f;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Float value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Float: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer getAsInteger(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Integer n = ((Number)object).intValue();
            return n;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Integer n = Integer.valueOf(object.toString());
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Integer value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Integer: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long getAsLong(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Long l = ((Number)object).longValue();
            return l;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Long l = Long.valueOf(object.toString());
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Long value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Long: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Short getAsShort(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Short s = ((Number)object).shortValue();
            return s;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    Short s = Short.valueOf(object.toString());
                    return s;
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = "Cannot parse Short value for " + object + " at key " + string2;
                    int n = Log.e(TAG, string3);
                    return null;
                }
            }
            String string4 = "Cannot cast value for " + string2 + " to a Short: " + object;
            int n = Log.e(TAG, string4, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAsString(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        return object.toString();
    }

    @Deprecated
    public ArrayList<String> getStringArrayList(String string2) {
        return (ArrayList)this.mValues.get(string2);
    }

    public int hashCode() {
        return this.mValues.hashCode();
    }

    public void put(String string2, Boolean bl) {
        Object object = this.mValues.put(string2, bl);
    }

    public void put(String string2, Byte by) {
        Object object = this.mValues.put(string2, by);
    }

    public void put(String string2, Double d) {
        Object object = this.mValues.put(string2, d);
    }

    public void put(String string2, Float f) {
        Object object = this.mValues.put(string2, f);
    }

    public void put(String string2, Integer n) {
        Object object = this.mValues.put(string2, n);
    }

    public void put(String string2, Long l) {
        Object object = this.mValues.put(string2, l);
    }

    public void put(String string2, Short s) {
        Object object = this.mValues.put(string2, s);
    }

    public void put(String string2, String string3) {
        Object object = this.mValues.put(string2, string3);
    }

    public void put(String string2, byte[] byArray) {
        Object object = this.mValues.put(string2, byArray);
    }

    public void putAll(ContentValues contentValues) {
        HashMap<String, Object> hashMap = this.mValues;
        HashMap<String, Object> hashMap2 = contentValues.mValues;
        hashMap.putAll(hashMap2);
    }

    public void putNull(String string2) {
        Object var2_2 = this.mValues.put(string2, null);
    }

    @Deprecated
    public void putStringArrayList(String string2, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = this.mValues.put(string2, arrayList);
    }

    public void remove(String string2) {
        Object object = this.mValues.remove(string2);
    }

    public int size() {
        return this.mValues.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.mValues.keySet()) {
            String string3 = this.getAsString(string2);
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder2 = stringBuilder.append(" ");
            }
            String string4 = string2 + "=" + string3;
            StringBuilder stringBuilder3 = stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mValues.entrySet();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        HashMap<String, Object> hashMap = this.mValues;
        parcel.writeMap(hashMap);
    }
}

