/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Entity;
import android.content.EntityIterator;
import android.database.Cursor;
import android.os.RemoteException;

public abstract class CursorEntityIterator
implements EntityIterator {
    private final Cursor mCursor;
    private boolean mIsClosed = false;

    public CursorEntityIterator(Cursor cursor) {
        this.mCursor = cursor;
        boolean bl = this.mCursor.moveToFirst();
    }

    @Override
    public final void close() {
        if (this.mIsClosed) {
            throw new IllegalStateException("closing when already closed");
        }
        this.mIsClosed = true;
        this.mCursor.close();
    }

    public abstract Entity getEntityAndIncrementCursor(Cursor var1) throws RemoteException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean hasNext() {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling hasNext() when the iterator is closed");
        }
        if (this.mCursor.isAfterLast()) return false;
        return true;
    }

    @Override
    public Entity next() {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling next() when the iterator is closed");
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("you may only call next() if hasNext() is true");
        }
        try {
            Cursor cursor = this.mCursor;
            Entity entity = this.getEntityAndIncrementCursor(cursor);
            return entity;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("caught a remote exception, this process will die soon", remoteException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported by EntityIterators");
    }

    @Override
    public final void reset() {
        if (this.mIsClosed) {
            throw new IllegalStateException("calling reset() when the iterator is closed");
        }
        boolean bl = this.mCursor.moveToFirst();
    }
}

