/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentInsertHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultDataHandler
implements ContentInsertHandler {
    private static final String ARG = "arg";
    private static final String COL = "col";
    private static final String DEL = "del";
    private static final String POSTFIX = "postfix";
    private static final String ROW = "row";
    private static final String SELECT = "select";
    private static final String URI_STR = "uri";
    private ContentResolver mContentResolver;
    private Stack<Uri> mUris;
    private ContentValues mValues;

    public DefaultDataHandler() {
        Stack stack = new Stack();
        this.mUris = stack;
    }

    private Uri insertRow() {
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri = (Uri)this.mUris.lastElement();
        ContentValues contentValues = this.mValues;
        Uri uri2 = contentResolver.insert(uri, contentValues);
        this.mValues = null;
        return uri2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseRow(Attributes attributes) throws SAXException {
        Uri uri;
        String string2 = attributes.getValue(URI_STR);
        if (string2 != null) {
            uri = Uri.parse(string2);
            if (uri == null) {
                StringBuilder stringBuilder = new StringBuilder().append("attribute ");
                String string3 = attributes.getValue(URI_STR);
                String string4 = stringBuilder.append(string3).append(" parsing failure").toString();
                throw new SAXException(string4);
            }
        } else {
            if (this.mUris.size() <= 0) {
                throw new SAXException("attribute parsing failure");
            }
            String string5 = attributes.getValue(POSTFIX);
            uri = string5 != null ? Uri.withAppendedPath((Uri)this.mUris.lastElement(), string5) : (Uri)this.mUris.lastElement();
        }
        Uri uri2 = this.mUris.push(uri);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (!ROW.equals(string3)) {
            return;
        }
        if (this.mUris.empty()) {
            throw new SAXException("uri mismatch");
        }
        if (this.mValues != null) {
            Uri uri = this.insertRow();
        }
        Uri uri = this.mUris.pop();
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void insert(ContentResolver contentResolver, InputStream inputStream) throws IOException, SAXException {
        this.mContentResolver = contentResolver;
        Xml.Encoding encoding = Xml.Encoding.UTF_8;
        Xml.parse(inputStream, encoding, this);
    }

    @Override
    public void insert(ContentResolver contentResolver, String string2) throws SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(string2, (ContentHandler)this);
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (ROW.equals(string3)) {
            if (this.mValues != null) {
                if (this.mUris.empty()) {
                    throw new SAXException("uri is empty");
                }
                Uri uri = this.insertRow();
                if (uri == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("insert to uri ");
                    String string5 = ((Uri)this.mUris.lastElement()).toString();
                    String string6 = stringBuilder.append(string5).append(" failure").toString();
                    throw new SAXException(string6);
                }
                Uri uri2 = this.mUris.pop();
                Uri uri3 = this.mUris.push(uri);
                this.parseRow(attributes);
                return;
            }
            if (attributes.getLength() == 0) {
                Stack<Uri> stack = this.mUris;
                Object e = this.mUris.lastElement();
                Uri uri = stack.push((Uri)e);
                return;
            }
            this.parseRow(attributes);
            return;
        }
        if (COL.equals(string3)) {
            int n = attributes.getLength();
            if (n != 2) {
                String string7 = "illegal attributes number " + n;
                throw new SAXException(string7);
            }
            String string8 = attributes.getValue(0);
            String string9 = attributes.getValue(1);
            if (string8 != null && string8.length() > 0 && string9 != null && string9.length() > 0) {
                if (this.mValues == null) {
                    ContentValues contentValues;
                    this.mValues = contentValues = new ContentValues();
                }
                this.mValues.put(string8, string9);
                return;
            }
            throw new SAXException("illegal attributes value");
        }
        if (DEL.equals(string3)) {
            Uri uri = Uri.parse(attributes.getValue(URI_STR));
            if (uri == null) {
                StringBuilder stringBuilder = new StringBuilder().append("attribute ");
                String string10 = attributes.getValue(URI_STR);
                String string11 = stringBuilder.append(string10).append(" parsing failure").toString();
                throw new SAXException(string11);
            }
            int n = attributes.getLength() - 2;
            if (n > 0) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string12;
                    int n2 = i + 2;
                    stringArray[i] = string12 = attributes.getValue(n2);
                }
                ContentResolver contentResolver = this.mContentResolver;
                String string13 = attributes.getValue(1);
                int n3 = contentResolver.delete(uri, string13, stringArray);
                return;
            }
            if (n == 0) {
                ContentResolver contentResolver = this.mContentResolver;
                String string14 = attributes.getValue(1);
                int n4 = contentResolver.delete(uri, string14, null);
                return;
            }
            int n5 = this.mContentResolver.delete(uri, null, null);
            return;
        }
        String string15 = "unknown element: " + string3;
        throw new SAXException(string15);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }
}

