/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncStatusInfo;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IContentService
extends IInterface {
    public void addPeriodicSync(Account var1, String var2, Bundle var3, long var4) throws RemoteException;

    public void addStatusChangeListener(int var1, ISyncStatusObserver var2) throws RemoteException;

    public void cancelSync(Account var1, String var2) throws RemoteException;

    public SyncInfo getCurrentSync() throws RemoteException;

    public int getIsSyncable(Account var1, String var2) throws RemoteException;

    public boolean getMasterSyncAutomatically() throws RemoteException;

    public List<PeriodicSync> getPeriodicSyncs(Account var1, String var2) throws RemoteException;

    public SyncAdapterType[] getSyncAdapterTypes() throws RemoteException;

    public boolean getSyncAutomatically(Account var1, String var2) throws RemoteException;

    public SyncStatusInfo getSyncStatus(Account var1, String var2) throws RemoteException;

    public boolean isSyncActive(Account var1, String var2) throws RemoteException;

    public boolean isSyncPending(Account var1, String var2) throws RemoteException;

    public void notifyChange(Uri var1, IContentObserver var2, boolean var3, boolean var4) throws RemoteException;

    public void registerContentObserver(Uri var1, boolean var2, IContentObserver var3) throws RemoteException;

    public void removePeriodicSync(Account var1, String var2, Bundle var3) throws RemoteException;

    public void removeStatusChangeListener(ISyncStatusObserver var1) throws RemoteException;

    public void requestSync(Account var1, String var2, Bundle var3) throws RemoteException;

    public void setIsSyncable(Account var1, String var2, int var3) throws RemoteException;

    public void setMasterSyncAutomatically(boolean var1) throws RemoteException;

    public void setSyncAutomatically(Account var1, String var2, boolean var3) throws RemoteException;

    public void unregisterContentObserver(IContentObserver var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentService {
        private static final String DESCRIPTOR = "android.content.IContentService";
        static final int TRANSACTION_addPeriodicSync = 9;
        static final int TRANSACTION_addStatusChangeListener = 20;
        static final int TRANSACTION_cancelSync = 5;
        static final int TRANSACTION_getCurrentSync = 16;
        static final int TRANSACTION_getIsSyncable = 11;
        static final int TRANSACTION_getMasterSyncAutomatically = 14;
        static final int TRANSACTION_getPeriodicSyncs = 8;
        static final int TRANSACTION_getSyncAdapterTypes = 17;
        static final int TRANSACTION_getSyncAutomatically = 6;
        static final int TRANSACTION_getSyncStatus = 18;
        static final int TRANSACTION_isSyncActive = 15;
        static final int TRANSACTION_isSyncPending = 19;
        static final int TRANSACTION_notifyChange = 3;
        static final int TRANSACTION_registerContentObserver = 1;
        static final int TRANSACTION_removePeriodicSync = 10;
        static final int TRANSACTION_removeStatusChangeListener = 21;
        static final int TRANSACTION_requestSync = 4;
        static final int TRANSACTION_setIsSyncable = 12;
        static final int TRANSACTION_setMasterSyncAutomatically = 13;
        static final int TRANSACTION_setSyncAutomatically = 7;
        static final int TRANSACTION_unregisterContentObserver = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IContentService asInterface(IBinder iBinder) {
            void var1_2;
            if (iBinder == null) {
                return var1_2;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IContentService) {
                IContentService iContentService = (IContentService)iInterface;
                return var1_2;
            }
            Proxy proxy = new Proxy(iBinder);
            return var1_2;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    void var7_52;
                    void var6_7;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Uri uri = Uri.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_8 = null;
                    }
                    if (parcel.readInt() != 0) {
                        Object var7_51 = null;
                    } else {
                        Object var7_53 = null;
                    }
                    IContentObserver iContentObserver = IContentObserver.Stub.asInterface(parcel.readStrongBinder());
                    this.registerContentObserver((Uri)var6_7, (boolean)var7_52, iContentObserver);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IContentObserver iContentObserver = IContentObserver.Stub.asInterface(parcel.readStrongBinder());
                    this.unregisterContentObserver(iContentObserver);
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    void var10_62;
                    void var6_10;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Uri uri = Uri.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_11 = null;
                    }
                    IContentObserver iContentObserver = IContentObserver.Stub.asInterface(parcel.readStrongBinder());
                    if (parcel.readInt() != 0) {
                        Object var10_61 = null;
                    } else {
                        Object var10_63 = null;
                    }
                    boolean bl = parcel.readInt() != 0;
                    this.notifyChange((Uri)var6_10, iContentObserver, (boolean)var10_62, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    void var10_65;
                    void var6_13;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_14 = null;
                    }
                    String string2 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Bundle bundle = Bundle.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var10_66 = null;
                    }
                    this.requestSync((Account)var6_13, string2, (Bundle)var10_65);
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    void var6_16;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_17 = null;
                    }
                    String string3 = parcel.readString();
                    this.cancelSync((Account)var6_16, string3);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    void var6_19;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_20 = null;
                    }
                    String string4 = parcel.readString();
                    boolean bl = this.getSyncAutomatically((Account)var6_19, string4);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 7: {
                    void var10_68;
                    void var6_22;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_23 = null;
                    }
                    String string5 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Object var10_67 = null;
                    } else {
                        Object var10_69 = null;
                    }
                    this.setSyncAutomatically((Account)var6_22, string5, (boolean)var10_68);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    void var6_25;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_26 = null;
                    }
                    String string6 = parcel.readString();
                    List<PeriodicSync> list = this.getPeriodicSyncs((Account)var6_25, string6);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 9: {
                    void var10_71;
                    void var6_28;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_29 = null;
                    }
                    String string7 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Bundle bundle = Bundle.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var10_72 = null;
                    }
                    long l = parcel.readLong();
                    this.addPeriodicSync((Account)var6_28, string7, (Bundle)var10_71, l);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    void var10_74;
                    void var6_31;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_32 = null;
                    }
                    String string8 = parcel.readString();
                    if (parcel.readInt() != 0) {
                        Bundle bundle = Bundle.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var10_75 = null;
                    }
                    this.removePeriodicSync((Account)var6_31, string8, (Bundle)var10_74);
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    void var6_34;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_35 = null;
                    }
                    String string9 = parcel.readString();
                    int n4 = this.getIsSyncable((Account)var6_34, string9);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 12: {
                    void var6_37;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_38 = null;
                    }
                    String string10 = parcel.readString();
                    int n5 = parcel.readInt();
                    this.setIsSyncable((Account)var6_37, string10, n5);
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    void var6_40;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Object var6_39 = null;
                    } else {
                        Object var6_41 = null;
                    }
                    this.setMasterSyncAutomatically((boolean)var6_40);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getMasterSyncAutomatically();
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 15: {
                    void var6_43;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_44 = null;
                    }
                    String string11 = parcel.readString();
                    boolean bl = this.isSyncActive((Account)var6_43, string11);
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    SyncInfo syncInfo = this.getCurrentSync();
                    parcel2.writeNoException();
                    if (syncInfo != null) {
                        parcel2.writeInt(1);
                        syncInfo.writeToParcel(parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getSyncAdapterTypes();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 18: {
                    void var6_46;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_47 = null;
                    }
                    String string12 = parcel.readString();
                    SyncStatusInfo syncStatusInfo = this.getSyncStatus((Account)var6_46, string12);
                    parcel2.writeNoException();
                    if (syncStatusInfo != null) {
                        parcel2.writeInt(1);
                        syncStatusInfo.writeToParcel(parcel2, 1);
                        return true;
                    } else {
                        parcel2.writeInt(0);
                    }
                    return true;
                }
                case 19: {
                    void var6_49;
                    parcel.enforceInterface(DESCRIPTOR);
                    if (parcel.readInt() != 0) {
                        Account account = Account.CREATOR.createFromParcel(parcel);
                    } else {
                        Object var6_50 = null;
                    }
                    String string13 = parcel.readString();
                    boolean bl = this.isSyncPending((Account)var6_49, string13);
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = parcel.readInt();
                    ISyncStatusObserver iSyncStatusObserver = ISyncStatusObserver.Stub.asInterface(parcel.readStrongBinder());
                    this.addStatusChangeListener(n9, iSyncStatusObserver);
                    parcel2.writeNoException();
                    return true;
                }
                case 21: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            ISyncStatusObserver iSyncStatusObserver = ISyncStatusObserver.Stub.asInterface(parcel.readStrongBinder());
            this.removeStatusChangeListener(iSyncStatusObserver);
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements IContentService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addPeriodicSync(Account account, String string2, Bundle bundle, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeLong(l);
                    boolean bl = this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addStatusChangeListener(int n, ISyncStatusObserver iSyncStatusObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    IBinder iBinder = iSyncStatusObserver != null ? iSyncStatusObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void cancelSync(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SyncInfo getCurrentSync() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    SyncInfo syncInfo = parcel2.readInt() != 0 ? SyncInfo.CREATOR.createFromParcel(parcel2) : null;
                    return syncInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getIsSyncable(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean getMasterSyncAutomatically() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl2 = n != 0;
                    return bl2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<PeriodicSync> getPeriodicSyncs(Account account, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    ArrayList<PeriodicSync> arrayList;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<PeriodicSync> creator = PeriodicSync.CREATOR;
                    ArrayList<PeriodicSync> arrayList2 = arrayList = parcel2.createTypedArrayList(creator);
                    parcel2.recycle();
                    parcel.recycle();
                    return arrayList2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public SyncAdapterType[] getSyncAdapterTypes() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    Parcelable.Creator<SyncAdapterType> creator = SyncAdapterType.CREATOR;
                    SyncAdapterType[] syncAdapterTypeArray = parcel2.createTypedArray(creator);
                    return syncAdapterTypeArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean getSyncAutomatically(Account account, String string2) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl2 = this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public SyncStatusInfo getSyncStatus(Account account, String string2) throws RemoteException {
                SyncStatusInfo syncStatusInfo;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl = this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    syncStatusInfo = parcel2.readInt() != 0 ? SyncStatusInfo.CREATOR.createFromParcel(parcel2) : null;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return syncStatusInfo;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isSyncActive(Account account, String string2) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl2 = this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isSyncPending(Account account, String string2) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    boolean bl2 = this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    bl = n != 0;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyChange(Uri uri, IContentObserver iContentObserver, boolean bl, boolean bl2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = iContentObserver != null ? iContentObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    iBinder = bl2 ? null : null;
                    parcel.writeInt((int)iBinder);
                    boolean bl3 = this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerContentObserver(Uri uri, boolean bl, IContentObserver iContentObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    IBinder iBinder;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        iBinder = null;
                        parcel.writeInt((int)iBinder);
                    }
                    iBinder = bl ? null : null;
                    parcel.writeInt((int)iBinder);
                    iBinder = iContentObserver != null ? iContentObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl2 = this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removePeriodicSync(Account account, String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeStatusChangeListener(ISyncStatusObserver iSyncStatusObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iSyncStatusObserver != null ? iSyncStatusObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestSync(Account account, String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    boolean bl = this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setIsSyncable(Account account, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        int n2 = 0;
                        parcel.writeInt(n2);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    boolean bl = this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setMasterSyncAutomatically(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setSyncAutomatically(Account account, String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    int n;
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (account != null) {
                        parcel.writeInt(1);
                        account.writeToParcel(parcel, 0);
                    } else {
                        n = 0;
                        parcel.writeInt(n);
                    }
                    parcel.writeString(string2);
                    n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    boolean bl2 = this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterContentObserver(IContentObserver iContentObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iContentObserver != null ? iContentObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

