/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.AndroidException;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable {
    private static final String ACTION_STR = "action";
    private static final String AUTH_STR = "auth";
    private static final String CAT_STR = "cat";
    public static final Parcelable.Creator<IntentFilter> CREATOR = new Parcelable.Creator<IntentFilter>(){

        @Override
        public IntentFilter createFromParcel(Parcel parcel) {
            return new IntentFilter(parcel);
        }

        public IntentFilter[] newArray(int n) {
            return new IntentFilter[n];
        }
    };
    private static final String HOST_STR = "host";
    private static final String LITERAL_STR = "literal";
    public static final int MATCH_ADJUSTMENT_MASK = 65535;
    public static final int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static final int MATCH_CATEGORY_EMPTY = 0x100000;
    public static final int MATCH_CATEGORY_HOST = 0x300000;
    public static final int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static final int MATCH_CATEGORY_PATH = 0x500000;
    public static final int MATCH_CATEGORY_PORT = 0x400000;
    public static final int MATCH_CATEGORY_SCHEME = 0x200000;
    public static final int MATCH_CATEGORY_TYPE = 0x600000;
    private static final String NAME_STR = "name";
    public static final int NO_MATCH_ACTION = 253;
    public static final int NO_MATCH_CATEGORY = 252;
    public static final int NO_MATCH_DATA = 254;
    public static final int NO_MATCH_TYPE = 255;
    private static final String PATH_STR = "path";
    private static final String PORT_STR = "port";
    private static final String PREFIX_STR = "prefix";
    private static final String SCHEME_STR = "scheme";
    private static final String SGLOB_STR = "sglob";
    public static final int SYSTEM_HIGH_PRIORITY = 1000;
    public static final int SYSTEM_LOW_PRIORITY = 64536;
    private static final String TYPE_STR = "type";
    private final ArrayList<String> mActions;
    private ArrayList<String> mCategories = null;
    private ArrayList<AuthorityEntry> mDataAuthorities = null;
    private ArrayList<PatternMatcher> mDataPaths = null;
    private ArrayList<String> mDataSchemes = null;
    private ArrayList<String> mDataTypes = null;
    private boolean mHasPartialTypes = false;
    private int mPriority;

    public IntentFilter() {
        this.mPriority = 0;
        ArrayList arrayList = new ArrayList();
        this.mActions = arrayList;
    }

    public IntentFilter(IntentFilter intentFilter) {
        boolean bl;
        int n;
        this.mPriority = n = intentFilter.mPriority;
        ArrayList<String> arrayList = intentFilter.mActions;
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
        this.mActions = arrayList2;
        if (intentFilter.mCategories != null) {
            ArrayList<String> arrayList3 = intentFilter.mCategories;
            ArrayList<String> arrayList4 = new ArrayList<String>(arrayList3);
            this.mCategories = arrayList4;
        }
        if (intentFilter.mDataTypes != null) {
            ArrayList<String> arrayList5 = intentFilter.mDataTypes;
            ArrayList<String> arrayList6 = new ArrayList<String>(arrayList5);
            this.mDataTypes = arrayList6;
        }
        if (intentFilter.mDataSchemes != null) {
            ArrayList<String> arrayList7 = intentFilter.mDataSchemes;
            ArrayList<String> arrayList8 = new ArrayList<String>(arrayList7);
            this.mDataSchemes = arrayList8;
        }
        if (intentFilter.mDataAuthorities != null) {
            ArrayList<AuthorityEntry> arrayList9 = intentFilter.mDataAuthorities;
            ArrayList<AuthorityEntry> arrayList10 = new ArrayList<AuthorityEntry>(arrayList9);
            this.mDataAuthorities = arrayList10;
        }
        if (intentFilter.mDataPaths != null) {
            ArrayList<PatternMatcher> arrayList11 = intentFilter.mDataPaths;
            ArrayList<PatternMatcher> arrayList12 = new ArrayList<PatternMatcher>(arrayList11);
            this.mDataPaths = arrayList12;
        }
        this.mHasPartialTypes = bl = intentFilter.mHasPartialTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IntentFilter(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = this.mActions = arrayList;
        parcel.readStringList(arrayList2);
        if (parcel.readInt() != 0) {
            ArrayList arrayList3 = new ArrayList();
            ArrayList<String> arrayList4 = this.mCategories = arrayList3;
            parcel.readStringList(arrayList4);
        }
        if (parcel.readInt() != 0) {
            ArrayList arrayList5 = new ArrayList();
            ArrayList<String> arrayList6 = this.mDataSchemes = arrayList5;
            parcel.readStringList(arrayList6);
        }
        if (parcel.readInt() != 0) {
            ArrayList arrayList7 = new ArrayList();
            ArrayList<String> arrayList8 = this.mDataTypes = arrayList7;
            parcel.readStringList(arrayList8);
        }
        if ((n4 = parcel.readInt()) > 0) {
            ArrayList arrayList9 = new ArrayList();
            this.mDataAuthorities = arrayList9;
            for (n3 = 0; n3 < n4; ++n3) {
                ArrayList<AuthorityEntry> arrayList10 = this.mDataAuthorities;
                AuthorityEntry authorityEntry = new AuthorityEntry(parcel);
                boolean bl = arrayList10.add(authorityEntry);
            }
        }
        if ((n2 = parcel.readInt()) > 0) {
            ArrayList arrayList11 = new ArrayList();
            this.mDataPaths = arrayList11;
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList<PatternMatcher> arrayList12 = this.mDataPaths;
                PatternMatcher patternMatcher = new PatternMatcher(parcel);
                boolean bl = arrayList12.add(patternMatcher);
            }
        }
        this.mPriority = n = parcel.readInt();
        boolean bl = parcel.readInt() > 0;
        this.mHasPartialTypes = bl;
    }

    public IntentFilter(String string2) {
        this.mPriority = 0;
        ArrayList arrayList = new ArrayList();
        this.mActions = arrayList;
        this.addAction(string2);
    }

    public IntentFilter(String string2, String string3) throws MalformedMimeTypeException {
        this.mPriority = 0;
        ArrayList arrayList = new ArrayList();
        this.mActions = arrayList;
        this.addAction(string2);
        this.addDataType(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] addStringToSet(String[] stringArray, String string2, int[] nArray, int n) {
        int n2;
        if (IntentFilter.findStringInSet(stringArray, string2, nArray, n) >= 0) {
            return stringArray;
        }
        if (stringArray == null) {
            stringArray = new String[2];
            stringArray[0] = string2;
            nArray[n] = 1;
            return stringArray;
        }
        int n3 = nArray[n];
        int n4 = stringArray.length;
        if (n3 < n4) {
            int n5;
            stringArray[n3] = string2;
            nArray[n] = n5 = n3 + 1;
            return stringArray;
        }
        String[] stringArray2 = new String[n3 * 3 / 2 + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        stringArray = stringArray2;
        stringArray[n3] = string2;
        nArray[n] = n2 = n3 + 1;
        return stringArray;
    }

    public static IntentFilter create(String string2, String string3) {
        try {
            IntentFilter intentFilter = new IntentFilter(string2, string3);
            return intentFilter;
        }
        catch (MalformedMimeTypeException malformedMimeTypeException) {
            throw new RuntimeException("Bad MIME type", malformedMimeTypeException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean findMimeType(String string2) {
        int n;
        String string3;
        String string4;
        ArrayList<String> arrayList = this.mDataTypes;
        if (string2 == null) {
            return false;
        }
        if (arrayList.contains(string2)) {
            return true;
        }
        int n2 = string2.length();
        if (n2 == 3 && string2.equals("*/*")) {
            if (arrayList.isEmpty()) return false;
            return true;
        }
        if (this.mHasPartialTypes && arrayList.contains("*")) {
            return true;
        }
        int n3 = string2.indexOf(47);
        if (n3 <= 0) return false;
        if (this.mHasPartialTypes && arrayList.contains(string4 = string2.substring(0, n3))) {
            return true;
        }
        int n4 = n3 + 2;
        if (n2 == n4) return false;
        int n5 = n3 + 1;
        if (string2.charAt(n5) != '*') return false;
        Iterator<String> iterator = arrayList.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!string2.regionMatches(0, string3 = iterator.next(), 0, n = n3 + 1));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findStringInSet(String[] stringArray, String string2, int[] nArray, int n) {
        if (stringArray == null) {
            return -1;
        }
        int n2 = nArray[n];
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3].equals(string2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] removeStringFromSet(String[] stringArray, String string2, int[] nArray, int n) {
        int n2 = IntentFilter.findStringInSet(stringArray, string2, nArray, n);
        if (n2 < 0) {
            return stringArray;
        }
        int n3 = nArray[n];
        int n4 = stringArray.length / 4;
        if (n3 > n4) {
            int n5;
            int n6 = n2 + 1;
            int n7 = n3 - n6;
            if (n7 > 0) {
                int n8 = n2 + 1;
                System.arraycopy(stringArray, n8, stringArray, n2, n7);
            }
            int n9 = n3 - 1;
            stringArray[n9] = null;
            nArray[n] = n5 = n3 - 1;
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length / 3];
        if (n2 > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        }
        if (n2 + 1 >= n3) return stringArray2;
        int n10 = n2 + 1;
        int n11 = n2 + 1;
        int n12 = n3 - n11;
        System.arraycopy(stringArray, n10, stringArray2, n2, n12);
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<String> actionsIterator() {
        if (this.mActions == null) return null;
        return this.mActions.iterator();
    }

    public final void addAction(String string2) {
        if (this.mActions.contains(string2)) {
            return;
        }
        ArrayList<String> arrayList = this.mActions;
        String string3 = string2.intern();
        boolean bl = arrayList.add(string3);
    }

    public final void addCategory(String string2) {
        if (this.mCategories == null) {
            ArrayList arrayList = new ArrayList();
            this.mCategories = arrayList;
        }
        if (this.mCategories.contains(string2)) {
            return;
        }
        ArrayList<String> arrayList = this.mCategories;
        String string3 = string2.intern();
        boolean bl = arrayList.add(string3);
    }

    public final void addDataAuthority(String string2, String string3) {
        if (this.mDataAuthorities == null) {
            ArrayList arrayList = new ArrayList();
            this.mDataAuthorities = arrayList;
        }
        if (string3 != null) {
            string3 = string3.intern();
        }
        ArrayList<AuthorityEntry> arrayList = this.mDataAuthorities;
        String string4 = string2.intern();
        AuthorityEntry authorityEntry = new AuthorityEntry(string4, string3);
        boolean bl = arrayList.add(authorityEntry);
    }

    public final void addDataPath(String string2, int n) {
        if (this.mDataPaths == null) {
            ArrayList arrayList = new ArrayList();
            this.mDataPaths = arrayList;
        }
        ArrayList<PatternMatcher> arrayList = this.mDataPaths;
        String string3 = string2.intern();
        PatternMatcher patternMatcher = new PatternMatcher(string3, n);
        boolean bl = arrayList.add(patternMatcher);
    }

    public final void addDataScheme(String string2) {
        if (this.mDataSchemes == null) {
            ArrayList arrayList = new ArrayList();
            this.mDataSchemes = arrayList;
        }
        if (this.mDataSchemes.contains(string2)) {
            return;
        }
        ArrayList<String> arrayList = this.mDataSchemes;
        String string3 = string2.intern();
        boolean bl = arrayList.add(string3);
    }

    public final void addDataType(String string2) throws MalformedMimeTypeException {
        int n;
        int n2 = string2.indexOf(47);
        int n3 = string2.length();
        if (n2 > 0 && n3 >= (n = n2 + 2)) {
            int n4;
            int n5;
            if (this.mDataTypes == null) {
                ArrayList arrayList = new ArrayList();
                this.mDataTypes = arrayList;
            }
            if (n3 != (n5 = n2 + 2) && string2.charAt(n4 = n2 + 1) == '*') {
                String string3 = string2.substring(0, n2);
                if (!this.mDataTypes.contains(string3)) {
                    ArrayList<String> arrayList = this.mDataTypes;
                    String string4 = string3.intern();
                    boolean bl = arrayList.add(string4);
                }
                this.mHasPartialTypes = true;
                return;
            }
            if (this.mDataTypes.contains(string2)) {
                return;
            }
            ArrayList<String> arrayList = this.mDataTypes;
            String string5 = string2.intern();
            boolean bl = arrayList.add(string5);
            return;
        }
        throw new MalformedMimeTypeException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<AuthorityEntry> authoritiesIterator() {
        if (this.mDataAuthorities == null) return null;
        return this.mDataAuthorities.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<String> categoriesIterator() {
        if (this.mCategories == null) return null;
        return this.mCategories.iterator();
    }

    public final int countActions() {
        return this.mActions.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int countCategories() {
        if (this.mCategories == null) return 0;
        return this.mCategories.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int countDataAuthorities() {
        if (this.mDataAuthorities == null) return 0;
        return this.mDataAuthorities.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int countDataPaths() {
        if (this.mDataPaths == null) return 0;
        return this.mDataPaths.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int countDataSchemes() {
        if (this.mDataSchemes == null) return 0;
        return this.mDataSchemes.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int countDataTypes() {
        if (this.mDataTypes == null) return 0;
        return this.mDataTypes.size();
    }

    public boolean debugCheck() {
        return true;
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        Iterator<String> iterator;
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            iterator = this.mActions.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                StringBuilder stringBuilder3 = stringBuilder.append("Action: \"");
                String string3 = iterator.next();
                StringBuilder stringBuilder4 = stringBuilder.append(string3);
                StringBuilder stringBuilder5 = stringBuilder.append("\"");
                String string4 = stringBuilder.toString();
                printer.println(string4);
            }
        }
        if (this.mCategories != null) {
            iterator = this.mCategories.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder6 = stringBuilder.append(string2);
                StringBuilder stringBuilder7 = stringBuilder.append("Category: \"");
                String string5 = iterator.next();
                StringBuilder stringBuilder8 = stringBuilder.append(string5);
                StringBuilder stringBuilder9 = stringBuilder.append("\"");
                String string6 = stringBuilder.toString();
                printer.println(string6);
            }
        }
        if (this.mDataSchemes != null) {
            iterator = this.mDataSchemes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder10 = stringBuilder.append(string2);
                StringBuilder stringBuilder11 = stringBuilder.append("Scheme: \"");
                String string7 = iterator.next();
                StringBuilder stringBuilder12 = stringBuilder.append(string7);
                StringBuilder stringBuilder13 = stringBuilder.append("\"");
                String string8 = stringBuilder.toString();
                printer.println(string8);
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry authorityEntry : this.mDataAuthorities) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder14 = stringBuilder.append(string2);
                StringBuilder stringBuilder15 = stringBuilder.append("Authority: \"");
                String string9 = authorityEntry.mHost;
                StringBuilder stringBuilder16 = stringBuilder.append(string9);
                StringBuilder stringBuilder17 = stringBuilder.append("\": ");
                int n = authorityEntry.mPort;
                StringBuilder stringBuilder18 = stringBuilder.append(n);
                if (authorityEntry.mWild) {
                    StringBuilder stringBuilder19 = stringBuilder.append(" WILD");
                }
                String string10 = stringBuilder.toString();
                printer.println(string10);
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher patternMatcher : this.mDataPaths) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder20 = stringBuilder.append(string2);
                StringBuilder stringBuilder21 = stringBuilder.append("Path: \"");
                StringBuilder stringBuilder22 = stringBuilder.append(patternMatcher);
                StringBuilder stringBuilder23 = stringBuilder.append("\"");
                String string11 = stringBuilder.toString();
                printer.println(string11);
            }
        }
        if (this.mDataTypes != null) {
            iterator = this.mDataTypes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                StringBuilder stringBuilder24 = stringBuilder.append(string2);
                StringBuilder stringBuilder25 = stringBuilder.append("Type: \"");
                String string12 = iterator.next();
                StringBuilder stringBuilder26 = stringBuilder.append(string12);
                StringBuilder stringBuilder27 = stringBuilder.append("\"");
                String string13 = stringBuilder.toString();
                printer.println(string13);
            }
        }
        if (this.mPriority == 0 && !this.mHasPartialTypes) {
            return;
        }
        stringBuilder.setLength(0);
        StringBuilder stringBuilder28 = stringBuilder.append(string2);
        StringBuilder stringBuilder29 = stringBuilder.append("mPriority=");
        int n = this.mPriority;
        StringBuilder stringBuilder30 = stringBuilder.append(n);
        StringBuilder stringBuilder31 = stringBuilder.append(", mHasPartialTypes=");
        boolean bl = this.mHasPartialTypes;
        StringBuilder stringBuilder32 = stringBuilder.append(bl);
        String string14 = stringBuilder.toString();
        printer.println(string14);
    }

    public final String getAction(int n) {
        return this.mActions.get(n);
    }

    public final String getCategory(int n) {
        return this.mCategories.get(n);
    }

    public final AuthorityEntry getDataAuthority(int n) {
        return this.mDataAuthorities.get(n);
    }

    public final PatternMatcher getDataPath(int n) {
        return this.mDataPaths.get(n);
    }

    public final String getDataScheme(int n) {
        return this.mDataSchemes.get(n);
    }

    public final String getDataType(int n) {
        return this.mDataTypes.get(n);
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final boolean hasAction(String string2) {
        return this.mActions.contains(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCategory(String string2) {
        if (this.mCategories == null) return false;
        if (!this.mCategories.contains(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasDataAuthority(Uri uri) {
        if (this.matchDataAuthority(uri) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasDataPath(String string2) {
        if (this.mDataPaths == null) {
            return false;
        }
        Iterator<PatternMatcher> iterator = this.mDataPaths.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!iterator.next().match(string2));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasDataScheme(String string2) {
        if (this.mDataSchemes == null) return false;
        if (!this.mDataSchemes.contains(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasDataType(String string2) {
        if (this.mDataTypes == null) return false;
        if (!this.findMimeType(string2)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int match(ContentResolver contentResolver, Intent intent, boolean bl, String string2) {
        String string3 = bl ? intent.resolveType(contentResolver) : intent.getType();
        String string4 = intent.getAction();
        String string5 = intent.getScheme();
        Uri uri = intent.getData();
        Set<String> set = intent.getCategories();
        IntentFilter intentFilter = this;
        String string6 = string2;
        return intentFilter.match(string4, string3, string5, uri, set, string6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int match(String string2, String string3, String string4, Uri uri, Set<String> set, String string5) {
        if (string2 != null && !this.matchAction(string2)) {
            return -1;
        }
        int n = this.matchData(string3, string4, uri);
        if (n < 0) {
            return n;
        }
        if (this.matchCategories(set) == null) return n;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchAction(String string2) {
        if (string2 == null) return false;
        if (this.mActions == null) return false;
        if (this.mActions.size() != 0) return this.mActions.contains(string2);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String matchCategories(Set<String> set) {
        String string2;
        if (set == null) {
            return null;
        }
        Iterator<String> iterator = set.iterator();
        if (this.mCategories == null) {
            if (!iterator.hasNext()) return null;
            return iterator.next();
        }
        do {
            if (!iterator.hasNext()) return null;
        } while (this.mCategories.contains(string2 = iterator.next()));
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int matchData(String string2, String string3, Uri uri) {
        ArrayList<String> arrayList = this.mDataTypes;
        ArrayList<String> arrayList2 = this.mDataSchemes;
        ArrayList<AuthorityEntry> arrayList3 = this.mDataAuthorities;
        ArrayList<PatternMatcher> arrayList4 = this.mDataPaths;
        int n = 0x100000;
        if (arrayList == null && arrayList2 == null) {
            if (string2 != null) return -1;
            if (uri != null) return -1;
            return 0x108000;
        }
        if (arrayList2 != null) {
            String string4 = string3 != null ? string3 : "";
            if (!arrayList2.contains(string4)) {
                return -1;
            }
            n = 0x200000;
            if (arrayList3 != null) {
                int n2 = this.matchDataAuthority(uri);
                if (n2 < 0) {
                    return -1;
                }
                if (arrayList4 == null) {
                    int n3 = n2;
                } else {
                    String string5 = uri.getPath();
                    if (!this.hasDataPath(string5)) {
                        return -1;
                    }
                    n = 0x500000;
                }
            }
        } else if (!(string3 == null || "".equals(string3) || "content".equals(string3) || "file".equals(string3))) {
            return -1;
        }
        if (arrayList != null) {
            if (this.findMimeType(string2)) return 0x608000;
            return -1;
        }
        if (string2 == null) return 32768 + n;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int matchDataAuthority(Uri uri) {
        int n;
        if (this.mDataAuthorities == null) {
            return -1;
        }
        Iterator<AuthorityEntry> iterator = this.mDataAuthorities.iterator();
        do {
            if (!iterator.hasNext()) return -1;
        } while ((n = iterator.next().match(uri)) < 0);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<PatternMatcher> pathsIterator() {
        if (this.mDataPaths == null) return null;
        return this.mDataPaths.iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getDepth();
        while (true) {
            block14: {
                String string2;
                block19: {
                    String string3;
                    block20: {
                        block18: {
                            block17: {
                                String string4;
                                block16: {
                                    block15: {
                                        block13: {
                                            int n2;
                                            if ((n2 = xmlPullParser.next()) == 1) {
                                                return;
                                            }
                                            if (n2 == 3 && xmlPullParser.getDepth() <= n) {
                                                return;
                                            }
                                            if (n2 == 3 || n2 == 4) continue;
                                            string2 = xmlPullParser.getName();
                                            if (!string2.equals(ACTION_STR)) break block13;
                                            string4 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                            if (string4 != null) {
                                                this.addAction(string4);
                                            }
                                            break block14;
                                        }
                                        if (!string2.equals(CAT_STR)) break block15;
                                        string4 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                        if (string4 != null) {
                                            this.addCategory(string4);
                                        }
                                        break block14;
                                    }
                                    if (!string2.equals(TYPE_STR)) break block16;
                                    string4 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                    if (string4 != null) {
                                        try {
                                            this.addDataType(string4);
                                        }
                                        catch (MalformedMimeTypeException malformedMimeTypeException) {}
                                    }
                                    break block14;
                                }
                                if (!string2.equals(SCHEME_STR)) break block17;
                                string4 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                if (string4 != null) {
                                    this.addDataScheme(string4);
                                }
                                break block14;
                            }
                            if (!string2.equals(AUTH_STR)) break block18;
                            String string5 = xmlPullParser.getAttributeValue(null, HOST_STR);
                            String string6 = xmlPullParser.getAttributeValue(null, PORT_STR);
                            if (string5 != null) {
                                this.addDataAuthority(string5, string6);
                            }
                            break block14;
                        }
                        if (!string2.equals(PATH_STR)) break block19;
                        string3 = xmlPullParser.getAttributeValue(null, LITERAL_STR);
                        if (string3 == null) break block20;
                        this.addDataPath(string3, 0);
                        break block14;
                    }
                    string3 = xmlPullParser.getAttributeValue(null, PREFIX_STR);
                    if (string3 != null) {
                        this.addDataPath(string3, 1);
                        break block14;
                    } else {
                        string3 = xmlPullParser.getAttributeValue(null, SGLOB_STR);
                        if (string3 != null) {
                            this.addDataPath(string3, 2);
                        }
                    }
                    break block14;
                }
                String string7 = "Unknown tag parsing IntentFilter: " + string2;
                int n3 = Log.w("IntentFilter", string7);
            }
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<String> schemesIterator() {
        if (this.mDataSchemes == null) return null;
        return this.mDataSchemes.iterator();
    }

    public final void setPriority(int n) {
        this.mPriority = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Iterator<String> typesIterator() {
        if (this.mDataTypes == null) return null;
        return this.mDataTypes.iterator();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        int n2;
        int n3;
        ArrayList<String> arrayList = this.mActions;
        parcel.writeStringList(arrayList);
        if (this.mCategories != null) {
            parcel.writeInt(1);
            ArrayList<String> arrayList2 = this.mCategories;
            parcel.writeStringList(arrayList2);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            parcel.writeInt(1);
            ArrayList<String> arrayList3 = this.mDataSchemes;
            parcel.writeStringList(arrayList3);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataTypes != null) {
            parcel.writeInt(1);
            ArrayList<String> arrayList4 = this.mDataTypes;
            parcel.writeStringList(arrayList4);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            n3 = this.mDataAuthorities.size();
            parcel.writeInt(n3);
            n2 = 0;
            while (n2 < n3) {
                this.mDataAuthorities.get(n2).writeToParcel(parcel);
                int n4 = n2 + 1;
            }
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataPaths != null) {
            n3 = this.mDataPaths.size();
            parcel.writeInt(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.mDataPaths.get(n2).writeToParcel(parcel, 0);
            }
        } else {
            parcel.writeInt(0);
        }
        int n5 = this.mPriority;
        parcel.writeInt(n5);
        int n6 = this.mHasPartialTypes ? 1 : 0;
        parcel.writeInt(n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeToXml(XmlSerializer xmlSerializer) throws IOException {
        int n = this.countActions();
        for (int i = 0; i < n; ++i) {
            XmlSerializer xmlSerializer2 = xmlSerializer.startTag(null, ACTION_STR);
            String string2 = this.mActions.get(i);
            XmlSerializer xmlSerializer3 = xmlSerializer.attribute(null, NAME_STR, string2);
            XmlSerializer xmlSerializer4 = xmlSerializer.endTag(null, ACTION_STR);
        }
        int n2 = this.countCategories();
        for (int i = 0; i < n2; ++i) {
            XmlSerializer xmlSerializer5 = xmlSerializer.startTag(null, CAT_STR);
            String string3 = this.mCategories.get(i);
            XmlSerializer xmlSerializer6 = xmlSerializer.attribute(null, NAME_STR, string3);
            XmlSerializer xmlSerializer7 = xmlSerializer.endTag(null, CAT_STR);
        }
        int n3 = this.countDataTypes();
        for (int i = 0; i < n3; ++i) {
            XmlSerializer xmlSerializer8 = xmlSerializer.startTag(null, TYPE_STR);
            String string4 = this.mDataTypes.get(i);
            if (string4.indexOf(47) < 0) {
                string4 = string4 + "/*";
            }
            XmlSerializer xmlSerializer9 = xmlSerializer.attribute(null, NAME_STR, string4);
            XmlSerializer xmlSerializer10 = xmlSerializer.endTag(null, TYPE_STR);
        }
        int n4 = this.countDataSchemes();
        for (int i = 0; i < n4; ++i) {
            XmlSerializer xmlSerializer11 = xmlSerializer.startTag(null, SCHEME_STR);
            String string5 = this.mDataSchemes.get(i);
            XmlSerializer xmlSerializer12 = xmlSerializer.attribute(null, NAME_STR, string5);
            XmlSerializer xmlSerializer13 = xmlSerializer.endTag(null, SCHEME_STR);
        }
        int n5 = this.countDataAuthorities();
        for (int i = 0; i < n5; ++i) {
            XmlSerializer xmlSerializer14 = xmlSerializer.startTag(null, AUTH_STR);
            AuthorityEntry authorityEntry = this.mDataAuthorities.get(i);
            String string6 = authorityEntry.getHost();
            XmlSerializer xmlSerializer15 = xmlSerializer.attribute(null, HOST_STR, string6);
            if (authorityEntry.getPort() >= 0) {
                String string7 = Integer.toString(authorityEntry.getPort());
                XmlSerializer xmlSerializer16 = xmlSerializer.attribute(null, PORT_STR, string7);
            }
            XmlSerializer xmlSerializer17 = xmlSerializer.endTag(null, AUTH_STR);
        }
        int n6 = this.countDataPaths();
        int n7 = 0;
        while (n7 < n6) {
            XmlSerializer xmlSerializer18 = xmlSerializer.startTag(null, PATH_STR);
            PatternMatcher patternMatcher = this.mDataPaths.get(n7);
            switch (patternMatcher.getType()) {
                case 0: {
                    String string8 = patternMatcher.getPath();
                    XmlSerializer xmlSerializer19 = xmlSerializer.attribute(null, LITERAL_STR, string8);
                    break;
                }
                case 1: {
                    String string9 = patternMatcher.getPath();
                    XmlSerializer xmlSerializer20 = xmlSerializer.attribute(null, PREFIX_STR, string9);
                    break;
                }
                case 2: {
                    String string10 = patternMatcher.getPath();
                    XmlSerializer xmlSerializer21 = xmlSerializer.attribute(null, SGLOB_STR, string10);
                    break;
                }
            }
            XmlSerializer xmlSerializer22 = xmlSerializer.endTag(null, PATH_STR);
            ++n7;
        }
        return;
    }

    public static final class AuthorityEntry {
        private final String mHost;
        private final String mOrigHost;
        private final int mPort;
        private final boolean mWild;

        /*
         * Enabled aggressive block sorting
         */
        AuthorityEntry(Parcel parcel) {
            int n;
            String string2;
            String string3;
            this.mOrigHost = string3 = parcel.readString();
            this.mHost = string2 = parcel.readString();
            boolean bl = parcel.readInt() != 0;
            this.mWild = bl;
            this.mPort = n = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        public AuthorityEntry(String string2, String string3) {
            this.mOrigHost = string2;
            boolean bl = string2.length() > 0 && string2.charAt(0) == '*';
            this.mWild = bl;
            String string4 = this.mWild ? string2.substring(1).intern() : string2;
            this.mHost = string4;
            int n = string3 != null ? Integer.parseInt(string3) : -1;
            this.mPort = n;
        }

        public String getHost() {
            return this.mOrigHost;
        }

        public int getPort() {
            return this.mPort;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int match(Uri uri) {
            String string2;
            String string3 = uri.getHost();
            if (string3 == null) {
                return -1;
            }
            if (this.mWild) {
                int n;
                int n2 = string3.length();
                if (n2 < (n = this.mHost.length())) {
                    return -1;
                }
                int n3 = string3.length();
                int n4 = this.mHost.length();
                int n5 = n3 - n4;
                string3 = string3.substring(n5);
            }
            if (string3.compareToIgnoreCase(string2 = this.mHost) != 0) {
                return -1;
            }
            if (this.mPort < 0) return 0x300000;
            int n = this.mPort;
            int n6 = uri.getPort();
            if (n == n6) return 0x400000;
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcel(Parcel parcel) {
            String string2 = this.mOrigHost;
            parcel.writeString(string2);
            String string3 = this.mHost;
            parcel.writeString(string3);
            int n = this.mWild ? 1 : 0;
            parcel.writeInt(n);
            int n2 = this.mPort;
            parcel.writeInt(n2);
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException {
        public MalformedMimeTypeException() {
        }

        public MalformedMimeTypeException(String string2) {
            super(string2);
        }
    }
}

