/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AndroidException;

public class IntentSender
implements Parcelable {
    public static final Parcelable.Creator<IntentSender> CREATOR = new Parcelable.Creator<IntentSender>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IntentSender createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder == null) return null;
            return new IntentSender(iBinder);
        }

        public IntentSender[] newArray(int n) {
            return new IntentSender[n];
        }
    };
    private final IIntentSender mTarget;

    public IntentSender(IIntentSender iIntentSender) {
        this.mTarget = iIntentSender;
    }

    public IntentSender(IBinder iBinder) {
        IIntentSender iIntentSender;
        this.mTarget = iIntentSender = IIntentSender.Stub.asInterface(iBinder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntentSender readIntentSenderOrNullFromParcel(Parcel parcel) {
        IBinder iBinder = parcel.readStrongBinder();
        if (iBinder == null) return null;
        return new IntentSender(iBinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeIntentSenderOrNullToParcel(IntentSender intentSender, Parcel parcel) {
        IBinder iBinder = intentSender != null ? intentSender.mTarget.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof IntentSender)) return false;
        IBinder iBinder = this.mTarget.asBinder();
        IBinder iBinder2 = ((IntentSender)object).mTarget.asBinder();
        return iBinder.equals(iBinder2);
    }

    public IIntentSender getTarget() {
        return this.mTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTargetPackage() {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            IIntentSender iIntentSender = this.mTarget;
            String string2 = iActivityManager.getPackageForIntentSender(iIntentSender);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendIntent(Context context, int n, Intent intent, OnFinished onFinished, Handler handler) throws SendIntentException {
        String string2;
        FinishedDispatcher finishedDispatcher = null;
        if (intent != null) {
            try {
                ContentResolver contentResolver = context.getContentResolver();
                string2 = intent.resolveTypeIfNeeded(contentResolver);
            }
            catch (RemoteException remoteException) {
                throw new SendIntentException();
            }
        } else {
            string2 = null;
        }
        IIntentSender iIntentSender = this.mTarget;
        if (onFinished != null) {
            finishedDispatcher = new FinishedDispatcher(this, onFinished, handler);
        }
        if (iIntentSender.send(n, intent, string2, finishedDispatcher) >= 0) {
            return;
        }
        throw new SendIntentException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        StringBuilder stringBuilder2 = stringBuilder.append("IntentSender{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
        StringBuilder stringBuilder4 = stringBuilder.append(": ");
        IBinder iBinder = this.mTarget != null ? this.mTarget.asBinder() : null;
        StringBuilder stringBuilder5 = stringBuilder.append(iBinder);
        StringBuilder stringBuilder6 = stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        IBinder iBinder = this.mTarget.asBinder();
        parcel.writeStrongBinder(iBinder);
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final Handler mHandler;
        private Intent mIntent;
        private final IntentSender mIntentSender;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;
        private final OnFinished mWho;

        FinishedDispatcher(IntentSender intentSender, OnFinished onFinished, Handler handler) {
            this.mIntentSender = intentSender;
            this.mWho = onFinished;
            this.mHandler = handler;
        }

        @Override
        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2) {
            this.mIntent = intent;
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
            if (this.mHandler == null) {
                this.run();
                return;
            }
            boolean bl3 = this.mHandler.post(this);
        }

        @Override
        public void run() {
            OnFinished onFinished = this.mWho;
            IntentSender intentSender = this.mIntentSender;
            Intent intent = this.mIntent;
            int n = this.mResultCode;
            String string2 = this.mResultData;
            Bundle bundle = this.mResultExtras;
            onFinished.onSendFinished(intentSender, intent, n, string2, bundle);
        }
    }

    public static interface OnFinished {
        public void onSendFinished(IntentSender var1, Intent var2, int var3, String var4, Bundle var5);
    }

    public static class SendIntentException
    extends AndroidException {
        public SendIntentException() {
        }

        public SendIntentException(Exception exception) {
            super(exception);
        }

        public SendIntentException(String string2) {
            super(string2);
        }
    }
}

