/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

public class SearchRecentSuggestionsProvider
extends ContentProvider {
    public static final int DATABASE_MODE_2LINES = 2;
    public static final int DATABASE_MODE_QUERIES = 1;
    private static final int DATABASE_VERSION = 512;
    private static final String NULL_COLUMN = "query";
    private static final String ORDER_BY = "date DESC";
    private static final String TAG = "SuggestionsProvider";
    private static final int URI_MATCH_SUGGEST = 1;
    private static final String sDatabaseName = "suggestions.db";
    private static final String sSuggestions = "suggestions";
    private String mAuthority;
    private int mMode;
    private SQLiteOpenHelper mOpenHelper;
    private String mSuggestSuggestionClause;
    private String[] mSuggestionProjection;
    private Uri mSuggestionsUri;
    private boolean mTwoLineDisplay;
    private UriMatcher mUriMatcher;

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        if (uri.getPathSegments().size() != 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        if (uri.getPathSegments().get(0).equals(sSuggestions)) {
            int n = sQLiteDatabase.delete(sSuggestions, string2, stringArray);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return n;
        }
        throw new IllegalArgumentException("Unknown Uri");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getType(Uri uri) {
        if (this.mUriMatcher.match(uri) == 1) {
            return "vnd.android.cursor.dir/vnd.android.search.suggest";
        }
        int n = uri.getPathSegments().size();
        if (n < 1) throw new IllegalArgumentException("Unknown Uri");
        if (!uri.getPathSegments().get(0).equals(sSuggestions)) throw new IllegalArgumentException("Unknown Uri");
        if (n == 1) {
            return "vnd.android.cursor.dir/suggestion";
        }
        if (n != 2) throw new IllegalArgumentException("Unknown Uri");
        return "vnd.android.cursor.item/suggestion";
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        int n = uri.getPathSegments().size();
        if (n < 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        long l = 65535L;
        String string2 = uri.getPathSegments().get(0);
        Uri uri2 = null;
        if (string2.equals(sSuggestions) && n == 1 && (l = sQLiteDatabase.insert(sSuggestions, NULL_COLUMN, contentValues)) > 0L) {
            Uri uri3 = this.mSuggestionsUri;
            String string3 = String.valueOf(l);
            uri2 = Uri.withAppendedPath(uri3, string3);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        this.getContext().getContentResolver().notifyChange(uri2, null);
        return uri2;
    }

    @Override
    public boolean onCreate() {
        if (this.mAuthority == null || this.mMode == 0) {
            throw new IllegalArgumentException("Provider not configured");
        }
        int n = this.mMode + 512;
        Context context = this.getContext();
        DatabaseHelper databaseHelper = new DatabaseHelper(context, n);
        this.mOpenHelper = databaseHelper;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        StringBuilder stringBuilder;
        int n;
        int n2;
        int n3;
        Cursor cursor;
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        UriMatcher uriMatcher = this.mUriMatcher;
        Uri uri2 = uri;
        if (uriMatcher.match(uri2) == 1) {
            String[] stringArray3;
            String string4;
            if (TextUtils.isEmpty(stringArray2[0])) {
                string4 = null;
                stringArray3 = null;
            } else {
                StringBuilder stringBuilder2 = new StringBuilder().append("%");
                String string5 = stringArray2[0];
                String string6 = stringBuilder2.append(string5).append("%").toString();
                stringArray3 = this.mTwoLineDisplay ? new String[]{string6, string6} : new String[]{string6};
                string4 = this.mSuggestSuggestionClause;
            }
            String[] stringArray4 = this.mSuggestionProjection;
            cursor = sQLiteDatabase.query(sSuggestions, stringArray4, string4, stringArray3, null, null, ORDER_BY, null);
            ContentResolver contentResolver = this.getContext().getContentResolver();
            Cursor cursor2 = cursor;
            ContentResolver contentResolver2 = contentResolver;
            Uri uri3 = uri;
            cursor2.setNotificationUri(contentResolver2, uri3);
            return cursor;
        }
        int n4 = uri.getPathSegments().size();
        int n5 = n4;
        if (n5 != (n3 = 1) && (n2 = n4) != (n = 2)) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String string7 = uri.getPathSegments().get(0);
        if (!string7.equals(sSuggestions)) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String[] stringArray5 = null;
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray6 = new String[stringArray.length + 1];
            int n6 = stringArray.length;
            String[] stringArray7 = stringArray;
            int n7 = 0;
            String[] stringArray8 = stringArray6;
            int n8 = 0;
            int n9 = n6;
            System.arraycopy(stringArray7, n7, stringArray8, n8, n9);
            int n10 = stringArray.length;
            stringArray6[n10] = "_id AS _id";
        }
        StringBuilder stringBuilder3 = stringBuilder;
        int n11 = 256;
        stringBuilder3(n11);
        int n12 = n4;
        int n13 = 2;
        if (n12 == n13) {
            StringBuilder stringBuilder4 = stringBuilder;
            String string8 = "(_id = ";
            StringBuilder stringBuilder5 = stringBuilder4.append(string8);
            String string9 = uri.getPathSegments().get(1);
            StringBuilder stringBuilder6 = stringBuilder5;
            String string10 = string9;
            StringBuilder stringBuilder7 = stringBuilder6.append(string10).append(")");
        }
        if (string2 != null && string2.length() > 0) {
            if (stringBuilder.length() > 0) {
                StringBuilder stringBuilder8 = stringBuilder;
                String string11 = " AND ";
                StringBuilder stringBuilder9 = stringBuilder8.append(string11);
            }
            StringBuilder stringBuilder10 = stringBuilder;
            char c = '(';
            StringBuilder stringBuilder11 = stringBuilder10.append(c);
            StringBuilder stringBuilder12 = stringBuilder;
            String string12 = string2;
            StringBuilder stringBuilder13 = stringBuilder12.append(string12);
            StringBuilder stringBuilder14 = stringBuilder;
            char c2 = ')';
            StringBuilder stringBuilder15 = stringBuilder14.append(c2);
        }
        String string13 = stringBuilder.toString();
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String[] stringArray9 = stringArray2;
        String string14 = string3;
        cursor = sQLiteDatabase2.query(string7, stringArray5, string13, stringArray9, null, null, string14, null);
        ContentResolver contentResolver = this.getContext().getContentResolver();
        Cursor cursor3 = cursor;
        ContentResolver contentResolver3 = contentResolver;
        Uri uri4 = uri;
        cursor3.setNotificationUri(contentResolver3, uri4);
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupSuggestions(String string2, int n) {
        UriMatcher uriMatcher;
        Uri uri;
        String string3;
        if (TextUtils.isEmpty(string2) || (n & 1) == 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = (n & 2) != 0;
        this.mTwoLineDisplay = bl;
        this.mAuthority = string3 = new String(string2);
        this.mMode = n;
        StringBuilder stringBuilder = new StringBuilder().append("content://");
        String string4 = this.mAuthority;
        this.mSuggestionsUri = uri = Uri.parse(stringBuilder.append(string4).append("/suggestions").toString());
        UriMatcher uriMatcher2 = this.mUriMatcher = (uriMatcher = new UriMatcher(-1));
        String string5 = this.mAuthority;
        uriMatcher2.addURI(string5, "search_suggest_query", 1);
        if (this.mTwoLineDisplay) {
            this.mSuggestSuggestionClause = "display1 LIKE ? OR display2 LIKE ?";
            String[] stringArray = new String[]{"0 AS suggest_format", "display1 AS suggest_text_1", "display2 AS suggest_text_2", "query AS suggest_intent_query", "_id"};
            this.mSuggestionProjection = stringArray;
            return;
        }
        this.mSuggestSuggestionClause = "display1 LIKE ?";
        String[] stringArray = new String[]{"0 AS suggest_format", "display1 AS suggest_text_1", "query AS suggest_intent_query", "_id"};
        this.mSuggestionProjection = stringArray;
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private int mNewVersion;

        public DatabaseHelper(Context context, int n) {
            super(context, SearchRecentSuggestionsProvider.sDatabaseName, null, n);
            this.mNewVersion = n;
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append("CREATE TABLE suggestions (_id INTEGER PRIMARY KEY,display1 TEXT UNIQUE ON CONFLICT REPLACE");
            if ((this.mNewVersion & 2) != 0) {
                StringBuilder stringBuilder3 = stringBuilder.append(",display2 TEXT");
            }
            StringBuilder stringBuilder4 = stringBuilder.append(",query TEXT,date LONG);");
            String string2 = stringBuilder.toString();
            sQLiteDatabase.execSQL(string2);
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            String string2 = "Upgrading database from version " + n + " to " + n2 + ", which will destroy all old data";
            int n3 = Log.w(SearchRecentSuggestionsProvider.TAG, string2);
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS suggestions");
            this.onCreate(sQLiteDatabase);
        }
    }
}

