/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ISyncContext;
import android.content.SyncResult;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;

public class SyncContext {
    private static final long HEARTBEAT_SEND_INTERVAL_IN_MS = 1000L;
    private long mLastHeartbeatSendTime;
    private ISyncContext mSyncContext;

    public SyncContext(ISyncContext iSyncContext) {
        this.mSyncContext = iSyncContext;
        this.mLastHeartbeatSendTime = 0L;
    }

    private void updateHeartbeat() {
        long l;
        long l2 = SystemClock.elapsedRealtime();
        if (l2 < (l = this.mLastHeartbeatSendTime + 1000L)) {
            return;
        }
        try {
            this.mLastHeartbeatSendTime = l2;
            if (this.mSyncContext == null) {
                return;
            }
            this.mSyncContext.sendHeartbeat();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBinder getSyncContextBinder() {
        if (this.mSyncContext != null) return this.mSyncContext.asBinder();
        return null;
    }

    public void onFinished(SyncResult syncResult) {
        try {
            if (this.mSyncContext == null) {
                return;
            }
            this.mSyncContext.onFinished(syncResult);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setStatusText(String string2) {
        this.updateHeartbeat();
    }
}

