/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncInfo;
import android.content.SyncOperation;
import android.content.SyncQueue;
import android.content.SyncResult;
import android.content.SyncStatusInfo;
import android.content.SyncStorageEngine;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ArrayUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;

public class SyncManager
implements OnAccountsUpdateListener {
    private static final String ACTION_SYNC_ALARM = "android.content.syncmanager.SYNC_ALARM";
    private static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    private static final int DELAY_RETRY_SYNC_IN_PROGRESS_IN_SECONDS = 10;
    private static final long ERROR_NOTIFICATION_DELAY_MS = 600000L;
    private static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarm";
    private static final int INITIALIZATION_UNBIND_DELAY_MS = 5000;
    private static final Account[] INITIAL_ACCOUNTS_ARRAY;
    private static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    private static final long LOCAL_SYNC_DELAY = 0L;
    private static final long MAX_TIME_PER_SYNC = 0L;
    private static final long SYNC_NOTIFICATION_DELAY = 30000L;
    private static final String SYNC_WAKE_LOCK = "*sync*";
    private static final String TAG = "SyncManager";
    private volatile Account[] mAccounts;
    private ActiveSyncContext mActiveSyncContext;
    private AlarmManager mAlarmService;
    private BroadcastReceiver mBackgroundDataSettingChanged;
    private volatile boolean mBootCompleted;
    private BroadcastReceiver mBootCompletedReceiver;
    private ConnectivityManager mConnManagerDoNotUseDirectly;
    private BroadcastReceiver mConnectivityIntentReceiver;
    private Context mContext;
    private volatile boolean mDataConnectionIsConnected;
    private volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    private final Handler mMainHandler;
    private boolean mNeedSyncActiveNotification;
    private boolean mNeedSyncErrorNotification;
    private final NotificationManager mNotificationMgr;
    private BroadcastReceiver mShutdownIntentReceiver;
    private BroadcastReceiver mStorageIntentReceiver;
    private volatile boolean mStorageIsLow;
    private final SyncAdaptersCache mSyncAdapters;
    private final PendingIntent mSyncAlarmIntent;
    private final SyncHandler mSyncHandler;
    public final SyncQueue mSyncQueue;
    private final SyncStorageEngine mSyncStorageEngine;
    private volatile PowerManager.WakeLock mSyncWakeLock;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string2 = SystemProperties.get("sync.local_sync_delay");
        long l = 30000L;
        if (string2 != null) {
            try {
                long l2;
                l = l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LOCAL_SYNC_DELAY = l;
        String string3 = SystemProperties.get("sync.max_time_per_sync");
        long l3 = 300000L;
        if (string3 != null) {
            try {
                long l4;
                l3 = l4 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        MAX_TIME_PER_SYNC = l3;
        INITIAL_ACCOUNTS_ARRAY = new Account[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    public SyncManager(Context context, boolean bl) {
        PowerManager.WakeLock wakeLock;
        PowerManager.WakeLock wakeLock2;
        PendingIntent pendingIntent;
        SyncAdaptersCache syncAdaptersCache;
        Handler handler;
        SyncHandler syncHandler;
        SyncQueue syncQueue;
        SyncStorageEngine syncStorageEngine;
        BroadcastReceiver broadcastReceiver;
        BroadcastReceiver broadcastReceiver2;
        BroadcastReceiver broadcastReceiver3;
        BroadcastReceiver broadcastReceiver4;
        BroadcastReceiver broadcastReceiver5;
        Account[] accountArray = INITIAL_ACCOUNTS_ARRAY;
        this.mAccounts = accountArray;
        this.mDataConnectionIsConnected = false;
        this.mStorageIsLow = false;
        this.mAlarmService = null;
        this.mActiveSyncContext = null;
        this.mNeedSyncErrorNotification = false;
        this.mNeedSyncActiveNotification = false;
        this.mStorageIntentReceiver = broadcastReceiver5 = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if ("android.intent.action.DEVICE_STORAGE_LOW".equals(string2)) {
                    if (Log.isLoggable(SyncManager.TAG, 2)) {
                        int n = Log.v(SyncManager.TAG, "Internal storage is low.");
                    }
                    boolean bl = SyncManager.access$002(SyncManager.this, true);
                    SyncManager.this.cancelActiveSync(null, null);
                    return;
                }
                if (!"android.intent.action.DEVICE_STORAGE_OK".equals(string2)) {
                    return;
                }
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    int n = Log.v(SyncManager.TAG, "Internal storage is ok.");
                }
                boolean bl = SyncManager.access$002(SyncManager.this, false);
                SyncManager.this.sendCheckAlarmsMessage();
            }
        };
        this.mBootCompletedReceiver = broadcastReceiver4 = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                SyncManager.this.mSyncHandler.onBootCompleted();
            }
        };
        this.mBackgroundDataSettingChanged = broadcastReceiver3 = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (!SyncManager.this.getConnectivityManager().getBackgroundDataSetting()) {
                    return;
                }
                SyncManager syncManager = SyncManager.this;
                Bundle bundle = new Bundle();
                String string2 = null;
                syncManager.scheduleSync(null, string2, bundle, 0L, false);
            }
        };
        this.mConnectivityIntentReceiver = broadcastReceiver2 = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                NetworkInfo.State state = networkInfo == null ? NetworkInfo.State.UNKNOWN : networkInfo.getState();
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    String string2 = "received connectivity action.  network info: " + networkInfo;
                    int n = Log.v(SyncManager.TAG, string2);
                }
                int[] nArray = 8.$SwitchMap$android$net$NetworkInfo$State;
                int n = state.ordinal();
                switch (nArray[n]) {
                    case 1: {
                        boolean bl = SyncManager.access$402(SyncManager.this, true);
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        if (intent.getBooleanExtra("noConnectivity", false)) {
                            boolean bl = SyncManager.access$402(SyncManager.this, false);
                            break;
                        }
                        boolean bl = SyncManager.access$402(SyncManager.this, true);
                    }
                }
                if (!SyncManager.this.mDataConnectionIsConnected) {
                    return;
                }
                SyncManager.this.sendCheckAlarmsMessage();
            }
        };
        this.mShutdownIntentReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int n = Log.w(SyncManager.TAG, "Writing sync state before shutdown...");
                SyncManager.this.getSyncStorageEngine().writeAllState();
            }
        };
        this.mBootCompleted = false;
        SyncStorageEngine.init(context);
        SyncStorageEngine syncStorageEngine2 = this.mSyncStorageEngine = (syncStorageEngine = SyncStorageEngine.getSingleton());
        this.mSyncQueue = syncQueue = new SyncQueue(syncStorageEngine2);
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("SyncHandlerThread", 10);
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        this.mSyncHandler = syncHandler = new SyncHandler(looper);
        Looper looper2 = this.mContext.getMainLooper();
        this.mMainHandler = handler = new Handler(looper2);
        Context context2 = this.mContext;
        SyncAdaptersCache syncAdaptersCache2 = this.mSyncAdapters = (syncAdaptersCache = new SyncAdaptersCache(context2));
        RegisteredServicesCacheListener<SyncAdapterType> registeredServicesCacheListener = new RegisteredServicesCacheListener<SyncAdapterType>(){

            @Override
            public void onServiceChanged(SyncAdapterType syncAdapterType, boolean bl) {
                if (bl) {
                    return;
                }
                SyncManager syncManager = SyncManager.this;
                String string2 = syncAdapterType.authority;
                Bundle bundle = null;
                syncManager.scheduleSync(null, string2, bundle, 0L, false);
            }
        };
        SyncHandler syncHandler2 = this.mSyncHandler;
        syncAdaptersCache2.setListener(registeredServicesCacheListener, syncHandler2);
        Context context3 = this.mContext;
        Intent intent = new Intent(ACTION_SYNC_ALARM);
        this.mSyncAlarmIntent = pendingIntent = PendingIntent.getBroadcast(context3, 0, intent, 0);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        BroadcastReceiver broadcastReceiver6 = this.mConnectivityIntentReceiver;
        Intent intent2 = context.registerReceiver(broadcastReceiver6, intentFilter);
        if (!bl) {
            IntentFilter intentFilter2 = new IntentFilter("android.intent.action.BOOT_COMPLETED");
            BroadcastReceiver broadcastReceiver7 = this.mBootCompletedReceiver;
            Intent intent3 = context.registerReceiver(broadcastReceiver7, intentFilter2);
        }
        IntentFilter intentFilter3 = new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
        BroadcastReceiver broadcastReceiver8 = this.mBackgroundDataSettingChanged;
        Intent intent4 = context.registerReceiver(broadcastReceiver8, intentFilter3);
        IntentFilter intentFilter4 = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter4.addAction("android.intent.action.DEVICE_STORAGE_OK");
        BroadcastReceiver broadcastReceiver9 = this.mStorageIntentReceiver;
        Intent intent5 = context.registerReceiver(broadcastReceiver9, intentFilter4);
        IntentFilter intentFilter5 = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        intentFilter5.setPriority(100);
        BroadcastReceiver broadcastReceiver10 = this.mShutdownIntentReceiver;
        Intent intent6 = context.registerReceiver(broadcastReceiver10, intentFilter5);
        if (!bl) {
            NotificationManager notificationManager;
            this.mNotificationMgr = notificationManager = (NotificationManager)context.getSystemService("notification");
            SyncAlarmIntentReceiver syncAlarmIntentReceiver = new SyncAlarmIntentReceiver();
            IntentFilter intentFilter6 = new IntentFilter(ACTION_SYNC_ALARM);
            Intent intent7 = context.registerReceiver(syncAlarmIntentReceiver, intentFilter6);
        } else {
            this.mNotificationMgr = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mSyncWakeLock = wakeLock2 = powerManager.newWakeLock(1, SYNC_WAKE_LOCK);
        this.mSyncWakeLock.setReferenceCounted(false);
        this.mHandleAlarmWakeLock = wakeLock = powerManager.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        SyncStorageEngine syncStorageEngine3 = this.mSyncStorageEngine;
        ISyncStatusObserver.Stub stub = new ISyncStatusObserver.Stub(){

            @Override
            public void onStatusChanged(int n) {
                SyncManager.this.sendCheckAlarmsMessage();
            }
        };
        syncStorageEngine3.addStatusChangeListener(1, stub);
        if (bl) {
            return;
        }
        AccountManager accountManager = AccountManager.get(this.mContext);
        SyncHandler syncHandler3 = this.mSyncHandler;
        accountManager.addOnAccountsUpdatedListener(this, syncHandler3, false);
        Account[] accountArray2 = AccountManager.get(this.mContext).getAccounts();
        this.onAccountsUpdated(accountArray2);
    }

    static /* synthetic */ boolean access$002(SyncManager syncManager, boolean bl) {
        syncManager.mStorageIsLow = bl;
        return bl;
    }

    static /* synthetic */ ActiveSyncContext access$1102(SyncManager syncManager, ActiveSyncContext activeSyncContext) {
        syncManager.mActiveSyncContext = activeSyncContext;
        return activeSyncContext;
    }

    static /* synthetic */ boolean access$1302(SyncManager syncManager, boolean bl) {
        syncManager.mBootCompleted = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2402(SyncManager syncManager, boolean bl) {
        syncManager.mNeedSyncActiveNotification = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2502(SyncManager syncManager, boolean bl) {
        syncManager.mNeedSyncErrorNotification = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(SyncManager syncManager, boolean bl) {
        syncManager.mDataConnectionIsConnected = bl;
        return bl;
    }

    private void clearBackoffSetting(SyncOperation syncOperation) {
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account = syncOperation.account;
        String string2 = syncOperation.authority;
        long l = 65535L;
        syncStorageEngine.setBackoff(account, string2, 65535L, l);
    }

    private void dumpDayStatistic(PrintWriter printWriter, SyncStorageEngine.DayStats dayStats) {
        printWriter.print("Success (");
        int n = dayStats.successCount;
        printWriter.print(n);
        if (dayStats.successCount > 0) {
            printWriter.print(" for ");
            long l = dayStats.successTime;
            this.dumpTimeSec(printWriter, l);
            printWriter.print(" avg=");
            long l2 = dayStats.successTime;
            long l3 = dayStats.successCount;
            long l4 = l2 / l3;
            this.dumpTimeSec(printWriter, l4);
        }
        printWriter.print(") Failure (");
        int n2 = dayStats.failureCount;
        printWriter.print(n2);
        if (dayStats.failureCount > 0) {
            printWriter.print(" for ");
            long l = dayStats.failureTime;
            this.dumpTimeSec(printWriter, l);
            printWriter.print(" avg=");
            long l5 = dayStats.failureTime;
            long l6 = dayStats.failureCount;
            long l7 = l5 / l6;
            this.dumpTimeSec(printWriter, l7);
        }
        printWriter.println(")");
    }

    private void dumpTimeSec(PrintWriter printWriter, long l) {
        long l2 = l / 1000L;
        printWriter.print(l2);
        printWriter.print('.');
        long l3 = l / 100L % 10L;
        printWriter.print(l3);
        printWriter.print('s');
    }

    private void ensureAlarmService() {
        AlarmManager alarmManager;
        if (this.mAlarmService != null) {
            return;
        }
        this.mAlarmService = alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
    }

    static String formatTime(long l) {
        Time time = new Time();
        time.set(l);
        return time.format("%Y-%m-%d %H:%M:%S");
    }

    private ConnectivityManager getConnectivityManager() {
        synchronized (this) {
            if (this.mConnManagerDoNotUseDirectly == null) {
                ConnectivityManager connectivityManager;
                this.mConnManagerDoNotUseDirectly = connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            }
            ConnectivityManager connectivityManager = this.mConnManagerDoNotUseDirectly;
            return connectivityManager;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void increaseBackoffSetting(SyncOperation syncOperation) {
        long l;
        long l2;
        long l3 = SystemClock.elapsedRealtime();
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account = syncOperation.account;
        String string2 = syncOperation.authority;
        Pair<Long, Long> pair = syncStorageEngine.getBackoff(account, string2);
        long l4 = pair == null || (Long)pair.second <= 0L ? this.jitterize(30000L, 33000L) : (Long)pair.second * 2L;
        if (l4 > (l2 = (l = Settings.Secure.getLong(this.mContext.getContentResolver(), "sync_max_retry_delay_in_seconds", 3600L)) * 1000L)) {
            l4 = l * 1000L;
        }
        SyncStorageEngine syncStorageEngine2 = this.mSyncStorageEngine;
        Account account2 = syncOperation.account;
        String string3 = syncOperation.authority;
        long l5 = l3 + l4;
        syncStorageEngine2.setBackoff(account2, string3, l5, l4);
    }

    private void initializeSyncAdapter(Account account, String string2) {
        String string3;
        SyncAdapterType syncAdapterType;
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo;
        if (Log.isLoggable(TAG, 2)) {
            String string4 = "initializeSyncAdapter: " + account + ", authority " + string2;
            int n = Log.v(TAG, string4);
        }
        if ((serviceInfo = this.mSyncAdapters.getServiceInfo(syncAdapterType = SyncAdapterType.newKey(string2, string3 = account.type))) == null) {
            String string5 = "can't find a sync adapter for " + syncAdapterType + ", removing";
            int n = Log.w(TAG, string5);
            this.mSyncStorageEngine.removeAuthority(account, string2);
            return;
        }
        Intent intent = new Intent();
        Intent intent2 = intent.setAction("android.content.SyncAdapter");
        ComponentName componentName = serviceInfo.componentName;
        Intent intent3 = intent.setComponent(componentName);
        Context context = this.mContext;
        Context context2 = this.mContext;
        Handler handler = this.mMainHandler;
        InitializerServiceConnection initializerServiceConnection = new InitializerServiceConnection(account, string2, context2, handler);
        if (context.bindService(intent, initializerServiceConnection, 5)) {
            return;
        }
        String string6 = "initializeSyncAdapter: failed to bind to " + intent;
        int n = Log.w(TAG, string6);
    }

    private long jitterize(long l, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        Random random = new Random(l3);
        long l4 = l2 - l;
        if (l4 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        int n = (int)l4;
        return (long)random.nextInt(n) + l;
    }

    private void sendCheckAlarmsMessage() {
        if (Log.isLoggable(TAG, 2)) {
            int n = Log.v(TAG, "sending MESSAGE_CHECK_ALARMS");
        }
        boolean bl = this.mSyncHandler.sendEmptyMessage(3);
    }

    private void sendSyncAlarmMessage() {
        if (Log.isLoggable(TAG, 2)) {
            int n = Log.v(TAG, "sending MESSAGE_SYNC_ALARM");
        }
        boolean bl = this.mSyncHandler.sendEmptyMessage(2);
    }

    private void sendSyncFinishedOrCanceledMessage(ActiveSyncContext activeSyncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            int n = Log.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message message = this.mSyncHandler.obtainMessage();
        message.what = 1;
        SyncHandlerMessagePayload syncHandlerMessagePayload = new SyncHandlerMessagePayload(activeSyncContext, syncResult);
        message.obj = syncHandlerMessagePayload;
        boolean bl = this.mSyncHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDelayUntilTime(SyncOperation syncOperation, long l) {
        long l2;
        long l3 = l * 1000L;
        long l4 = System.currentTimeMillis();
        if (l3 > l4) {
            long l5 = SystemClock.elapsedRealtime();
            long l6 = l3 - l4;
            l2 = l5 + l6;
        } else {
            l2 = 0L;
        }
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account = syncOperation.account;
        String string2 = syncOperation.authority;
        syncStorageEngine.setDelayUntilTime(account, string2, l2);
    }

    public void cancelActiveSync(Account account, String string2) {
        String string3;
        Account account2;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext == null) {
            return;
        }
        if (account != null && !account.equals(account2 = activeSyncContext.mSyncOperation.account)) {
            return;
        }
        if (string2 != null && !string2.equals(string3 = activeSyncContext.mSyncOperation.authority)) {
            return;
        }
        this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
    }

    public void clearScheduledSyncOperations(Account account, String string2) {
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account2 = account;
        String string3 = string2;
        long l = 65535L;
        syncStorageEngine.setBackoff(account2, string3, 65535L, l);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.remove(account, string2);
            return;
        }
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dumpSyncState(printWriter, stringBuilder);
        this.dumpSyncHistory(printWriter, stringBuilder);
        printWriter.println();
        printWriter.println("SyncAdapters:");
        Iterator iterator = this.mSyncAdapters.getAllServices().iterator();
        while (iterator.hasNext()) {
            RegisteredServicesCache.ServiceInfo serviceInfo = iterator.next();
            String string2 = "  " + serviceInfo;
            printWriter.println(string2);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dumpSyncHistory(PrintWriter printWriter, StringBuilder stringBuilder) {
        ArrayList<SyncStorageEngine.SyncHistoryItem> arrayList;
        int n;
        SyncStorageEngine.DayStats[] dayStatsArray = this.mSyncStorageEngine.getDayStatistics();
        if (dayStatsArray != null && dayStatsArray[0] != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            SyncStorageEngine.DayStats dayStats;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            printWriter.println();
            PrintWriter printWriter2 = printWriter;
            String string2 = "Sync Statistics";
            printWriter2.println(string2);
            PrintWriter printWriter3 = printWriter;
            String string3 = "  Today:  ";
            printWriter3.print(string3);
            SyncStorageEngine.DayStats dayStats2 = dayStatsArray[0];
            SyncManager syncManager = this;
            PrintWriter printWriter4 = printWriter;
            SyncStorageEngine.DayStats dayStats3 = dayStats2;
            syncManager.dumpDayStatistic(printWriter4, dayStats3);
            int n14 = dayStatsArray[0].day;
            n = 1;
            while ((n13 = ++n) <= (n12 = 6) && (n11 = n) < (n10 = (n9 = dayStatsArray.length)) && (dayStats = dayStatsArray[n]) != null && (n8 = (n7 = n14 - (n6 = dayStats.day))) <= (n5 = 6)) {
                PrintWriter printWriter5 = printWriter;
                String string4 = "  Day-";
                printWriter5.print(string4);
                PrintWriter printWriter6 = printWriter;
                int n15 = n7;
                printWriter6.print(n15);
                PrintWriter printWriter7 = printWriter;
                String string5 = ":  ";
                printWriter7.print(string5);
                SyncManager syncManager2 = this;
                PrintWriter printWriter8 = printWriter;
                SyncStorageEngine.DayStats dayStats4 = dayStats;
                syncManager2.dumpDayStatistic(printWriter8, dayStats4);
            }
            int n16 = n14;
            while ((n4 = n) < (n3 = (n2 = dayStatsArray.length))) {
                int n17;
                int n18;
                int n19;
                SyncStorageEngine.DayStats dayStats5 = null;
                n16 += -7;
                while ((n19 = n) < (n18 = (n17 = dayStatsArray.length))) {
                    long l;
                    int n20;
                    long l2;
                    int n21;
                    dayStats = dayStatsArray[n];
                    if (dayStats == null) {
                        n = dayStatsArray.length;
                        break;
                    }
                    int n22 = dayStats.day;
                    int n23 = n16 - n22;
                    int n24 = 6;
                    if (n23 > n24) break;
                    ++n;
                    if (dayStats5 == null) {
                        dayStats5 = new SyncStorageEngine.DayStats(n16);
                    }
                    int n25 = dayStats5.successCount;
                    int n26 = dayStats.successCount;
                    dayStats5.successCount = n21 = n25 + n26;
                    long l3 = dayStats5.successTime;
                    long l4 = dayStats.successTime;
                    dayStats5.successTime = l2 = l3 + l4;
                    int n27 = dayStats5.failureCount;
                    int n28 = dayStats.failureCount;
                    dayStats5.failureCount = n20 = n27 + n28;
                    long l5 = dayStats5.failureTime;
                    long l6 = dayStats.failureTime;
                    dayStats5.failureTime = l = l5 + l6;
                }
                if (dayStats5 == null) continue;
                PrintWriter printWriter9 = printWriter;
                String string6 = "  Week-";
                printWriter9.print(string6);
                int n29 = (n14 - n16) / 7;
                PrintWriter printWriter10 = printWriter;
                int n30 = n29;
                printWriter10.print(n30);
                PrintWriter printWriter11 = printWriter;
                String string7 = ": ";
                printWriter11.print(string7);
                SyncManager syncManager3 = this;
                PrintWriter printWriter12 = printWriter;
                SyncStorageEngine.DayStats dayStats6 = dayStats5;
                syncManager3.dumpDayStatistic(printWriter12, dayStats6);
            }
        }
        if ((arrayList = this.mSyncStorageEngine.getSyncHistory()) == null) {
            return;
        }
        if (arrayList.size() <= 0) {
            return;
        }
        printWriter.println();
        PrintWriter printWriter13 = printWriter;
        String string8 = "Recent Sync History";
        printWriter13.println(string8);
        int n31 = arrayList.size();
        n = 0;
        while (n < n31) {
            String string9;
            SyncStorageEngine.SyncHistoryItem syncHistoryItem = arrayList.get(n);
            SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
            int n32 = syncHistoryItem.authorityId;
            SyncStorageEngine.AuthorityInfo authorityInfo = syncStorageEngine.getAuthority(n32);
            PrintWriter printWriter14 = printWriter;
            String string10 = "  #";
            printWriter14.print(string10);
            int n33 = n + 1;
            PrintWriter printWriter15 = printWriter;
            int n34 = n33;
            printWriter15.print(n34);
            PrintWriter printWriter16 = printWriter;
            String string11 = ": ";
            printWriter16.print(string11);
            if (authorityInfo != null) {
                String string12 = authorityInfo.account.name;
                PrintWriter printWriter17 = printWriter;
                String string13 = string12;
                printWriter17.print(string13);
                PrintWriter printWriter18 = printWriter;
                String string14 = ":";
                printWriter18.print(string14);
                String string15 = authorityInfo.account.type;
                PrintWriter printWriter19 = printWriter;
                String string16 = string15;
                printWriter19.print(string16);
                PrintWriter printWriter20 = printWriter;
                String string17 = " ";
                printWriter20.print(string17);
                String string18 = authorityInfo.authority;
                PrintWriter printWriter21 = printWriter;
                String string19 = string18;
                printWriter21.print(string19);
            } else {
                PrintWriter printWriter22 = printWriter;
                String string20 = "<no account>";
                printWriter22.print(string20);
            }
            Time time = new Time();
            long l = syncHistoryItem.eventTime;
            Time time2 = time;
            long l7 = l;
            time2.set(l7);
            PrintWriter printWriter23 = printWriter;
            String string21 = " ";
            printWriter23.print(string21);
            String[] stringArray = SyncStorageEngine.SOURCES;
            int n35 = syncHistoryItem.source;
            String string22 = stringArray[n35];
            PrintWriter printWriter24 = printWriter;
            String string23 = string22;
            printWriter24.print(string23);
            PrintWriter printWriter25 = printWriter;
            String string24 = " @ ";
            printWriter25.print(string24);
            String string25 = SyncManager.formatTime(syncHistoryItem.eventTime);
            PrintWriter printWriter26 = printWriter;
            String string26 = string25;
            printWriter26.print(string26);
            PrintWriter printWriter27 = printWriter;
            String string27 = " for ";
            printWriter27.print(string27);
            long l8 = syncHistoryItem.elapsedTime;
            SyncManager syncManager = this;
            PrintWriter printWriter28 = printWriter;
            long l9 = l8;
            syncManager.dumpTimeSec(printWriter28, l9);
            printWriter.println();
            int n36 = syncHistoryItem.event;
            int n37 = 1;
            if (n36 != n37 || syncHistoryItem.upstreamActivity != 0L || syncHistoryItem.downstreamActivity != 0L) {
                PrintWriter printWriter29 = printWriter;
                String string28 = "    event=";
                printWriter29.print(string28);
                int n38 = syncHistoryItem.event;
                PrintWriter printWriter30 = printWriter;
                int n39 = n38;
                printWriter30.print(n39);
                PrintWriter printWriter31 = printWriter;
                String string29 = " upstreamActivity=";
                printWriter31.print(string29);
                long l10 = syncHistoryItem.upstreamActivity;
                PrintWriter printWriter32 = printWriter;
                long l11 = l10;
                printWriter32.print(l11);
                PrintWriter printWriter33 = printWriter;
                String string30 = " downstreamActivity=";
                printWriter33.print(string30);
                long l12 = syncHistoryItem.downstreamActivity;
                PrintWriter printWriter34 = printWriter;
                long l13 = l12;
                printWriter34.println(l13);
            }
            if (syncHistoryItem.mesg != null && !"success".equals(string9 = syncHistoryItem.mesg)) {
                PrintWriter printWriter35 = printWriter;
                String string31 = "    mesg=";
                printWriter35.print(string31);
                String string32 = syncHistoryItem.mesg;
                PrintWriter printWriter36 = printWriter;
                String string33 = string32;
                printWriter36.println(string33);
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dumpSyncState(PrintWriter printWriter, StringBuilder stringBuilder) {
        ArrayList<SyncStorageEngine.PendingOperation> arrayList;
        PrintWriter printWriter2 = printWriter;
        String string2 = "data connected: ";
        printWriter2.print(string2);
        boolean bl = this.mDataConnectionIsConnected;
        PrintWriter printWriter3 = printWriter;
        boolean bl2 = bl;
        printWriter3.println(bl2);
        PrintWriter printWriter4 = printWriter;
        String string3 = "memory low: ";
        printWriter4.print(string3);
        boolean bl3 = this.mStorageIsLow;
        PrintWriter printWriter5 = printWriter;
        boolean bl4 = bl3;
        printWriter5.println(bl4);
        Account[] accountArray = this.mAccounts;
        PrintWriter printWriter6 = printWriter;
        String string4 = "accounts: ";
        printWriter6.print(string4);
        Account[] accountArray2 = INITIAL_ACCOUNTS_ARRAY;
        Account[] accountArray3 = accountArray;
        Account[] accountArray4 = accountArray2;
        if (accountArray3 != accountArray4) {
            int n = accountArray.length;
            PrintWriter printWriter7 = printWriter;
            int n2 = n;
            printWriter7.println(n2);
        } else {
            PrintWriter printWriter8 = printWriter;
            String string5 = "not known yet";
            printWriter8.println(string5);
        }
        long l = SystemClock.elapsedRealtime();
        PrintWriter printWriter9 = printWriter;
        String string6 = "now: ";
        printWriter9.print(string6);
        PrintWriter printWriter10 = printWriter;
        long l2 = l;
        printWriter10.print(l2);
        StringBuilder stringBuilder2 = new StringBuilder().append(" (");
        String string7 = SyncManager.formatTime(System.currentTimeMillis());
        String string8 = stringBuilder2.append(string7).append(")").toString();
        PrintWriter printWriter11 = printWriter;
        String string9 = string8;
        printWriter11.println(string9);
        PrintWriter printWriter12 = printWriter;
        String string10 = "uptime: ";
        printWriter12.print(string10);
        String string11 = DateUtils.formatElapsedTime(l / 1000L);
        PrintWriter printWriter13 = printWriter;
        String string12 = string11;
        printWriter13.print(string12);
        PrintWriter printWriter14 = printWriter;
        String string13 = " (HH:MM:SS)";
        printWriter14.println(string13);
        PrintWriter printWriter15 = printWriter;
        String string14 = "time spent syncing: ";
        printWriter15.print(string14);
        String string15 = DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L);
        PrintWriter printWriter16 = printWriter;
        String string16 = string15;
        printWriter16.print(string16);
        PrintWriter printWriter17 = printWriter;
        String string17 = " (HH:MM:SS), sync ";
        printWriter17.print(string17);
        String string18 = this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ";
        PrintWriter printWriter18 = printWriter;
        String string19 = string18;
        printWriter18.print(string19);
        PrintWriter printWriter19 = printWriter;
        String string20 = "in progress";
        printWriter19.println(string20);
        if (this.mSyncHandler.mAlarmScheduleTime != null) {
            PrintWriter printWriter20 = printWriter;
            String string21 = "next alarm time: ";
            printWriter20.print(string21);
            Long l3 = this.mSyncHandler.mAlarmScheduleTime;
            PrintWriter printWriter21 = printWriter;
            Long l4 = l3;
            printWriter21.print(l4);
            PrintWriter printWriter22 = printWriter;
            String string22 = " (";
            printWriter22.print(string22);
            String string23 = DateUtils.formatElapsedTime((this.mSyncHandler.mAlarmScheduleTime - l) / 1000L);
            PrintWriter printWriter23 = printWriter;
            String string24 = string23;
            printWriter23.print(string24);
            PrintWriter printWriter24 = printWriter;
            String string25 = " (HH:MM:SS) from now)";
            printWriter24.println(string25);
        } else {
            PrintWriter printWriter25 = printWriter;
            String string26 = "no alarm is scheduled (there had better not be any pending syncs)";
            printWriter25.println(string26);
        }
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        PrintWriter printWriter26 = printWriter;
        String string27 = "active sync: ";
        printWriter26.print(string27);
        PrintWriter printWriter27 = printWriter;
        ActiveSyncContext activeSyncContext2 = activeSyncContext;
        printWriter27.println(activeSyncContext2);
        PrintWriter printWriter28 = printWriter;
        String string28 = "notification info: ";
        printWriter28.print(string28);
        StringBuilder stringBuilder3 = stringBuilder;
        int n = 0;
        stringBuilder3.setLength(n);
        SyncHandler.SyncNotificationInfo syncNotificationInfo = this.mSyncHandler.mSyncNotificationInfo;
        StringBuilder stringBuilder4 = stringBuilder;
        syncNotificationInfo.toString(stringBuilder4);
        String string29 = stringBuilder.toString();
        PrintWriter printWriter29 = printWriter;
        String string30 = string29;
        printWriter29.println(string30);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            PrintWriter printWriter30 = printWriter;
            String string31 = "sync queue: ";
            printWriter30.print(string31);
            StringBuilder stringBuilder5 = stringBuilder;
            int n3 = 0;
            stringBuilder5.setLength(n3);
            SyncQueue syncQueue2 = this.mSyncQueue;
            StringBuilder stringBuilder6 = stringBuilder;
            syncQueue2.dump(stringBuilder6);
            String string32 = stringBuilder.toString();
            PrintWriter printWriter31 = printWriter;
            String string33 = string32;
            printWriter31.println(string33);
        }
        SyncInfo syncInfo = this.mSyncStorageEngine.getCurrentSync();
        if (syncInfo != null) {
            SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
            int n4 = syncInfo.authorityId;
            SyncStorageEngine.AuthorityInfo authorityInfo = syncStorageEngine.getAuthority(n4);
            long l5 = syncInfo.startTime;
            long l6 = (l - l5) / 1000L;
            PrintWriter printWriter32 = printWriter;
            String string34 = "Active sync: ";
            printWriter32.print(string34);
            Object object = authorityInfo != null ? authorityInfo.account : "<no account>";
            PrintWriter printWriter33 = printWriter;
            Object object2 = object;
            printWriter33.print(object2);
            PrintWriter printWriter34 = printWriter;
            String string35 = " ";
            printWriter34.print(string35);
            String string36 = authorityInfo != null ? authorityInfo.authority : "<no account>";
            PrintWriter printWriter35 = printWriter;
            String string37 = string36;
            printWriter35.print(string37);
            if (activeSyncContext != null) {
                PrintWriter printWriter36 = printWriter;
                String string38 = " ";
                printWriter36.print(string38);
                String[] stringArray = SyncStorageEngine.SOURCES;
                int n5 = activeSyncContext.mSyncOperation.syncSource;
                String string39 = stringArray[n5];
                PrintWriter printWriter37 = printWriter;
                String string40 = string39;
                printWriter37.print(string40);
            }
            PrintWriter printWriter38 = printWriter;
            String string41 = ", duration is ";
            printWriter38.print(string41);
            String string42 = DateUtils.formatElapsedTime(l6);
            PrintWriter printWriter39 = printWriter;
            String string43 = string42;
            printWriter39.println(string43);
        } else {
            PrintWriter printWriter40 = printWriter;
            String string44 = "No sync is in progress.";
            printWriter40.println(string44);
        }
        if ((arrayList = this.mSyncStorageEngine.getPendingOperations()) != null && arrayList.size() > 0) {
            printWriter.println();
            PrintWriter printWriter41 = printWriter;
            String string45 = "Pending Syncs";
            printWriter41.println(string45);
            int n6 = arrayList.size();
            for (int i = 0; i < n6; ++i) {
                ArrayList<SyncStorageEngine.PendingOperation> arrayList2 = arrayList;
                int n7 = i;
                SyncStorageEngine.PendingOperation pendingOperation = arrayList2.get(n7);
                PrintWriter printWriter42 = printWriter;
                String string46 = "  #";
                printWriter42.print(string46);
                PrintWriter printWriter43 = printWriter;
                int n8 = i;
                printWriter43.print(n8);
                PrintWriter printWriter44 = printWriter;
                String string47 = ": account=";
                printWriter44.print(string47);
                String string48 = pendingOperation.account.name;
                PrintWriter printWriter45 = printWriter;
                String string49 = string48;
                printWriter45.print(string49);
                PrintWriter printWriter46 = printWriter;
                String string50 = ":";
                printWriter46.print(string50);
                String string51 = pendingOperation.account.type;
                PrintWriter printWriter47 = printWriter;
                String string52 = string51;
                printWriter47.print(string52);
                PrintWriter printWriter48 = printWriter;
                String string53 = " authority=";
                printWriter48.print(string53);
                String string54 = pendingOperation.authority;
                PrintWriter printWriter49 = printWriter;
                String string55 = string54;
                printWriter49.print(string55);
                PrintWriter printWriter50 = printWriter;
                String string56 = " expedited=";
                printWriter50.print(string56);
                boolean bl5 = pendingOperation.expedited;
                PrintWriter printWriter51 = printWriter;
                boolean bl6 = bl5;
                printWriter51.println(bl6);
                if (pendingOperation.extras == null || pendingOperation.extras.size() <= 0) continue;
                StringBuilder stringBuilder7 = stringBuilder;
                int n9 = 0;
                stringBuilder7.setLength(n9);
                Bundle bundle = pendingOperation.extras;
                StringBuilder stringBuilder8 = stringBuilder;
                boolean bl7 = false;
                SyncOperation.extrasToStringBuilder(bundle, stringBuilder8, bl7);
                PrintWriter printWriter52 = printWriter;
                String string57 = "    extras: ";
                printWriter52.print(string57);
                String string58 = stringBuilder.toString();
                PrintWriter printWriter53 = printWriter;
                String string59 = string58;
                printWriter53.println(string59);
            }
        }
        printWriter.println();
        PrintWriter printWriter54 = printWriter;
        String string60 = "Sync Status";
        printWriter54.println(string60);
        Account[] accountArray5 = accountArray;
        int n10 = accountArray5.length;
        int n11 = 0;
        int n12;
        int n13;
        block4: while ((n13 = ++n11) < (n12 = n10)) {
            Account account = accountArray5[n11];
            PrintWriter printWriter55 = printWriter;
            String string61 = "  Account ";
            printWriter55.print(string61);
            String string62 = account.name;
            PrintWriter printWriter56 = printWriter;
            String string63 = string62;
            printWriter56.print(string63);
            PrintWriter printWriter57 = printWriter;
            String string64 = " ";
            printWriter57.print(string64);
            String string65 = account.type;
            PrintWriter printWriter58 = printWriter;
            String string66 = string65;
            printWriter58.print(string66);
            PrintWriter printWriter59 = printWriter;
            String string67 = ":";
            printWriter59.println(string67);
            Iterator iterator = this.mSyncAdapters.getAllServices().iterator();
            while (true) {
                int n14;
                int n15;
                int n16;
                if (!iterator.hasNext()) continue block4;
                RegisteredServicesCache.ServiceInfo serviceInfo = iterator.next();
                String string68 = ((SyncAdapterType)serviceInfo.type).accountType;
                String string69 = account.type;
                if (!string68.equals(string69)) continue;
                SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
                String string70 = ((SyncAdapterType)serviceInfo.type).authority;
                SyncStorageEngine syncStorageEngine2 = syncStorageEngine;
                Account account2 = account;
                String string71 = string70;
                SyncStorageEngine.AuthorityInfo authorityInfo = syncStorageEngine2.getOrCreateAuthority(account2, string71);
                SyncStorageEngine syncStorageEngine3 = this.mSyncStorageEngine;
                SyncStorageEngine.AuthorityInfo authorityInfo2 = authorityInfo;
                SyncStatusInfo syncStatusInfo = syncStorageEngine3.getOrCreateSyncStatus(authorityInfo2);
                PrintWriter printWriter60 = printWriter;
                String string72 = "    ";
                printWriter60.print(string72);
                String string73 = authorityInfo.authority;
                PrintWriter printWriter61 = printWriter;
                String string74 = string73;
                printWriter61.print(string74);
                PrintWriter printWriter62 = printWriter;
                String string75 = ":";
                printWriter62.println(string75);
                PrintWriter printWriter63 = printWriter;
                String string76 = "      settings:";
                printWriter63.print(string76);
                StringBuilder stringBuilder9 = new StringBuilder().append(" ");
                String string77 = authorityInfo.syncable > 0 ? "syncable" : (authorityInfo.syncable == 0 ? "not syncable" : "not initialized");
                String string78 = stringBuilder9.append(string77).toString();
                PrintWriter printWriter64 = printWriter;
                String string79 = string78;
                printWriter64.print(string79);
                StringBuilder stringBuilder10 = new StringBuilder().append(", ");
                String string80 = authorityInfo.enabled ? "enabled" : "disabled";
                String string81 = stringBuilder10.append(string80).toString();
                PrintWriter printWriter65 = printWriter;
                String string82 = string81;
                printWriter65.print(string82);
                if (authorityInfo.delayUntil > l) {
                    StringBuilder stringBuilder11 = new StringBuilder().append(", delay for ");
                    long l7 = (authorityInfo.delayUntil - l) / 1000L;
                    String string83 = stringBuilder11.append(l7).append(" sec").toString();
                    PrintWriter printWriter66 = printWriter;
                    String string84 = string83;
                    printWriter66.print(string84);
                }
                if (authorityInfo.backoffTime > l) {
                    StringBuilder stringBuilder12 = new StringBuilder().append(", backoff for ");
                    long l8 = (authorityInfo.backoffTime - l) / 1000L;
                    String string85 = stringBuilder12.append(l8).append(" sec").toString();
                    PrintWriter printWriter67 = printWriter;
                    String string86 = string85;
                    printWriter67.print(string86);
                }
                if (authorityInfo.backoffDelay > 0L) {
                    StringBuilder stringBuilder13 = new StringBuilder().append(", the backoff increment is ");
                    long l9 = authorityInfo.backoffDelay / 1000L;
                    String string87 = stringBuilder13.append(l9).append(" sec").toString();
                    PrintWriter printWriter68 = printWriter;
                    String string88 = string87;
                    printWriter68.print(string88);
                }
                printWriter.println();
                int n17 = 0;
                while ((n16 = n17) < (n15 = (n14 = authorityInfo.periodicSyncs.size()))) {
                    ArrayList<Pair<Bundle, Long>> arrayList3 = authorityInfo.periodicSyncs;
                    int n18 = n17;
                    Pair<Bundle, Long> pair = arrayList3.get(n18);
                    SyncStatusInfo syncStatusInfo2 = syncStatusInfo;
                    int n19 = n17++;
                    long l10 = syncStatusInfo2.getPeriodicSyncTime(n19);
                    long l11 = (Long)pair.second * 1000L;
                    long l12 = l10 + l11;
                    StringBuilder stringBuilder14 = new StringBuilder().append("      periodic period=");
                    Object s = pair.second;
                    StringBuilder stringBuilder15 = stringBuilder14.append(s).append(", extras=");
                    Object f = pair.first;
                    StringBuilder stringBuilder16 = stringBuilder15.append(f).append(", next=");
                    String string89 = SyncManager.formatTime(l12);
                    String string90 = stringBuilder16.append(string89).toString();
                    PrintWriter printWriter69 = printWriter;
                    String string91 = string90;
                    printWriter69.println(string91);
                }
                PrintWriter printWriter70 = printWriter;
                String string92 = "      count: local=";
                printWriter70.print(string92);
                int n20 = syncStatusInfo.numSourceLocal;
                PrintWriter printWriter71 = printWriter;
                int n21 = n20;
                printWriter71.print(n21);
                PrintWriter printWriter72 = printWriter;
                String string93 = " poll=";
                printWriter72.print(string93);
                int n22 = syncStatusInfo.numSourcePoll;
                PrintWriter printWriter73 = printWriter;
                int n23 = n22;
                printWriter73.print(n23);
                PrintWriter printWriter74 = printWriter;
                String string94 = " periodic=";
                printWriter74.print(string94);
                int n24 = syncStatusInfo.numSourcePeriodic;
                PrintWriter printWriter75 = printWriter;
                int n25 = n24;
                printWriter75.print(n25);
                PrintWriter printWriter76 = printWriter;
                String string95 = " server=";
                printWriter76.print(string95);
                int n26 = syncStatusInfo.numSourceServer;
                PrintWriter printWriter77 = printWriter;
                int n27 = n26;
                printWriter77.print(n27);
                PrintWriter printWriter78 = printWriter;
                String string96 = " user=";
                printWriter78.print(string96);
                int n28 = syncStatusInfo.numSourceUser;
                PrintWriter printWriter79 = printWriter;
                int n29 = n28;
                printWriter79.print(n29);
                PrintWriter printWriter80 = printWriter;
                String string97 = " total=";
                printWriter80.print(string97);
                int n30 = syncStatusInfo.numSyncs;
                PrintWriter printWriter81 = printWriter;
                int n31 = n30;
                printWriter81.print(n31);
                printWriter.println();
                PrintWriter printWriter82 = printWriter;
                String string98 = "      total duration: ";
                printWriter82.print(string98);
                String string99 = DateUtils.formatElapsedTime(syncStatusInfo.totalElapsedTime / 1000L);
                PrintWriter printWriter83 = printWriter;
                String string100 = string99;
                printWriter83.println(string100);
                if (syncStatusInfo.lastSuccessTime != 0L) {
                    PrintWriter printWriter84 = printWriter;
                    String string101 = "      SUCCESS: source=";
                    printWriter84.print(string101);
                    String[] stringArray = SyncStorageEngine.SOURCES;
                    int n32 = syncStatusInfo.lastSuccessSource;
                    String string102 = stringArray[n32];
                    PrintWriter printWriter85 = printWriter;
                    String string103 = string102;
                    printWriter85.print(string103);
                    PrintWriter printWriter86 = printWriter;
                    String string104 = " time=";
                    printWriter86.print(string104);
                    String string105 = SyncManager.formatTime(syncStatusInfo.lastSuccessTime);
                    PrintWriter printWriter87 = printWriter;
                    String string106 = string105;
                    printWriter87.println(string106);
                }
                if (syncStatusInfo.lastFailureTime == 0L) continue;
                PrintWriter printWriter88 = printWriter;
                String string107 = "      FAILURE: source=";
                printWriter88.print(string107);
                String[] stringArray = SyncStorageEngine.SOURCES;
                int n33 = syncStatusInfo.lastFailureSource;
                String string108 = stringArray[n33];
                PrintWriter printWriter89 = printWriter;
                String string109 = string108;
                printWriter89.print(string109);
                PrintWriter printWriter90 = printWriter;
                String string110 = " initialTime=";
                printWriter90.print(string110);
                String string111 = SyncManager.formatTime(syncStatusInfo.initialFailureTime);
                PrintWriter printWriter91 = printWriter;
                String string112 = string111;
                printWriter91.print(string112);
                PrintWriter printWriter92 = printWriter;
                String string113 = " lastTime=";
                printWriter92.print(string113);
                String string114 = SyncManager.formatTime(syncStatusInfo.lastFailureTime);
                PrintWriter printWriter93 = printWriter;
                String string115 = string114;
                printWriter93.println(string115);
                PrintWriter printWriter94 = printWriter;
                String string116 = "      message: ";
                printWriter94.print(string116);
                String string117 = syncStatusInfo.lastFailureMesg;
                PrintWriter printWriter95 = printWriter;
                String string118 = string117;
                printWriter95.println(string118);
            }
            break;
        }
        return;
    }

    public SyncAdapterType[] getSyncAdapterTypes() {
        Collection collection = this.mSyncAdapters.getAllServices();
        SyncAdapterType[] syncAdapterTypeArray = new SyncAdapterType[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SyncAdapterType syncAdapterType;
            syncAdapterTypeArray[n] = syncAdapterType = (SyncAdapterType)iterator.next().type;
            ++n;
        }
        return syncAdapterTypeArray;
    }

    public SyncStorageEngine getSyncStorageEngine() {
        return this.mSyncStorageEngine;
    }

    void maybeRescheduleSync(SyncResult syncResult, SyncOperation syncOperation) {
        boolean bl = Log.isLoggable(TAG, 3);
        if (bl) {
            String string2 = "encountered error(s) during the sync: " + syncResult + ", " + syncOperation;
            int n = Log.d(TAG, string2);
        }
        SyncOperation syncOperation2 = new SyncOperation(syncOperation);
        if (syncOperation2.extras.getBoolean("ignore_backoff", false)) {
            syncOperation2.extras.remove("ignore_backoff");
        }
        if (syncOperation2.extras.getBoolean("do_not_retry", false)) {
            String string3 = "not retrying sync operation because SYNC_EXTRAS_DO_NOT_RETRY was specified " + syncOperation2;
            int n = Log.d(TAG, string3);
            return;
        }
        if (syncOperation2.extras.getBoolean("upload", false)) {
            syncOperation2.extras.remove("upload");
            String string4 = "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + syncOperation2;
            int n = Log.d(TAG, string4);
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        if (syncResult.tooManyRetries) {
            String string5 = "not retrying sync operation because it retried too many times: " + syncOperation2;
            int n = Log.d(TAG, string5);
            return;
        }
        if (syncResult.madeSomeProgress()) {
            if (bl) {
                int n = Log.d(TAG, "retrying sync operation because even though it had an error it achieved some success");
            }
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        if (syncResult.syncAlreadyInProgress) {
            if (bl) {
                String string6 = "retrying sync operation that failed because there was already a sync in progress: " + syncOperation2;
                int n = Log.d(TAG, string6);
            }
            Account account = syncOperation2.account;
            int n = syncOperation2.syncSource;
            String string7 = syncOperation2.authority;
            Bundle bundle = syncOperation2.extras;
            SyncOperation syncOperation3 = new SyncOperation(account, n, string7, bundle, 10000L);
            this.scheduleSyncOperation(syncOperation3);
            return;
        }
        if (syncResult.hasSoftError()) {
            if (bl) {
                String string8 = "retrying sync operation because it encountered a soft error: " + syncOperation2;
                int n = Log.d(TAG, string8);
            }
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        String string9 = "not retrying sync operation because the error is a hard error: " + syncOperation2;
        int n = Log.d(TAG, string9);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onAccountsUpdated(Account[] accountArray) {
        Account account;
        Account[] accountArray2 = this.mAccounts;
        Account[] accountArray3 = INITIAL_ACCOUNTS_ARRAY;
        boolean bl = accountArray2 == accountArray3;
        this.mAccounts = accountArray;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext != null && !ArrayUtils.contains(accountArray, account = activeSyncContext.mSyncOperation.account)) {
            int n = Log.d(TAG, "canceling sync since the account has been removed");
            this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
        }
        this.sendCheckAlarmsMessage();
        if (this.mBootCompleted) {
            this.mSyncStorageEngine.doDatabaseCleanup(accountArray);
        }
        if (accountArray.length <= 0) {
            return;
        }
        boolean bl2 = bl;
        SyncManager syncManager = this;
        String string2 = null;
        Bundle bundle = null;
        syncManager.scheduleSync(null, string2, bundle, 0L, bl2);
    }

    public void scheduleLocalSync(Account account, String string2) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("upload", true);
        long l = LOCAL_SYNC_DELAY;
        SyncManager syncManager = this;
        Account account2 = account;
        String string3 = string2;
        syncManager.scheduleSync(account2, string3, bundle, l, false);
    }

    /*
     * Unable to fully structure code
     */
    public void scheduleSync(Account var1_1, String var2_2, Bundle var3_3, long var4_4, boolean var6_5) {
        block23: {
            block22: {
                block19: {
                    block21: {
                        block20: {
                            block18: {
                                block17: {
                                    var7_6 = Log.isLoggable("SyncManager", 2);
                                    if (!this.mBootCompleted || this.getConnectivityManager().getBackgroundDataSetting()) {
                                        var7_6 = true;
lbl4:
                                        // 2 sources

                                        while (true) {
                                            if (var3_3 == null) {
                                                var3_3 = new Bundle();
                                            }
                                            if (Boolean.valueOf((var9_7 = var3_3).getBoolean(var10_8 = "expedited", var11_9 = false)).booleanValue()) {
                                                var4_4 = 65535L;
                                            }
                                            if (var1_1 == null) break block17;
                                            var12_10 = new Account[]{var1_1};
lbl11:
                                            // 2 sources

                                            while (true) {
                                                var13_11 = var3_3;
                                                var14_12 = "upload";
                                                var15_13 = false;
                                                var16_14 = var13_11.getBoolean(var14_12, var15_13);
                                                var17_15 = var3_3;
                                                var18_16 = "force";
                                                var19_17 = false;
                                                var20_18 = var17_15.getBoolean(var18_16, var19_17);
                                                if (var20_18) {
                                                    var21_19 = var3_3;
                                                    var22_20 = "ignore_backoff";
                                                    var23_21 = true;
                                                    var21_19.putBoolean(var22_20, var23_21);
                                                    var24_22 = var3_3;
                                                    var25_23 = "ignore_settings";
                                                    var26_24 = true;
                                                    var24_22.putBoolean(var25_23, var26_24);
                                                }
                                                var27_25 = var3_3;
                                                var28_26 = "ignore_settings";
                                                var29_27 = false;
                                                var30_28 = var27_25.getBoolean(var28_26, var29_27);
                                                if (!var16_14) break block18;
                                                var31_29 = 1;
lbl35:
                                                // 4 sources

                                                while (true) {
                                                    var32_30 = new HashSet<String>();
                                                    var33_31 = this.mSyncAdapters.getAllServices().iterator();
                                                    while (var33_31.hasNext()) {
                                                        var34_32 = ((SyncAdapterType)var33_31.next().type).authority;
                                                        var35_33 = var32_30;
                                                        var36_34 = var34_32;
                                                        var37_35 = var35_33.add(var36_34);
                                                    }
                                                    break block19;
                                                    break;
                                                }
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    var7_6 = false;
                                    ** while (true)
                                }
                                ** while ((var12_10 = this.mAccounts).length != 0)
lbl49:
                                // 1 sources

                                if (!var7_6) {
                                    return;
                                }
                                var38_36 = Log.v("SyncManager", "scheduleSync: no accounts configured, dropping");
                                return;
                            }
                            if (!var20_18) break block20;
                            var31_29 = 3;
                            ** GOTO lbl35
                        }
                        if (var2_2 != null) break block21;
                        var31_29 = 2;
                        ** GOTO lbl35
                    }
                    var31_29 = 0;
                    ** while (true)
                }
                if (var2_2 != null) {
                    var39_37 = var32_30;
                    var40_38 = var2_2;
                    var41_39 = var39_37.contains(var40_38);
                    var32_30.clear();
                    if (var41_39) {
                        var42_40 = var32_30;
                        var43_41 = var2_2;
                        var44_42 = var42_40.add(var43_41);
                    }
                }
                var45_43 = this.mSyncStorageEngine.getMasterSyncAutomatically();
                var46_44 = var32_30.iterator();
                block4: while (true) {
                    if (!var46_44.hasNext()) {
                        return;
                    }
                    var47_45 = (String)var46_44.next();
                    var48_46 = var12_10;
                    var49_47 = var48_46.length;
                    var50_48 = 0;
                    block5: while (true) {
                        if ((var51_49 = ++var50_48) >= (var52_50 = var49_47)) continue block4;
                        var53_51 = var48_46[var50_48];
                        var54_52 = this.mSyncStorageEngine.getIsSyncable(var53_51, var47_45);
                        if (var54_52 != 0) break block4;
lbl88:
                        // 5 sources

                        continue block5;
                        break;
                    }
                    break;
                }
                if (var6_5 && var54_52 >= 0 || (var58_56 = (var55_53 = this.mSyncAdapters).getServiceInfo(var57_55 = SyncAdapterType.newKey(var47_45, var56_54 = var53_51.type))) == null || !((SyncAdapterType)var58_56.type).supportsUploading() && var16_14) ** GOTO lbl88
                if (var54_52 >= 0 && !var30_28 && (!var7_6 || !var45_43 || !this.mSyncStorageEngine.getSyncAutomatically(var53_51, var47_45))) break block22;
                var58_57 = true;
lbl93:
                // 2 sources

                while (!var58_57) {
                    if (!var7_6) ** GOTO lbl88
                    var60_58 = "scheduleSync: sync of " + var53_51 + ", " + var47_45 + " is not allowed, dropping request";
                    var61_59 = Log.d("SyncManager", var60_58);
                    ** GOTO lbl88
                }
                break block23;
            }
            var58_57 = false;
            ** GOTO lbl93
        }
        if (var7_6) {
            var62_60 = new StringBuilder().append("scheduleSync: delay ");
            var63_61 = var4_4;
            var65_62 = var62_60.append(var63_61).append(", source ").append(var31_29).append(", account ").append(var53_51).append(", authority ").append(var47_45).append(", extras ");
            var66_63 = var3_3;
            var67_64 = var65_62.append(var66_63).toString();
            var68_65 = Log.v("SyncManager", var67_64);
        }
        var69_66 = var3_3;
        var70_67 = var4_4;
        var72_68 = new SyncOperation(var53_51, var31_29, var47_45, var69_66, var70_67);
        var73_69 = this;
        var74_70 = var72_68;
        var73_69.scheduleSyncOperation(var74_70);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void scheduleSyncOperation(SyncOperation syncOperation) {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (syncOperation.expedited && activeSyncContext != null) {
            String string2 = activeSyncContext.mSyncOperation.key;
            String string3 = syncOperation.key;
            boolean bl = string2.equals(string3);
            if (!activeSyncContext.mSyncOperation.expedited && !bl) {
                SyncOperation syncOperation2 = activeSyncContext.mSyncOperation;
                SyncOperation syncOperation3 = new SyncOperation(syncOperation2);
                this.scheduleSyncOperation(syncOperation3);
                this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
            }
        }
        SyncQueue syncQueue = this.mSyncQueue;
        // MONITORENTER : syncQueue
        boolean bl = this.mSyncQueue.add(syncOperation);
        // MONITOREXIT : syncQueue
        if (bl) {
            if (Log.isLoggable(TAG, 2)) {
                String string4 = "scheduleSyncOperation: enqueued " + syncOperation;
                int n = Log.v(TAG, string4);
            }
            this.sendCheckAlarmsMessage();
            return;
        }
        if (!Log.isLoggable(TAG, 2)) {
            return;
        }
        String string5 = "scheduleSyncOperation: dropping duplicate sync operation " + syncOperation;
        int n = Log.v(TAG, string5);
    }

    class SyncHandler
    extends Handler {
        private static final int MESSAGE_CHECK_ALARMS = 3;
        private static final int MESSAGE_SERVICE_CONNECTED = 4;
        private static final int MESSAGE_SERVICE_DISCONNECTED = 5;
        private static final int MESSAGE_SYNC_ALARM = 2;
        private static final int MESSAGE_SYNC_FINISHED = 1;
        private Long mAlarmScheduleTime;
        private boolean mErrorNotificationInstalled;
        private volatile CountDownLatch mReadyToRunLatch;
        public final SyncNotificationInfo mSyncNotificationInfo;
        public final SyncTimeTracker mSyncTimeTracker;

        public SyncHandler(Looper looper) {
            CountDownLatch countDownLatch;
            SyncTimeTracker syncTimeTracker;
            SyncNotificationInfo syncNotificationInfo;
            super(looper);
            this.mSyncNotificationInfo = syncNotificationInfo = new SyncNotificationInfo();
            this.mAlarmScheduleTime = null;
            SyncManager syncManager2 = SyncManager.this;
            this.mSyncTimeTracker = syncTimeTracker = syncManager2.new SyncTimeTracker();
            this.mErrorNotificationInstalled = false;
            this.mReadyToRunLatch = countDownLatch = new CountDownLatch(1);
        }

        private void installHandleTooManyDeletesNotification(Account account, String string2, long l) {
            int n;
            if (SyncManager.this.mNotificationMgr == null) {
                return;
            }
            ProviderInfo providerInfo = SyncManager.this.mContext.getPackageManager().resolveContentProvider(string2, 0);
            if (providerInfo == null) {
                return;
            }
            PackageManager packageManager = SyncManager.this.mContext.getPackageManager();
            CharSequence charSequence = providerInfo.loadLabel(packageManager);
            Intent intent = new Intent();
            Intent intent2 = intent.setClassName("com.android.providers.subscribedfeeds", "com.android.settings.SyncActivityTooManyDeletes");
            Intent intent3 = intent.putExtra("account", account);
            Intent intent4 = intent.putExtra("authority", string2);
            String string3 = ((Object)charSequence).toString();
            Intent intent5 = intent.putExtra("provider", string3);
            Intent intent6 = intent.putExtra("numDeletes", l);
            if (!this.isActivityAvailable(intent)) {
                int n2 = Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity(SyncManager.this.mContext, 0, intent, 0x10000000);
            CharSequence charSequence2 = SyncManager.this.mContext.getResources().getText(17039627);
            String string4 = SyncManager.this.mContext.getString(17039625);
            long l2 = System.currentTimeMillis();
            Notification notification = new Notification(17302163, string4, l2);
            Context context = SyncManager.this.mContext;
            String string5 = SyncManager.this.mContext.getString(17039626);
            String string6 = ((Object)charSequence2).toString();
            Object[] objectArray = new Object[]{charSequence};
            String string7 = String.format(string6, objectArray);
            notification.setLatestEventInfo(context, string5, string7, pendingIntent);
            notification.flags = n = notification.flags | 2;
            NotificationManager notificationManager = SyncManager.this.mNotificationMgr;
            int n3 = account.hashCode();
            int n4 = string2.hashCode();
            int n5 = n3 ^ n4;
            notificationManager.notify(n5, notification);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isActivityAvailable(Intent intent) {
            List<ResolveInfo> list = SyncManager.this.mContext.getPackageManager().queryIntentActivities(intent, 0);
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                if ((list.get((int)n2).activityInfo.applicationInfo.flags & 1) != 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void manageErrorNotification() {
            long l;
            long l2;
            long l3 = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime();
            if (l3 > 0L && (l2 = 600000L + l3) < (l = System.currentTimeMillis())) {
                if (!this.mErrorNotificationInstalled) {
                    boolean bl = SyncManager.access$2502(SyncManager.this, true);
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = true;
                return;
            }
            if (this.mErrorNotificationInstalled) {
                boolean bl = SyncManager.access$2502(SyncManager.this, false);
                this.sendSyncStateIntent();
            }
            this.mErrorNotificationInstalled = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void manageSyncAlarm(Long l) {
            long l2;
            Long l3;
            if (!SyncManager.this.mDataConnectionIsConnected) {
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                return;
            }
            long l4 = SystemClock.elapsedRealtime();
            if (SyncManager.this.mActiveSyncContext == null) {
                SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                synchronized (syncQueue) {
                    Pair<SyncOperation, Long> pair = SyncManager.this.mSyncQueue.nextOperation();
                    if (l == null && pair == null) {
                        l3 = null;
                    } else if (l == null) {
                        l3 = (Long)pair.second;
                    } else if (pair == null) {
                        l3 = l;
                    } else {
                        long l5 = l;
                        long l6 = (Long)pair.second;
                        l3 = Math.min(l5, l6);
                    }
                }
            } else {
                long l7 = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.startTime + 30000L;
                long l8 = ((SyncManager)SyncManager.this).mActiveSyncContext.mTimeoutStartTime;
                long l9 = MAX_TIME_PER_SYNC;
                long l10 = l8 + l9;
                if (((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.isActive) {
                    l3 = l10;
                } else {
                    long l11 = l7;
                    long l12 = l10;
                    l3 = Math.min(l11, l12);
                }
            }
            if (!this.mErrorNotificationInstalled && (l2 = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime()) > 0L) {
                long l13;
                long l14 = l2 + 600000L;
                long l15 = System.currentTimeMillis();
                long l16 = l14 - l15;
                l2 = l4 + l16;
                if (l3 != null) {
                    long l17 = l3;
                    long l18 = l2;
                    l13 = Math.min(l17, l18);
                } else {
                    l13 = l2;
                }
                l3 = l13;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.mAlarmScheduleTime != null;
            boolean bl4 = l3 != null;
            if (bl4) {
                long l19;
                long l20;
                if (!bl3 || (l20 = l3.longValue()) < (l19 = this.mAlarmScheduleTime.longValue())) {
                    bl = true;
                }
            } else {
                bl2 = bl3;
            }
            SyncManager.this.ensureAlarmService();
            if (bl) {
                Long l21;
                this.mAlarmScheduleTime = l21 = l3;
                AlarmManager alarmManager = SyncManager.this.mAlarmService;
                long l22 = l3;
                PendingIntent pendingIntent = SyncManager.this.mSyncAlarmIntent;
                alarmManager.set(2, l22, pendingIntent);
                return;
            }
            if (!bl2) {
                return;
            }
            Object var51_31 = null;
            this.mAlarmScheduleTime = var51_31;
            AlarmManager alarmManager = SyncManager.this.mAlarmService;
            PendingIntent pendingIntent = SyncManager.this.mSyncAlarmIntent;
            alarmManager.cancel(pendingIntent);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void manageSyncNotification() {
            String string2;
            Account account;
            boolean bl;
            boolean bl2;
            if (SyncManager.this.mActiveSyncContext == null) {
                this.mSyncNotificationInfo.startTime = null;
                bl2 = this.mSyncNotificationInfo.isActive;
                bl = false;
            } else {
                Account account2;
                Account account3;
                String string3;
                String string4;
                SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                long l = SystemClock.elapsedRealtime();
                if (this.mSyncNotificationInfo.startTime == null) {
                    Long l2;
                    SyncNotificationInfo syncNotificationInfo = this.mSyncNotificationInfo;
                    syncNotificationInfo.startTime = l2 = Long.valueOf(l);
                }
                bl2 = this.mSyncNotificationInfo.isActive && (!(string4 = syncOperation.authority).equals(string3 = this.mSyncNotificationInfo.authority) || !(account3 = syncOperation.account).equals(account2 = this.mSyncNotificationInfo.account));
                if (this.mSyncNotificationInfo.isActive) {
                    bl = bl2;
                } else {
                    long l3 = this.mSyncNotificationInfo.startTime + 30000L;
                    boolean bl3 = l > l3;
                    boolean bl4 = syncOperation.extras.getBoolean("force", false);
                    bl = bl3 || bl4;
                }
            }
            if (bl2 && !bl) {
                boolean bl5 = SyncManager.access$2402(SyncManager.this, false);
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = false;
            }
            if (!bl) {
                return;
            }
            SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
            boolean bl6 = SyncManager.access$2402(SyncManager.this, true);
            this.sendSyncStateIntent();
            this.mSyncNotificationInfo.isActive = true;
            SyncNotificationInfo syncNotificationInfo = this.mSyncNotificationInfo;
            syncNotificationInfo.account = account = syncOperation.account;
            SyncNotificationInfo syncNotificationInfo2 = this.mSyncNotificationInfo;
            syncNotificationInfo2.authority = string2 = syncOperation.authority;
        }

        private void runBoundToSyncAdapter(ISyncAdapter iSyncAdapter) {
            ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncAdapter = iSyncAdapter;
            SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
            try {
                ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
                String string2 = syncOperation.authority;
                Account account = syncOperation.account;
                Bundle bundle = syncOperation.extras;
                iSyncAdapter.startSync(activeSyncContext, string2, account, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                int n = Log.d(SyncManager.TAG, "runStateIdle: caught a RemoteException, rescheduling", remoteException);
                SyncManager.this.mActiveSyncContext.close();
                ActiveSyncContext activeSyncContext = SyncManager.access$1102(SyncManager.this, null);
                SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
                ActiveSyncContext activeSyncContext2 = SyncManager.this.mActiveSyncContext;
                syncStorageEngine.setActiveSync(activeSyncContext2);
                SyncManager.this.increaseBackoffSetting(syncOperation);
                SyncManager syncManager = SyncManager.this;
                SyncOperation syncOperation2 = new SyncOperation(syncOperation);
                syncManager.scheduleSyncOperation(syncOperation2);
                return;
            }
            catch (RuntimeException runtimeException) {
                SyncManager.this.mActiveSyncContext.close();
                ActiveSyncContext activeSyncContext = SyncManager.access$1102(SyncManager.this, null);
                SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
                ActiveSyncContext activeSyncContext3 = SyncManager.this.mActiveSyncContext;
                syncStorageEngine.setActiveSync(activeSyncContext3);
                String string3 = "Caught RuntimeException while starting the sync " + syncOperation;
                int n = Log.e(SyncManager.TAG, string3, runtimeException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runStateIdle() {
            ActiveSyncContext activeSyncContext;
            SyncAdapterType syncAdapterType;
            int n;
            SyncOperation syncOperation;
            Account[] accountArray;
            Account[] accountArray2;
            boolean bl = Log.isLoggable(SyncManager.TAG, 2);
            if (bl) {
                int n2 = Log.v(SyncManager.TAG, "runStateIdle");
            }
            if (!SyncManager.this.mDataConnectionIsConnected) {
                if (!bl) {
                    return;
                }
                int n3 = Log.v(SyncManager.TAG, "runStateIdle: no data connection, skipping");
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                if (!bl) {
                    return;
                }
                int n4 = Log.v(SyncManager.TAG, "runStateIdle: memory low, skipping");
                return;
            }
            Account[] accountArray3 = SyncManager.this.mAccounts;
            Account[] accountArray4 = accountArray3;
            if (accountArray4 == (accountArray2 = (accountArray = INITIAL_ACCOUNTS_ARRAY))) {
                if (!bl) {
                    return;
                }
                int n5 = Log.v(SyncManager.TAG, "runStateIdle: accounts not known, skipping");
                return;
            }
            boolean bl2 = SyncManager.this.getConnectivityManager().getBackgroundDataSetting();
            boolean bl3 = SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically();
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            synchronized (syncQueue) {
                String string2;
                Account account;
                SyncStorageEngine syncStorageEngine;
                String string3;
                Account account2;
                SyncStorageEngine syncStorageEngine2;
                Account account3;
                Account[] accountArray5;
                long l = SystemClock.elapsedRealtime();
                do {
                    Pair<SyncOperation, Long> pair;
                    if ((pair = SyncManager.this.mSyncQueue.nextOperation()) == null || (Long)pair.second > l) {
                        if (bl) {
                            int n6 = Log.v(SyncManager.TAG, "runStateIdle: no more ready sync operations, returning");
                        }
                        return;
                    }
                    syncOperation = (SyncOperation)pair.first;
                    SyncQueue syncQueue2 = SyncManager.this.mSyncQueue;
                    SyncOperation syncOperation2 = syncOperation;
                    syncQueue2.remove(syncOperation2);
                } while (!ArrayUtils.contains(accountArray5 = SyncManager.this.mAccounts, account3 = syncOperation.account) || (n = (syncStorageEngine2 = SyncManager.this.mSyncStorageEngine).getIsSyncable(account2 = syncOperation.account, string3 = syncOperation.authority)) == 0 || !syncOperation.extras.getBoolean("ignore_settings", false) && n > 0 && (!bl3 || !bl2 || !(syncStorageEngine = SyncManager.this.mSyncStorageEngine).getSyncAutomatically(account = syncOperation.account, string2 = syncOperation.authority)));
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("runStateIdle: we are going to sync ");
                    SyncOperation syncOperation3 = syncOperation;
                    String string4 = stringBuilder.append(syncOperation3).toString();
                    int n7 = Log.v(SyncManager.TAG, string4);
                }
            }
            boolean bl4 = syncOperation.extras.getBoolean("initialize", false);
            if (n < 0 && !bl4) {
                syncOperation.extras.putBoolean("initialize", true);
                syncOperation = new SyncOperation(syncOperation);
            } else if (n > 0 && bl4) {
                syncOperation.extras.putBoolean("initialize", false);
                syncOperation = new SyncOperation(syncOperation);
            }
            String string5 = syncOperation.authority;
            String string6 = syncOperation.account.type;
            SyncAdapterType syncAdapterType2 = SyncAdapterType.newKey(string5, string6);
            SyncAdaptersCache syncAdaptersCache = SyncManager.this.mSyncAdapters;
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo = syncAdaptersCache.getServiceInfo(syncAdapterType = syncAdapterType2);
            if (serviceInfo == null) {
                StringBuilder stringBuilder = new StringBuilder().append("can't find a sync adapter for ");
                SyncAdapterType syncAdapterType3 = syncAdapterType2;
                String string7 = stringBuilder.append(syncAdapterType3).append(", removing settings for it").toString();
                int n8 = Log.d(SyncManager.TAG, string7);
                SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
                Account account = syncOperation.account;
                String string8 = syncOperation.authority;
                syncStorageEngine.removeAuthority(account, string8);
                this.runStateIdle();
                return;
            }
            SyncManager syncManager = SyncManager.this;
            SyncHandler syncHandler = this;
            SyncOperation syncOperation4 = syncOperation;
            long l = syncHandler.insertStartSyncEvent(syncOperation4);
            ActiveSyncContext activeSyncContext2 = activeSyncContext;
            SyncManager syncManager2 = syncManager;
            SyncOperation syncOperation5 = syncOperation;
            long l2 = l;
            activeSyncContext2(syncOperation5, l2);
            SyncManager syncManager3 = SyncManager.this;
            ActiveSyncContext activeSyncContext3 = activeSyncContext;
            ActiveSyncContext activeSyncContext4 = SyncManager.access$1102(syncManager3, activeSyncContext3);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("runStateIdle: setting mActiveSyncContext to ");
                ActiveSyncContext activeSyncContext5 = SyncManager.this.mActiveSyncContext;
                String string9 = stringBuilder.append(activeSyncContext5).toString();
                int n9 = Log.v(SyncManager.TAG, string9);
            }
            SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
            ActiveSyncContext activeSyncContext6 = SyncManager.this.mActiveSyncContext;
            syncStorageEngine.setActiveSync(activeSyncContext6);
            ActiveSyncContext activeSyncContext7 = activeSyncContext;
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo2 = serviceInfo;
            if (!activeSyncContext7.bindToSyncAdapter(serviceInfo2)) {
                StringBuilder stringBuilder = new StringBuilder().append("Bind attempt failed to ");
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo3 = serviceInfo;
                String string10 = stringBuilder.append(serviceInfo3).toString();
                int n10 = Log.e(SyncManager.TAG, string10);
                SyncManager.this.mActiveSyncContext.close();
                ActiveSyncContext activeSyncContext8 = SyncManager.access$1102(SyncManager.this, null);
                SyncStorageEngine syncStorageEngine3 = SyncManager.this.mSyncStorageEngine;
                ActiveSyncContext activeSyncContext9 = SyncManager.this.mActiveSyncContext;
                syncStorageEngine3.setActiveSync(activeSyncContext9);
                SyncManager.this.mSyncWakeLock.setWorkSource(null);
                this.runStateIdle();
                return;
            }
            PowerManager.WakeLock wakeLock = SyncManager.this.mSyncWakeLock;
            int n11 = serviceInfo.uid;
            WorkSource workSource = new WorkSource(n11);
            wakeLock.setWorkSource(workSource);
            SyncManager.this.mSyncWakeLock.acquire();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void runStateSyncing() {
            long l;
            long l2;
            long l3;
            long l4;
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            long l5 = SystemClock.elapsedRealtime();
            if (l5 <= (l4 = (l3 = activeSyncContext.mTimeoutStartTime) + (l2 = MAX_TIME_PER_SYNC))) {
                return;
            }
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            // MONITORENTER : syncQueue
            Pair<SyncOperation, Long> pair = SyncManager.this.mSyncQueue.nextOperation();
            // MONITOREXIT : syncQueue
            if (pair != null && (Long)pair.second <= l5) {
                StringBuilder stringBuilder = new StringBuilder().append("canceling and rescheduling sync because it ran too long: ");
                SyncOperation syncOperation = activeSyncContext.mSyncOperation;
                String string2 = stringBuilder.append(syncOperation).toString();
                int n = Log.d(SyncManager.TAG, string2);
                SyncManager syncManager = SyncManager.this;
                SyncOperation syncOperation2 = activeSyncContext.mSyncOperation;
                SyncOperation syncOperation3 = new SyncOperation(syncOperation2);
                syncManager.scheduleSyncOperation(syncOperation3);
                SyncManager.this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
                return;
            }
            activeSyncContext.mTimeoutStartTime = l = MAX_TIME_PER_SYNC + l5;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runSyncFinishedOrCanceled(SyncResult syncResult) {
            int n;
            int n2;
            String string2;
            boolean bl = Log.isLoggable(SyncManager.TAG, 2);
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            ActiveSyncContext activeSyncContext2 = SyncManager.access$1102(SyncManager.this, null);
            SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
            ActiveSyncContext activeSyncContext3 = SyncManager.this.mActiveSyncContext;
            syncStorageEngine.setActiveSync(activeSyncContext3);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            long l = SystemClock.elapsedRealtime();
            long l2 = activeSyncContext.mStartTime;
            long l3 = l - l2;
            if (syncResult != null) {
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("runSyncFinishedOrCanceled [finished]: ").append(syncOperation).append(", result ");
                    SyncResult syncResult2 = syncResult;
                    String string3 = stringBuilder.append(syncResult2).toString();
                    int n3 = Log.v(SyncManager.TAG, string3);
                }
                if (!syncResult.hasError()) {
                    String string4;
                    Account account;
                    SyncStorageEngine syncStorageEngine2;
                    string2 = "success";
                    n2 = 0;
                    n = 0;
                    SyncManager.this.clearBackoffSetting(syncOperation);
                    if (syncOperation.extras.getBoolean("initialize", false) && (syncStorageEngine2 = SyncManager.this.mSyncStorageEngine).getIsSyncable(account = syncOperation.account, string4 = syncOperation.authority) > 0) {
                        SyncManager syncManager = SyncManager.this;
                        SyncOperation syncOperation2 = new SyncOperation(syncOperation);
                        syncManager.scheduleSyncOperation(syncOperation2);
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("failed sync operation ").append(syncOperation).append(", ");
                    SyncResult syncResult3 = syncResult;
                    String string5 = stringBuilder.append(syncResult3).toString();
                    int n4 = Log.d(SyncManager.TAG, string5);
                    if (!syncResult.syncAlreadyInProgress) {
                        SyncManager.this.increaseBackoffSetting(syncOperation);
                    }
                    SyncManager syncManager = SyncManager.this;
                    SyncResult syncResult4 = syncResult;
                    SyncOperation syncOperation3 = syncOperation;
                    syncManager.maybeRescheduleSync(syncResult4, syncOperation3);
                    string2 = Integer.toString(this.syncResultToErrorNumber(syncResult));
                    n2 = 0;
                    n = 0;
                }
                SyncManager syncManager = SyncManager.this;
                long l4 = syncResult.delayUntil;
                syncManager.setDelayUntilTime(syncOperation, l4);
            } else {
                if (bl) {
                    String string6 = "runSyncFinishedOrCanceled [canceled]: " + syncOperation;
                    int n5 = Log.v(SyncManager.TAG, string6);
                }
                if (activeSyncContext.mSyncAdapter != null) {
                    try {
                        ISyncAdapter iSyncAdapter = activeSyncContext.mSyncAdapter;
                        ActiveSyncContext activeSyncContext4 = activeSyncContext;
                        iSyncAdapter.cancelSync(activeSyncContext4);
                    }
                    catch (RemoteException remoteException) {}
                }
                string2 = "canceled";
                n2 = 0;
                n = 0;
            }
            long l5 = activeSyncContext.mHistoryRowId;
            this.stopSyncEvent(l5, syncOperation, string2, n, n2, l3);
            activeSyncContext.close();
            if (syncResult != null && syncResult.tooManyDeletions) {
                Account account = syncOperation.account;
                String string7 = syncOperation.authority;
                long l6 = syncResult.stats.numDeletes;
                SyncHandler syncHandler = this;
                Account account2 = account;
                String string8 = string7;
                long l7 = l6;
                syncHandler.installHandleTooManyDeletesNotification(account2, string8, l7);
            } else {
                NotificationManager notificationManager = SyncManager.this.mNotificationMgr;
                int n6 = syncOperation.account.hashCode();
                int n7 = syncOperation.authority.hashCode();
                int n8 = n6 ^ n7;
                notificationManager.cancel(n8);
            }
            if (syncResult == null) {
                return;
            }
            if (!syncResult.fullSyncRequested) {
                return;
            }
            SyncManager syncManager = SyncManager.this;
            Account account = syncOperation.account;
            int n9 = syncOperation.syncSource;
            String string9 = syncOperation.authority;
            Bundle bundle = new Bundle();
            SyncOperation syncOperation4 = new SyncOperation(account, n9, string9, bundle, 0L);
            syncManager.scheduleSyncOperation(syncOperation4);
        }

        /*
         * Unable to fully structure code
         */
        private Long scheduleReadyPeriodicSyncs() {
            block8: {
                var1_1 = SyncManager.access$300(SyncManager.this).getBackgroundDataSetting();
                var2_2 = null;
                if (!var1_1 || !SyncManager.access$1400(SyncManager.this).getMasterSyncAutomatically()) {
                    var3_3 = null;
lbl5:
                    // 3 sources

                    return var3_3;
                }
                var4_4 = System.currentTimeMillis();
                for (SyncStorageEngine.AuthorityInfo var7_6 : SyncManager.access$1400(SyncManager.this).getAuthorities()) {
                    var8_7 = SyncManager.access$1600(SyncManager.this);
                    if (!ArrayUtils.contains(var8_7, var9_8 = var7_6.account) || !(var10_9 = SyncManager.access$1400(SyncManager.this)).getSyncAutomatically(var11_10 = var7_6.account, var12_11 = var7_6.authority) || (var13_12 = SyncManager.access$1400(SyncManager.this)).getIsSyncable(var14_13 = var7_6.account, var15_14 = var7_6.authority) == 0) continue;
                    var16_15 = SyncManager.access$1400(SyncManager.this);
                    var17_16 = var7_6;
                    var18_17 = var16_15.getOrCreateSyncStatus(var17_16);
                    var20_19 = var7_6.periodicSyncs.size();
                    block2: for (var19_18 = 0; var19_18 < var20_19; ++var19_18) {
                        var21_20 = (Bundle)var7_6.periodicSyncs.get((int)var19_18).first;
                        var22_21 = (Long)var7_6.periodicSyncs.get((int)var19_18).second;
                        var23_22 = var18_17;
                        var24_23 = var19_18;
                        var25_24 = var23_22.getPeriodicSyncTime(var24_23);
                        var29_26 = var25_24 + (var27_25 = var22_21 * 1000L);
                        if (var29_26 <= var4_4) {
                            var31_27 = SyncManager.this;
                            var32_28 = var7_6.account;
                            var33_29 = var7_6.authority;
                            var34_30 = new SyncOperation(var32_28, 4, var33_29, var21_20, 0L);
                            var31_27.scheduleSyncOperation(var34_30);
                            var35_31 = var18_17;
                            var36_32 = var19_18;
                            var37_33 = var4_4;
                            var35_31.setPeriodicSyncTime(var36_32, var37_33);
lbl32:
                            // 3 sources

                            continue block2;
                        }
                        if (var2_2 != null && var29_26 >= (var39_34 = var2_2.longValue())) ** GOTO lbl32
                        var2_2 = var29_26;
                        ** continue;
                    }
                }
                if (var2_2 != null) break block8;
                var3_3 = null;
                ** GOTO lbl5
            }
            var41_35 = SystemClock.elapsedRealtime();
            if (var2_2 < var4_4) {
                var43_36 = 0L;
lbl45:
                // 2 sources

                while (true) {
                    var3_3 = var41_35 + var43_36;
                    ** continue;
                    break;
                }
            }
            var43_36 = var2_2 - var4_4;
            ** while (true)
        }

        private void sendSyncStateIntent() {
            Intent intent = new Intent("android.intent.action.SYNC_STATE_CHANGED");
            Intent intent2 = intent.addFlags(0x10000000);
            boolean bl = SyncManager.this.mNeedSyncActiveNotification;
            Intent intent3 = intent.putExtra("active", bl);
            boolean bl2 = SyncManager.this.mNeedSyncErrorNotification;
            Intent intent4 = intent.putExtra("failing", bl2);
            SyncManager.this.mContext.sendBroadcast(intent);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            String string2 = "we are not in an error state, " + syncResult;
            throw new IllegalStateException(string2);
        }

        private void waitUntilReadyToRun() {
            CountDownLatch countDownLatch = this.mReadyToRunLatch;
            if (countDownLatch == null) {
                return;
            }
            while (true) {
                try {
                    countDownLatch.await();
                    this.mReadyToRunLatch = null;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void handleMessage(Message var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 342->585)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            int n = syncOperation.syncSource;
            long l = System.currentTimeMillis();
            Object[] objectArray = new Object[4];
            String string2 = syncOperation.authority;
            objectArray[0] = string2;
            Integer n2 = 0;
            objectArray[1] = n2;
            Integer n3 = n;
            objectArray[2] = n3;
            Integer n4 = syncOperation.account.name.hashCode();
            objectArray[3] = n4;
            int n5 = EventLog.writeEvent(2720, objectArray);
            SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
            Account account = syncOperation.account;
            String string3 = syncOperation.authority;
            return syncStorageEngine.insertStartSyncEvent(account, string3, l, n);
        }

        public void onBootCompleted() {
            boolean bl = SyncManager.access$1302(SyncManager.this, true);
            SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
            Account[] accountArray = AccountManager.get(SyncManager.this.mContext).getAccounts();
            syncStorageEngine.doDatabaseCleanup(accountArray);
            if (this.mReadyToRunLatch == null) {
                return;
            }
            this.mReadyToRunLatch.countDown();
        }

        public void stopSyncEvent(long l, SyncOperation syncOperation, String string2, int n, int n2, long l2) {
            Object[] objectArray = new Object[4];
            String string3 = syncOperation.authority;
            objectArray[0] = string3;
            Integer n3 = 1;
            objectArray[1] = n3;
            Integer n4 = syncOperation.syncSource;
            objectArray[2] = n4;
            Integer n5 = syncOperation.account.name.hashCode();
            objectArray[3] = n5;
            int n6 = EventLog.writeEvent(2720, objectArray);
            SyncStorageEngine syncStorageEngine = SyncManager.this.mSyncStorageEngine;
            long l3 = n2;
            long l4 = n;
            long l5 = l;
            long l6 = l2;
            String string4 = string2;
            syncStorageEngine.stopSyncEvent(l5, l6, string4, l3, l4);
        }

        class SyncNotificationInfo {
            public Account account;
            public String authority;
            public boolean isActive = false;
            public Long startTime = null;

            SyncNotificationInfo() {
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                this.toString(stringBuilder);
                return stringBuilder.toString();
            }

            public void toString(StringBuilder stringBuilder) {
                StringBuilder stringBuilder2 = stringBuilder.append("account ");
                Account account = this.account;
                StringBuilder stringBuilder3 = stringBuilder2.append(account).append(", authority ");
                String string2 = this.authority;
                StringBuilder stringBuilder4 = stringBuilder3.append(string2).append(", isActive ");
                boolean bl = this.isActive;
                StringBuilder stringBuilder5 = stringBuilder4.append(bl).append(", startTime ");
                Long l = this.startTime;
                StringBuilder stringBuilder6 = stringBuilder5.append(l);
            }
        }
    }

    class ServiceConnectionData {
        public final ActiveSyncContext activeSyncContext;
        public final ISyncAdapter syncAdapter;

        ServiceConnectionData(ActiveSyncContext activeSyncContext, ISyncAdapter iSyncAdapter) {
            this.activeSyncContext = activeSyncContext;
            this.syncAdapter = iSyncAdapter;
        }
    }

    private class SyncTimeTracker {
        boolean mLastWasSyncing = false;
        private long mTimeSpentSyncing;
        long mWhenSyncStarted = 0L;

        private SyncTimeTracker() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long timeSpentSyncing() {
            synchronized (this) {
                if (!this.mLastWasSyncing) {
                    return this.mTimeSpentSyncing;
                }
                long l = SystemClock.elapsedRealtime();
                long l2 = this.mTimeSpentSyncing;
                long l3 = this.mWhenSyncStarted;
                long l4 = l - l3;
                l2 += l4;
                return l2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void update() {
            synchronized (this) {
                boolean bl = SyncManager.this.mActiveSyncContext != null;
                boolean bl2 = this.mLastWasSyncing;
                if (bl == bl2) {
                    long l = SystemClock.elapsedRealtime();
                    if (bl) {
                        this.mWhenSyncStarted = l;
                    } else {
                        long l2;
                        long l3 = this.mTimeSpentSyncing;
                        long l4 = this.mWhenSyncStarted;
                        long l5 = l - l4;
                        this.mTimeSpentSyncing = l2 = l3 + l5;
                    }
                    this.mLastWasSyncing = bl;
                }
                return;
            }
        }
    }

    class ActiveSyncContext
    extends ISyncContext.Stub
    implements ServiceConnection {
        boolean mBound;
        final long mHistoryRowId;
        final long mStartTime;
        ISyncAdapter mSyncAdapter;
        final SyncOperation mSyncOperation;
        long mTimeoutStartTime;

        public ActiveSyncContext(SyncOperation syncOperation, long l) {
            long l2;
            long l3;
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = l;
            this.mSyncAdapter = null;
            this.mTimeoutStartTime = l3 = (this.mStartTime = (l2 = SystemClock.elapsedRealtime()));
        }

        boolean bindToSyncAdapter(RegisteredServicesCache.ServiceInfo serviceInfo) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("bindToSyncAdapter: ");
                ComponentName componentName = serviceInfo.componentName;
                String string2 = stringBuilder.append(componentName).append(", connection ").append(this).toString();
                int n = Log.d(SyncManager.TAG, string2);
            }
            Intent intent = new Intent();
            Intent intent2 = intent.setAction("android.content.SyncAdapter");
            ComponentName componentName = serviceInfo.componentName;
            Intent intent3 = intent.setComponent(componentName);
            Intent intent4 = intent.putExtra("android.intent.extra.client_label", 17040226);
            Context context = SyncManager.this.mContext;
            Intent intent5 = new Intent("android.settings.SYNC_SETTINGS");
            PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, intent5, 0);
            Intent intent6 = intent.putExtra("android.intent.extra.client_intent", pendingIntent);
            this.mBound = true;
            boolean bl = SyncManager.this.mContext.bindService(intent, this, 5);
            if (!bl) {
                this.mBound = false;
            }
            return bl;
        }

        protected void close() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                String string2 = "unBindFromSyncAdapter: connection " + this;
                int n = Log.d(SyncManager.TAG, string2);
            }
            if (!this.mBound) {
                return;
            }
            this.mBound = false;
            SyncManager.this.mContext.unbindService(this);
        }

        @Override
        public void onFinished(SyncResult syncResult) {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, syncResult);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Message message = SyncManager.this.mSyncHandler.obtainMessage();
            message.what = 4;
            SyncManager syncManager = SyncManager.this;
            ISyncAdapter iSyncAdapter = ISyncAdapter.Stub.asInterface(iBinder);
            ServiceConnectionData serviceConnectionData = syncManager.new ServiceConnectionData(this, iSyncAdapter);
            message.obj = serviceConnectionData;
            boolean bl = SyncManager.this.mSyncHandler.sendMessage(message);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Message message = SyncManager.this.mSyncHandler.obtainMessage();
            message.what = 5;
            SyncManager syncManager = SyncManager.this;
            ServiceConnectionData serviceConnectionData = syncManager.new ServiceConnectionData(this, null);
            message.obj = serviceConnectionData;
            boolean bl = SyncManager.this.mSyncHandler.sendMessage(message);
        }

        @Override
        public void sendHeartbeat() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = stringBuilder.append("startTime ");
            long l = this.mStartTime;
            StringBuilder stringBuilder3 = stringBuilder2.append(l).append(", mTimeoutStartTime ");
            long l2 = this.mTimeoutStartTime;
            StringBuilder stringBuilder4 = stringBuilder3.append(l2).append(", mHistoryRowId ");
            long l3 = this.mHistoryRowId;
            StringBuilder stringBuilder5 = stringBuilder4.append(l3).append(", syncOperation ");
            SyncOperation syncOperation = this.mSyncOperation;
            StringBuilder stringBuilder6 = stringBuilder5.append(syncOperation);
        }
    }

    class SyncAlarmIntentReceiver
    extends BroadcastReceiver {
        SyncAlarmIntentReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mHandleAlarmWakeLock.acquire();
            SyncManager.this.sendSyncAlarmMessage();
        }
    }

    class SyncHandlerMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        SyncHandlerMessagePayload(ActiveSyncContext activeSyncContext, SyncResult syncResult) {
            this.activeSyncContext = activeSyncContext;
            this.syncResult = syncResult;
        }
    }

    private static class InitializerServiceConnection
    implements ServiceConnection {
        private final Account mAccount;
        private final String mAuthority;
        private volatile Context mContext;
        private final Handler mHandler;
        private volatile boolean mInitialized;

        public InitializerServiceConnection(Account account, String string2, Context context, Handler handler) {
            this.mAccount = account;
            this.mAuthority = string2;
            this.mContext = context;
            this.mHandler = handler;
            this.mInitialized = false;
        }

        static /* synthetic */ Context access$502(InitializerServiceConnection initializerServiceConnection, Context context) {
            initializerServiceConnection.mContext = context;
            return context;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onServiceConnected(ComponentName var1_1, IBinder var2_2) {
            try {
                if (!this.mInitialized) {
                    this.mInitialized = true;
                    if (Log.isLoggable("SyncManager", 2)) {
                        var3_3 = new StringBuilder().append("calling initialize: ");
                        var4_4 = this.mAccount;
                        var5_5 = var3_3.append(var4_4).append(", authority ");
                        var6_6 = this.mAuthority;
                        var7_7 = var5_5.append(var6_6).toString();
                        var8_8 = Log.v("SyncManager", var7_7);
                    }
                    var9_9 = ISyncAdapter.Stub.asInterface(var2_2);
                    var10_10 = this.mAccount;
                    var11_11 = this.mAuthority;
                    var9_9.initialize(var10_10, var11_11);
                }
                var12_12 = this.mHandler;
            }
            catch (RemoteException var15_15) {
                try {
                    var16_16 = new StringBuilder().append("error while initializing: ");
                    var17_17 = this.mAccount;
                    var18_18 = var16_16.append(var17_17).append(", authority ");
                    var19_19 = this.mAuthority;
                    var20_20 = var18_18.append(var19_19).toString();
                    var21_21 = Log.d("SyncManager", var20_20, var15_15);
                    var12_12 = this.mHandler;
                }
                catch (Throwable var22_22) {
                    var23_23 = this.mHandler;
                    var24_24 = new Runnable(){

                        @Override
                        public void run() {
                            if (InitializerServiceConnection.this.mContext == null) {
                                return;
                            }
                            Context context = InitializerServiceConnection.this.mContext;
                            InitializerServiceConnection initializerServiceConnection = InitializerServiceConnection.this;
                            context.unbindService(initializerServiceConnection);
                            Context context2 = InitializerServiceConnection.access$502(InitializerServiceConnection.this, null);
                        }
                    };
                    var25_25 = var23_23.postDelayed(var24_24, 5000L);
                    throw var22_22;
                }
                var13_13 = new /* invalid duplicate definition of identical inner class */;
                ** continue;
            }
            var13_13 = new /* invalid duplicate definition of identical inner class */;
lbl17:
            // 2 sources

            while (true) {
                var14_14 = var12_12.postDelayed(var13_13, 5000L);
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            if (this.mContext == null) {
                return;
            }
            this.mContext.unbindService(this);
            this.mContext = null;
        }
    }
}

