/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncStorageEngine;
import android.os.Bundle;
import android.os.SystemClock;

public class SyncOperation
implements Comparable {
    public final Account account;
    public String authority;
    public long earliestRunTime;
    public boolean expedited;
    public Bundle extras;
    public final String key;
    public SyncStorageEngine.PendingOperation pendingOperation;
    public int syncSource;

    /*
     * Enabled aggressive block sorting
     */
    public SyncOperation(Account account, int n, String string2, Bundle bundle, long l) {
        String string3;
        Bundle bundle2;
        this.account = account;
        this.syncSource = n;
        this.authority = string2;
        this.extras = bundle2 = new Bundle(bundle);
        this.removeFalseExtra("upload");
        this.removeFalseExtra("force");
        this.removeFalseExtra("ignore_settings");
        this.removeFalseExtra("ignore_backoff");
        this.removeFalseExtra("do_not_retry");
        this.removeFalseExtra("discard_deletions");
        this.removeFalseExtra("expedited");
        this.removeFalseExtra("deletions_override");
        long l2 = SystemClock.elapsedRealtime();
        if (l < 0L) {
            this.expedited = true;
            this.earliestRunTime = l2;
        } else {
            long l3;
            this.expedited = false;
            this.earliestRunTime = l3 = l2 + l;
        }
        this.key = string3 = this.toKey();
    }

    SyncOperation(SyncOperation syncOperation) {
        String string2;
        long l;
        boolean bl;
        Bundle bundle;
        String string3;
        int n;
        Account account;
        this.account = account = syncOperation.account;
        this.syncSource = n = syncOperation.syncSource;
        this.authority = string3 = syncOperation.authority;
        Bundle bundle2 = syncOperation.extras;
        this.extras = bundle = new Bundle(bundle2);
        this.expedited = bl = syncOperation.expedited;
        this.earliestRunTime = l = SystemClock.elapsedRealtime();
        this.key = string2 = this.toKey();
    }

    public static void extrasToStringBuilder(Bundle bundle, StringBuilder stringBuilder, boolean bl) {
        StringBuilder stringBuilder2 = stringBuilder.append("[");
        for (String string2 : bundle.keySet()) {
            if (bl && "initialize".equals(string2)) continue;
            StringBuilder stringBuilder3 = stringBuilder.append(string2).append("=");
            Object object = bundle.get(string2);
            StringBuilder stringBuilder4 = stringBuilder3.append(object).append(" ");
        }
        StringBuilder stringBuilder5 = stringBuilder.append("]");
    }

    private void removeFalseExtra(String string2) {
        if (this.extras.getBoolean(string2, false)) {
            return;
        }
        this.extras.remove(string2);
    }

    private String toKey() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("authority: ");
        String string2 = this.authority;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        StringBuilder stringBuilder4 = new StringBuilder().append(" account {name=");
        String string3 = this.account.name;
        StringBuilder stringBuilder5 = stringBuilder4.append(string3).append(", type=");
        String string4 = this.account.type;
        String string5 = stringBuilder5.append(string4).append("}").toString();
        StringBuilder stringBuilder6 = stringBuilder.append(string5);
        StringBuilder stringBuilder7 = stringBuilder.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, stringBuilder, true);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(Object object) {
        SyncOperation syncOperation = (SyncOperation)object;
        long l = this.earliestRunTime;
        long l2 = syncOperation.earliestRunTime;
        if (l == l2) {
            return 0;
        }
        long l3 = this.earliestRunTime;
        long l4 = syncOperation.earliestRunTime;
        if (l3 >= l4) return 1;
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("authority: ");
        String string2 = this.authority;
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        StringBuilder stringBuilder4 = stringBuilder.append(" account: ");
        Account account = this.account;
        StringBuilder stringBuilder5 = stringBuilder4.append(account);
        StringBuilder stringBuilder6 = stringBuilder.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, stringBuilder, false);
        StringBuilder stringBuilder7 = stringBuilder.append(" syncSource: ");
        int n = this.syncSource;
        StringBuilder stringBuilder8 = stringBuilder7.append(n);
        StringBuilder stringBuilder9 = stringBuilder.append(" when: ");
        long l = this.earliestRunTime;
        StringBuilder stringBuilder10 = stringBuilder9.append(l);
        StringBuilder stringBuilder11 = stringBuilder.append(" expedited: ");
        boolean bl = this.expedited;
        StringBuilder stringBuilder12 = stringBuilder11.append(bl);
        return stringBuilder.toString();
    }
}

