/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncOperation;
import android.content.SyncStorageEngine;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyncQueue {
    private static final String TAG = "SyncManager";
    private final HashMap<String, SyncOperation> mOperationsMap;
    private SyncStorageEngine mSyncStorageEngine;

    public SyncQueue(SyncStorageEngine syncStorageEngine) {
        HashMap hashMap = Maps.newHashMap();
        this.mOperationsMap = hashMap;
        this.mSyncStorageEngine = syncStorageEngine;
        ArrayList<SyncStorageEngine.PendingOperation> arrayList = this.mSyncStorageEngine.getPendingOperations();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            SyncStorageEngine.PendingOperation pendingOperation = arrayList.get(n2);
            Account account = pendingOperation.account;
            int n3 = pendingOperation.syncSource;
            String string2 = pendingOperation.authority;
            Bundle bundle = pendingOperation.extras;
            SyncOperation syncOperation = new SyncOperation(account, n3, string2, bundle, 0L);
            syncOperation.expedited = bl = pendingOperation.expedited;
            syncOperation.pendingOperation = pendingOperation;
            boolean bl2 = this.add(syncOperation, pendingOperation);
            ++n2;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean add(SyncOperation syncOperation, SyncStorageEngine.PendingOperation pendingOperation) {
        String string2 = syncOperation.key;
        SyncOperation syncOperation2 = this.mOperationsMap.get(string2);
        if (syncOperation2 != null) {
            boolean bl = false;
            boolean bl2 = syncOperation2.expedited;
            boolean bl3 = syncOperation.expedited;
            if (bl2 != bl3) {
                long l = syncOperation2.earliestRunTime;
                long l2 = syncOperation.earliestRunTime;
                long l3 = Math.min(l, l2);
                if (syncOperation2.earliestRunTime == l3) return bl;
                syncOperation2.earliestRunTime = l3;
                return true;
            }
            if (!syncOperation.expedited) return bl;
            syncOperation2.expedited = true;
            return true;
        }
        syncOperation.pendingOperation = pendingOperation;
        if (syncOperation.pendingOperation == null) {
            Account account = syncOperation.account;
            int n = syncOperation.syncSource;
            String string3 = syncOperation.authority;
            Bundle bundle = syncOperation.extras;
            boolean bl = syncOperation.expedited;
            SyncStorageEngine.PendingOperation pendingOperation2 = new SyncStorageEngine.PendingOperation(account, n, string3, bundle, bl);
            pendingOperation = this.mSyncStorageEngine.insertIntoPending(pendingOperation2);
            if (pendingOperation == null) {
                String string4 = "error adding pending sync operation " + syncOperation;
                throw new IllegalStateException(string4);
            }
            syncOperation.pendingOperation = pendingOperation;
        }
        SyncOperation syncOperation3 = this.mOperationsMap.put(string2, syncOperation);
        return true;
    }

    public boolean add(SyncOperation syncOperation) {
        return this.add(syncOperation, null);
    }

    public void dump(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder.append("SyncQueue: ");
        int n = this.mOperationsMap.size();
        StringBuilder stringBuilder3 = stringBuilder2.append(n).append(" operation(s)\n");
        Iterator<SyncOperation> iterator = this.mOperationsMap.values().iterator();
        while (iterator.hasNext()) {
            SyncOperation syncOperation = iterator.next();
            StringBuilder stringBuilder4 = stringBuilder.append(syncOperation).append("\n");
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean getIsInitial(SyncOperation syncOperation) {
        if (syncOperation.extras.getBoolean("initialize", false)) return false;
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account = syncOperation.account;
        String string2 = syncOperation.authority;
        if (syncStorageEngine.getIsSyncable(account, string2) >= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getOpTime(SyncOperation syncOperation) {
        long l;
        long l2 = syncOperation.earliestRunTime;
        if (syncOperation.extras.getBoolean("ignore_backoff", false)) return l2;
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        Account account = syncOperation.account;
        String string2 = syncOperation.authority;
        Pair<Long, Long> pair = syncStorageEngine.getBackoff(account, string2);
        SyncStorageEngine syncStorageEngine2 = this.mSyncStorageEngine;
        Account account2 = syncOperation.account;
        String string3 = syncOperation.authority;
        long l3 = syncStorageEngine2.getDelayUntilTime(account2, string3);
        long l4 = Math.max(l2, l3);
        if (pair != null) {
            l = (Long)pair.first;
            return Math.max(l4, l);
        }
        l = 0L;
        return Math.max(l4, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isOpBetter(SyncOperation syncOperation, long l, boolean bl, SyncOperation syncOperation2, long l2, boolean bl2) {
        boolean bl3 = false;
        if (Log.isLoggable(TAG, 2)) {
            String string2 = "nextOperation: Processing op: " + syncOperation2;
            int n = Log.v(TAG, string2);
        }
        if (syncOperation == null) {
            if (!Log.isLoggable(TAG, 2)) return true;
            int n = Log.v(TAG, "   First op selected");
            return true;
        }
        if (bl != bl2) {
            boolean bl4 = syncOperation.expedited;
            boolean bl5 = syncOperation2.expedited;
            if (bl4 != bl5) {
                if (l2 >= l) return bl3;
                if (!Log.isLoggable(TAG, 2)) return true;
                int n = Log.v(TAG, "   Same expedite level - new op selected");
                return true;
            }
            long l3 = SystemClock.elapsedRealtime();
            if (syncOperation2.expedited) {
                if (l2 <= l3 || l > l3) {
                    if (!Log.isLoggable(TAG, 2)) return true;
                    int n = Log.v(TAG, "   New op is expedited and can run - new op selected");
                    return true;
                }
                if (!Log.isLoggable(TAG, 2)) return bl3;
                int n = Log.v(TAG, "   New op is expedited but can't run and best can");
                return bl3;
            }
            if (l <= l3) return bl3;
            if (l2 > l3) return bl3;
            if (!Log.isLoggable(TAG, 2)) return true;
            int n = Log.v(TAG, "   New op is not expedited but can run - new op selected");
            return true;
        }
        if (!bl2) return bl3;
        if (!Log.isLoggable(TAG, 2)) return true;
        int n = Log.v(TAG, "   New op is init - new op selected");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<SyncOperation, Long> nextOperation() {
        SyncOperation syncOperation = null;
        long l = 0L;
        boolean bl = false;
        for (SyncOperation syncOperation2 : this.mOperationsMap.values()) {
            boolean bl2;
            long l2;
            if (!this.isOpBetter(syncOperation, l, bl, syncOperation2, l2 = this.getOpTime(syncOperation2), bl2 = this.getIsInitial(syncOperation2))) continue;
            syncOperation = syncOperation2;
            bl = bl2;
            l = l2;
        }
        if (syncOperation == null) {
            return null;
        }
        Long l3 = l;
        return Pair.create(syncOperation, l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<SyncOperation, Long> nextReadyToRun(long l) {
        Pair<SyncOperation, Long> pair = this.nextOperation();
        if (pair == null) return null;
        if ((Long)pair.second <= l) return pair;
        return null;
    }

    public void remove(Account account, String string2) {
        Iterator<Map.Entry<String, SyncOperation>> iterator = this.mOperationsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            SyncOperation syncOperation = iterator.next().getValue();
            if (account != null && !syncOperation.account.equals(account) || string2 != null && !syncOperation.authority.equals(string2)) continue;
            iterator.remove();
            SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
            SyncStorageEngine.PendingOperation pendingOperation = syncOperation.pendingOperation;
            if (syncStorageEngine.deleteFromPending(pendingOperation)) continue;
            String string3 = "unable to find pending row for " + syncOperation;
            IllegalStateException illegalStateException = new IllegalStateException(string3);
            int n = Log.e(TAG, string3, illegalStateException);
        }
        return;
    }

    public void remove(SyncOperation syncOperation) {
        HashMap<String, SyncOperation> hashMap = this.mOperationsMap;
        String string2 = syncOperation.key;
        SyncOperation syncOperation2 = hashMap.remove(string2);
        if (syncOperation2 == null) {
            return;
        }
        SyncStorageEngine syncStorageEngine = this.mSyncStorageEngine;
        SyncStorageEngine.PendingOperation pendingOperation = syncOperation2.pendingOperation;
        if (syncStorageEngine.deleteFromPending(pendingOperation)) {
            return;
        }
        String string3 = "unable to find pending row for " + syncOperation2;
        IllegalStateException illegalStateException = new IllegalStateException(string3);
        int n = Log.e(TAG, string3, illegalStateException);
    }
}

